/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"LOGGER", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "ensureCorrectVersion", "", "wsl", "Lcom/intellij/execution/wsl/WSLDistribution;", "intellij.platform.testFramework"})
public final class WslTeamCityTestToolKt {
    @NotNull
    private static final Logger LOGGER;

    public static final void ensureCorrectVersion(@NotNull WSLDistribution wsl) {
        Intrinsics.checkNotNullParameter((Object)wsl, (String)"wsl");
        String string = System.getenv("WSL_VERSION");
        if (string != null) {
            String it = string;
            boolean bl = false;
            if (Integer.parseInt(it) != wsl.getVersion()) {
                String error = StringsKt.trimIndent((String)("\n        Variable provided by environment claims WSL is " + it + ".\n        But wsl is " + wsl.getVersion() + ".\n        Hence, environment provides wrong information.\n        With all of that, test can't continue. Fix your environment.\n      "));
                LOGGER.error(error);
                throw new IllegalStateException(error.toString());
            }
        }
    }

    static {
        Logger logger = Logger.getInstance((String)"WslTeamCityTestTool");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOGGER = logger;
    }
}

