/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.lang.LanguageTestUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.IoTestUtil;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.testFramework.GlobalState;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UITestUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.tests.DynamicExtensionPointsTester;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;

public class JUnit5TestSessionListener
implements LauncherSessionListener {
    private final boolean includeFirstLast = !"true".equals(System.getProperty("intellij.build.test.ignoreFirstAndLastTests")) && UsefulTestCase.IS_UNDER_TEAMCITY;
    private final List<Throwable> caughtExceptions = new ArrayList<Throwable>();

    public void launcherSessionOpened(LauncherSession session) {
        if (!this.includeFirstLast) {
            return;
        }
        session.getLauncher().registerTestExecutionListeners(new TestExecutionListener[]{new FirstAndLastInSuiteTestExecutionListener(this.caughtExceptions)});
    }

    public void launcherSessionClosed(LauncherSession session) {
        if (!this.caughtExceptions.isEmpty()) {
            RuntimeException e = new RuntimeException("Caught exception in _FirstInSuiteTest/_LastInSuiteTest", this.caughtExceptions.getFirst());
            this.caughtExceptions.stream().skip(1L).forEach(e::addSuppressed);
            throw e;
        }
    }

    private static class FirstAndLastInSuiteTestExecutionListener
    implements TestExecutionListener {
        private static final String BOOTSTRAP_TESTS_SUITE_NAME = "com.intellij.tests.BootstrapTests";
        private static final String VINTAGE_UNIQUE_ID = UniqueId.forEngine((String)"junit-vintage").toString();
        private final List<Throwable> caughtExceptions;
        private long suiteStarted = 0L;

        private FirstAndLastInSuiteTestExecutionListener(List<Throwable> caughtExceptions) {
            this.caughtExceptions = caughtExceptions;
        }

        public void testPlanExecutionStarted(TestPlan testPlan) {
            String _FirstInSuiteTestPrefix = "_FirstInSuiteTest.";
            boolean junit34Test = ContainerUtil.exists((Iterable)testPlan.getRoots(), root -> root.getUniqueId().equals(VINTAGE_UNIQUE_ID));
            BiConsumer<String, ThrowableRunnable> doTest = junit34Test ? this::catchExceptionAndReportAsBootstrapTestsSuite : this::catchException;
            doTest.accept("_FirstInSuiteTest.testNothing", () -> {
                this.suiteStarted = System.nanoTime();
                if (junit34Test) {
                    IdeaForkJoinWorkerThreadFactory.setupForkJoinCommonPool((boolean)true);
                    SwingUtilities.invokeAndWait(() -> System.out.println("EDT is " + String.valueOf(Thread.currentThread())));
                    UITestUtil.replaceIdeEventQueueSafely();
                    SwingUtilities.invokeAndWait(() -> System.out.println("EDT is " + String.valueOf(Thread.currentThread())));
                    Class.forName("com.sun.jna.Native");
                }
                String tempDirectory = FileUtilRt.getTempDirectory();
                String[] list = new File(tempDirectory).list();
                assert (list != null);
                System.out.println("FileUtil.getTempDirectory() = " + tempDirectory + " (" + list.length + " files)");
                if (junit34Test) {
                    Preferences.userRoot();
                }
            });
            System.out.println(Timings.getStatistics());
            doTest.accept("_FirstInSuiteTest.testFileEncoding", () -> {
                FirstAndLastInSuiteTestExecutionListener.assertEncoding("file.encoding");
                FirstAndLastInSuiteTestExecutionListener.assertEncoding("sun.jnu.encoding");
            });
            doTest.accept("_FirstInSuiteTest.testSymlinkAbility", () -> {
                Assertions.assertTrue((boolean)IoTestUtil.isSymLinkCreationSupported, (String)String.format("Symlink creation not supported for %s on %s (%s)", SystemProperties.getUserName(), SystemInfo.OS_NAME, SystemInfo.OS_VERSION));
                Assertions.assertEquals((Object)"false", (Object)System.getProperty("sun.io.useCanonCaches", Runtime.version().feature() >= 13 ? "false" : ""), (String)"The `sun.io.useCanonCaches` makes `File#getCanonical*` methods unreliable and should be set to `false`");
            });
            doTest.accept("_FirstInSuiteTest.testGlobalState", () -> {
                if (junit34Test) {
                    GlobalState.checkSystemStreams();
                }
            });
        }

        private static void assertEncoding(@NotNull String property) {
            if (property == null) {
                FirstAndLastInSuiteTestExecutionListener.$$$reportNull$$$0(0);
            }
            String encoding = System.getProperty(property);
            System.out.println("** " + property + "=" + encoding);
            Assertions.assertNotNull((Object)encoding, (String)("The property '" + property + "' is 'null'. Please check build configuration settings."));
            Assertions.assertFalse((boolean)Charset.forName(encoding).aliases().contains("default"), (String)("The property '" + property + "' is set to a default value. Please make sure the build agent has sane locale settings."));
        }

        public void testPlanExecutionFinished(TestPlan testPlan) {
            boolean junit34Test;
            BiConsumer<String, ThrowableRunnable> doTest;
            String _LastInSuiteTestPrefix = "_LastInSuiteTest.";
            Object buildConfName = System.getProperty("teamcity.buildConfName", "");
            if (!((String)buildConfName).isEmpty()) {
                buildConfName = "[" + (String)buildConfName + "]";
            }
            BiConsumer<String, ThrowableRunnable> biConsumer = doTest = (junit34Test = ContainerUtil.exists((Iterable)testPlan.getRoots(), root -> root.getUniqueId().equals(VINTAGE_UNIQUE_ID))) ? this::catchExceptionAndReportAsBootstrapTestsSuite : this::catchException;
            if (junit34Test) {
                Disposer.setDebugMode((boolean)true);
            }
            doTest.accept("_LastInSuiteTest.testDynamicExtensions" + (String)buildConfName, () -> {
                boolean testDynamicExtensions = SystemProperties.getBooleanProperty((String)"intellij.test.all.dynamic.extension.points", (boolean)false);
                if ((!DynamicExtensionPointsTester.EXTENSION_POINTS_WHITE_LIST.isEmpty() || testDynamicExtensions) && testDynamicExtensions) {
                    DynamicExtensionPointsTester.checkDynamicExtensionPoints((Function<? super String, String>)Functions.id());
                }
            });
            doTest.accept("_LastInSuiteTest.testProjectLeak" + (String)buildConfName, () -> TestApplicationManager.testProjectLeak());
            doTest.accept("_LastInSuiteTest.testLanguagesHaveDifferentDisplayNames" + (String)buildConfName, () -> LanguageTestUtil.assertAllLanguagesHaveDifferentDisplayNames());
            doTest.accept("_LastInSuiteTest.testFilenameIndexConsistency" + (String)buildConfName, () -> {
                if (junit34Test) {
                    FSRecords.checkFilenameIndexConsistency();
                }
            });
            doTest.accept("_LastInSuiteTest.testGlobalState" + (String)buildConfName, () -> {
                if (junit34Test) {
                    GlobalState.checkSystemStreams();
                }
            });
            doTest.accept("_LastInSuiteTest.testStatistics" + (String)buildConfName, () -> {
                if (this.suiteStarted != 0L) {
                    long testSuiteDuration = System.nanoTime() - this.suiteStarted;
                    System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTimeMs' value='%d']%n", testSuiteDuration / 1000000L);
                }
                LightPlatformTestCase.reportTestExecutionStatistics();
            });
        }

        private void catchException(String testName, ThrowableRunnable<?> test) {
            try {
                test.run();
            }
            catch (Throwable e) {
                this.caughtExceptions.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void catchExceptionAndReportAsBootstrapTestsSuite(String testName, ThrowableRunnable<?> test) {
            long started = System.nanoTime();
            String escapedTestName = FirstAndLastInSuiteTestExecutionListener.teamcityStdEscaper2(testName);
            System.out.printf("##teamcity[testSuiteStarted name='%s']%n", BOOTSTRAP_TESTS_SUITE_NAME);
            System.out.printf("##teamcity[testStarted name='%s' captureStandardOutput='true']%n", escapedTestName);
            try {
                test.run();
            }
            catch (Throwable e) {
                try {
                    this.caughtExceptions.add(e);
                    StringWriter stacktrace = new StringWriter();
                    e.printStackTrace(new PrintWriter(stacktrace));
                    System.out.printf("##teamcity[testFailed name='%s' message='%s' details='%s']%n", escapedTestName, FirstAndLastInSuiteTestExecutionListener.teamcityStdEscaper2(e.toString()), FirstAndLastInSuiteTestExecutionListener.teamcityStdEscaper2(stacktrace.toString()));
                }
                catch (Throwable throwable) {
                    long duration = System.nanoTime() - started;
                    System.out.printf("##teamcity[testFinished name='%s' duration='%d']%n", escapedTestName, duration / 1000000L);
                    System.out.printf("##teamcity[testSuiteFinished name='%s']%n", BOOTSTRAP_TESTS_SUITE_NAME);
                    throw throwable;
                }
                long duration = System.nanoTime() - started;
                System.out.printf("##teamcity[testFinished name='%s' duration='%d']%n", escapedTestName, duration / 1000000L);
                System.out.printf("##teamcity[testSuiteFinished name='%s']%n", BOOTSTRAP_TESTS_SUITE_NAME);
            }
            long duration = System.nanoTime() - started;
            System.out.printf("##teamcity[testFinished name='%s' duration='%d']%n", escapedTestName, duration / 1000000L);
            System.out.printf("##teamcity[testSuiteFinished name='%s']%n", BOOTSTRAP_TESTS_SUITE_NAME);
        }

        private static String teamcityStdEscaper2(String s) {
            StringBuilder result = new StringBuilder(s.length());
            block8: for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                switch (c) {
                    case '\'': {
                        result.append("|'");
                        continue block8;
                    }
                    case '\n': {
                        result.append("|n");
                        continue block8;
                    }
                    case '\r': {
                        result.append("|r");
                        continue block8;
                    }
                    case '|': {
                        result.append("||");
                        continue block8;
                    }
                    case '[': {
                        result.append("|[");
                        continue block8;
                    }
                    case ']': {
                        result.append("|]");
                        continue block8;
                    }
                    default: {
                        result.append(c < '\u0080' ? Character.valueOf(c) : String.format("|0x%04x", c));
                    }
                }
            }
            return result.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/tests/JUnit5TestSessionListener$FirstAndLastInSuiteTestExecutionListener", "assertEncoding"));
        }
    }
}

