/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.ContentMismatchReporter;
import com.intellij.util.io.DirectoryContentBuilder;
import com.intellij.util.io.DirectoryContentSpec;
import com.intellij.util.io.FileTextMatcher;
import com.intellij.util.io.impl.DirectoryContentBuilderImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImpl;
import com.intellij.util.io.impl.DirectoryContentSpecImplKt;
import com.intellij.util.io.impl.DirectorySpec;
import com.intellij.util.io.impl.JarSpec;
import com.intellij.util.io.impl.ZipSpec;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.rules.ErrorCollector;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0000\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u00f8\u0001\u0000\u001a%\u0010\u0007\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u00f8\u0001\u0000\u001a%\u0010\b\u001a\u00020\u00012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006H\u0086\b\u00f8\u0001\u0000\u001a\u001a\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000bH\u0007\u001a@\u0010\r\u001a\u00020\u0005*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a@\u0010\r\u001a\u00020\u0005*\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a@\u0010\u0017\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00032\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007\u001a<\u0010\u0017\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u000b2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0007\u001a\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001a*\u0004\u0018\u00010\u0016H\u0002\u001a\n\u0010\u001c\u001a\u00020\u001d*\u00020\u0001\u001a\u0012\u0010\u001e\u001a\u00020\u0005*\u00020\u00012\u0006\u0010\u001f\u001a\u00020\u001d\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006 "}, d2={"directoryContent", "Lcom/intellij/util/io/DirectoryContentSpec;", "content", "Lkotlin/Function1;", "Lcom/intellij/util/io/DirectoryContentBuilder;", "", "Lkotlin/ExtensionFunctionType;", "zipFile", "jarFile", "directoryContentOf", "dir", "Ljava/nio/file/Path;", "originalDir", "assertMatches", "Ljava/io/File;", "spec", "fileTextMatcher", "Lcom/intellij/util/io/FileTextMatcher;", "filePathFilter", "", "", "errorCollector", "Lorg/junit/rules/ErrorCollector;", "assertIsMatchedBy", "path", "customErrorReporter", "Lcom/intellij/util/io/ContentMismatchReporter;", "asReporter", "generateInVirtualTempDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "generate", "target", "intellij.platform.testFramework"})
@SourceDebugExtension(value={"SMAP\nDirectoryContentSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectoryContentSpec.kt\ncom/intellij/util/io/DirectoryContentSpecKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class DirectoryContentSpecKt {
    @NotNull
    public static final DirectoryContentSpec directoryContent(@NotNull Function1<? super DirectoryContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        boolean $i$f$directoryContent = false;
        DirectoryContentBuilderImpl builder = new DirectoryContentBuilderImpl(new DirectorySpec(null, 1, null));
        content.invoke((Object)builder);
        return builder.getResult();
    }

    @NotNull
    public static final DirectoryContentSpec zipFile(@NotNull Function1<? super DirectoryContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        boolean $i$f$zipFile = false;
        DirectoryContentBuilderImpl builder = new DirectoryContentBuilderImpl(new ZipSpec(0, 1, null));
        content.invoke((Object)builder);
        return builder.getResult();
    }

    @NotNull
    public static final DirectoryContentSpec jarFile(@NotNull Function1<? super DirectoryContentBuilder, Unit> content) {
        Intrinsics.checkNotNullParameter(content, (String)"content");
        boolean $i$f$jarFile = false;
        DirectoryContentBuilderImpl builder = new DirectoryContentBuilderImpl(new JarSpec());
        content.invoke((Object)builder);
        return builder.getResult();
    }

    @JvmOverloads
    @NotNull
    public static final DirectoryContentSpec directoryContentOf(@NotNull Path dir, @NotNull Path originalDir) {
        DirectorySpec directorySpec;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)originalDir, (String)"originalDir");
        DirectorySpec it = directorySpec = new DirectorySpec(null, 1, null);
        boolean bl = false;
        DirectoryContentSpecImplKt.fillSpecFromDirectory(it, dir, originalDir);
        return directorySpec;
    }

    public static /* synthetic */ DirectoryContentSpec directoryContentOf$default(Path path, Path path2, int n, Object object) {
        if ((n & 2) != 0) {
            path2 = path;
        }
        return DirectoryContentSpecKt.directoryContentOf(path, path2);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull File $this$assertMatches, @NotNull DirectoryContentSpec spec, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        Path path = $this$assertMatches.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        DirectoryContentSpecImplKt.assertContentUnderFileMatches(path, (DirectoryContentSpecImpl)spec, fileTextMatcher, filePathFilter, DirectoryContentSpecKt.asReporter(errorCollector), true);
    }

    public static /* synthetic */ void assertMatches$default(File file, DirectoryContentSpec directoryContentSpec, FileTextMatcher fileTextMatcher, Function1 function1, ErrorCollector errorCollector, int n, Object object) {
        if ((n & 2) != 0) {
            fileTextMatcher = FileTextMatcher.Companion.exact();
        }
        if ((n & 4) != 0) {
            function1 = DirectoryContentSpecKt::assertMatches$lambda$0;
        }
        if ((n & 8) != 0) {
            errorCollector = null;
        }
        DirectoryContentSpecKt.assertMatches(file, directoryContentSpec, fileTextMatcher, (Function1<? super String, Boolean>)function1, errorCollector);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull Path $this$assertMatches, @NotNull DirectoryContentSpec spec, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        DirectoryContentSpecImplKt.assertContentUnderFileMatches($this$assertMatches, (DirectoryContentSpecImpl)spec, fileTextMatcher, filePathFilter, DirectoryContentSpecKt.asReporter(errorCollector), true);
    }

    public static /* synthetic */ void assertMatches$default(Path path, DirectoryContentSpec directoryContentSpec, FileTextMatcher fileTextMatcher, Function1 function1, ErrorCollector errorCollector, int n, Object object) {
        if ((n & 2) != 0) {
            fileTextMatcher = FileTextMatcher.Companion.exact();
        }
        if ((n & 4) != 0) {
            function1 = DirectoryContentSpecKt::assertMatches$lambda$1;
        }
        if ((n & 8) != 0) {
            errorCollector = null;
        }
        DirectoryContentSpecKt.assertMatches(path, directoryContentSpec, fileTextMatcher, (Function1<? super String, Boolean>)function1, errorCollector);
    }

    @JvmOverloads
    public static final void assertIsMatchedBy(@NotNull DirectoryContentSpec $this$assertIsMatchedBy, @NotNull Path path, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsMatchedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        DirectoryContentSpecImplKt.assertContentUnderFileMatches(path, (DirectoryContentSpecImpl)$this$assertIsMatchedBy, fileTextMatcher, filePathFilter, DirectoryContentSpecKt.asReporter(errorCollector), false);
    }

    public static /* synthetic */ void assertIsMatchedBy$default(DirectoryContentSpec directoryContentSpec, Path path, FileTextMatcher fileTextMatcher, Function1 function1, ErrorCollector errorCollector, int n, Object object) {
        if ((n & 2) != 0) {
            fileTextMatcher = FileTextMatcher.Companion.exact();
        }
        if ((n & 4) != 0) {
            function1 = DirectoryContentSpecKt::assertIsMatchedBy$lambda$0;
        }
        if ((n & 8) != 0) {
            errorCollector = null;
        }
        DirectoryContentSpecKt.assertIsMatchedBy(directoryContentSpec, path, fileTextMatcher, (Function1<? super String, Boolean>)function1, errorCollector);
    }

    @JvmOverloads
    public static final void assertIsMatchedBy(@NotNull DirectoryContentSpec $this$assertIsMatchedBy, @NotNull Path path, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ContentMismatchReporter customErrorReporter) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsMatchedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        DirectoryContentSpecImplKt.assertContentUnderFileMatches(path, (DirectoryContentSpecImpl)$this$assertIsMatchedBy, fileTextMatcher, filePathFilter, customErrorReporter, false);
    }

    public static /* synthetic */ void assertIsMatchedBy$default(DirectoryContentSpec directoryContentSpec, Path path, FileTextMatcher fileTextMatcher, Function1 function1, ContentMismatchReporter contentMismatchReporter, int n, Object object) {
        if ((n & 2) != 0) {
            fileTextMatcher = FileTextMatcher.Companion.exact();
        }
        DirectoryContentSpecKt.assertIsMatchedBy(directoryContentSpec, path, fileTextMatcher, (Function1<? super String, Boolean>)function1, contentMismatchReporter);
    }

    private static final ContentMismatchReporter asReporter(ErrorCollector $this$asReporter) {
        ContentMismatchReporter contentMismatchReporter;
        ErrorCollector errorCollector = $this$asReporter;
        if (errorCollector != null) {
            ErrorCollector it = errorCollector;
            boolean bl = false;
            contentMismatchReporter = (arg_0, arg_1) -> DirectoryContentSpecKt.asReporter$lambda$0$0(it, arg_0, arg_1);
        } else {
            contentMismatchReporter = null;
        }
        return contentMismatchReporter;
    }

    @NotNull
    public static final VirtualFile generateInVirtualTempDir(@NotNull DirectoryContentSpec $this$generateInVirtualTempDir) {
        Intrinsics.checkNotNullParameter((Object)$this$generateInVirtualTempDir, (String)"<this>");
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile($this$generateInVirtualTempDir.generateInTempDir());
        Intrinsics.checkNotNull((Object)virtualFile);
        return virtualFile;
    }

    public static final void generate(@NotNull DirectoryContentSpec $this$generate, @NotNull VirtualFile target) {
        Intrinsics.checkNotNullParameter((Object)$this$generate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Path path = target.toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        $this$generate.generate(path);
        VirtualFile[] virtualFileArray = new VirtualFile[]{target};
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])virtualFileArray);
    }

    @JvmOverloads
    @NotNull
    public static final DirectoryContentSpec directoryContentOf(@NotNull Path dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return DirectoryContentSpecKt.directoryContentOf$default(dir, null, 2, null);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull File $this$assertMatches, @NotNull DirectoryContentSpec spec, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        DirectoryContentSpecKt.assertMatches$default($this$assertMatches, spec, fileTextMatcher, filePathFilter, null, 8, null);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull File $this$assertMatches, @NotNull DirectoryContentSpec spec, @NotNull FileTextMatcher fileTextMatcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        DirectoryContentSpecKt.assertMatches$default($this$assertMatches, spec, fileTextMatcher, null, null, 12, null);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull File $this$assertMatches, @NotNull DirectoryContentSpec spec) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        DirectoryContentSpecKt.assertMatches$default($this$assertMatches, spec, null, null, null, 14, null);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull Path $this$assertMatches, @NotNull DirectoryContentSpec spec, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        DirectoryContentSpecKt.assertMatches$default($this$assertMatches, spec, fileTextMatcher, filePathFilter, null, 8, null);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull Path $this$assertMatches, @NotNull DirectoryContentSpec spec, @NotNull FileTextMatcher fileTextMatcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        DirectoryContentSpecKt.assertMatches$default($this$assertMatches, spec, fileTextMatcher, null, null, 12, null);
    }

    @JvmOverloads
    public static final void assertMatches(@NotNull Path $this$assertMatches, @NotNull DirectoryContentSpec spec) {
        Intrinsics.checkNotNullParameter((Object)$this$assertMatches, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        DirectoryContentSpecKt.assertMatches$default($this$assertMatches, spec, null, null, null, 14, null);
    }

    @JvmOverloads
    public static final void assertIsMatchedBy(@NotNull DirectoryContentSpec $this$assertIsMatchedBy, @NotNull Path path, @NotNull FileTextMatcher fileTextMatcher, @NotNull Function1<? super String, Boolean> filePathFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsMatchedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        DirectoryContentSpecKt.assertIsMatchedBy$default($this$assertIsMatchedBy, path, fileTextMatcher, filePathFilter, null, 8, null);
    }

    @JvmOverloads
    public static final void assertIsMatchedBy(@NotNull DirectoryContentSpec $this$assertIsMatchedBy, @NotNull Path path, @NotNull FileTextMatcher fileTextMatcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsMatchedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileTextMatcher, (String)"fileTextMatcher");
        DirectoryContentSpecKt.assertIsMatchedBy$default($this$assertIsMatchedBy, path, fileTextMatcher, null, null, 12, null);
    }

    @JvmOverloads
    public static final void assertIsMatchedBy(@NotNull DirectoryContentSpec $this$assertIsMatchedBy, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsMatchedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        DirectoryContentSpecKt.assertIsMatchedBy$default($this$assertIsMatchedBy, path, null, null, null, 14, null);
    }

    @JvmOverloads
    public static final void assertIsMatchedBy(@NotNull DirectoryContentSpec $this$assertIsMatchedBy, @NotNull Path path, @NotNull Function1<? super String, Boolean> filePathFilter, @Nullable ContentMismatchReporter customErrorReporter) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsMatchedBy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(filePathFilter, (String)"filePathFilter");
        DirectoryContentSpecKt.assertIsMatchedBy$default($this$assertIsMatchedBy, path, null, filePathFilter, customErrorReporter, 2, null);
    }

    private static final boolean assertMatches$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean assertMatches$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean assertIsMatchedBy$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final void asReporter$lambda$0$0(ErrorCollector $it, String string, Throwable error) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        $it.addError(error);
    }
}

