/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.lang.TokenWrapper;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.RestartableLexer;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LexerTestCase
extends UsefulTestCase {
    protected void doTest(@NotNull String text) {
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(0);
        }
        this.doTest(text, null);
    }

    protected void doTest(@NotNull String text, @Nullable String expected) {
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(1);
        }
        this.doTest(text, expected, this.createLexer());
    }

    protected void doTest(@NotNull String text, @Nullable String expected, @NotNull Lexer lexer) {
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(2);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(3);
        }
        String result = this.printTokens(lexer, text, 0);
        if (expected != null) {
            LexerTestCase.assertSameLines(expected, result);
        } else {
            LexerTestCase.assertSameLinesWithFile(this.getPathToTestDataFile(this.getExpectedFileExtension()), result);
        }
    }

    protected String printTokens(@NotNull Lexer lexer, @NotNull CharSequence text, int start) {
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(4);
        }
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(5);
        }
        return LexerTestCase.printTokens(text, start, lexer);
    }

    @NotNull
    protected String getPathToTestDataFile(@NotNull String extension) {
        if (extension == null) {
            LexerTestCase.$$$reportNull$$$0(6);
        }
        String string = IdeaTestExecutionPolicy.getHomePathWithPolicy() + "/" + this.getDirPath() + "/" + this.getTestName(true) + extension;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    protected String getExpectedFileExtension() {
        return ".txt";
    }

    protected void checkZeroState(@NotNull String text, TokenSet tokenTypes) {
        IElementType type;
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(8);
        }
        Lexer lexer = this.createLexer();
        lexer.start((CharSequence)text);
        while ((type = lexer.getTokenType()) != null) {
            if (tokenTypes.contains(type) && lexer.getState() != 0) {
                LexerTestCase.fail((String)("Non-zero lexer state on token \"" + lexer.getTokenText() + "\" (" + String.valueOf(type) + ") at " + lexer.getTokenStart()));
            }
            lexer.advance();
        }
    }

    protected String printTokens(@NotNull String text, int start) {
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(9);
        }
        return LexerTestCase.printTokens(text, start, this.createLexer());
    }

    protected void checkCorrectRestart(@NotNull String text) {
        IElementType type;
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(10);
        }
        Lexer mainLexer = this.createLexer();
        List<Trinity<IElementType, Integer, Integer>> allTokens = LexerTestCase.tokenize(text, 0, 0, mainLexer);
        Lexer auxLexer = this.createLexer();
        auxLexer.start((CharSequence)text);
        int index = 0;
        while ((type = auxLexer.getTokenType()) != null) {
            int state = auxLexer.getState();
            if (state == 0 || auxLexer instanceof RestartableLexer && ((RestartableLexer)auxLexer).isRestartableState(state)) {
                int tokenStart = auxLexer.getTokenStart();
                List<Trinity<IElementType, Integer, Integer>> expectedTokens = allTokens.subList(index, allTokens.size());
                List<Trinity<IElementType, Integer, Integer>> restartedTokens = LexerTestCase.tokenize(text, tokenStart, state, mainLexer);
                LexerTestCase.assertEquals((String)("Restarting impossible from offset " + tokenStart + " - " + auxLexer.getTokenText() + "\nAll tokens <type, offset, lexer state>: " + String.valueOf(allTokens) + "\n"), (String)expectedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")), (String)restartedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")));
            }
            ++index;
            auxLexer.advance();
        }
    }

    protected void checkCorrectRestartUsingPosition(@NotNull String text) {
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(11);
        }
        Lexer mainLexer = this.createLexer();
        List<Trinity<IElementType, Integer, Integer>> allTokens = LexerTestCase.tokenize(text, 0, 0, mainLexer);
        List<LexerPosition> allPositions = LexerTestCase.buildPositions(text, 0, mainLexer);
        for (int i = 0; i < allPositions.size(); ++i) {
            LexerPosition position = allPositions.get(i);
            List<Trinity<IElementType, Integer, Integer>> expectedTokens = allTokens.subList(i, allTokens.size());
            List<Trinity<IElementType, Integer, Integer>> restartedTokens = LexerTestCase.tokenize(position, mainLexer);
            mainLexer.restore(position);
            LexerTestCase.assertEquals((String)("Restarting using position impossible from offset " + position.getOffset() + " - " + mainLexer.getTokenText() + "\nAll tokens <type, offset, lexer state>: " + String.valueOf(allTokens) + "\n"), (String)expectedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")), (String)restartedTokens.stream().map(Objects::toString).collect(Collectors.joining("\n")));
        }
    }

    @NotNull
    private static List<Trinity<IElementType, Integer, Integer>> tokenize(@NotNull String text, int start, int state, @NotNull Lexer lexer) {
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(12);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(13);
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> allTokens = new ArrayList<Trinity<IElementType, Integer, Integer>>();
        try {
            lexer.start((CharSequence)text, start, text.length(), state);
        }
        catch (Throwable t) {
            LOG.error("Restarting impossible from offset " + start, t);
            throw new RuntimeException(t);
        }
        while (lexer.getTokenType() != null) {
            allTokens.add((Trinity<IElementType, Integer, Integer>)Trinity.create((Object)lexer.getTokenType(), (Object)lexer.getTokenStart(), (Object)lexer.getState()));
            lexer.advance();
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> arrayList = allTokens;
        if (arrayList == null) {
            LexerTestCase.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static List<LexerPosition> buildPositions(@NotNull String text, int start, @NotNull Lexer lexer) {
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(15);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(16);
        }
        ArrayList<LexerPosition> result = new ArrayList<LexerPosition>();
        try {
            lexer.start((CharSequence)text, start, text.length());
        }
        catch (Throwable t) {
            LOG.error("Restarting impossible from offset " + start, t);
            throw new RuntimeException(t);
        }
        while (lexer.getTokenType() != null) {
            result.add(lexer.getCurrentPosition());
            lexer.advance();
        }
        ArrayList<LexerPosition> arrayList = result;
        if (arrayList == null) {
            LexerTestCase.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static List<Trinity<IElementType, Integer, Integer>> tokenize(@NotNull LexerPosition position, @NotNull Lexer lexer) {
        if (position == null) {
            LexerTestCase.$$$reportNull$$$0(18);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(19);
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> allTokens = new ArrayList<Trinity<IElementType, Integer, Integer>>();
        try {
            lexer.restore(position);
        }
        catch (Throwable t) {
            LOG.error("Restoring location impossible from offset " + position.getOffset(), t);
            throw new RuntimeException(t);
        }
        while (lexer.getTokenType() != null) {
            allTokens.add((Trinity<IElementType, Integer, Integer>)Trinity.create((Object)lexer.getTokenType(), (Object)lexer.getTokenStart(), (Object)lexer.getState()));
            lexer.advance();
        }
        ArrayList<Trinity<IElementType, Integer, Integer>> arrayList = allTokens;
        if (arrayList == null) {
            LexerTestCase.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    public static String printTokens(@NotNull CharSequence text, int start, @NotNull Lexer lexer) {
        IElementType tokenType;
        if (text == null) {
            LexerTestCase.$$$reportNull$$$0(21);
        }
        if (lexer == null) {
            LexerTestCase.$$$reportNull$$$0(22);
        }
        lexer.start(text, start, text.length());
        StringBuilder result = new StringBuilder();
        while ((tokenType = lexer.getTokenType()) != null) {
            result.append(LexerTestCase.printSingleToken(text, tokenType, lexer.getTokenStart(), lexer.getTokenEnd()));
            lexer.advance();
        }
        return result.toString();
    }

    @NotNull
    public static String printTokens(@NotNull HighlighterIterator iterator) {
        if (iterator == null) {
            LexerTestCase.$$$reportNull$$$0(23);
        }
        CharSequence text = iterator.getDocument().getCharsSequence();
        StringBuilder result = new StringBuilder();
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            result.append(LexerTestCase.printSingleToken(text, tokenType, iterator.getStart(), iterator.getEnd()));
            iterator.advance();
        }
        String string = result.toString();
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static String printSingleToken(@NotNull CharSequence fileText, @NotNull IElementType tokenType, int start, int end) {
        if (fileText == null) {
            LexerTestCase.$$$reportNull$$$0(25);
        }
        if (tokenType == null) {
            LexerTestCase.$$$reportNull$$$0(26);
        }
        return String.valueOf(tokenType) + " ('" + LexerTestCase.getTokenText(tokenType, fileText, start, end) + "')\n";
    }

    protected void doFileTest(@NotNull String fileExt) {
        if (fileExt == null) {
            LexerTestCase.$$$reportNull$$$0(27);
        }
        this.doTest(this.loadTestDataFile("." + fileExt));
    }

    @NotNull
    protected String loadTestDataFile(String fileExt) {
        String fileName = this.getPathToTestDataFile(fileExt);
        String text = "";
        try {
            String fileText = FileUtil.loadFile((File)new File(fileName));
            text = StringUtil.convertLineSeparators((String)(this.shouldTrim() ? fileText.trim() : fileText));
        }
        catch (IOException e) {
            LexerTestCase.fail((String)("can't load file " + fileName + ": " + e.getMessage()));
        }
        String string = text;
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(28);
        }
        return string;
    }

    protected boolean shouldTrim() {
        return true;
    }

    @NotNull
    private static String getTokenText(IElementType tokenType, CharSequence sequence, int start, int end) {
        String string = tokenType instanceof TokenWrapper ? ((TokenWrapper)tokenType).getText() : StringUtil.replace((String)sequence.subSequence(start, end).toString(), (String)"\n", (String)"\\n");
        if (string == null) {
            LexerTestCase.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    protected abstract Lexer createLexer();

    @NotNull
    protected abstract String getDirPath();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 14, 17, 20, 24, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LexerTestCase";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathToTestDataFile";
                break;
            }
            case 14: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPositions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "printTokens";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTestDataFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "printTokens";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getPathToTestDataFile";
                break;
            }
            case 7: 
            case 14: 
            case 17: 
            case 20: 
            case 24: 
            case 28: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkZeroState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkCorrectRestart";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkCorrectRestartUsingPosition";
                break;
            }
            case 12: 
            case 13: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildPositions";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "printSingleToken";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "doFileTest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 14, 17, 20, 24, 28, 29 -> new IllegalStateException(string);
        };
    }
}

