/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tests;

import com.intellij.lang.LanguageTestUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.IoTestUtil;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.tests.DynamicExtensionPointsTester;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;

public class JUnit5TestSessionListener
implements LauncherSessionListener {
    private final boolean includeFirstLast = !"true".equals(System.getProperty("intellij.build.test.ignoreFirstAndLastTests")) && UsefulTestCase.IS_UNDER_TEAMCITY;
    private long suiteStarted = 0L;

    public void launcherSessionOpened(LauncherSession session) {
        session.getLauncher().registerTestExecutionListeners(new TestExecutionListener[]{new TestExecutionListener(){

            public void testPlanExecutionStarted(TestPlan testPlan) {
                if (JUnit5TestSessionListener.this.suiteStarted == 0L) {
                    if (!JUnit5TestSessionListener.this.includeFirstLast) {
                        return;
                    }
                    JUnit5TestSessionListener.this.suiteStarted = System.nanoTime();
                    String tempDirectory = FileUtilRt.getTempDirectory();
                    String[] list = new File(tempDirectory).list();
                    assert (list != null);
                    System.out.println("FileUtil.getTempDirectory() = " + tempDirectory + " (" + list.length + " files)");
                    System.out.println(Timings.getStatistics());
                    Assertions.assertAll((Executable[])new Executable[]{() -> JUnit5TestSessionListener.assertEncoding("file.encoding"), () -> JUnit5TestSessionListener.assertEncoding("sun.jnu.encoding"), () -> Assertions.assertTrue((boolean)IoTestUtil.isSymLinkCreationSupported, (String)String.format("Symlink creation not supported for %s on %s (%s)", SystemProperties.getUserName(), SystemInfo.OS_NAME, SystemInfo.OS_VERSION)), () -> Assertions.assertEquals((Object)"false", (Object)System.getProperty("sun.io.useCanonCaches", Runtime.version().feature() >= 13 ? "false" : ""), (String)"The `sun.io.useCanonCaches` makes `File#getCanonical*` methods unreliable and should be set to `false`")});
                }
            }
        }});
    }

    private static void assertEncoding(@NotNull String property) {
        if (property == null) {
            JUnit5TestSessionListener.$$$reportNull$$$0(0);
        }
        String encoding = System.getProperty(property);
        System.out.println("** " + property + "=" + encoding);
        Assertions.assertNotNull((Object)encoding, (String)("The property '" + property + "' is 'null'. Please check build configuration settings."));
        Assertions.assertFalse((boolean)Charset.forName(encoding).aliases().contains("default"), (String)("The property '" + property + "' is set to a default value. Please make sure the build agent has sane locale settings."));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launcherSessionClosed(LauncherSession session) {
        block4: {
            if (!this.includeFirstLast) return;
            if (this.suiteStarted == 0L) {
                return;
            }
            try {
                Assertions.assertAll((Executable[])new Executable[]{() -> {
                    boolean testDynamicExtensions = SystemProperties.getBooleanProperty((String)"intellij.test.all.dynamic.extension.points", (boolean)false);
                    if (testDynamicExtensions) {
                        DynamicExtensionPointsTester.checkDynamicExtensionPoints((Function<? super String, String>)Functions.id());
                    }
                }, () -> TestApplicationManager.testProjectLeak(), () -> LanguageTestUtil.assertAllLanguagesHaveDifferentDisplayNames()});
                if (this.suiteStarted == 0L) break block4;
            }
            catch (Throwable throwable) {
                if (this.suiteStarted != 0L) {
                    long testSuiteDuration = System.nanoTime() - this.suiteStarted;
                    System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTimeMs' value='%d']%n", testSuiteDuration / 1000000L);
                }
                LightPlatformTestCase.reportTestExecutionStatistics();
                throw throwable;
            }
            long testSuiteDuration = System.nanoTime() - this.suiteStarted;
            System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTimeMs' value='%d']%n", testSuiteDuration / 1000000L);
        }
        LightPlatformTestCase.reportTestExecutionStatistics();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/tests/JUnit5TestSessionListener", "assertEncoding"));
    }
}

