/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

final class FileTree {
    private static final Logger LOG = Logger.getInstance(FileTree.class);
    @NotNull
    private static final RegistryValue ASSERT_THREADS = RegistryManager.getInstance().get("ide.tree.ui.assert.threads");
    private final Map<VirtualFile, List<VirtualFile>> myDirectory2Children = new ConcurrentHashMap<VirtualFile, List<VirtualFile>>();
    private final Set<VirtualFile> myFiles = ConcurrentCollectionFactory.createConcurrentSet();
    private final Map<VirtualFile, List<VirtualFile>> myStrictDirectory2Children = new ConcurrentHashMap<VirtualFile, List<VirtualFile>>();

    FileTree() {
    }

    int size() {
        return this.myFiles.size();
    }

    void add(@NotNull VirtualFile file) {
        if (file == null) {
            FileTree.$$$reportNull$$$0(0);
        }
        FileTree.assertThreadIfNeeded();
        if (this.myFiles.contains(file)) {
            return;
        }
        VirtualFile dir = file.getParent();
        if (dir == null) {
            LOG.error("Parent is null for " + String.valueOf(file));
            return;
        }
        this.myFiles.add(file);
        Object children = this.myStrictDirectory2Children.get(dir);
        if (children != null) {
            LOG.assertTrue(!children.contains(file));
            children.add(file);
        } else {
            children = ContainerUtil.createConcurrentList();
            children.add(file);
            this.myStrictDirectory2Children.put(dir, (List<VirtualFile>)children);
        }
        children = this.myDirectory2Children.get(dir);
        if (children != null) {
            LOG.assertTrue(!children.contains(file));
            children.add(file);
            return;
        }
        children = ContainerUtil.createConcurrentList();
        children.add(file);
        this.myDirectory2Children.put(dir, (List<VirtualFile>)children);
        for (VirtualFile parent = dir.getParent(); parent != null; parent = parent.getParent()) {
            children = this.myDirectory2Children.get(parent);
            if (children != null) {
                if (!children.contains(dir)) {
                    children.add(dir);
                }
                return;
            }
            children = ContainerUtil.createConcurrentList();
            children.add(dir);
            this.myDirectory2Children.put(parent, (List<VirtualFile>)children);
            dir = parent;
        }
    }

    boolean isDirectoryEmpty(@NotNull VirtualFile dir) {
        if (dir == null) {
            FileTree.$$$reportNull$$$0(1);
        }
        FileTree.assertThreadIfNeeded();
        return this.myStrictDirectory2Children.getOrDefault(dir, List.of()).isEmpty();
    }

    @NotNull
    List<VirtualFile> getFilesUnderDirectory(@NotNull VirtualFile dir) {
        if (dir == null) {
            FileTree.$$$reportNull$$$0(2);
        }
        FileTree.assertThreadIfNeeded();
        List<VirtualFile> files = this.myStrictDirectory2Children.get(dir);
        List<Object> list = files != null ? List.copyOf(files) : List.of();
        if (list == null) {
            FileTree.$$$reportNull$$$0(3);
        }
        return list;
    }

    void removeFile(@NotNull VirtualFile file) {
        List<VirtualFile> children;
        if (file == null) {
            FileTree.$$$reportNull$$$0(4);
        }
        FileTree.assertThreadIfNeeded();
        if (!this.myFiles.contains(file)) {
            return;
        }
        this.myFiles.remove(file);
        List<VirtualFile> dirsToBeRemoved = null;
        for (VirtualFile _directory : this.myDirectory2Children.keySet()) {
            children = this.myDirectory2Children.get(_directory);
            LOG.assertTrue(children != null);
            dirsToBeRemoved = FileTree.collectDirsToRemove(file, children, dirsToBeRemoved, _directory);
        }
        for (VirtualFile dir : this.myStrictDirectory2Children.keySet()) {
            children = this.myStrictDirectory2Children.get(dir);
            LOG.assertTrue(children != null);
            children.remove(file);
        }
        if (dirsToBeRemoved != null) {
            LOG.assertTrue(!dirsToBeRemoved.isEmpty());
            for (VirtualFile dirToBeRemoved : dirsToBeRemoved) {
                this.removeDir(dirToBeRemoved);
            }
        }
    }

    private void removeDir(@NotNull VirtualFile psiDirectory) {
        if (psiDirectory == null) {
            FileTree.$$$reportNull$$$0(5);
        }
        if (!this.myDirectory2Children.containsKey(psiDirectory)) {
            throw new IllegalArgumentException("directory is not in the tree: " + String.valueOf(psiDirectory));
        }
        List<VirtualFile> children = this.myDirectory2Children.remove(psiDirectory);
        if (children == null) {
            throw new IllegalArgumentException("directory has no children list: " + String.valueOf(psiDirectory));
        }
        if (!children.isEmpty()) {
            throw new IllegalArgumentException("directory isn't empty: " + String.valueOf(psiDirectory));
        }
        this.myStrictDirectory2Children.remove(psiDirectory);
        List<VirtualFile> dirsToBeRemoved = null;
        for (VirtualFile _directory : this.myDirectory2Children.keySet()) {
            children = this.myDirectory2Children.get(_directory);
            LOG.assertTrue(children != null);
            dirsToBeRemoved = FileTree.collectDirsToRemove(psiDirectory, children, dirsToBeRemoved, _directory);
        }
        if (dirsToBeRemoved != null) {
            for (VirtualFile dirToBeRemoved : dirsToBeRemoved) {
                this.removeDir(dirToBeRemoved);
            }
        }
    }

    private static List<VirtualFile> collectDirsToRemove(@NotNull VirtualFile psiDirectory, @NotNull List<VirtualFile> children, List<VirtualFile> dirsToBeRemoved, @NotNull VirtualFile _directory) {
        if (psiDirectory == null) {
            FileTree.$$$reportNull$$$0(6);
        }
        if (children == null) {
            FileTree.$$$reportNull$$$0(7);
        }
        if (_directory == null) {
            FileTree.$$$reportNull$$$0(8);
        }
        if (children.remove(psiDirectory) && children.isEmpty()) {
            if (dirsToBeRemoved == null) {
                dirsToBeRemoved = new ArrayList<VirtualFile>(2);
            }
            dirsToBeRemoved.add(_directory);
        }
        return dirsToBeRemoved;
    }

    boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            FileTree.$$$reportNull$$$0(9);
        }
        return this.myFiles.contains(file);
    }

    void clear() {
        FileTree.assertThreadIfNeeded();
        this.myStrictDirectory2Children.clear();
        this.myDirectory2Children.clear();
        this.myFiles.clear();
    }

    @NotNull
    Iterator<VirtualFile> getFileIterator() {
        FileTree.assertThreadIfNeeded();
        Iterator<VirtualFile> iterator = this.myFiles.iterator();
        if (iterator == null) {
            FileTree.$$$reportNull$$$0(10);
        }
        return iterator;
    }

    @NotNull
    List<VirtualFile> getFiles(@NotNull VirtualFile dir) {
        if (dir == null) {
            FileTree.$$$reportNull$$$0(11);
        }
        FileTree.assertThreadIfNeeded();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList filesList = new ArrayList();
        this.collectFiles(dir, filesList);
        List<VirtualFile> list = Collections.unmodifiableList(filesList);
        if (list == null) {
            FileTree.$$$reportNull$$$0(12);
        }
        return list;
    }

    private void collectFiles(@NotNull VirtualFile dir, @NotNull List<? super VirtualFile> filesList) {
        if (dir == null) {
            FileTree.$$$reportNull$$$0(13);
        }
        if (filesList == null) {
            FileTree.$$$reportNull$$$0(14);
        }
        for (VirtualFile child : this.myDirectory2Children.getOrDefault(dir, Collections.emptyList())) {
            ProgressManager.checkCanceled();
            if (!child.isDirectory()) {
                if (LOG.isDebugEnabled()) {
                    LOG.assertTrue(!filesList.contains(child));
                }
                filesList.add((VirtualFile)child);
                continue;
            }
            this.collectFiles(child, filesList);
        }
    }

    static void assertThreadIfNeeded() {
        if (ASSERT_THREADS.asBoolean()) {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 3: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/FileTree";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDirectory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_directory";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/FileTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesUnderDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileIterator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryEmpty";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilesUnderDirectory";
                break;
            }
            case 3: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeDir";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectDirsToRemove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 10, 12 -> new IllegalStateException(string);
        };
    }
}

