/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.configurable;

import com.intellij.ide.IdeBundle;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.ui.ItemRemovable;
import java.util.List;
import javax.swing.Icon;
import javax.swing.table.AbstractTableModel;

final class PatternsTableModel
extends AbstractTableModel
implements ItemRemovable {
    private final String[] myColumnNames = new String[]{IdeBundle.message((String)"column.todo.patterns.icon", (Object[])new Object[0]), IdeBundle.message((String)"column.todo.patterns.case.sensitive", (Object[])new Object[0]), IdeBundle.message((String)"column.todo.patterns.pattern", (Object[])new Object[0])};
    private final List<TodoPattern> myPatterns;

    PatternsTableModel(List<TodoPattern> patterns) {
        this.myPatterns = patterns;
    }

    @Override
    public String getColumnName(int column) {
        return this.myColumnNames[column];
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return switch (column) {
            case 0 -> Icon.class;
            case 1 -> Boolean.class;
            case 2 -> String.class;
            default -> throw new IllegalArgumentException();
        };
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return this.myPatterns.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        TodoPattern pattern = this.myPatterns.get(row);
        return switch (column) {
            case 0 -> pattern.getAttributes().getIcon();
            case 1 -> pattern.isCaseSensitive();
            case 2 -> pattern.getPatternString();
            default -> throw new IllegalArgumentException();
        };
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        TodoPattern pattern = this.myPatterns.get(row);
        switch (column) {
            case 0: {
                pattern.getAttributes().setIcon((Icon)value);
                break;
            }
            case 1: {
                pattern.setCaseSensitive(((Boolean)value).booleanValue());
                break;
            }
            case 2: {
                pattern.setPatternString(((String)value).trim());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void removeRow(int index) {
        this.myPatterns.remove(index);
        this.fireTableRowsDeleted(index, index);
    }
}

