/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.todo.AllTodosTreeBuilder;
import com.intellij.ide.todo.CurrentFileTodosPanel;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.ScopeBasedTodosPanel;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoPanel;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeBuilderFactory;
import com.intellij.ide.todo.TodoViewChangesSupport;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.IdeUICustomization;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JTree;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@com.intellij.openapi.components.State(name="TodoView", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$")}, perClient=true)
public class TodoView
implements PersistentStateComponent<State>,
Disposable {
    @NotNull
    private final Project myProject;
    private ToolWindow myToolWindow;
    private ContentManager myContentManager;
    private TodoPanel myAllTodos;
    @Nullable
    private TodoPanel myChangeListTodosPanel;
    private CurrentFileTodosPanel myCurrentFileTodosPanel;
    private ScopeBasedTodosPanel myScopeBasedTodosPanel;
    private final List<TodoPanel> myPanels;
    private final List<Content> myNotAddedContent;
    private State state;
    private final TodoViewChangesSupport myChangesSupport;
    private final TodoViewChangesSupport.Listener myChangesListener;
    private Content myChangeListTodosContent;

    public TodoView(@NotNull Project project) {
        if (project == null) {
            TodoView.$$$reportNull$$$0(0);
        }
        this.myPanels = new ArrayList<TodoPanel>();
        this.myNotAddedContent = new ArrayList<Content>();
        this.state = new State();
        this.myProject = project;
        this.state.all.arePackagesShown = true;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(TodoConfiguration.PROPERTY_CHANGE, (Object)new MyPropertyChangeListener());
        connection.subscribe(FileTypeManager.TOPIC, (Object)new MyFileTypeListener());
        this.myChangesSupport = (TodoViewChangesSupport)project.getService(TodoViewChangesSupport.class);
        this.myChangesListener = this.myChangesSupport.installListener(project, connection, (Function0<? extends ContentManager>)((Function0)() -> this.myContentManager), (Function0<? extends Content>)((Function0)() -> this.myChangeListTodosContent));
    }

    void setSelectedContent(@NotNull TodoPanel panel) {
        Content content;
        if (panel == null) {
            TodoView.$$$reportNull$$$0(1);
        }
        if ((content = this.myContentManager.getContent((JComponent)((Object)panel))) != null) {
            this.myContentManager.setSelectedContent(content);
        }
    }

    @NotNull
    Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            TodoView.$$$reportNull$$$0(2);
        }
        return project;
    }

    @ApiStatus.Internal
    public void loadState(@NotNull State state) {
        if (state == null) {
            TodoView.$$$reportNull$$$0(3);
        }
        this.state = state;
    }

    @ApiStatus.Internal
    @NotNull
    public State getState() {
        if (this.myContentManager != null) {
            Content content = this.myContentManager.getSelectedContent();
            this.state.selectedIndex = content == null ? -1 : this.myContentManager.getIndexOfContent(content);
        }
        State state = this.state;
        if (state == null) {
            TodoView.$$$reportNull$$$0(4);
        }
        return state;
    }

    public void dispose() {
    }

    public void initToolWindow(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TodoView.$$$reportNull$$$0(5);
        }
        ContentFactory contentFactory = ContentFactory.getInstance();
        Content allTodosContent = contentFactory.createContent(null, IdeUICustomization.getInstance().projectMessage("tab.title.project", new Object[0]), false);
        toolWindow.setHelpId("find.todoList");
        this.myAllTodos = new TodoPanel(this, this.state.all, false, allTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(@NotNull JTree tree, @NotNull Project project) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                AllTodosTreeBuilder builder = TodoView.this.createAllTodoBuilder(tree, project);
                builder.init();
                return builder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/todo/TodoView$1";
                objectArray[2] = "createTreeBuilder";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        allTodosContent.setComponent((JComponent)((Object)this.myAllTodos));
        allTodosContent.setPreferredFocusableComponent((JComponent)this.myAllTodos.getTree());
        Disposer.register((Disposable)this, (Disposable)this.myAllTodos);
        if (toolWindow instanceof ToolWindowEx) {
            DefaultActionGroup group = new DefaultActionGroup(){
                {
                    this.getTemplatePresentation().setText(IdeBundle.messagePointer((String)"group.view.options", (Object[])new Object[0]));
                    this.setPopup(true);
                    this.add(TodoView.this.myAllTodos.createAutoScrollToSourceAction());
                    this.addSeparator();
                    this.addAll((ActionGroup)TodoView.this.myAllTodos.createGroupByActionGroup());
                }
            };
            toolWindow.setAdditionalGearActions((ActionGroup)group);
        }
        Content currentFileTodosContent = contentFactory.createContent(null, IdeBundle.message((String)"title.todo.current.file", (Object[])new Object[0]), false);
        this.myCurrentFileTodosPanel = new CurrentFileTodosPanel(this, this.state.current, currentFileTodosContent){

            @Override
            protected TodoTreeBuilder createTreeBuilder(@NotNull JTree tree, @NotNull Project project) {
                if (tree == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (project == null) {
                    3.$$$reportNull$$$0(1);
                }
                CurrentFileTodosTreeBuilder builder = new CurrentFileTodosTreeBuilder(tree, project);
                builder.init();
                return builder;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "tree";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ide/todo/TodoView$3";
                objectArray[2] = "createTreeBuilder";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Disposer.register((Disposable)this, (Disposable)this.myCurrentFileTodosPanel);
        currentFileTodosContent.setComponent((JComponent)((Object)this.myCurrentFileTodosPanel));
        currentFileTodosContent.setPreferredFocusableComponent((JComponent)this.myCurrentFileTodosPanel.getTree());
        String tabName = this.myChangesSupport.getTabName(this.myProject);
        this.myChangeListTodosContent = contentFactory.createContent(null, tabName, false);
        this.myChangeListTodosPanel = this.myChangesSupport.createPanel(this, this.state.current, this.myChangeListTodosContent);
        if (this.myChangeListTodosPanel != null) {
            Disposer.register((Disposable)this, (Disposable)this.myChangeListTodosPanel);
            this.myChangeListTodosContent.setComponent((JComponent)((Object)this.myChangeListTodosPanel));
            this.myChangeListTodosContent.setPreferredFocusableComponent((JComponent)this.myChangeListTodosPanel.getTree());
        }
        Content scopeBasedTodoContent = contentFactory.createContent(null, LangBundle.message((String)"tab.title.scope.based", (Object[])new Object[0]), false);
        this.myScopeBasedTodosPanel = new ScopeBasedTodosPanel(this, this.state.current, scopeBasedTodoContent);
        Disposer.register((Disposable)this, (Disposable)this.myScopeBasedTodosPanel);
        scopeBasedTodoContent.setComponent((JComponent)((Object)this.myScopeBasedTodosPanel));
        this.myToolWindow = toolWindow;
        this.myContentManager = toolWindow.getContentManager();
        this.myContentManager.addContent(allTodosContent);
        this.myContentManager.addContent(currentFileTodosContent);
        this.myContentManager.addContent(scopeBasedTodoContent);
        if (this.myChangesSupport.isContentVisible(this.myProject)) {
            this.myChangesListener.setVisible(true);
            this.myContentManager.addContent(this.myChangeListTodosContent);
        }
        for (Content content : this.myNotAddedContent) {
            this.myContentManager.addContent(content);
        }
        this.myChangeListTodosContent.setCloseable(false);
        allTodosContent.setCloseable(false);
        currentFileTodosContent.setCloseable(false);
        scopeBasedTodoContent.setCloseable(false);
        Content content = this.myContentManager.getContent(this.state.selectedIndex);
        this.myContentManager.setSelectedContent(content == null ? allTodosContent : content);
        this.myPanels.add(this.myAllTodos);
        if (this.myChangeListTodosPanel != null) {
            this.myPanels.add(this.myChangeListTodosPanel);
        }
        this.myPanels.add(this.myCurrentFileTodosPanel);
        this.myPanels.add(this.myScopeBasedTodosPanel);
        MyVisibilityListener visibilityListener = new MyVisibilityListener();
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ToolWindowManagerListener.TOPIC, (Object)visibilityListener);
        toolWindow.addContentManagerListener((ContentManagerListener)visibilityListener);
        this.myAllTodos.invokePostponedRunnable();
        this.myCurrentFileTodosPanel.invokePostponedRunnable();
        if (this.myChangeListTodosPanel != null) {
            this.myChangeListTodosPanel.invokePostponedRunnable();
        }
    }

    @ApiStatus.Internal
    @NotNull
    protected AllTodosTreeBuilder createAllTodoBuilder(@NotNull JTree tree, @NotNull Project project) {
        if (tree == null) {
            TodoView.$$$reportNull$$$0(6);
        }
        if (project == null) {
            TodoView.$$$reportNull$$$0(7);
        }
        return new AllTodosTreeBuilder(tree, project);
    }

    private void visibilityChanged() {
        if (this.myProject.isOpen()) {
            PsiDocumentManager.getInstance((Project)this.myProject).performWhenAllCommitted(() -> this.myPanels.forEach(p -> p.updateVisibility(this.myToolWindow)));
        }
    }

    public final void refresh(@NotNull List<VirtualFile> files) {
        if (files == null) {
            TodoView.$$$reportNull$$$0(8);
        }
        if (this.myAllTodos == null) {
            return;
        }
        this.myPanels.stream().map(TodoPanel::getTreeBuilder).map(TodoTreeBuilder::getCoroutineHelper).forEach(x -> x.scheduleMarkFilesAsDirtyAndUpdateTree(files));
    }

    public TodoPanel getCurrentFilePanel() {
        return this.myCurrentFileTodosPanel;
    }

    @VisibleForTesting
    @NotNull
    public final CompletableFuture<Void> refresh() {
        if (this.myAllTodos == null) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                TodoView.$$$reportNull$$$0(9);
            }
            return completableFuture;
        }
        ReadConstraint inSmartMode = ReadConstraint.Companion.inSmartMode(this.myProject);
        CompletableFuture[] futures = (CompletableFuture[])this.myPanels.stream().map(TodoPanel::getTreeBuilder).map(TodoTreeBuilder::getCoroutineHelper).map(helper -> helper.scheduleCacheAndTreeUpdate(inSmartMode)).toArray(CompletableFuture[]::new);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(futures);
        if (completableFuture == null) {
            TodoView.$$$reportNull$$$0(10);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @Nullable
    public Content addCustomTodoView(@NotNull TodoTreeBuilderFactory factory, @NlsContexts.TabTitle String title, @NotNull TodoPanelSettings settings) {
        Content content;
        TodoPanel panel;
        if (factory == null) {
            TodoView.$$$reportNull$$$0(11);
        }
        if (settings == null) {
            TodoView.$$$reportNull$$$0(12);
        }
        if ((panel = this.myChangesSupport.createPanel(this, settings, content = ContentFactory.getInstance().createContent(null, title, true), factory)) == null) {
            return null;
        }
        content.setComponent((JComponent)((Object)panel));
        Disposer.register((Disposable)this, (Disposable)panel);
        if (this.myContentManager == null) {
            this.myNotAddedContent.add(content);
        } else {
            this.myContentManager.addContent(content);
        }
        this.myPanels.add(panel);
        content.setCloseable(true);
        content.setDisposer(new Disposable(){

            public void dispose() {
                TodoView.this.myPanels.remove((Object)panel);
            }
        });
        return content;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoView";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoView";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initToolWindow";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createAllTodoBuilder";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addCustomTodoView";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 9, 10 -> new IllegalStateException(string);
        };
    }

    static final class State {
        @Attribute(value="selected-index")
        public int selectedIndex;
        @OptionTag(value="selected-file", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings current = new TodoPanelSettings();
        @OptionTag(value="all", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings all = new TodoPanelSettings();
        @OptionTag(value="default-changelist", nameAttribute="id", tag="todo-panel", valueAttribute="")
        public TodoPanelSettings changeList = new TodoPanelSettings();
        @Nls
        public String selectedScope;

        State() {
        }
    }

    private final class MyPropertyChangeListener
    implements PropertyChangeListener {
        private MyPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if ("todoPatterns".equals(e.getPropertyName()) || "todoFilters".equals(e.getPropertyName())) {
                this.updateFilters();
            }
        }

        private void updateFilters() {
            try {
                for (TodoPanel panel : TodoView.this.myPanels) {
                    panel.updateTodoFilter();
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
        }
    }

    private final class MyFileTypeListener
    implements FileTypeListener {
        private MyFileTypeListener() {
        }

        public void fileTypesChanged(@NotNull FileTypeEvent e) {
            if (e == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            TodoView.this.refresh();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoView$MyFileTypeListener", "fileTypesChanged"));
        }
    }

    private final class MyVisibilityListener
    implements ToolWindowManagerListener,
    ContentManagerListener {
        private MyVisibilityListener() {
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            if (toolWindowManager == null) {
                MyVisibilityListener.$$$reportNull$$$0(0);
            }
            TodoView.this.visibilityChanged();
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event == null) {
                MyVisibilityListener.$$$reportNull$$$0(1);
            }
            TodoView.this.visibilityChanged();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toolWindowManager";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/todo/TodoView$MyVisibilityListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "stateChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public static enum Scope {
        AllTodos,
        ChangeList,
        CurrentFile,
        ScopeBased;

    }
}

