/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefOSRHandlerFactory;
import com.intellij.ui.jcef.SettingsHelper;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.cef.CefApp;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefCallback;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.handler.CefResourceHandler;
import org.cef.handler.CefResourceHandlerAdapter;
import org.cef.handler.CefResourceRequestHandler;
import org.cef.handler.CefResourceRequestHandlerAdapter;
import org.cef.misc.BoolRef;
import org.cef.misc.IntRef;
import org.cef.misc.StringRef;
import org.cef.misc.Utils;
import org.cef.network.CefRequest;
import org.cef.network.CefResponse;
import org.jetbrains.annotations.NotNull;

final class StartupTest {
    private static final Logger LOG = Logger.getInstance(StartupTest.class);
    private static final Boolean IS_DISABLED = Utils.getBoolean((String)"ide.browser.jcef.out-of-process.startup_test.disabled");
    private static final int LOAD_TIMEOUT_SEC = Utils.getInteger((String)"ide.browser.jcef.out-of-process.startup_test.timeout_sec", (int)60);
    private static final String TEST_URL = "http://test.com/test.html";
    private static final String TEST_CONTENT = "<html><head><title>Test Title</title></head><body>Test!</body></html>";

    StartupTest() {
    }

    static void checkBrowserCreation(final @NotNull CefApp cefApp, final @NotNull Supplier<Boolean> restarter) {
        if (cefApp == null) {
            StartupTest.$$$reportNull$$$0(0);
        }
        if (restarter == null) {
            StartupTest.$$$reportNull$$$0(1);
        }
        if (IS_DISABLED.booleanValue()) {
            return;
        }
        Runnable test = new Runnable(){
            private CefLoadHandler.ErrorCode errCode = CefLoadHandler.ErrorCode.ERR_NONE;
            private String errText = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean isInitialized = false;
                try {
                    CountDownLatch latch = new CountDownLatch(1);
                    cefApp.onInitialization(state -> latch.countDown());
                    latch.await(LOAD_TIMEOUT_SEC, TimeUnit.SECONDS);
                    if (latch.getCount() == 0L) {
                        isInitialized = true;
                    }
                }
                catch (InterruptedException e) {
                    LOG.error((Throwable)e);
                }
                String errDesc = null;
                if (isInitialized) {
                    final CountDownLatch latch = new CountDownLatch(2);
                    CefClient client = cefApp.createClient();
                    client.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

                        public void onLoadStart(CefBrowser browser, CefFrame frame, CefRequest.TransitionType transitionType) {
                            latch.countDown();
                        }

                        public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                            latch.countDown();
                        }

                        public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                            errCode = errorCode;
                            errText = errorText;
                        }
                    });
                    client.addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(this){

                        public CefResourceRequestHandler getResourceRequestHandler(CefBrowser browser, CefFrame frame, CefRequest request, boolean isNavigation, boolean isDownload, String requestInitiator, BoolRef disableDefaultHandling) {
                            return new CefResourceRequestHandlerAdapter(this){

                                public CefResourceHandler getResourceHandler(CefBrowser browser, CefFrame frame, CefRequest request) {
                                    return new TestResourceHandler(StartupTest.TEST_CONTENT, "text/html");
                                }
                            };
                        }
                    });
                    CefBrowser browser = JBCefBrowserBase.createOsrBrowser(JBCefOSRHandlerFactory.getInstance(), client, StartupTest.TEST_URL, null, null, null, true, new CefBrowserSettings());
                    browser.createImmediately();
                    try {
                        latch.await(LOAD_TIMEOUT_SEC, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException e) {
                        LOG.error((Throwable)e);
                    }
                    finally {
                        client.dispose();
                    }
                    int lc = (int)latch.getCount();
                    if (lc == 0) {
                        return;
                    }
                    if (this.errCode != CefLoadHandler.ErrorCode.ERR_NONE) {
                        LOG.warn(String.format("onLoadError occurred, errCode=%s, errText=%s.", this.errCode, this.errText));
                    }
                    if (lc == 2) {
                        errDesc = "onLoadStart wasn't called";
                    } else if (lc == 1) {
                        errDesc = "onLoadEnd wasn't called";
                    }
                } else {
                    errDesc = "CefApp wasn't initialized";
                }
                LOG.error(String.format("Startup JCEF test is failed (because %s). JCEF will be restarted with verbose logging.", errDesc));
                boolean result = (Boolean)restarter.get();
                if (!result) {
                    LOG.warn("JCEF restart failed.");
                }
            }
        };
        ApplicationManager.getApplication().executeOnPooledThread(test);
    }

    private static void showNotification() {
        Notification notification = ((NotificationGroup)SettingsHelper.NOTIFICATION_GROUP.getValue()).createNotification("Out-of-process JCEF mode is disabled.", "JCEF is running in out-of-process mode now and it seems to be unstable. This mode will be disabled (JCEF will run in usual mode after IDE restart).", NotificationType.ERROR);
        notification.addAction(new AnAction(IdeBundle.message((String)"notification.content.jcef.gpucrash.action.restart", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().restart();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/jcef/StartupTest$2", "actionPerformed"));
            }
        });
        notification.notify(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "cefApp";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "restarter";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/jcef/StartupTest";
        objectArray[2] = "checkBrowserCreation";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class TestResourceHandler
    extends CefResourceHandlerAdapter {
        private int myOffset = 0;
        private final String myContent;
        private final String myMimeType;

        TestResourceHandler(String content, String mimeType) {
            this.myContent = content;
            this.myMimeType = mimeType;
        }

        public boolean processRequest(CefRequest request, CefCallback callback) {
            callback.Continue();
            return true;
        }

        public void getResponseHeaders(CefResponse response, IntRef response_length, StringRef redirectUrl) {
            response_length.set(this.myContent.length());
            response.setMimeType(this.myMimeType);
            response.setStatus(200);
        }

        public boolean readResponse(byte[] data_out, int bytes_to_read, IntRef bytes_read, CefCallback callback) {
            int length = this.myContent.length();
            if (this.myOffset >= length) {
                return false;
            }
            int endPos = this.myOffset + bytes_to_read;
            String dataToSend = endPos > length ? this.myContent.substring(this.myOffset) : this.myContent.substring(this.myOffset, endPos);
            ByteBuffer result = ByteBuffer.wrap(data_out);
            result.put(dataToSend.getBytes());
            bytes_read.set(dataToSend.length());
            this.myOffset = endPos;
            return true;
        }
    }
}

