/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ+\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ui/jcef/JBCefPsiNavigationUtils;", "", "<init>", "()V", "PSI_ELEMENT_COORDINATES", "Lkotlin/text/Regex;", "FILE_PATH_GROUP", "", "OFFSET_GROUP", "navigateTo", "", "requestLink", "", "filePath", "lineColumn", "Lcom/intellij/openapi/util/text/LineColumn;", "offset", "(Ljava/lang/String;Ljava/lang/Integer;Lcom/intellij/openapi/util/text/LineColumn;)Z", "parsePsiElementCoordinates", "Lcom/intellij/ui/jcef/JBCefPsiNavigationUtils$Coordinates;", "rawCoordinates", "Coordinates", "intellij.platform.ui.jcef"})
@SourceDebugExtension(value={"SMAP\nJBCefPsiNavigationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBCefPsiNavigationUtils.kt\ncom/intellij/ui/jcef/JBCefPsiNavigationUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,58:1\n1#2:59\n*E\n"})
public final class JBCefPsiNavigationUtils {
    @NotNull
    public static final JBCefPsiNavigationUtils INSTANCE = new JBCefPsiNavigationUtils();
    @NonNls
    @NotNull
    private static final Regex PSI_ELEMENT_COORDINATES = new Regex("source://(.+):(\\d+)");
    private static final int FILE_PATH_GROUP = 1;
    private static final int OFFSET_GROUP = 2;

    private JBCefPsiNavigationUtils() {
    }

    public final boolean navigateTo(@NotNull String requestLink) {
        Intrinsics.checkNotNullParameter((Object)requestLink, (String)"requestLink");
        Coordinates coordinates = this.parsePsiElementCoordinates(requestLink);
        if (coordinates == null) {
            return false;
        }
        Coordinates coordinates2 = coordinates;
        String filePath = coordinates2.component1();
        int offset = coordinates2.component2();
        return JBCefPsiNavigationUtils.navigateTo$default(this, filePath, offset, null, 4, null);
    }

    public final boolean navigateTo(@NotNull String filePath, @NotNull LineColumn lineColumn) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)lineColumn, (String)"lineColumn");
        return this.navigateTo(filePath, null, lineColumn);
    }

    private final boolean navigateTo(String filePath, Integer offset, LineColumn lineColumn) {
        DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(arg_0 -> JBCefPsiNavigationUtils.navigateTo$lambda$1(arg_0 -> JBCefPsiNavigationUtils.navigateTo$lambda$0(offset, lineColumn, filePath, arg_0), arg_0));
        return true;
    }

    static /* synthetic */ boolean navigateTo$default(JBCefPsiNavigationUtils jBCefPsiNavigationUtils, String string, Integer n, LineColumn lineColumn, int n2, Object object) {
        if ((n2 & 4) != 0) {
            lineColumn = null;
        }
        return jBCefPsiNavigationUtils.navigateTo(string, n, lineColumn);
    }

    private final Coordinates parsePsiElementCoordinates(String rawCoordinates) {
        MatchResult matchResult = PSI_ELEMENT_COORDINATES.matchEntire((CharSequence)rawCoordinates);
        if (matchResult == null || (matchResult = matchResult.getGroups()) == null) {
            return null;
        }
        MatchResult groups = matchResult;
        Object object = groups.get(1);
        if (object == null || (object = object.getValue()) == null) {
            return null;
        }
        Object filePath = object;
        Object object2 = groups.get(2);
        if (object2 == null || (object2 = object2.getValue()) == null) {
            return null;
        }
        int offset = Integer.parseInt((String)object2);
        return new Coordinates((String)filePath, offset);
    }

    private static final Unit navigateTo$lambda$0(Integer $offset, LineColumn $lineColumn, String $filePath, DataContext dataContext) {
        OpenFileDescriptor openFileDescriptor;
        Intrinsics.checkNotNull((Object)dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project2).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        Sequence sequence = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), arg_0 -> JBCefPsiNavigationUtils.navigateTo$lambda$0$0($filePath, arg_0));
        VirtualFileManager virtualFileManager = VirtualFileManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileManager, (String)"getInstance(...)");
        VirtualFile virtualFile2 = (VirtualFile)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)((Function1)new Function1<Path, VirtualFile>((Object)virtualFileManager){

            public final VirtualFile invoke(Path p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((VirtualFileManager)this.receiver).findFileByNioPath(p0);
            }
        })));
        if (virtualFile2 == null) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Integer n = $offset;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            openFileDescriptor = new OpenFileDescriptor(project2, virtualFile3, $offset.intValue());
        } else {
            LineColumn lineColumn = $lineColumn;
            if (lineColumn != null) {
                LineColumn it = lineColumn;
                boolean bl = false;
                openFileDescriptor = new OpenFileDescriptor(project2, virtualFile3, $lineColumn.line, $lineColumn.column);
            } else {
                return Unit.INSTANCE;
            }
        }
        OpenFileDescriptor descriptor = openFileDescriptor;
        ApplicationManager.getApplication().invokeLater(() -> JBCefPsiNavigationUtils.navigateTo$lambda$0$3(project2, descriptor));
        return Unit.INSTANCE;
    }

    private static final Path navigateTo$lambda$0$0(String $filePath, VirtualFile it) {
        String[] stringArray = new String[]{$filePath};
        return Paths.get(it.getPath(), stringArray);
    }

    private static final void navigateTo$lambda$0$3(Project $project, OpenFileDescriptor $descriptor) {
        FileEditorManager.getInstance((Project)$project).openEditor($descriptor, true);
    }

    private static final void navigateTo$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ui/jcef/JBCefPsiNavigationUtils$Coordinates;", "", "filePath", "", "offset", "", "<init>", "(Ljava/lang/String;I)V", "getFilePath", "()Ljava/lang/String;", "getOffset", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.ui.jcef"})
    private static final class Coordinates {
        @NotNull
        private final String filePath;
        private final int offset;

        public Coordinates(@NotNull String filePath, int offset) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.filePath = filePath;
            this.offset = offset;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final int getOffset() {
            return this.offset;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        public final int component2() {
            return this.offset;
        }

        @NotNull
        public final Coordinates copy(@NotNull String filePath, int offset) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return new Coordinates(filePath, offset);
        }

        public static /* synthetic */ Coordinates copy$default(Coordinates coordinates, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = coordinates.filePath;
            }
            if ((n2 & 2) != 0) {
                n = coordinates.offset;
            }
            return coordinates.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Coordinates(filePath=" + this.filePath + ", offset=" + this.offset + ")";
        }

        public int hashCode() {
            int result = this.filePath.hashCode();
            result = result * 31 + Integer.hashCode(this.offset);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Coordinates)) {
                return false;
            }
            Coordinates coordinates = (Coordinates)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)coordinates.filePath)) {
                return false;
            }
            return this.offset == coordinates.offset;
        }
    }
}

