/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefLoadHtmlResourceHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class JBCefFileSchemeHandlerFactory
implements JBCefApp.JBCefCustomSchemeHandlerFactory {
    public static final String FILE_SCHEME_NAME = "file";
    public static final String LOADHTML_RANDOM_URL_PREFIX = "file:///jbcefbrowser/";
    public static final Map<CefBrowser, Map<String, String>> LOADHTML_REQUEST_MAP = new WeakHashMap<CefBrowser, Map<String, String>>();

    @Override
    public void registerCustomScheme(@NotNull CefSchemeRegistrar registrar) {
        if (registrar == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(0);
        }
    }

    @Override
    @NotNull
    public String getSchemeName() {
        return FILE_SCHEME_NAME;
    }

    @Override
    @NotNull
    public String getDomainName() {
        return "";
    }

    public CefResourceHandler create(@NotNull CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
        String html;
        if (browser == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(1);
        }
        if (!FILE_SCHEME_NAME.equals(schemeName)) {
            return null;
        }
        String url = request.getURL();
        if (url == null) {
            return null;
        }
        url = JBCefFileSchemeHandlerFactory.normalizeUrl(url);
        Map<String, String> map = LOADHTML_REQUEST_MAP.get(browser);
        if (map != null && (html = map.get(url)) != null) {
            return new JBCefLoadHtmlResourceHandler(html);
        }
        return null;
    }

    @NotNull
    public static String registerLoadHTMLRequest(@NotNull CefBrowser browser, @NotNull String html, @NotNull String origUrl) {
        if (browser == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(2);
        }
        if (html == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(3);
        }
        if (origUrl == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(4);
        }
        origUrl = JBCefFileSchemeHandlerFactory.normalizeUrl(origUrl);
        String fileUrl = JBCefFileSchemeHandlerFactory.makeFileUrl(origUrl);
        JBCefFileSchemeHandlerFactory.getInitMap(browser).put(fileUrl, html);
        String string = fileUrl;
        if (string == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(5);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Map<String, String> getInitMap(@NotNull CefBrowser browser) {
        Map<String, String> map;
        if (browser == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(6);
        }
        if ((map = LOADHTML_REQUEST_MAP.get(browser)) == null) {
            Map<CefBrowser, Map<String, String>> map2 = LOADHTML_REQUEST_MAP;
            synchronized (map2) {
                map = LOADHTML_REQUEST_MAP.get(browser);
                if (map == null) {
                    map = Collections.synchronizedMap(new HashMap());
                    LOADHTML_REQUEST_MAP.put(browser, map);
                }
            }
        }
        Map<String, String> map3 = map;
        if (map3 == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(7);
        }
        return map3;
    }

    @NotNull
    public static String makeFileUrl(@NotNull String url) {
        if (url == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(8);
        }
        if (url.startsWith("file://")) {
            String string = url;
            if (string == null) {
                JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(9);
            }
            return string;
        }
        return JBCefFileSchemeHandlerFactory.normalizeUrl(LOADHTML_RANDOM_URL_PREFIX + new Random().nextInt(Integer.MAX_VALUE) + "#url=" + url);
    }

    @NotNull
    private static String normalizeUrl(@NotNull String url) {
        if (url == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(10);
        }
        String string = url.replaceAll("/$", "");
        if (string == null) {
            JBCefFileSchemeHandlerFactory.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origUrl";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefFileSchemeHandlerFactory";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefFileSchemeHandlerFactory";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "registerLoadHTMLRequest";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitMap";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFileUrl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomScheme";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerLoadHTMLRequest";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInitMap";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeFileUrl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "normalizeUrl";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 11 -> new IllegalStateException(string);
        };
    }
}

