/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.execution.Platform;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.jcef.CefDelegate;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefFileSchemeHandlerFactory;
import com.intellij.ui.jcef.JBCefHealthMonitor;
import com.intellij.ui.jcef.JBCefNativeBundleProvider;
import com.intellij.ui.jcef.JBCefOSRHandlerFactory;
import com.intellij.ui.jcef.JBCefSourceSchemeHandlerFactory;
import com.intellij.ui.jcef.JcefBundle;
import com.intellij.ui.jcef.LibC;
import com.intellij.ui.jcef.SettingsHelper;
import com.intellij.ui.jcef.StartupTest;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.OS;
import org.cef.SystemBootstrap;
import org.cef.browser.CefMessageRouter;
import org.cef.browser.CefRendering;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.cef.handler.CefRenderHandler;
import org.cef.misc.BoolRef;
import org.cef.misc.CefLog;
import org.jdom.IllegalDataException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class JBCefApp {
    private static final Logger LOG = Logger.getInstance(JBCefApp.class);
    private static final boolean SKIP_VERSION_CHECK = Boolean.getBoolean("ide.browser.jcef.skip_version_check");
    private static final String REGISTRY_REMOTE_KEY = "ide.browser.jcef.out-of-process.enabled";
    private static final int MIN_SUPPORTED_CEF_MAJOR_VERSION = 119;
    private static final int MIN_SUPPORTED_JCEF_API_MAJOR_VERSION = 1;
    private static final int MIN_SUPPORTED_JCEF_API_MINOR_VERSION = 20;
    private static final String MIN_SUPPORTED_GLIBC_DEFAULT = "2.28.0";
    private static final AtomicInteger CEFAPP_INSTANCE_COUNT = new AtomicInteger(0);
    @Nullable
    private final CefDelegate myDelegate;
    @Nullable
    private CefApp myCefApp;
    private String @Nullable [] myCefArgs;
    @Nullable
    private final CefSettings myCefSettings;
    @NotNull
    private final CompletableFuture<Integer> myDebuggingPort;
    private final boolean myIsRemoteEnabled;
    @Nullable
    private final File myServerExe;
    @NotNull
    private final Disposable myDisposable;
    private static volatile AtomicBoolean ourSupported;
    private static final Object ourSupportedLock;
    private static final AtomicBoolean ourInitialized;
    private static final List<JBCefCustomSchemeHandlerFactory> ourCustomSchemeHandlerFactoryList;

    private JBCefApp(@NotNull JCefAppConfig config) throws IllegalStateException {
        if (config == null) {
            JBCefApp.$$$reportNull$$$0(0);
        }
        this.myDebuggingPort = new CompletableFuture();
        this.myDisposable = new Disposable(){

            public void dispose() {
                if (JBCefApp.this.myCefApp != null) {
                    JBCefApp.this.myCefApp.dispose();
                }
            }
        };
        this.myDelegate = JBCefApp.getActiveDelegate();
        this.myIsRemoteEnabled = this.myDelegate == null && config.isRemoteEnabled();
        this.myServerExe = config.getServerExe();
        SystemBootstrap.setLoader((SystemBootstrap.Loader)config.getLoader());
        if (this.myDelegate != null) {
            this.myCefSettings = null;
            this.myCefApp = null;
            this.myDebuggingPort.completeExceptionally(new UnsupportedOperationException());
        } else {
            CefApp.setIsRemoteEnabled((boolean)this.myIsRemoteEnabled);
            if (this.myIsRemoteEnabled) {
                Supplier<CefRendering> defaultRenderingFactory = () -> {
                    JBCefOSRHandlerFactory osrHandlerFactory = JBCefOSRHandlerFactory.getInstance();
                    JComponent component = osrHandlerFactory.createComponent(true);
                    CefRenderHandler handler = osrHandlerFactory.createCefRenderHandler(component);
                    return new CefRendering.CefRenderingWithHandler(handler, (Component)component);
                };
                CefApp.setDefaultRenderingFactory(defaultRenderingFactory);
            }
            CefSettings settings = (CefSettings)Cancellation.forceNonCancellableSectionInClassInitializer(() -> SettingsHelper.loadSettings(config));
            String logPath = SettingsHelper.getLogPath();
            CefLog.init((String)logPath, (CefSettings.LogSeverity)settings.log_severity);
            JBCefHealthMonitor.getInstance().performHealthCheckAsync(settings, () -> {
                if (OS.isMacintosh() && config.getCefFrameworkPathOSX() != null) {
                    CefApp.startupAsync((String)config.getCefFrameworkPathOSX());
                } else {
                    CefApp.startup((String[])ArrayUtil.EMPTY_STRING_ARRAY);
                }
            });
            BoolRef trackGPUCrashes = new BoolRef(false);
            String[] args = (String[])Cancellation.forceNonCancellableSectionInClassInitializer(() -> SettingsHelper.loadArgs(config, settings, trackGPUCrashes));
            if (SettingsHelper.isDebugMode()) {
                settings.log_severity = CefSettings.LogSeverity.LOGSEVERITY_INFO;
                settings.log_file = null;
                args = ArrayUtil.mergeArrays((String[])args, (String[])new String[]{"--enable-logging=stderr", "--vmodule=statistics_recorder*=0", "--v=1"});
            }
            if (settings.log_severity != CefSettings.LogSeverity.LOGSEVERITY_DISABLE || settings.log_file != null || logPath != null) {
                LOG.info(String.format("JCEF logging: level=%s, file=%s, chromium_log=%s", settings.log_severity, logPath, settings.log_file));
            }
            this.myCefArgs = args;
            CefApp.addAppHandler((CefAppHandler)new MyCefAppHandler(args, trackGPUCrashes.get()));
            this.myCefSettings = settings;
            this.myCefApp = CefApp.getInstance(null, (CefSettings)settings, (File)this.myServerExe);
            CEFAPP_INSTANCE_COUNT.incrementAndGet();
            if (this.myCefSettings.remote_debugging_port > 0) {
                this.myDebuggingPort.complete(this.myCefSettings.remote_debugging_port);
            } else {
                this.myCefApp.onInitialization(state -> {
                    try {
                        this.myDebuggingPort.complete(JBCefApp.readDebugPortFile(Path.of(this.myCefSettings.cache_path, "DevToolsActivePort")));
                    }
                    catch (Exception e) {
                        this.myDebuggingPort.completeExceptionally(e);
                    }
                });
            }
            if (this.myIsRemoteEnabled) {
                StartupTest.checkBrowserCreation(this.myCefApp, () -> this.restartJCEF(true, true));
                if (ApplicationManager.getApplication().isInternal()) {
                    ActionManagerEx.getInstanceEx().registerAction("RestartJCEFActionId", new AnAction(JcefBundle.message("action.RestartJCEFActionId.text", new Object[0])){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            JBCefApp.this.restartJCEF(false, true);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/jcef/JBCefApp$2", "actionPerformed"));
                        }
                    });
                    ActionManagerEx.getInstanceEx().registerAction("RestartJCEFWithDebugActionId", new AnAction(JcefBundle.message("action.RestartJCEFWithDebugActionId.text", new Object[0])){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            JBCefApp.this.restartJCEF(true, true);
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/jcef/JBCefApp$3", "actionPerformed"));
                        }
                    });
                }
            }
        }
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.myDisposable);
    }

    private boolean restartJCEF(boolean withVerboseLogging, boolean withNewCachePath) {
        if (!this.myIsRemoteEnabled) {
            return false;
        }
        if (this.myCefSettings == null) {
            LOG.error("JCEF wasn't restarted (because running with CefDelegate).");
            return false;
        }
        if (this.myCefArgs == null) {
            this.myCefArgs = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (withVerboseLogging) {
            this.myCefSettings.log_severity = CefSettings.LogSeverity.LOGSEVERITY_VERBOSE;
            this.myCefSettings.log_file = PathManager.getLogPath() + Platform.current().fileSeparator + "jcef_chromium_" + ProcessHandle.current().pid() + "_i" + CEFAPP_INSTANCE_COUNT.get() + ".log";
            this.myCefArgs = ArrayUtil.mergeArrays((String[])this.myCefArgs, (String[])new String[]{"--vmodule=statistics_recorder*=0", "--v=1"});
        }
        if (withNewCachePath) {
            this.myCefSettings.cache_path = System.getProperty("java.io.tmpdir") + Platform.current().fileSeparator + "jcef_cache_" + ProcessHandle.current().pid() + "_i" + CEFAPP_INSTANCE_COUNT.get();
        }
        String logPath = PathManager.getLogPath() + Platform.current().fileSeparator + "jcef_" + ProcessHandle.current().pid() + "_i" + CEFAPP_INSTANCE_COUNT.get() + ".log";
        CefLog.init((String)logPath, (CefSettings.LogSeverity)this.myCefSettings.log_severity);
        CefApp.addAppHandler((CefAppHandler)new MyCefAppHandler(this.myCefArgs, true));
        CefApp newInstance = CefApp.getInstance((String[])this.myCefArgs, (CefSettings)this.myCefSettings, (File)this.myServerExe);
        if (newInstance == null) {
            LOG.error("JCEF wasn't restarted (new instance is null).");
            return false;
        }
        if (this.myCefApp == newInstance) {
            LOG.info("JCEF wasn't restarted. It seems that args and settings were the same - please dispose current CefApp and then create a new one.");
            return false;
        }
        CEFAPP_INSTANCE_COUNT.incrementAndGet();
        CefApp.setDefaultInstance((CefApp)newInstance);
        if (this.myCefApp != null) {
            this.myCefApp.dispose();
        }
        this.myCefApp = newInstance;
        LOG.info("JCEF has been restarted with verbose logging, with new cache_path '" + this.myCefSettings.cache_path + "', with log_file '" + this.myCefSettings.log_file + "'");
        return true;
    }

    @NotNull
    Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            JBCefApp.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static JBCefApp getInstance() {
        if (Holder.INSTANCE == null) {
            Class<Holder> clazz = Holder.class;
            // MONITORENTER : com.intellij.ui.jcef.JBCefApp$Holder.class
            if (Holder.INSTANCE == null) {
                if (!RegistryManager.getInstance().is("ide.browser.jcef.testMode.enabled")) throw new IllegalStateException("JCEF is not supported in this env or failed to initialize");
                Holder.INSTANCE = Holder.init();
                if (Holder.INSTANCE == null) throw new IllegalStateException("JCEF is not supported in this env or failed to initialize");
                JBCefApp jBCefApp = Objects.requireNonNull(Holder.INSTANCE);
                // MONITOREXIT : clazz
                if (jBCefApp != null) return jBCefApp;
                JBCefApp.$$$reportNull$$$0(2);
                return jBCefApp;
            }
            // MONITOREXIT : clazz
        }
        JBCefApp jBCefApp = Objects.requireNonNull(Holder.INSTANCE);
        if (jBCefApp != null) return jBCefApp;
        JBCefApp.$$$reportNull$$$0(3);
        return jBCefApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupported() {
        boolean testModeEnabled = RegistryManager.getInstance().is("ide.browser.jcef.testMode.enabled");
        Object object = ourSupportedLock;
        synchronized (object) {
            if (ourSupported != null && !testModeEnabled) {
                return ourSupported.get();
            }
            if (testModeEnabled) {
                ourSupported = null;
            } else if (ourSupported != null) {
                return ourSupported.get();
            }
            boolean supported = JBCefApp.isSupportedImpl();
            ourSupported = new AtomicBoolean(supported);
            return supported;
        }
    }

    private static boolean isSupportedImpl() {
        CefDelegate delegate = JBCefApp.getActiveDelegate();
        if (delegate != null) {
            return delegate.isCefSupported();
        }
        if (SystemInfo.isLinux && !JBCefApp.isLinuxLibcSupported()) {
            return false;
        }
        Function<String, Boolean> unsupported = msg -> {
            LOG.warn(msg + (!msg.contains("disabled") ? " (Use JBR bundled with the IDE)" : ""));
            return false;
        };
        if (!RegistryManager.getInstance().is("ide.browser.jcef.enabled")) {
            return unsupported.apply("JCEF is manually disabled via 'ide.browser.jcef.enabled=false'");
        }
        if (GraphicsEnvironment.isHeadless() && !RegistryManager.getInstance().is("ide.browser.jcef.headless.enabled")) {
            return unsupported.apply("JCEF is manually disabled in headless env via 'ide.browser.jcef.headless.enabled=false'");
        }
        if (!SKIP_VERSION_CHECK) {
            JCefVersionDetails version;
            try {
                version = JCefAppConfig.getVersionDetails();
            }
            catch (Throwable e) {
                return unsupported.apply("JCEF runtime version is not supported");
            }
            if (119 > version.cefVersion.major) {
                return unsupported.apply("JCEF: minimum supported CEF major version is 119, current is " + version.cefVersion.major);
            }
            if (1 > version.apiVersion.major || 1 == version.apiVersion.major && 20 > version.apiVersion.minor) {
                return unsupported.apply("JCEF: minimum supported API version is 1.20, current is " + version.apiVersion.major + "." + version.apiVersion.minor);
            }
        }
        return JBCefApp.isJcefFromJbr() || JBCefApp.getNativeBundlePath() != null;
    }

    private static boolean isJcefFromJbr() {
        URL url = JCefAppConfig.class.getResource("JCefAppConfig.class");
        if (url == null) {
            LOG.error("JCefAppConfig.class not found");
            return false;
        }
        return url.getProtocol().equals("jrt");
    }

    public static boolean isStarted() {
        boolean initialised = ourInitialized.get();
        if (!initialised) {
            return false;
        }
        return JBCefApp.getInstance() != null;
    }

    @Contract(pure=true)
    @NotNull
    String getCachePath() {
        if (this.myCefSettings == null) {
            throw new UnsupportedOperationException();
        }
        String string = this.myCefSettings.cache_path;
        if (string == null) {
            JBCefApp.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void getRemoteDebuggingPort(@NotNull Consumer<? super @Nullable Integer> consumer) {
        if (consumer == null) {
            JBCefApp.$$$reportNull$$$0(5);
        }
        this.myDebuggingPort.whenCompleteAsync((integer, throwable) -> {
            if (throwable != null) {
                LOG.error("Failed to get JCEF debugging port: " + throwable.getMessage());
                consumer.accept(null);
            } else {
                consumer.accept((Integer)integer);
            }
        }, f -> SwingUtilities.invokeLater(f));
    }

    @NotNull
    public JBCefClient createClient() {
        CefClient cefClient = this.myDelegate == null ? Objects.requireNonNull(this.myCefApp).createClient() : this.myDelegate.createClient();
        return new JBCefClient(cefClient);
    }

    @NotNull
    public CefMessageRouter createMessageRouter(@Nullable CefMessageRouter.CefMessageRouterConfig config) {
        if (this.myDelegate != null) {
            CefMessageRouter cefMessageRouter = this.myDelegate.createMessageRouter(config);
            if (cefMessageRouter == null) {
                JBCefApp.$$$reportNull$$$0(6);
            }
            return cefMessageRouter;
        }
        CefMessageRouter cefMessageRouter = CefMessageRouter.create((CefMessageRouter.CefMessageRouterConfig)config);
        if (cefMessageRouter == null) {
            JBCefApp.$$$reportNull$$$0(7);
        }
        return cefMessageRouter;
    }

    public static boolean isOffScreenRenderingModeEnabled() {
        return SettingsHelper.isOffScreenRenderingModeEnabled();
    }

    @Nullable
    public CefSettings getCefSettings() {
        return this.myCefSettings;
    }

    static void checkOffScreenRenderingModeEnabled() {
        if (!JBCefApp.isOffScreenRenderingModeEnabled()) {
            throw new IllegalStateException("off-screen rendering mode is disabled: 'ide.browser.jcef.osr.enabled=false'");
        }
    }

    public static NotificationGroup getNotificationGroup() {
        return (NotificationGroup)SettingsHelper.NOTIFICATION_GROUP.getValue();
    }

    @ApiStatus.Internal
    public static void addCefCustomSchemeHandlerFactory(@NotNull JBCefCustomSchemeHandlerFactory factory) {
        if (factory == null) {
            JBCefApp.$$$reportNull$$$0(8);
        }
        if (ourInitialized.get()) {
            throw new IllegalStateException("JBCefApp has already been initialized!");
        }
        ourCustomSchemeHandlerFactoryList.add(factory);
    }

    @Contract(pure=true)
    @ApiStatus.Internal
    @NotNull
    public static @UnmodifiableView List<JBCefCustomSchemeHandlerFactory> getCefCustomSchemeHandlerFactories() {
        List<JBCefCustomSchemeHandlerFactory> list = Collections.unmodifiableList(ourCustomSchemeHandlerFactoryList);
        if (list == null) {
            JBCefApp.$$$reportNull$$$0(9);
        }
        return list;
    }

    public static double getForceDeviceScaleFactor() {
        return JreHiDpiUtil.isJreHiDPIEnabled() ? -1.0 : ScaleContext.create().getScale(DerivedScaleType.PIX_SCALE);
    }

    public static int normalizeScaledSize(int scaledSize) {
        return JreHiDpiUtil.isJreHiDPIEnabled() ? scaledSize : PaintUtil.RoundingMode.ROUND.round((double)scaledSize / JBCefApp.getForceDeviceScaleFactor());
    }

    boolean isRemoteEnabled() {
        return this.myIsRemoteEnabled;
    }

    private static int readDebugPortFile(@NotNull Path filePath) throws IOException {
        if (filePath == null) {
            JBCefApp.$$$reportNull$$$0(10);
        }
        try (Stream<String> lines = Files.lines(filePath);){
            String portNumber = lines.findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to read JCEF debugging port number in " + String.valueOf(filePath)));
            int value = Integer.parseInt(portNumber);
            if (value > 0) {
                int n = value;
                return n;
            }
            throw new IllegalDataException("Invalid JCEF JCEF debugging port number value: " + value);
        }
    }

    @Nullable
    CefDelegate getDelegate() {
        return this.myDelegate;
    }

    @Nullable
    private static CefDelegate getActiveDelegate() {
        return (CefDelegate)CefDelegate.EP.findFirstSafe(CefDelegate::isActive);
    }

    @Nullable
    private static String getNativeBundlePath() {
        if (JBCefApp.isJcefFromJbr()) {
            return null;
        }
        @Nullable JBCefNativeBundleProvider provider = null;
        if (!JBCefApp.isJcefFromJbr()) {
            provider = (JBCefNativeBundleProvider)JBCefNativeBundleProvider.EP.findFirstSafe(JBCefNativeBundleProvider::isAvailable);
        }
        if (provider == null) {
            return null;
        }
        return provider.getNativeBundlePath();
    }

    private static boolean isLinuxLibcSupported() {
        String libcVersionString;
        try {
            libcVersionString = LibC.INSTANCE.gnu_get_libc_version();
        }
        catch (UnsatisfiedLinkError e) {
            LOG.warn("Failed to get the glibc version: " + e.getMessage());
            return false;
        }
        Version version = Version.parseVersion((String)libcVersionString);
        if (version == null) {
            LOG.warn("Failed to parse the glibc version: " + libcVersionString);
            return false;
        }
        Version minSupportedGlibc = Version.parseVersion((String)System.getProperty("ide.browser.jcef.required.glibc.version", MIN_SUPPORTED_GLIBC_DEFAULT));
        if (minSupportedGlibc != null && version.compareTo(minSupportedGlibc) < 0) {
            LOG.warn("Incompatible glibc version: " + libcVersionString + "; JCEF is disabled");
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    @Nullable
    public static String getNativeBundleVersionString() {
        String nativeBundlePath = JBCefApp.getNativeBundlePath();
        if (nativeBundlePath == null) {
            return null;
        }
        Path versionFile = Path.of(nativeBundlePath, "jcef.version");
        if (Files.exists(versionFile, new LinkOption[0])) {
            try {
                for (String line : Files.readAllLines(versionFile)) {
                    String[] split;
                    if (!line.contains("JCEF_VERSION_DETAILED") || (split = line.split("=")).length != 2) continue;
                    return split[1].trim();
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    static {
        ourSupportedLock = new Object();
        ourInitialized = new AtomicBoolean(false);
        ourCustomSchemeHandlerFactoryList = Collections.synchronizedList(new ArrayList());
        JBCefApp.addCefCustomSchemeHandlerFactory(new JBCefSourceSchemeHandlerFactory());
        JBCefApp.addCefCustomSchemeHandlerFactory(new JBCefFileSchemeHandlerFactory());
        if (SettingsHelper.isDebugMode()) {
            LOG.info("Use verbose CefLog to stderr.");
            System.err.println("Use verbose CefLog to stderr.");
            CefLog.init(null, (CefSettings.LogSeverity)CefSettings.LogSeverity.LOGSEVERITY_VERBOSE);
            System.setProperty("CEF_SERVER_LOG_LEVEL", "5");
        }
        if (RegistryManager.getInstance().is(REGISTRY_REMOTE_KEY)) {
            String PROPERTY_NAME = "jcef.remote.enabled";
            String isRemoteEnabledSystemProp = System.getProperty("jcef.remote.enabled");
            if (isRemoteEnabledSystemProp != null) {
                boolean val = isRemoteEnabledSystemProp.trim().compareToIgnoreCase("true") == 0;
                LOG.info(String.format("Force %s out-of-process jcef mode.", val ? "enabled" : "disabled"));
            } else {
                System.setProperty("jcef.remote.enabled", "true");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefApp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefApp";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachePath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessageRouter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefCustomSchemeHandlerFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteDebuggingPort";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addCefCustomSchemeHandlerFactory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readDebugPortFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 9 -> new IllegalStateException(string);
        };
    }

    private static class MyCefAppHandler
    extends CefAppHandlerAdapter {
        private final int myGPUCrashLimit;
        private int myGPULaunchCounter;
        private boolean myNotificationShown;
        private final String myArgs;

        MyCefAppHandler(String @Nullable [] args, boolean trackGPUCrashes) {
            super(args);
            this.myArgs = Arrays.toString(args);
            this.myGPUCrashLimit = trackGPUCrashes ? Integer.getInteger("ide.browser.jcef.gpu.infinitecrash.internallimit", 10) : -1;
        }

        public boolean onBeforeTerminate() {
            return true;
        }

        public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
            for (JBCefCustomSchemeHandlerFactory f : ourCustomSchemeHandlerFactoryList) {
                f.registerCustomScheme(registrar);
            }
        }

        public void stateHasChanged(CefApp.CefAppState state) {
            if (state.equals((Object)CefApp.CefAppState.INITIALIZED)) {
                LOG.info(String.format("jcef version: %s | cmd args: %s", CefApp.getInstance().getVersion().getJcefVersion(), this.myArgs));
            }
        }

        public void onContextInitialized() {
            for (JBCefCustomSchemeHandlerFactory f : ourCustomSchemeHandlerFactoryList) {
                Objects.requireNonNull(JBCefApp.getInstance().myCefApp).registerSchemeHandlerFactory(f.getSchemeName(), f.getDomainName(), (CefSchemeHandlerFactory)f);
            }
        }

        public void onBeforeChildProcessLaunch(String command_line) {
            if (command_line == null || !command_line.contains("--type=gpu-process")) {
                return;
            }
            ++this.myGPULaunchCounter;
            if (this.myGPUCrashLimit >= 0 && this.myGPULaunchCounter > this.myGPUCrashLimit) {
                if (!this.myNotificationShown) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> SettingsHelper.showNotificationDisableGPU());
                    this.myNotificationShown = true;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> CefApp.getInstance().dispose());
                JBCefHealthMonitor.getInstance().onGpuProcessFailed();
            }
        }
    }

    private static final class Holder {
        @Nullable
        static volatile JBCefApp INSTANCE = Holder.init();

        private Holder() {
        }

        @Nullable
        static JBCefApp init() {
            ourInitialized.set(true);
            JCefAppConfig config = null;
            if (JBCefApp.isSupported()) {
                try {
                    String nativeBundlePath;
                    if (!JreHiDpiUtil.isJreHiDPIEnabled()) {
                        System.setProperty("jcef.forceDeviceScaleFactor", String.valueOf(JBCefApp.getForceDeviceScaleFactor()));
                    }
                    config = (nativeBundlePath = JBCefApp.getNativeBundlePath()) != null && !JBCefApp.isJcefFromJbr() ? JCefAppConfig.getInstance((String)nativeBundlePath) : JCefAppConfig.getInstance();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            JBCefApp app = null;
            if (config != null) {
                try {
                    app = new JBCefApp(config);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return app;
        }
    }

    public static interface JBCefCustomSchemeHandlerFactory
    extends CefSchemeHandlerFactory {
        public void registerCustomScheme(@NotNull CefSchemeRegistrar var1);

        @NotNull
        public String getSchemeName();

        @NotNull
        public String getDomainName();
    }
}

