/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.credentialStore.Credentials;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.CefDelegate;
import com.intellij.ui.jcef.DisposeHelper;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefCookieManager;
import com.intellij.ui.jcef.JBCefDisposable;
import com.intellij.ui.jcef.JBCefEventUtils;
import com.intellij.ui.jcef.JBCefFileSchemeHandlerFactory;
import com.intellij.ui.jcef.JBCefOSRHandlerFactory;
import com.intellij.ui.jcef.JBCefOsrComponent;
import com.intellij.ui.jcef.JBCefProxyAuthenticator;
import com.intellij.ui.jcef.PropertiesHelper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleContextCache;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.IconUtil;
import com.intellij.util.LazyInitializer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowserOsrWithHandler;
import org.cef.browser.CefFrame;
import org.cef.browser.CefRendering;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefAuthCallback;
import org.cef.callback.CefCallback;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.misc.CefLog;
import org.cef.misc.Utils;
import org.cef.network.CefCookieManager;
import org.cef.network.CefRequest;
import org.cef.security.CefSSLInfo;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class JBCefBrowserBase
implements JBCefDisposable {
    private static final Logger LOG = Logger.getInstance(JBCefBrowserBase.class);
    @NotNull
    protected static final String BLANK_URI = "about:blank";
    @NotNull
    private static final Icon ERROR_PAGE_ICON = AllIcons.General.ErrorDialog;
    @NotNull
    public static final String JBCEFBROWSER_INSTANCE_PROP = "JBCefBrowser.instance";
    @NotNull
    private final DisposeHelper myDisposeHelper;
    private final LoadDeferrer NO_LOADER;
    private final AtomicReference<LoadDeferrer> myLoadDeferrer;
    @NotNull
    private String myLastRequestedUrl;
    @Nullable
    private String myLoadingUrl;
    @NotNull
    private final Object myUrlLock;
    @Nullable
    private volatile ErrorPage myErrorPage;
    @NotNull
    private final PropertiesHelper myPropertiesHelper;
    @NotNull
    private final AtomicBoolean myIsCreateStarted;
    @Nullable
    private CefRequestHandler myHrefProcessingRequestHandler;
    @NotNull
    private final CertificateListener myCertificateListener;
    private static final // Could not load outer class - annotation placement on inner may be incorrect
    LazyInitializer.LazyValue<@NotNull String> ERROR_PAGE_READER = LazyInitializer.create(() -> {
        try {
            return new String(FileUtil.loadBytes((InputStream)Objects.requireNonNull(JBCefApp.class.getResourceAsStream("resources/load_error.html"))), StandardCharsets.UTF_8);
        }
        catch (IOException | NullPointerException e) {
            LOG.error("couldn't find load_error.html", (Throwable)e);
            return "";
        }
    });
    private static final LazyInitializer.LazyValue<ScaleContextCache<String>> BASE64_ERROR_PAGE_ICON = LazyInitializer.create(() -> new ScaleContextCache(scaleContext -> {
        String string;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            BufferedImage image = IconUtil.toBufferedImage((Icon)IconUtil.scale((Icon)ERROR_PAGE_ICON, (ScaleContext)scaleContext), (boolean)false);
            ImageIO.write((RenderedImage)image, "png", out);
            string = Base64.getEncoder().encodeToString(out.toByteArray());
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                LOG.error("couldn't write an error image", (Throwable)ex);
                return "";
            }
        }
        out.close();
        return string;
    }));
    private static final double ZOOM_COMMON_RATIO = 1.2;
    private static final double LOG_ZOOM = Math.log(1.2);
    @Nullable
    static WeakReference<JBCefBrowserBase> focusedBrowser;
    @NotNull
    protected final JBCefClient myCefClient;
    private final boolean myDefaultCefClient;
    @NotNull
    protected final CefBrowser myCefBrowser;
    private final boolean myIsOffScreenRendering;
    private final boolean myEnableOpenDevToolsMenuItem;
    @Nullable
    private final CefLoadHandler myLoadHandler;
    @Nullable
    private final CefRequestHandler myRequestHandler;
    @Nullable
    private final CefContextMenuHandler myContextMenuHandler;
    @NotNull
    private final ReentrantLock myCookieManagerLock;
    @Nullable
    private volatile JBCefCookieManager myJBCefCookieManager;
    @Nullable
    private volatile String myCssBgColor;
    @NotNull
    private final CefKeyboardHandler myKeyboardHandler;

    protected JBCefBrowserBase(@NotNull JBCefBrowserBuilder builder) {
        if (builder == null) {
            JBCefBrowserBase.$$$reportNull$$$0(0);
        }
        this.myDisposeHelper = new DisposeHelper();
        this.NO_LOADER = new LoadDeferrer(null, "");
        this.myLoadDeferrer = new AtomicReference<LoadDeferrer>(this.NO_LOADER);
        this.myLastRequestedUrl = "";
        this.myLoadingUrl = "";
        this.myUrlLock = new Object();
        this.myPropertiesHelper = new PropertiesHelper();
        this.myIsCreateStarted = new AtomicBoolean(false);
        this.myCookieManagerLock = new ReentrantLock();
        JBCefClient providedClient = builder.myClient;
        if (providedClient == null) {
            this.myCefClient = JBCefApp.getInstance().createClient();
            this.myDefaultCefClient = true;
        } else {
            this.myCefClient = providedClient;
            this.myDefaultCefClient = false;
        }
        Disposer.register((Disposable)this.myCefClient, (Disposable)this);
        this.myIsOffScreenRendering = builder.myIsOffScreenRendering;
        this.myEnableOpenDevToolsMenuItem = builder.myEnableOpenDevToolsMenuItem;
        boolean isDefaultBrowserCreated = false;
        CefBrowser cefBrowser = builder.myCefBrowser;
        if (cefBrowser == null) {
            if (this.myIsOffScreenRendering && JBCefBrowserBase.getCefDelegate() == null) {
                JBCefApp.checkOffScreenRenderingModeEnabled();
                CefBrowserSettings settings = new CefBrowserSettings();
                settings.windowless_frame_rate = builder.myWindowlessFrameRate;
                @NotNull JBCefOSRHandlerFactory factory = (JBCefOSRHandlerFactory)ObjectUtils.notNull((Object)builder.myOSRHandlerFactory, (Object)JBCefOSRHandlerFactory.getInstance());
                cefBrowser = JBCefBrowserBase.createOsrBrowser(factory, this.myCefClient.getCefClient(), builder.myUrl, null, null, null, builder.myMouseWheelEventEnable, settings);
            } else {
                cefBrowser = this.myCefClient.getCefClient().createBrowser(JBCefBrowserBase.validateUrl(builder.myUrl), CefRendering.DEFAULT, false, null);
            }
            isDefaultBrowserCreated = true;
        } else if (cefBrowser.getUIComponent() instanceof JBCefOsrComponent) {
            ((JBCefOsrComponent)cefBrowser.getUIComponent()).setBrowser(cefBrowser);
        }
        this.myCefBrowser = cefBrowser;
        if (isDefaultBrowserCreated) {
            this.myCefClient.addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

                public void onAfterCreated(CefBrowser browser) {
                    LoadDeferrer loader = JBCefBrowserBase.this.myLoadDeferrer.getAndSet(null);
                    if (loader != null && loader != JBCefBrowserBase.this.NO_LOADER) {
                        loader.load();
                    }
                }

                public void onBeforeClose(CefBrowser browser) {
                    JBCefBrowserBase.this.myCefClient.removeAllHandlers(JBCefBrowserBase.this.getCefBrowser());
                }
            }, this.getCefBrowser());
            this.myLoadHandler = new CefLoadHandlerAdapter(){

                public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                    if (Utils.getBoolean((String)"ide.browser.jcef.log.extended", (boolean)false)) {
                        browser.executeJavaScript("console.log('CefLoadHandler#onLoadEnd:\\n' + document.documentElement.outerHTML)", null, 0);
                    }
                    JBCefBrowserBase.this.setPageBackgroundColor();
                }

                public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                    String html;
                    CefLog.Warn((String)("CefLoadHandler#onLoadError: " + failedUrl + " (" + String.valueOf(errorCode) + ")"), (Object[])new Object[0]);
                    ErrorPage errorPage = JBCefBrowserBase.this.myErrorPage;
                    String lastRequestedUrl = JBCefBrowserBase.this.getLastRequestedUrl();
                    if (errorPage != null && lastRequestedUrl.equals(failedUrl) && (html = errorPage.create(errorCode, errorText, failedUrl)) != null) {
                        UIUtil.invokeLaterIfNeeded(() -> JBCefBrowserBase.this.compareLastRequestedUrlAndPerform(failedUrl, () -> JBCefBrowserBase.this.loadHTML(html)));
                    }
                }
            };
            this.myCefClient.addLoadHandler(this.myLoadHandler, this.getCefBrowser());
            this.myRequestHandler = new CefRequestHandlerAdapter(){

                public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                    JBCefBrowserBase.this.setLastRequestedUrl((String)ObjectUtils.notNull((Object)request.getURL(), (Object)""));
                    return super.onBeforeBrowse(browser, frame, request, user_gesture, is_redirect);
                }

                public boolean getAuthCredentials(CefBrowser browser, String origin_url, boolean isProxy, String host, int port, String realm, String scheme, CefAuthCallback callback) {
                    if (isProxy && !JBCefBrowserBase.this.isProperty("JBCefBrowserBase.noDefaultAuthCredentials")) {
                        Credentials credentials = JBCefProxyAuthenticator.getCredentials(JBCefBrowserBase.this, host, port);
                        if (credentials != null) {
                            callback.Continue(credentials.getUserName(), credentials.getPasswordAsString());
                            return true;
                        }
                        LOG.error("missing credentials to sign in to proxy");
                    }
                    return super.getAuthCredentials(browser, origin_url, isProxy, host, port, realm, scheme, callback);
                }

                public boolean onCertificateError(CefBrowser browser, CefLoadHandler.ErrorCode cert_error, String request_url, CefSSLInfo sslInfo, CefCallback callback) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        try {
                            CertificateManager.getInstance().getTrustManager().checkServerTrusted(sslInfo.certificate.getCertificatesChain(), "UNKNOWN");
                            callback.Continue();
                        }
                        catch (CertificateException e) {
                            callback.cancel();
                        }
                    });
                    return true;
                }
            };
            this.myCefClient.addRequestHandler(this.myRequestHandler, this.getCefBrowser());
            this.myContextMenuHandler = this.createDefaultContextMenuHandler();
            this.myCefClient.addContextMenuHandler(this.myContextMenuHandler, this.getCefBrowser());
        } else {
            this.myLoadHandler = null;
            this.myRequestHandler = null;
            this.myContextMenuHandler = null;
        }
        if (builder.myCreateImmediately) {
            this.createImmediately();
        }
        this.myCertificateListener = new CertificateListener(){

            public void certificateAdded(X509Certificate certificate) {
            }

            public void certificateRemoved(X509Certificate certificate) {
                CefRequestContext context = JBCefBrowserBase.this.getCefBrowser().getRequestContext();
                if (context != null) {
                    context.ClearCertificateExceptions(null);
                    context.CloseAllConnections(null);
                } else {
                    JBCefBrowserBase.this.getCefBrowser().createImmediately();
                    CompletableFuture browserReadyFuture = JBCefBrowserBase.this.getCefBrowser().getDevToolsClient().executeDevToolsMethod("");
                    browserReadyFuture.thenRun(() -> {
                        CefRequestContext context1 = Objects.requireNonNull(JBCefBrowserBase.this.getCefBrowser().getRequestContext());
                        context1.ClearCertificateExceptions(null);
                        context1.CloseAllConnections(null);
                    });
                }
            }
        };
        CertificateManager.getInstance().getCustomTrustManager().addListener(this.myCertificateListener);
        this.myKeyboardHandler = new CefKeyboardHandlerAdapter(){

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
                boolean consume;
                if (JBCefBrowserBase.this.isOffScreenRendering()) {
                    return false;
                }
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl = consume = focusOwner != browser.getUIComponent();
                if (consume && SystemInfo.isMac && JBCefEventUtils.isUpDownKeyEvent(cefKeyEvent)) {
                    return true;
                }
                Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (focusedWindow == null) {
                    return true;
                }
                try {
                    KeyEvent javaKeyEvent = JBCefEventUtils.convertCefKeyEvent(cefKeyEvent, focusedWindow);
                    Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(javaKeyEvent);
                }
                catch (IllegalArgumentException e) {
                    LOG.error("Failed to convert CEF key event: " + String.valueOf(cefKeyEvent) + "\nReason: " + String.valueOf(e));
                }
                return consume;
            }
        };
        this.myCefClient.addKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createImmediately() {
        AtomicBoolean atomicBoolean = this.myIsCreateStarted;
        synchronized (atomicBoolean) {
            this.myIsCreateStarted.set(true);
            this.getCefBrowser().createImmediately();
        }
    }

    public final void loadURL(@NotNull String url) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(1);
        }
        if (this.isCefBrowserCreated() || !this.scheduleLoading(new LoadDeferrer(null, url))) {
            this.loadUrlImpl(url);
        }
    }

    public final void loadHTML(@NotNull String html, @NotNull String url) {
        if (html == null) {
            JBCefBrowserBase.$$$reportNull$$$0(2);
        }
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(3);
        }
        if (this.isCefBrowserCreated() || !this.scheduleLoading(new LoadDeferrer(html, url))) {
            this.loadHtmlImpl(html, url);
        }
    }

    private boolean scheduleLoading(@NotNull LoadDeferrer loader) {
        if (loader == null) {
            JBCefBrowserBase.$$$reportNull$$$0(4);
        }
        return this.myLoadDeferrer.getAndUpdate(value -> value == null ? null : loader) != null;
    }

    public final void loadHTML(@NotNull String html) {
        if (html == null) {
            JBCefBrowserBase.$$$reportNull$$$0(5);
        }
        this.loadHTML(html, BLANK_URI);
    }

    @NotNull
    public final CefBrowser getCefBrowser() {
        CefBrowser cefBrowser = this.myCefBrowser;
        if (cefBrowser == null) {
            JBCefBrowserBase.$$$reportNull$$$0(6);
        }
        return cefBrowser;
    }

    @Nullable
    public static JBCefBrowserBase getFocusedBrowser() {
        if (focusedBrowser != null) {
            return (JBCefBrowserBase)focusedBrowser.get();
        }
        return null;
    }

    public final double getZoomLevel() {
        return Math.pow(1.2, this.myCefBrowser.getZoomLevel());
    }

    public final void setZoomLevel(double zoomLevel) {
        this.myCefBrowser.setZoomLevel(Math.log(zoomLevel) / LOG_ZOOM);
    }

    @NotNull
    public final JBCefClient getJBCefClient() {
        JBCefClient jBCefClient = this.myCefClient;
        if (jBCefClient == null) {
            JBCefBrowserBase.$$$reportNull$$$0(7);
        }
        return jBCefClient;
    }

    @NotNull
    public static JBCefCookieManager getGlobalJBCefCookieManager() {
        return new JBCefCookieManager(CefCookieManager.getGlobalManager());
    }

    @NotNull
    public final JBCefCookieManager getJBCefCookieManager() {
        this.myCookieManagerLock.lock();
        if (this.myJBCefCookieManager == null) {
            this.myJBCefCookieManager = new JBCefCookieManager();
        }
        JBCefCookieManager jBCefCookieManager = Objects.requireNonNull(this.myJBCefCookieManager);
        JBCefCookieManager jBCefCookieManager2 = jBCefCookieManager;
        if (jBCefCookieManager2 == null) {
            JBCefBrowserBase.$$$reportNull$$$0(8);
        }
        return jBCefCookieManager2;
        finally {
            this.myCookieManagerLock.unlock();
        }
    }

    public final void setJBCefCookieManager(@NotNull JBCefCookieManager jBCefCookieManager) {
        if (jBCefCookieManager == null) {
            JBCefBrowserBase.$$$reportNull$$$0(9);
        }
        this.myCookieManagerLock.lock();
        try {
            this.myJBCefCookieManager = jBCefCookieManager;
        }
        finally {
            this.myCookieManagerLock.unlock();
        }
    }

    public void setOpenLinksInExternalBrowser(boolean openLinksInExternalBrowser) {
        if (openLinksInExternalBrowser) {
            this.enableExternalBrowserLinks();
        } else {
            this.disableExternalBrowserLinks();
        }
    }

    private void enableExternalBrowserLinks() {
        if (this.myHrefProcessingRequestHandler != null) {
            return;
        }
        CefRequestHandlerAdapter hrefProcessingRequestHandler = new CefRequestHandlerAdapter(this){

            public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                if (user_gesture) {
                    BrowserUtil.open((String)request.getURL());
                    return true;
                }
                return false;
            }
        };
        this.myCefClient.addRequestHandler((CefRequestHandler)hrefProcessingRequestHandler, this.myCefBrowser);
        this.myHrefProcessingRequestHandler = hrefProcessingRequestHandler;
    }

    private void disableExternalBrowserLinks() {
        CefRequestHandler hrefProcessingRequestHandler = this.myHrefProcessingRequestHandler;
        if (hrefProcessingRequestHandler != null) {
            this.myCefClient.removeRequestHandler(hrefProcessingRequestHandler, this.myCefBrowser);
            this.myHrefProcessingRequestHandler = null;
        }
    }

    public void disableNavigation() {
        CefDelegate delegate = JBCefBrowserBase.getCefDelegate();
        if (delegate != null) {
            delegate.disableNavigation(this.myCefBrowser);
        } else {
            this.myCefClient.addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(this){

                public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                    return user_gesture;
                }
            }, this.myCefBrowser);
        }
    }

    @Nullable
    public abstract JComponent getComponent();

    @Nullable
    public Component getBrowserComponent() {
        return this.myCefBrowser.getUIComponent();
    }

    public boolean isOffScreenRendering() {
        return this.myIsOffScreenRendering;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public final boolean isCefBrowserCreated() {
        return JBCefBrowserBase.isCefBrowserCreated(this.myCefBrowser);
    }

    static boolean isCefBrowserCreated(@NotNull CefBrowser cefBrowser) {
        CefDelegate delegate;
        if (cefBrowser == null) {
            JBCefBrowserBase.$$$reportNull$$$0(10);
        }
        if ((delegate = JBCefBrowserBase.getCefDelegate()) != null) {
            return delegate.isInitialized(cefBrowser);
        }
        return CefClient.isNativeBrowserCreated((CefBrowser)cefBrowser);
    }

    static boolean isCefBrowserCreationStarted(@NotNull CefBrowser browser) {
        if (browser == null) {
            JBCefBrowserBase.$$$reportNull$$$0(11);
        }
        return CefClient.isNativeBrowserCreationStarted((CefBrowser)browser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCefBrowserCreateStarted() {
        AtomicBoolean atomicBoolean = this.myIsCreateStarted;
        synchronized (atomicBoolean) {
            return this.myIsCreateStarted.get() || this.isCefBrowserCreated();
        }
    }

    public void dispose() {
        this.dispose(null);
    }

    protected void dispose(@Nullable Runnable subDisposer) {
        this.myDisposeHelper.dispose(() -> {
            if (subDisposer != null) {
                subDisposer.run();
            }
            if (this.myLoadHandler != null) {
                this.getJBCefClient().removeLoadHandler(this.myLoadHandler, this.getCefBrowser());
            }
            if (this.myRequestHandler != null) {
                this.getJBCefClient().removeRequestHandler(this.myRequestHandler, this.getCefBrowser());
            }
            if (this.myHrefProcessingRequestHandler != null) {
                this.getJBCefClient().removeRequestHandler(this.myHrefProcessingRequestHandler, this.getCefBrowser());
            }
            if (this.myContextMenuHandler != null) {
                this.getJBCefClient().removeContextMenuHandler(this.myContextMenuHandler, this.getCefBrowser());
            }
            CertificateManager.getInstance().getCustomTrustManager().removeListener(this.myCertificateListener);
            this.myCefBrowser.stopLoad();
            this.myCefBrowser.setCloseAllowed();
            this.myCefBrowser.close(true);
            if (this.myDefaultCefClient) {
                Disposer.dispose((Disposable)this.myCefClient);
            }
            this.myCefClient.removeKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
        });
    }

    @Override
    public final boolean isDisposed() {
        return this.myDisposeHelper.isDisposed();
    }

    @Nullable
    public static JBCefBrowser getJBCefBrowser(@NotNull CefBrowser browser) {
        Container parentComp;
        Component uiComp;
        if (browser == null) {
            JBCefBrowserBase.$$$reportNull$$$0(12);
        }
        if ((uiComp = browser.getUIComponent()) != null && (parentComp = uiComp.getParent()) instanceof JComponent) {
            return (JBCefBrowser)((JComponent)parentComp).getClientProperty(JBCEFBROWSER_INSTANCE_PROP);
        }
        return null;
    }

    public void setPageBackgroundColor(@NotNull String cssColor) {
        if (cssColor == null) {
            JBCefBrowserBase.$$$reportNull$$$0(13);
        }
        this.myCssBgColor = cssColor;
        this.setPageBackgroundColor();
    }

    private void setPageBackgroundColor() {
        if (this.myCssBgColor != null) {
            this.getCefBrowser().executeJavaScript("document.body.style.backgroundColor = \"" + this.myCssBgColor + "\";", BLANK_URI, 0);
        }
    }

    private void loadHtmlImpl(@NotNull String html, @NotNull String url) {
        if (html == null) {
            JBCefBrowserBase.$$$reportNull$$$0(14);
        }
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(15);
        }
        this.loadUrlImpl(JBCefFileSchemeHandlerFactory.registerLoadHTMLRequest(this.getCefBrowser(), html, url));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadUrlImpl(@NotNull String url) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(16);
        }
        Object object = this.myUrlLock;
        synchronized (object) {
            if (Objects.equals(this.myLoadingUrl, url)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("URL already requested, skipping: " + url);
                }
                return;
            }
            this.myLoadingUrl = url;
            this.setLastRequestedUrl("");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading URL: " + url);
        }
        this.getCefBrowser().loadURL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLastRequestedUrl() {
        Object object = this.myUrlLock;
        synchronized (object) {
            return this.myLastRequestedUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLastRequestedUrl(@NotNull String url) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(17);
        }
        Object object = this.myUrlLock;
        synchronized (object) {
            this.myLastRequestedUrl = url;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareLastRequestedUrlAndPerform(@NotNull String url, @NotNull Runnable action) {
        if (url == null) {
            JBCefBrowserBase.$$$reportNull$$$0(18);
        }
        if (action == null) {
            JBCefBrowserBase.$$$reportNull$$$0(19);
        }
        Object object = this.myUrlLock;
        synchronized (object) {
            if (this.myLastRequestedUrl.equals(url)) {
                action.run();
            }
        }
    }

    public void setErrorPage(@Nullable ErrorPage errorPage) {
        this.myErrorPage = errorPage;
    }

    public void setProperty(@NotNull String name, @Nullable Object value) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(20);
        }
        this.myPropertiesHelper.setProperty(name, value);
    }

    @Nullable
    public Object getProperty(@NotNull String name) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(21);
        }
        return this.myPropertiesHelper.getProperty(name);
    }

    public boolean isProperty(@NotNull String name) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(22);
        }
        return this.myPropertiesHelper.is(name);
    }

    void addPropertyChangeListener(@NotNull String name, @NotNull PropertyChangeListener listener) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(23);
        }
        if (listener == null) {
            JBCefBrowserBase.$$$reportNull$$$0(24);
        }
        this.myPropertiesHelper.addPropertyChangeListener(name, listener);
    }

    void removePropertyChangeListener(@NotNull String name, @NotNull PropertyChangeListener listener) {
        if (name == null) {
            JBCefBrowserBase.$$$reportNull$$$0(25);
        }
        if (listener == null) {
            JBCefBrowserBase.$$$reportNull$$$0(26);
        }
        this.myPropertiesHelper.removePropertyChangeListener(name, listener);
    }

    protected DefaultCefContextMenuHandler createDefaultContextMenuHandler() {
        return new DefaultCefContextMenuHandler();
    }

    public void openDevtools() {
        this.myCefBrowser.openDevTools();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                JBCefBrowserBase.this.myCefBrowser.closeDevTools();
            }
        });
    }

    @NotNull
    private static String validateUrl(@Nullable String url) {
        return url != null && !url.isEmpty() ? url : "";
    }

    @Nullable
    private static CefDelegate getCefDelegate() {
        return JBCefApp.getInstance().getDelegate();
    }

    private static CefRendering.CefRenderingWithHandler createCefRenderingWithHandler(@NotNull JBCefOSRHandlerFactory osrHandlerFactory, boolean isMouseWheelEventEnabled) {
        if (osrHandlerFactory == null) {
            JBCefBrowserBase.$$$reportNull$$$0(27);
        }
        JComponent component = osrHandlerFactory.createComponent(isMouseWheelEventEnabled);
        CefRenderHandler handler = osrHandlerFactory.createCefRenderHandler(component);
        return new CefRendering.CefRenderingWithHandler(handler, (Component)component);
    }

    @NotNull
    static CefBrowser createOsrBrowser(final @NotNull JBCefOSRHandlerFactory osrHandlerFactory, @NotNull CefClient client, @Nullable String url, @Nullable CefRequestContext context, @Nullable CefBrowser parentBrowser, @Nullable Point inspectAt, final boolean isMouseWheelEventEnabled, CefBrowserSettings settings) {
        if (osrHandlerFactory == null) {
            JBCefBrowserBase.$$$reportNull$$$0(28);
        }
        if (client == null) {
            JBCefBrowserBase.$$$reportNull$$$0(29);
        }
        String validUrl = (String)ObjectUtils.notNull((Object)url, (Object)"");
        if (JBCefApp.getInstance().isRemoteEnabled()) {
            Supplier<CefRendering> renderingSupplier = () -> JBCefBrowserBase.createCefRenderingWithHandler(osrHandlerFactory, isMouseWheelEventEnabled);
            CefBrowser browser = client.createBrowser(validUrl, renderingSupplier, true, context, settings);
            if (browser.getUIComponent() instanceof JBCefOsrComponent) {
                ((JBCefOsrComponent)browser.getUIComponent()).setBrowser(browser);
            }
            CefBrowser cefBrowser = browser;
            if (cefBrowser == null) {
                JBCefBrowserBase.$$$reportNull$$$0(30);
            }
            return cefBrowser;
        }
        CefRendering.CefRenderingWithHandler rendering = JBCefBrowserBase.createCefRenderingWithHandler(osrHandlerFactory, isMouseWheelEventEnabled);
        CefBrowserOsrWithHandler browser = new CefBrowserOsrWithHandler(client, validUrl, context, rendering.getRenderHandler(), rendering.getComponent(), parentBrowser, inspectAt, settings){

            protected CefBrowser createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser parent, Point inspectAt) {
                return JBCefBrowserBase.createOsrBrowser(osrHandlerFactory, client, this.getUrl(), this.getRequestContext(), (CefBrowser)this, inspectAt, isMouseWheelEventEnabled, null);
            }
        };
        if (rendering.getComponent() instanceof JBCefOsrComponent) {
            ((JBCefOsrComponent)rendering.getComponent()).setBrowser((CefBrowser)browser);
        }
        CefBrowserOsrWithHandler cefBrowserOsrWithHandler = browser;
        if (cefBrowserOsrWithHandler == null) {
            JBCefBrowserBase.$$$reportNull$$$0(31);
        }
        return cefBrowserOsrWithHandler;
    }

    public void runJavaScript(@Language(value="JavaScript") String code) {
        this.runJavaScript(code, null, 0);
    }

    public void runJavaScript(@Language(value="JavaScript") String code, String url, int line) {
        if (Utils.getBoolean((String)"ide.browser.jcef.log.extended", (boolean)false)) {
            CefLog.Debug((String)"%s.runJavaScript(%s)", (Object[])new Object[]{this.myCefBrowser.toString(), code});
        }
        this.myCefBrowser.executeJavaScript(code, url, line);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 8, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 3: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowserBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jBCefCookieManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefBrowser";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cssColor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osrHandlerFactory";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowserBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCefBrowser";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBCefClient";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getJBCefCookieManager";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createOsrBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadURL";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadHTML";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "scheduleLoading";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 30: 
            case 31: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setJBCefCookieManager";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCefBrowserCreated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCefBrowserCreationStarted";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJBCefBrowser";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPageBackgroundColor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadHtmlImpl";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadUrlImpl";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setLastRequestedUrl";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "compareLastRequestedUrlAndPerform";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProperty";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isProperty";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createCefRenderingWithHandler";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createOsrBrowser";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 8, 30, 31 -> new IllegalStateException(string);
        };
    }

    private final class LoadDeferrer {
        @Nullable
        private final String myHtml;
        @NotNull
        private final String myUrl;

        private LoadDeferrer(@NotNull String html, String url) {
            if (url == null) {
                LoadDeferrer.$$$reportNull$$$0(0);
            }
            this.myHtml = html;
            this.myUrl = url;
        }

        public void load() {
            SwingUtilities.invokeLater(this.myHtml == null ? () -> JBCefBrowserBase.this.loadUrlImpl(this.myUrl) : () -> JBCefBrowserBase.this.loadHtmlImpl(this.myHtml, this.myUrl));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ui/jcef/JBCefBrowserBase$LoadDeferrer", "<init>"));
        }
    }

    protected class DefaultCefContextMenuHandler
    extends CefContextMenuHandlerAdapter {
        protected static final int DEBUG_COMMAND_ID = 28500;
        private final boolean isOpenDevToolsItemEnabled;

        public DefaultCefContextMenuHandler() {
            this.isOpenDevToolsItemEnabled = JBCefBrowserBase.this.myEnableOpenDevToolsMenuItem || Registry.is((String)"ide.browser.jcef.contextMenu.devTools.enabled");
        }

        public DefaultCefContextMenuHandler(boolean isOpenDevToolsItemEnabled) {
            this.isOpenDevToolsItemEnabled = isOpenDevToolsItemEnabled;
        }

        public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
            if (JBCefBrowserBase.this.isProperty("JBCefBrowserBase.noContextMenu")) {
                model.clear();
                return;
            }
            if (this.isOpenDevToolsItemEnabled) {
                model.addItem(28500, "Open DevTools");
            }
        }

        public boolean onContextMenuCommand(CefBrowser browser, CefFrame frame, CefContextMenuParams params, int commandId, int eventFlags) {
            if (JBCefBrowserBase.this.isProperty("JBCefBrowserBase.noContextMenu")) {
                return false;
            }
            if (commandId == 28500) {
                JBCefBrowserBase.this.openDevtools();
                return true;
            }
            return false;
        }
    }

    public static interface ErrorPage {
        public static final ErrorPage DEFAULT = new ErrorPage(){

            @Override
            @NotNull
            public String create(// Could not load outer class - annotation placement on inner may be incorrect
            @NotNull CefLoadHandler.ErrorCode errorCode, @NotNull String errorText, @NotNull String failedUrl) {
                if (errorText == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (failedUrl == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (errorCode == null) {
                    1.$$$reportNull$$$0(2);
                }
                int fontSize = (int)((double)EditorColorsManager.getInstance().getGlobalScheme().getEditorFontSize() * 1.1);
                int headerFontSize = fontSize + JBUIScale.scale((int)3);
                int headerPaddingTop = headerFontSize / 5;
                int lineHeight = headerFontSize * 2;
                int iconPaddingRight = JBUIScale.scale((int)12);
                Color bgColor = JBColor.background();
                String bgWebColor = String.format("#%02x%02x%02x", bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue());
                Color fgColor = JBColor.foreground();
                String fgWebColor = String.format("#%02x%02x%02x", fgColor.getRed(), fgColor.getGreen(), fgColor.getBlue());
                String html = (String)ERROR_PAGE_READER.get();
                html = html.replace("${lineHeight}", String.valueOf(lineHeight));
                html = html.replace("${iconPaddingRight}", String.valueOf(iconPaddingRight));
                html = html.replace("${fontSize}", String.valueOf(fontSize));
                html = html.replace("${headerFontSize}", String.valueOf(headerFontSize));
                html = html.replace("${headerPaddingTop}", String.valueOf(headerPaddingTop));
                html = html.replace("${bgWebColor}", bgWebColor);
                html = html.replace("${fgWebColor}", fgWebColor);
                html = html.replace("${errorText}", errorText);
                html = html.replace("${failedUrl}", failedUrl);
                ScaleContext ctx = ScaleContext.create();
                ctx.setScale(ScaleType.OBJ_SCALE.of(1.2 * (double)headerFontSize / (double)ERROR_PAGE_ICON.getIconHeight()));
                ctx.overrideScale(ScaleType.SYS_SCALE.of(1.0f));
                String string = html = html.replace("${base64Image}", (CharSequence)ObjectUtils.notNull((Object)((String)((ScaleContextCache)BASE64_ERROR_PAGE_ICON.get()).getOrProvide(ctx)), (Object)""));
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorText";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "failedUrl";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorCode";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowserBase$ErrorPage$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowserBase$ErrorPage$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 3 -> new IllegalStateException(string);
                };
            }
        };

        @Nullable
        public String create(@NotNull CefLoadHandler.ErrorCode var1, @NotNull String var2, @NotNull String var3);
    }

    public static class Properties {
        @NotNull
        public static final String NO_DEFAULT_AUTH_CREDENTIALS = "JBCefBrowserBase.noDefaultAuthCredentials";
        @NotNull
        public static final String NO_CONTEXT_MENU = "JBCefBrowserBase.noContextMenu";

        static {
            PropertiesHelper.setType(NO_DEFAULT_AUTH_CREDENTIALS, Boolean.class);
            PropertiesHelper.setType(NO_CONTEXT_MENU, Boolean.class);
        }
    }
}

