/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef.menu;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cef.callback.CefMenuModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0002#$B/\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB!\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\u000eJ \u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0015\u001a\u00020\bH\u0016J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001d\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u001e\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0011R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/ui/jcef/menu/JBCefMenuAdapter;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/ui/jcef/menu/JBCefMenuAdapter$MenuItem;", "items", "", "myOnSelected", "Ljava/util/function/Consumer;", "isRoot", "", "<init>", "(Ljava/util/List;Ljava/util/function/Consumer;Z)V", "model", "Lorg/cef/callback/CefMenuModel;", "onSelected", "(Lorg/cef/callback/CefMenuModel;Ljava/util/function/Consumer;)V", "getMyOnSelected", "()Ljava/util/function/Consumer;", "()Z", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "getIconFor", "Ljavax/swing/Icon;", "value", "getTextFor", "", "getSeparatorAbove", "Lcom/intellij/openapi/ui/popup/ListSeparator;", "isSelectable", "hasSubstep", "canceled", "", "hasAnyIcon", "Lkotlin/Lazy;", "MenuItem", "Companion", "intellij.platform.ui.jcef"})
@SourceDebugExtension(value={"SMAP\nJBCefMenuAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JBCefMenuAdapter.kt\ncom/intellij/ui/jcef/menu/JBCefMenuAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n1807#2,3:139\n*S KotlinDebug\n*F\n+ 1 JBCefMenuAdapter.kt\ncom/intellij/ui/jcef/menu/JBCefMenuAdapter\n*L\n79#1:139,3\n*E\n"})
public final class JBCefMenuAdapter
extends BaseListPopupStep<MenuItem> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Consumer<MenuItem> myOnSelected;
    private final boolean isRoot;
    @NotNull
    private final Lazy<Boolean> hasAnyIcon;

    public JBCefMenuAdapter(@NotNull List<MenuItem> items, @NotNull Consumer<MenuItem> myOnSelected, boolean isRoot) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(myOnSelected, (String)"myOnSelected");
        super(null, items);
        this.myOnSelected = myOnSelected;
        this.isRoot = isRoot;
        this.hasAnyIcon = LazyKt.lazy(() -> JBCefMenuAdapter.hasAnyIcon$lambda$0(this));
    }

    public /* synthetic */ JBCefMenuAdapter(List list, Consumer consumer, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        this(list, consumer, bl);
    }

    @NotNull
    public final Consumer<MenuItem> getMyOnSelected() {
        return this.myOnSelected;
    }

    public final boolean isRoot() {
        return this.isRoot;
    }

    public JBCefMenuAdapter(@NotNull CefMenuModel model, @NotNull Consumer<MenuItem> onSelected) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter(onSelected, (String)"onSelected");
        this(JBCefMenuAdapter.Companion.convert(model), onSelected, false, 4, null);
    }

    @Nullable
    public PopupStep<?> onChosen(@Nullable MenuItem selectedValue, boolean finalChoice) {
        if (finalChoice) {
            if (this.isRoot || selectedValue != null) {
                this.myOnSelected.accept(selectedValue);
            }
            return BaseListPopupStep.FINAL_CHOICE;
        }
        MenuItem menuItem = selectedValue;
        if ((menuItem != null ? menuItem.getType() : null) == CefMenuModel.MenuItemType.MENUITEMTYPE_SUBMENU) {
            List<MenuItem> list = selectedValue.getSubmenu();
            Intrinsics.checkNotNull(list);
            return (PopupStep)new JBCefMenuAdapter(list, this.myOnSelected, false);
        }
        return null;
    }

    @Nullable
    public Icon getIconFor(@Nullable MenuItem value) {
        if (!((Boolean)this.hasAnyIcon.getValue()).booleanValue()) {
            return null;
        }
        MenuItem menuItem = value;
        boolean bl = menuItem != null ? menuItem.getChecked() : false;
        if (bl) {
            return AllIcons.Actions.Checked;
        }
        return EmptyIcon.ICON_16;
    }

    @NotNull
    public String getTextFor(@Nullable MenuItem value) {
        Object object = value;
        if (object == null || (object = ((MenuItem)object).getLabel()) == null) {
            object = "";
        }
        return object;
    }

    @Nullable
    public ListSeparator getSeparatorAbove(@Nullable MenuItem value) {
        MenuItem menuItem = value;
        return (menuItem != null ? menuItem.getHasSeparatorAbove() : false) ? new ListSeparator() : null;
    }

    public boolean isSelectable(@Nullable MenuItem value) {
        MenuItem menuItem = value;
        return menuItem != null ? menuItem.getEnabled() : false;
    }

    public boolean hasSubstep(@Nullable MenuItem selectedValue) {
        MenuItem menuItem = selectedValue;
        return (menuItem != null ? menuItem.getType() : null) == CefMenuModel.MenuItemType.MENUITEMTYPE_SUBMENU;
    }

    public void canceled() {
        if (this.isRoot) {
            this.myOnSelected.accept(null);
        }
    }

    private static final boolean hasAnyIcon$lambda$0(JBCefMenuAdapter this$0) {
        boolean bl;
        block3: {
            List list = this$0.getValues();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValues(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MenuItem it = (MenuItem)element$iv;
                    boolean bl2 = false;
                    Object[] objectArray = new CefMenuModel.MenuItemType[]{CefMenuModel.MenuItemType.MENUITEMTYPE_CHECK, CefMenuModel.MenuItemType.MENUITEMTYPE_RADIO};
                    MenuItem menuItem = it;
                    if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])objectArray), (Object)(menuItem != null ? menuItem.getType() : null))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/ui/jcef/menu/JBCefMenuAdapter$Companion;", "", "<init>", "()V", "convert", "", "Lcom/intellij/ui/jcef/menu/JBCefMenuAdapter$MenuItem;", "model", "Lorg/cef/callback/CefMenuModel;", "intellij.platform.ui.jcef"})
    public static final class Companion {
        private Companion() {
        }

        private final List<MenuItem> convert(CefMenuModel model) {
            if (model == null) {
                return CollectionsKt.emptyList();
            }
            List mutableListOf = new ArrayList();
            int n = model.getCount();
            for (int i = 0; i < n; ++i) {
                if (!model.isVisibleAt(i)) continue;
                if (model.getTypeAt(i) == CefMenuModel.MenuItemType.MENUITEMTYPE_SEPARATOR) {
                    if (!(!((Collection)mutableListOf).isEmpty())) continue;
                    ((MenuItem)CollectionsKt.last((List)mutableListOf)).setHasSeparatorAbove(true);
                    continue;
                }
                if (model.getTypeAt(i) == CefMenuModel.MenuItemType.MENUITEMTYPE_SUBMENU) {
                    String string = model.getLabelAt(i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabelAt(...)");
                    mutableListOf.add(new MenuItem(StringsKt.replace$default((String)string, (String)"&", (String)"", (boolean)false, (int)4, null), model.getCommandIdAt(i), false, CefMenuModel.MenuItemType.MENUITEMTYPE_SUBMENU, model.getGroupIdAt(i), model.isEnabledAt(i), model.isCheckedAt(i), model.isVisibleAt(i), this.convert(model.getSubMenuAt(i))));
                    continue;
                }
                String string = model.getLabelAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLabelAt(...)");
                String string2 = StringsKt.replace$default((String)string, (String)"&", (String)"", (boolean)false, (int)4, null);
                int n2 = model.getCommandIdAt(i);
                CefMenuModel.MenuItemType menuItemType = model.getTypeAt(i);
                Intrinsics.checkNotNullExpressionValue((Object)menuItemType, (String)"getTypeAt(...)");
                mutableListOf.add(new MenuItem(string2, n2, false, menuItemType, model.getGroupIdAt(i), model.isEnabledAt(i), model.isCheckedAt(i), model.isVisibleAt(i), this.convert(model.getSubMenuAt(i))));
            }
            return mutableListOf;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b-\b\u0086\b\u0018\u00002\u00020\u0001BY\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u0005H\u00c6\u0003J\t\u00100\u001a\u00020\u0007H\u00c6\u0003J\t\u00101\u001a\u00020\tH\u00c6\u0003J\t\u00102\u001a\u00020\u0005H\u00c6\u0003J\t\u00103\u001a\u00020\u0007H\u00c6\u0003J\t\u00104\u001a\u00020\u0007H\u00c6\u0003J\t\u00105\u001a\u00020\u0007H\u00c6\u0003J\u0011\u00106\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000fH\u00c6\u0003Jk\u00107\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\u00072\b\b\u0002\u0010\f\u001a\u00020\u00072\b\b\u0002\u0010\r\u001a\u00020\u00072\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000fH\u00c6\u0001J\u0014\u00108\u001a\u00020\u00072\b\u00109\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010:\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010;\u001a\u00020\u0003H\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0017\"\u0004\b#\u0010\u0019R\u001a\u0010\u000b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001dR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010\u001dR\u001a\u0010\r\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001b\"\u0004\b)\u0010\u001dR\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0000\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006<"}, d2={"Lcom/intellij/ui/jcef/menu/JBCefMenuAdapter$MenuItem;", "", "label", "", "commandId", "", "hasSeparatorAbove", "", "type", "Lorg/cef/callback/CefMenuModel$MenuItemType;", "groupId", "enabled", "checked", "visible", "submenu", "", "<init>", "(Ljava/lang/String;IZLorg/cef/callback/CefMenuModel$MenuItemType;IZZZLjava/util/List;)V", "getLabel", "()Ljava/lang/String;", "setLabel", "(Ljava/lang/String;)V", "getCommandId", "()I", "setCommandId", "(I)V", "getHasSeparatorAbove", "()Z", "setHasSeparatorAbove", "(Z)V", "getType", "()Lorg/cef/callback/CefMenuModel$MenuItemType;", "setType", "(Lorg/cef/callback/CefMenuModel$MenuItemType;)V", "getGroupId", "setGroupId", "getEnabled", "setEnabled", "getChecked", "setChecked", "getVisible", "setVisible", "getSubmenu", "()Ljava/util/List;", "setSubmenu", "(Ljava/util/List;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "toString", "intellij.platform.ui.jcef"})
    public static final class MenuItem {
        @NotNull
        private String label;
        private int commandId;
        private boolean hasSeparatorAbove;
        @NotNull
        private CefMenuModel.MenuItemType type;
        private int groupId;
        private boolean enabled;
        private boolean checked;
        private boolean visible;
        @Nullable
        private List<MenuItem> submenu;

        public MenuItem(@NlsSafe @NotNull String label, int commandId, boolean hasSeparatorAbove, @NotNull CefMenuModel.MenuItemType type, int groupId, boolean enabled, boolean checked, boolean visible, @Nullable List<MenuItem> submenu) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.label = label;
            this.commandId = commandId;
            this.hasSeparatorAbove = hasSeparatorAbove;
            this.type = type;
            this.groupId = groupId;
            this.enabled = enabled;
            this.checked = checked;
            this.visible = visible;
            this.submenu = submenu;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        public final void setLabel(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.label = string;
        }

        public final int getCommandId() {
            return this.commandId;
        }

        public final void setCommandId(int n) {
            this.commandId = n;
        }

        public final boolean getHasSeparatorAbove() {
            return this.hasSeparatorAbove;
        }

        public final void setHasSeparatorAbove(boolean bl) {
            this.hasSeparatorAbove = bl;
        }

        @NotNull
        public final CefMenuModel.MenuItemType getType() {
            return this.type;
        }

        public final void setType(@NotNull CefMenuModel.MenuItemType menuItemType) {
            Intrinsics.checkNotNullParameter((Object)menuItemType, (String)"<set-?>");
            this.type = menuItemType;
        }

        public final int getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(int n) {
            this.groupId = n;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public final boolean getChecked() {
            return this.checked;
        }

        public final void setChecked(boolean bl) {
            this.checked = bl;
        }

        public final boolean getVisible() {
            return this.visible;
        }

        public final void setVisible(boolean bl) {
            this.visible = bl;
        }

        @Nullable
        public final List<MenuItem> getSubmenu() {
            return this.submenu;
        }

        public final void setSubmenu(@Nullable List<MenuItem> list) {
            this.submenu = list;
        }

        @NotNull
        public final String component1() {
            return this.label;
        }

        public final int component2() {
            return this.commandId;
        }

        public final boolean component3() {
            return this.hasSeparatorAbove;
        }

        @NotNull
        public final CefMenuModel.MenuItemType component4() {
            return this.type;
        }

        public final int component5() {
            return this.groupId;
        }

        public final boolean component6() {
            return this.enabled;
        }

        public final boolean component7() {
            return this.checked;
        }

        public final boolean component8() {
            return this.visible;
        }

        @Nullable
        public final List<MenuItem> component9() {
            return this.submenu;
        }

        @NotNull
        public final MenuItem copy(@NlsSafe @NotNull String label, int commandId, boolean hasSeparatorAbove, @NotNull CefMenuModel.MenuItemType type, int groupId, boolean enabled, boolean checked, boolean visible, @Nullable List<MenuItem> submenu) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new MenuItem(label, commandId, hasSeparatorAbove, type, groupId, enabled, checked, visible, submenu);
        }

        public static /* synthetic */ MenuItem copy$default(MenuItem menuItem, String string, int n, boolean bl, CefMenuModel.MenuItemType menuItemType, int n2, boolean bl2, boolean bl3, boolean bl4, List list, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = menuItem.label;
            }
            if ((n3 & 2) != 0) {
                n = menuItem.commandId;
            }
            if ((n3 & 4) != 0) {
                bl = menuItem.hasSeparatorAbove;
            }
            if ((n3 & 8) != 0) {
                menuItemType = menuItem.type;
            }
            if ((n3 & 0x10) != 0) {
                n2 = menuItem.groupId;
            }
            if ((n3 & 0x20) != 0) {
                bl2 = menuItem.enabled;
            }
            if ((n3 & 0x40) != 0) {
                bl3 = menuItem.checked;
            }
            if ((n3 & 0x80) != 0) {
                bl4 = menuItem.visible;
            }
            if ((n3 & 0x100) != 0) {
                list = menuItem.submenu;
            }
            return menuItem.copy(string, n, bl, menuItemType, n2, bl2, bl3, bl4, list);
        }

        @NotNull
        public String toString() {
            return "MenuItem(label=" + this.label + ", commandId=" + this.commandId + ", hasSeparatorAbove=" + this.hasSeparatorAbove + ", type=" + this.type + ", groupId=" + this.groupId + ", enabled=" + this.enabled + ", checked=" + this.checked + ", visible=" + this.visible + ", submenu=" + this.submenu + ")";
        }

        public int hashCode() {
            int result = this.label.hashCode();
            result = result * 31 + Integer.hashCode(this.commandId);
            result = result * 31 + Boolean.hashCode(this.hasSeparatorAbove);
            result = result * 31 + this.type.hashCode();
            result = result * 31 + Integer.hashCode(this.groupId);
            result = result * 31 + Boolean.hashCode(this.enabled);
            result = result * 31 + Boolean.hashCode(this.checked);
            result = result * 31 + Boolean.hashCode(this.visible);
            result = result * 31 + (this.submenu == null ? 0 : ((Object)this.submenu).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MenuItem)) {
                return false;
            }
            MenuItem menuItem = (MenuItem)other;
            if (!Intrinsics.areEqual((Object)this.label, (Object)menuItem.label)) {
                return false;
            }
            if (this.commandId != menuItem.commandId) {
                return false;
            }
            if (this.hasSeparatorAbove != menuItem.hasSeparatorAbove) {
                return false;
            }
            if (this.type != menuItem.type) {
                return false;
            }
            if (this.groupId != menuItem.groupId) {
                return false;
            }
            if (this.enabled != menuItem.enabled) {
                return false;
            }
            if (this.checked != menuItem.checked) {
                return false;
            }
            if (this.visible != menuItem.visible) {
                return false;
            }
            return Intrinsics.areEqual(this.submenu, menuItem.submenu);
        }
    }
}

