/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefHealthMonitor;
import com.intellij.ui.jcef.JBCefNotifications;
import com.intellij.ui.jcef.JcefShortcutProvider;
import com.intellij.ui.jcef.PropertiesHelper;
import com.intellij.ui.jcef.menu.CefContextMenuRunner;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.cef.browser.CefBrowser;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefBrowser
extends JBCefBrowserBase {
    @NotNull
    private static final List<Consumer<? super JBCefBrowser>> ourOnBrowserMoveResizeCallbacks = Collections.synchronizedList(new ArrayList(1));
    @NotNull
    static final Dimension DEF_PREF_SIZE = new Dimension(800, 600);
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final CefFocusHandler myCefFocusHandler;
    private volatile boolean myFirstShow;
    private MessageBusConnection myMsgBusConnection;

    protected JBCefBrowser(@NotNull JBCefBrowserBuilder builder) {
        if (builder == null) {
            JBCefBrowser.$$$reportNull$$$0(0);
        }
        super(builder);
        this.myFirstShow = true;
        if (this.myCefClient.isDisposed()) {
            throw new IllegalArgumentException("JBCefClient is disposed");
        }
        this.myComponent = this.createComponent(builder.myMouseWheelEventEnable);
        this.myCefFocusHandler = new CefFocusHandlerAdapter(){

            public void onTakeFocus(CefBrowser browser, boolean next) {
                super.onTakeFocus(browser, next);
                JBCefBrowserBase.focusedBrowser = null;
            }

            public void onGotFocus(CefBrowser browser) {
                super.onGotFocus(browser);
                JBCefBrowserBase.focusedBrowser = new WeakReference<JBCefBrowser>(JBCefBrowser.this);
            }

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean componentFocused = focusOwner == JBCefBrowser.this.getComponent() || focusOwner == JBCefBrowser.this.getCefBrowser().getUIComponent();
                boolean focusOnNavigation = JBCefBrowser.this.myFirstShow && JBCefBrowser.this.isProperty("JBCefBrowser.focusOnShow") || JBCefBrowser.this.isProperty("JBCefBrowser.focusOnNavigation") || componentFocused;
                JBCefBrowser.this.myFirstShow = false;
                if (source == CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION && !focusOnNavigation) {
                    if (SystemInfo.isWindows) {
                        JBCefBrowser.this.myCefBrowser.setFocus(false);
                    }
                    return true;
                }
                if (JBCefBrowser.this.isOffScreenRendering()) {
                    return false;
                }
                if (!browser.getUIComponent().hasFocus()) {
                    if (SystemInfo.isLinux) {
                        browser.getUIComponent().requestFocus();
                    } else {
                        browser.getUIComponent().requestFocusInWindow();
                    }
                }
                return false;
            }
        };
        this.myCefClient.addFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
        if (this.isOffScreenRendering()) {
            final CefContextMenuRunner contextMenuRunner = new CefContextMenuRunner();
            this.myCefClient.addContextMenuHandler((CefContextMenuHandler)contextMenuRunner, this.myCefBrowser);
            this.myCefBrowser.getUIComponent().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    JBCefBrowser.this.myCefBrowser.setFocus(true);
                }

                @Override
                public void focusLost(FocusEvent e) {
                    if (!contextMenuRunner.isShowing()) {
                        JBCefBrowser.this.myCefBrowser.setFocus(false);
                    }
                }
            });
        }
    }

    @NotNull
    public static JBCefBrowserBuilder createBuilder() {
        return new JBCefBrowserBuilder();
    }

    @NotNull
    public static JBCefBrowser create(@NotNull JBCefBrowserBuilder builder) {
        if (builder == null) {
            JBCefBrowser.$$$reportNull$$$0(1);
        }
        return new JBCefBrowser(builder);
    }

    public JBCefBrowser() {
        this(JBCefBrowser.createBuilder());
    }

    public JBCefBrowser(@NotNull String url) {
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(2);
        }
        this(JBCefBrowser.createBuilder().setUrl(url));
    }

    @Deprecated
    public JBCefBrowser(@NotNull JBCefClient client, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(3);
        }
        this(JBCefBrowser.createBuilder().setClient(client).setUrl(url));
    }

    @Deprecated
    public JBCefBrowser(@NotNull CefBrowser cefBrowser, @NotNull JBCefClient client) {
        if (cefBrowser == null) {
            JBCefBrowser.$$$reportNull$$$0(4);
        }
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(5);
        }
        this(JBCefBrowser.createBuilder().setCefBrowser(cefBrowser).setClient(client));
    }

    @NotNull
    private JPanel createComponent(boolean isMouseWheelEventEnabled) {
        Component uiComp = this.getCefBrowser().getUIComponent();
        final MyPanel resultPanel = new MyPanel(uiComp, isMouseWheelEventEnabled);
        resultPanel.setBackground(this.getBackgroundColor());
        resultPanel.putClientProperty("JBCefBrowser.instance", this);
        if (SystemInfo.isMac) {
            JcefShortcutProvider.registerShortcuts(resultPanel, this);
        }
        resultPanel.add(uiComp, "Center");
        if (SystemInfo.isWindows) {
            this.myCefBrowser.getUIComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (JBCefBrowser.this.myCefBrowser.getUIComponent().isFocusable()) {
                        JBCefBrowser.this.getCefBrowser().setFocus(true);
                    }
                }
            });
        }
        resultPanel.setFocusCycleRoot(true);
        resultPanel.setFocusTraversalPolicyProvider(true);
        resultPanel.setFocusTraversalPolicy(new MyFTP());
        resultPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }
        });
        this.myMsgBusConnection = ApplicationManager.getApplication().getMessageBus().connect();
        this.myMsgBusConnection.subscribe(JBCefHealthMonitor.JBCefHealthCheckTopic.TOPIC, (Object)new JBCefHealthMonitor.JBCefHealthCheckTopic(){

            @Override
            public void onHealthHealthStatusChanged(@NotNull JBCefHealthMonitor.Status status) {
                if (status == null) {
                    5.$$$reportNull$$$0(0);
                }
                SwingUtilities.invokeLater(() -> {
                    Component panel = JBCefNotifications.createStubPanel(status);
                    if (panel != null) {
                        resultPanel.setStubPanel(panel);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/ui/jcef/JBCefBrowser$5", "onHealthHealthStatusChanged"));
            }
        });
        JBCefHealthMonitor.Status status = JBCefHealthMonitor.getInstance().getStatus();
        Component stubPanel = JBCefNotifications.createStubPanel(status);
        if (stubPanel != null) {
            resultPanel.setStubPanel(stubPanel);
        }
        MyPanel myPanel = resultPanel;
        if (myPanel == null) {
            JBCefBrowser.$$$reportNull$$$0(6);
        }
        return myPanel;
    }

    @NotNull
    protected Color getBackgroundColor() {
        Color color = JBColor.background();
        if (color == null) {
            JBCefBrowser.$$$reportNull$$$0(7);
        }
        return color;
    }

    public static void addOnBrowserMoveResizeCallback(@NotNull Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(8);
        }
        ourOnBrowserMoveResizeCallbacks.add(callback);
    }

    public static void removeOnBrowserMoveResizeCallback(@NotNull Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(9);
        }
        ourOnBrowserMoveResizeCallbacks.remove(callback);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            JBCefBrowser.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    @Override
    public void dispose() {
        if (this.myMsgBusConnection != null) {
            this.myMsgBusConnection.disconnect();
        }
        super.dispose(() -> this.myCefClient.removeFocusHandler(this.myCefFocusHandler, this.myCefBrowser));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefBrowser";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundColor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addOnBrowserMoveResizeCallback";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeOnBrowserMoveResizeCallback";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10 -> new IllegalStateException(string);
        };
    }

    public class MyPanel
    extends JPanel {
        private final Component myUiComp;

        private MyPanel(Component uiComp, boolean isMouseWheelEventEnabled) {
            super(new BorderLayout());
            this.myUiComp = uiComp;
            this.myUiComp.setBackground(this.getBackground());
            if (isMouseWheelEventEnabled) {
                this.enableEvents(131072L);
            }
        }

        @Override
        public void setBackground(Color bg) {
            if (this.myUiComp != null) {
                this.myUiComp.setBackground(bg);
            }
            super.setBackground(bg);
        }

        @Override
        public void removeNotify() {
            if (SystemInfo.isWindows && JBCefBrowser.this.myCefBrowser.getUIComponent().hasFocus()) {
                JBCefBrowser.this.myCefBrowser.setFocus(false);
            }
            JBCefBrowser.this.myFirstShow = true;
            super.removeNotify();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return size.width > 0 && size.height > 0 ? size : DEF_PREF_SIZE;
        }

        @Override
        protected void processFocusEvent(FocusEvent e) {
            super.processFocusEvent(e);
            if (e.getID() == 1004) {
                this.myUiComp.requestFocusInWindow();
            }
        }

        @NotNull
        public JBCefBrowser getJBCefBrowser() {
            JBCefBrowser jBCefBrowser = JBCefBrowser.this;
            if (jBCefBrowser == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            return jBCefBrowser;
        }

        private void setStubPanel(@NotNull Component stubPanel) {
            if (stubPanel == null) {
                MyPanel.$$$reportNull$$$0(1);
            }
            this.removeAll();
            this.add(stubPanel);
            this.revalidate();
            this.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowser$MyPanel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stubPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getJBCefBrowser";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser$MyPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setStubPanel";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyFTP
    extends FocusTraversalPolicy {
        private MyFTP() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }
    }

    protected class DefaultCefContextMenuHandler
    extends JBCefBrowserBase.DefaultCefContextMenuHandler {
        public DefaultCefContextMenuHandler(JBCefBrowser this$0) {
            super(this$0);
        }

        public DefaultCefContextMenuHandler(JBCefBrowser this$0, boolean isOpenDevToolsItemEnabled) {
            super(this$0, isOpenDevToolsItemEnabled);
        }
    }

    public static class Properties
    extends JBCefBrowserBase.Properties {
        @NotNull
        public static final String FOCUS_ON_NAVIGATION = "JBCefBrowser.focusOnNavigation";
        @NotNull
        public static final String FOCUS_ON_SHOW = "JBCefBrowser.focusOnShow";

        static {
            PropertiesHelper.setType(FOCUS_ON_NAVIGATION, Boolean.class);
            PropertiesHelper.setType(FOCUS_ON_SHOW, Boolean.class);
        }
    }
}

