/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.icons.AllIcons;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.UsageGroupBase;
import com.intellij.usages.impl.rules.UsageGroupingRulesDefaultRanks;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.usages.rules.UsageInLibrary;
import com.intellij.usages.rules.UsageInModule;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ModuleGroupingRule
implements UsageGroupingRuleEx,
DumbAware {
    private final ModuleGrouper myGrouper;
    private final boolean myFlattenModules;

    ModuleGroupingRule(@NotNull Project project, boolean flattenModules) {
        if (project == null) {
            ModuleGroupingRule.$$$reportNull$$$0(0);
        }
        this.myGrouper = ModuleGrouper.instanceFor((Project)project);
        this.myFlattenModules = flattenModules;
    }

    @NotNull
    public List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        UsageInModule usageInModule;
        Module module;
        if (usage == null) {
            ModuleGroupingRule.$$$reportNull$$$0(1);
        }
        if (targets == null) {
            ModuleGroupingRule.$$$reportNull$$$0(2);
        }
        if (usage instanceof UsageInModule && (module = (usageInModule = (UsageInModule)usage).getModule()) != null) {
            if (this.myFlattenModules) {
                List<UsageGroup> list = Collections.singletonList(new ModuleUsageGroup(module, null));
                if (list == null) {
                    ModuleGroupingRule.$$$reportNull$$$0(3);
                }
                return list;
            }
            List groupPath = this.myGrouper.getGroupPath(module);
            ArrayList<UsageGroup> parentGroups = new ArrayList<UsageGroup>(groupPath.size() + 1);
            for (int i = 1; i <= groupPath.size(); ++i) {
                parentGroups.add(new ModuleGroupUsageGroup(groupPath.subList(0, i)));
            }
            parentGroups.add(new ModuleUsageGroup(module, this.myGrouper));
            ArrayList<UsageGroup> arrayList = parentGroups;
            if (arrayList == null) {
                ModuleGroupingRule.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        if (usage instanceof UsageInLibrary) {
            UsageInLibrary usageInLibrary = (UsageInLibrary)usage;
            OrderEntry entry = usageInLibrary.getLibraryEntry();
            if (entry != null) {
                List<UsageGroup> list = Collections.singletonList(new LibraryUsageGroup(entry));
                if (list == null) {
                    ModuleGroupingRule.$$$reportNull$$$0(5);
                }
                return list;
            }
            for (SyntheticLibrary syntheticLibrary : usageInLibrary.getSyntheticLibraries()) {
                if (!(syntheticLibrary instanceof ItemPresentation)) continue;
                List<UsageGroup> list = Collections.singletonList(new SyntheticLibraryUsageGroup((ItemPresentation)syntheticLibrary));
                if (list == null) {
                    ModuleGroupingRule.$$$reportNull$$$0(6);
                }
                return list;
            }
        }
        List<UsageGroup> list = Collections.emptyList();
        if (list == null) {
            ModuleGroupingRule.$$$reportNull$$$0(7);
        }
        return list;
    }

    public int getRank() {
        return UsageGroupingRulesDefaultRanks.MODULE.getAbsoluteRank();
    }

    @Nullable
    public String getGroupingActionId() {
        return "UsageGrouping.Module";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentGroupsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentGroupsFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }

    private static class ModuleUsageGroup
    extends UsageGroupBase
    implements UiDataProvider {
        private final Module myModule;
        private final ModuleGrouper myGrouper;

        ModuleUsageGroup(@NotNull Module module, @Nullable ModuleGrouper grouper) {
            if (module == null) {
                ModuleUsageGroup.$$$reportNull$$$0(0);
            }
            super(1);
            this.myModule = module;
            this.myGrouper = grouper;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModuleUsageGroup)) {
                return false;
            }
            ModuleUsageGroup moduleUsageGroup = (ModuleUsageGroup)o;
            return this.myModule.equals((Object)moduleUsageGroup.myModule);
        }

        public int hashCode() {
            return this.myModule.hashCode();
        }

        public Icon getIcon() {
            return this.myModule.isDisposed() ? null : ModuleType.get((Module)this.myModule).getIcon();
        }

        @NotNull
        public String getPresentableGroupText() {
            String string = this.myModule.isDisposed() ? "" : (this.myGrouper != null ? this.myGrouper.getShortenedName(this.myModule) : this.myModule.getName());
            if (string == null) {
                ModuleUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isValid() {
            return !this.myModule.isDisposed();
        }

        public String toString() {
            return UsageViewBundle.message((String)"node.group.module", (Object[])new Object[]{this.getPresentableGroupText()});
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                ModuleUsageGroup.$$$reportNull$$$0(2);
            }
            sink.set(LangDataKeys.MODULE_CONTEXT, (Object)this.myModule);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sink";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "uiDataSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class ModuleGroupUsageGroup
    extends UsageGroupBase {
        private final List<String> myGroupPath;

        ModuleGroupUsageGroup(@NotNull List<String> groupPath) {
            if (groupPath == null) {
                ModuleGroupUsageGroup.$$$reportNull$$$0(0);
            }
            super(0);
            this.myGroupPath = groupPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof ModuleGroupUsageGroup && this.myGroupPath.equals(((ModuleGroupUsageGroup)o).myGroupPath);
        }

        public int hashCode() {
            return this.myGroupPath.hashCode();
        }

        public Icon getIcon() {
            return AllIcons.Nodes.ModuleGroup;
        }

        @NotNull
        public String getPresentableGroupText() {
            String string = this.myGroupPath.get(this.myGroupPath.size() - 1);
            if (string == null) {
                ModuleGroupUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public String toString() {
            return UsageViewBundle.message((String)"node.group.module.group", (Object[])new Object[]{this.getPresentableGroupText()});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "groupPath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleGroupUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$ModuleGroupUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class LibraryUsageGroup
    extends UsageGroupBase {
        private final OrderEntry myEntry;

        LibraryUsageGroup(@NotNull OrderEntry entry) {
            if (entry == null) {
                LibraryUsageGroup.$$$reportNull$$$0(0);
            }
            super(2);
            this.myEntry = entry;
        }

        public Icon getIcon() {
            return AllIcons.Nodes.PpLibFolder;
        }

        @NotNull
        public String getPresentableGroupText() {
            String string = this.myEntry.getPresentableName();
            if (string == null) {
                LibraryUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof LibraryUsageGroup && this.myEntry.equals((Object)((LibraryUsageGroup)o).myEntry);
        }

        public int hashCode() {
            return this.myEntry.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "entry";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$LibraryUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class SyntheticLibraryUsageGroup
    extends UsageGroupBase {
        @NotNull
        private final ItemPresentation myItemPresentation;

        SyntheticLibraryUsageGroup(@NotNull ItemPresentation itemPresentation) {
            if (itemPresentation == null) {
                SyntheticLibraryUsageGroup.$$$reportNull$$$0(0);
            }
            super(2);
            this.myItemPresentation = itemPresentation;
        }

        public Icon getIcon() {
            return this.myItemPresentation.getIcon(false);
        }

        @NotNull
        public String getPresentableGroupText() {
            String string = StringUtil.notNullize((String)this.myItemPresentation.getPresentableText(), (String)UsageViewBundle.message((String)"list.item.library", (Object[])new Object[0]));
            if (string == null) {
                SyntheticLibraryUsageGroup.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof SyntheticLibraryUsageGroup && this.myItemPresentation.equals((Object)((SyntheticLibraryUsageGroup)o).myItemPresentation);
        }

        public int hashCode() {
            return this.myItemPresentation.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "itemPresentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/usages/impl/rules/ModuleGroupingRule$SyntheticLibraryUsageGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/usages/impl/rules/ModuleGroupingRule$SyntheticLibraryUsageGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableGroupText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

