/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages.similarity;

import com.intellij.find.findUsages.similarity.SnippetRenderingData;
import com.intellij.find.findUsages.similarity.UsageCodeSnippetComponent;
import com.intellij.find.findUsages.similarity.UsagePreviewComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageView;
import com.intellij.usages.similarity.statistics.SimilarUsagesCollector;
import com.intellij.util.IconUtil;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00192\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00012\u00020\u0002:\u0001\u0019B)\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/find/findUsages/similarity/UsagePreviewComponent;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/Disposable;", "usageView", "Lcom/intellij/usages/UsageView;", "usageInfo", "Lcom/intellij/usageView/UsageInfo;", "renderingData", "Lcom/intellij/find/findUsages/similarity/SnippetRenderingData;", "parent", "<init>", "(Lcom/intellij/usages/UsageView;Lcom/intellij/usageView/UsageInfo;Lcom/intellij/find/findUsages/similarity/SnippetRenderingData;Lcom/intellij/openapi/Disposable;)V", "header", "Ljavax/swing/JPanel;", "getHeader", "()Ljavax/swing/JPanel;", "setHeader", "(Ljavax/swing/JPanel;)V", "mySnippetComponent", "Lcom/intellij/find/findUsages/similarity/UsageCodeSnippetComponent;", "myUsageView", "renderCluster", "", "createHeaderWithLocationLink", "dispose", "Companion", "intellij.platform.usageView.impl"})
public final class UsagePreviewComponent
extends JBPanel<JBPanel<?>>
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private JPanel header;
    @NotNull
    private UsageCodeSnippetComponent mySnippetComponent;
    @NotNull
    private final UsageView myUsageView;

    private UsagePreviewComponent(UsageView usageView, UsageInfo usageInfo, SnippetRenderingData renderingData, Disposable parent) {
        this.setLayout((LayoutManager)new VerticalLayout(0));
        this.myUsageView = usageView;
        this.header = this.createHeaderWithLocationLink(usageInfo);
        this.add(this.header);
        this.mySnippetComponent = new UsageCodeSnippetComponent(renderingData, usageInfo);
        this.add((Component)((Object)this.mySnippetComponent));
        if (!Disposer.tryRegister((Disposable)parent, (Disposable)this)) {
            Disposer.dispose((Disposable)parent);
        }
    }

    @NotNull
    public final JPanel getHeader() {
        return this.header;
    }

    public final void setHeader(@NotNull JPanel jPanel) {
        Intrinsics.checkNotNullParameter((Object)jPanel, (String)"<set-?>");
        this.header = jPanel;
    }

    public final void renderCluster(@NotNull UsageInfo usageInfo, @NotNull SnippetRenderingData renderingData) {
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        Intrinsics.checkNotNullParameter((Object)renderingData, (String)"renderingData");
        this.removeAll();
        this.header = this.createHeaderWithLocationLink(usageInfo);
        Disposer.dispose((Disposable)((Disposable)this.mySnippetComponent));
        this.mySnippetComponent = new UsageCodeSnippetComponent(renderingData, usageInfo);
        this.add(this.header);
        this.add((Component)((Object)this.mySnippetComponent));
    }

    private final JPanel createHeaderWithLocationLink(UsageInfo usageInfo) {
        ActionLink locationLinkComponent = Companion.createNavigationLink((JComponent)((Object)this), this.myUsageView, usageInfo);
        JPanel header = new JPanel();
        header.setBackground(UIUtil.getTextFieldBackground());
        header.setLayout(new FlowLayout(0));
        if (locationLinkComponent != null) {
            header.add((Component)locationLinkComponent);
        }
        header.setBorder(JBUI.Borders.customLineTop((Color)((Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51))));
        return header;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.mySnippetComponent));
    }

    @JvmStatic
    @NotNull
    public static final UsagePreviewComponent create(@NotNull UsageView usageView, @NotNull UsageInfo info, @NotNull SnippetRenderingData renderingData, @NotNull Disposable parent) {
        return Companion.create(usageView, info, renderingData, parent);
    }

    public /* synthetic */ UsagePreviewComponent(UsageView usageView, UsageInfo usageInfo, SnippetRenderingData renderingData, Disposable parent, DefaultConstructorMarker $constructor_marker) {
        this(usageView, usageInfo, renderingData, parent);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J \u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Lcom/intellij/find/findUsages/similarity/UsagePreviewComponent$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/find/findUsages/similarity/UsagePreviewComponent;", "usageView", "Lcom/intellij/usages/UsageView;", "info", "Lcom/intellij/usageView/UsageInfo;", "renderingData", "Lcom/intellij/find/findUsages/similarity/SnippetRenderingData;", "parent", "Lcom/intellij/openapi/Disposable;", "createNavigationLink", "Lcom/intellij/ui/components/ActionLink;", "sourceComponent", "Ljavax/swing/JComponent;", "usageInfo", "intellij.platform.usageView.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final UsagePreviewComponent create(@NotNull UsageView usageView, @NotNull UsageInfo info, @NotNull SnippetRenderingData renderingData, @NotNull Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)usageView, (String)"usageView");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter((Object)renderingData, (String)"renderingData");
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            return new UsagePreviewComponent(usageView, info, renderingData, parent, null);
        }

        @Nullable
        public final ActionLink createNavigationLink(@NotNull JComponent sourceComponent, @NotNull UsageView usageView, @NotNull UsageInfo usageInfo) {
            Intrinsics.checkNotNullParameter((Object)sourceComponent, (String)"sourceComponent");
            Intrinsics.checkNotNullParameter((Object)usageView, (String)"usageView");
            Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
            VirtualFile virtualFile = usageInfo.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile file = virtualFile;
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            ActionLink actionLink2 = new ActionLink(string, (ActionListener)new AbstractAction(usageInfo, sourceComponent, usageView){
                final /* synthetic */ UsageInfo $usageInfo;
                final /* synthetic */ JComponent $sourceComponent;
                final /* synthetic */ UsageView $usageView;
                {
                    this.$usageInfo = $usageInfo;
                    this.$sourceComponent = $sourceComponent;
                    this.$usageView = $usageView;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    Project project = this.$usageInfo.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    SimilarUsagesCollector.logNavigateToUsageClicked((Project)project, this.$sourceComponent.getClass(), (UsageView)this.$usageView);
                    WriteIntentReadAction.run(() -> createNavigationLink.actionLink.1.actionPerformed$lambda$0(this.$usageInfo));
                }

                private static final void actionPerformed$lambda$0(UsageInfo $usageInfo) {
                    PsiNavigateUtil.navigate((PsiElement)$usageInfo.getElement());
                }
            });
            actionLink2.setBackground(UIUtil.TRANSPARENT_COLOR);
            actionLink2.setOpaque(false);
            actionLink2.setIcon(IconUtil.getIcon((VirtualFile)file, (int)2, (Project)usageInfo.getProject()));
            return actionLink2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

