/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl;

import com.intellij.find.SearchInBackgroundOption;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.TooManyUsagesStatus;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.FileRankerMlService;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.content.Content;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageLimitUtil;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.CodeNavigateSource;
import com.intellij.usages.impl.SearchForUsagesRunnable;
import com.intellij.usages.impl.UsageViewEx;
import com.intellij.usages.impl.UsageViewFactory;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewStatisticsCollector;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class UsageViewManagerImpl
extends UsageViewManager {
    private static final Logger LOG = Logger.getInstance(UsageViewManagerImpl.class);
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    private static final Key<UsageView> USAGE_VIEW_KEY = Key.create((String)"USAGE_VIEW");

    @ApiStatus.Internal
    public UsageViewManagerImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(1);
        }
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    @NotNull
    public UsageViewEx createUsageView(UsageTarget @NotNull [] targets, Usage @NotNull [] usages, @NotNull UsageViewPresentation presentation, @Nullable Factory<? extends UsageSearcher> usageSearcherFactory) {
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(2);
        }
        if (targets == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(3);
        }
        if (usages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(4);
        }
        for (UsageViewFactory factory : UsageViewFactory.EP_NAME.getExtensionList()) {
            UsageViewEx result = factory.createUsageView(targets, usages, presentation, usageSearcherFactory);
            if (result == null) continue;
            UsageViewEx usageViewEx = result;
            if (usageViewEx == null) {
                UsageViewManagerImpl.$$$reportNull$$$0(5);
            }
            return usageViewEx;
        }
        final UsageViewImpl usageView = new UsageViewImpl(this.project, CoroutineScopeKt.childScope((CoroutineScope)this.coroutineScope, (String)"UsageView", (CoroutineContext)EmptyCoroutineContext.INSTANCE, (boolean)true), presentation, targets, (Supplier<? extends UsageSearcher>)usageSearcherFactory);
        if (usages.length != 0) {
            usageView.appendUsagesInBulk(Arrays.asList(usages));
            ProgressManager.getInstance().run((Task)new Task.Modal(this, this.project, UsageViewBundle.message((String)"progress.title.waiting.for.usages", (Object[])new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    usageView.waitForUpdateRequestsCompletion();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/UsageViewManagerImpl$1", "run"));
                }
            });
        }
        usageView.setSearchInProgress(false);
        UsageViewImpl usageViewImpl = usageView;
        if (usageViewImpl == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(6);
        }
        return usageViewImpl;
    }

    @NotNull
    public UsageView showUsages(UsageTarget @NotNull [] searchedFor, Usage @NotNull [] foundUsages, @NotNull UsageViewPresentation presentation, @Nullable Factory<? extends UsageSearcher> factory) {
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(7);
        }
        if (searchedFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(8);
        }
        if (foundUsages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(9);
        }
        UsageViewEx usageView = this.createUsageView(searchedFor, foundUsages, presentation, factory);
        this.showUsageView(usageView, presentation);
        if (usageView instanceof UsageViewImpl) {
            UsageViewImpl impl = (UsageViewImpl)usageView;
            this.showToolWindow(true);
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!impl.isDisposed()) {
                    impl.expandRoot();
                }
            });
        }
        UsageViewEx usageViewEx = usageView;
        if (usageViewEx == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(10);
        }
        return usageViewEx;
    }

    @NotNull
    public UsageView showUsages(UsageTarget @NotNull [] searchedFor, Usage @NotNull [] foundUsages, @NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(11);
        }
        if (searchedFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(12);
        }
        if (foundUsages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(13);
        }
        UsageView usageView = this.showUsages(searchedFor, foundUsages, presentation, null);
        if (usageView == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(14);
        }
        return usageView;
    }

    void showUsageView(@NotNull UsageViewEx usageView, @NotNull UsageViewPresentation presentation) {
        if (usageView == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(15);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(16);
        }
        boolean wasPinned = false;
        Content selectedContent = UsageViewContentManager.getInstance((Project)this.project).getSelectedContent();
        if (selectedContent != null && System.identityHashCode(selectedContent) == presentation.getRerunHash()) {
            wasPinned = selectedContent.isPinned();
            selectedContent.setPinned(false);
        }
        Content content = UsageViewContentManager.getInstance((Project)this.project).addContent(presentation.getTabText(), presentation.getTabName(), presentation.getToolwindowTitle(), true, usageView.getComponent(), presentation.isOpenInNewTab() && presentation.getRerunHash() == 0, true);
        content.setPinned(wasPinned);
        ((UsageViewImpl)usageView).setContent(content);
        content.putUserData(USAGE_VIEW_KEY, (Object)usageView);
    }

    @Nullable
    public UsageView searchAndShowUsages(UsageTarget @NotNull [] searchFor, @NotNull Supplier<? extends UsageSearcher> searcherFactory, boolean showPanelIfOnlyOneUsage, boolean showNotFoundMessage, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searcherFactory == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(17);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(18);
        }
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(19);
        }
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowNotFoundMessage(showNotFoundMessage);
        processPresentation.setShowPanelIfOnlyOneUsage(showPanelIfOnlyOneUsage);
        return this.doSearchAndShow(searchFor, searcherFactory, presentation, processPresentation, listener);
    }

    private UsageView doSearchAndShow(final UsageTarget @NotNull [] searchFor, final @NotNull Supplier<? extends UsageSearcher> searcherFactory, final @NotNull UsageViewPresentation presentation, final @NotNull FindUsagesProcessPresentation processPresentation, final @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searcherFactory == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(20);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(21);
        }
        if (processPresentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(22);
        }
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(23);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Can't start find usages from under write action. Please consider Application.invokeLater() it instead.");
        }
        final Supplier<SearchScope> scopeSupplier = this.getMaxSearchScopeToWarnOfFallingOutOf(searchFor);
        final AtomicReference usageViewRef = new AtomicReference();
        final long start = System.nanoTime();
        final AtomicLong firstItemFoundTS = new AtomicLong();
        final AtomicBoolean tooManyUsages = new AtomicBoolean();
        Task.Backgroundable task = new Task.Backgroundable(this.project, UsageViewManagerImpl.getProgressTitle(presentation), true, (PerformInBackgroundOption)new SearchInBackgroundOption()){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                SearchScope searchScopeToWarnOfFallingOutOf = (SearchScope)ReadAction.compute(() -> 2.lambda$run$0((Supplier)scopeSupplier));
                new SearchForUsagesRunnable(UsageViewManagerImpl.this, UsageViewManagerImpl.this.project, usageViewRef, presentation, searchFor, searcherFactory, processPresentation, searchScopeToWarnOfFallingOutOf, listener, firstItemFoundTS, tooManyUsages).run();
            }

            public void onCancel() {
                this.reportSearchCompletedToFus(true);
                super.onCancel();
            }

            @NotNull
            public Task.NotificationInfo getNotificationInfo() {
                UsageViewEx usageView = (UsageViewEx)usageViewRef.get();
                int count = usageView == null ? 0 : usageView.getUsagesCount();
                long duration = this.reportSearchCompletedToFus(false);
                String notification = StringUtil.capitalizeWords((String)UsageViewBundle.message((String)"usages.n", (Object[])new Object[]{count}), (boolean)true);
                LOG.debug(notification + " in " + duration + "ms.");
                return new Task.NotificationInfo("Find Usages", UsageViewBundle.message((String)"notification.title.find.usages.finished", (Object[])new Object[0]), notification);
            }

            private long reportSearchCompletedToFus(boolean isCancelled) {
                Class targetClass;
                long currentTS = System.nanoTime();
                long durationFirstResults = TimeUnit.NANOSECONDS.toMillis(firstItemFoundTS.get() - start);
                long duration = TimeUnit.NANOSECONDS.toMillis(currentTS - start);
                PsiElement element = SearchForUsagesRunnable.getPsiElement(searchFor);
                UsageViewEx view = (UsageViewEx)usageViewRef.get();
                Class clazz = targetClass = element != null ? element.getClass() : null;
                Language language = element != null ? (Language)ReadAction.compute(() -> ((PsiElement)element).getLanguage()) : null;
                SearchScope scope = null;
                if (element instanceof DataProvider) {
                    DataProvider provider = (DataProvider)element;
                    scope = (SearchScope)UsageView.USAGE_SCOPE.getData(provider);
                }
                int numberOfUsagesFound = view == null ? 0 : view.getUsagesCount();
                UsageViewStatisticsCollector.logSearchFinished((Project)this.myProject, (UsageView)view, (Class)targetClass, (SearchScope)scope, (Language)language, (int)numberOfUsagesFound, (long)durationFirstResults, (long)duration, (boolean)tooManyUsages.get(), (boolean)isCancelled, (CodeNavigateSource)CodeNavigateSource.FindToolWindow);
                Set usages = view == null ? Collections.emptySet() : view.getUsages();
                UsageViewManagerImpl.informRankerMlService(UsageViewManagerImpl.this.project, usages, FileRankerMlService.CallSource.FIND_USAGES);
                return duration;
            }

            private static /* synthetic */ SearchScope lambda$run$0(Supplier scopeSupplier2) throws RuntimeException {
                return (SearchScope)scopeSupplier2.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/usages/impl/UsageViewManagerImpl$2", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
        return (UsageView)usageViewRef.get();
    }

    @ApiStatus.Internal
    public static void informRankerMlService(@NotNull Project project, @NotNull Collection<Usage> usages, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull FileRankerMlService.CallSource source) {
        FileRankerMlService rankerMlService;
        if (project == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(24);
        }
        if (usages == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(25);
        }
        if (source == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(26);
        }
        if ((rankerMlService = FileRankerMlService.getInstance()) == null) {
            return;
        }
        Set foundFiles = ContainerUtil.map2SetNotNull(usages, usage -> {
            VirtualFile virtualFile;
            if (usage instanceof UsageInFile) {
                UsageInFile inFile = (UsageInFile)usage;
                virtualFile = inFile.getFile();
            } else {
                virtualFile = null;
            }
            return virtualFile;
        });
        rankerMlService.onSessionFinished(project, foundFiles, source);
    }

    @VisibleForTesting
    @ApiStatus.Internal
    @NotNull
    public Supplier<SearchScope> getMaxSearchScopeToWarnOfFallingOutOf(UsageTarget @NotNull [] searchFor) {
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(27);
        }
        UsageTarget target = searchFor.length > 0 ? searchFor[0] : null;
        DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)DataContext.EMPTY_CONTEXT, sink -> DataSink.uiDataSnapshot((DataSink)sink, (Object)target));
        Supplier<SearchScope> supplier = () -> Objects.requireNonNullElseGet((SearchScope)dataContext.getData(UsageView.USAGE_SCOPE), () -> GlobalSearchScope.everythingScope((Project)this.project));
        if (supplier == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(28);
        }
        return supplier;
    }

    public void searchAndShowUsages(UsageTarget @NotNull [] searchFor, @NotNull Factory<? extends UsageSearcher> searcherFactory, @NotNull FindUsagesProcessPresentation processPresentation, @NotNull UsageViewPresentation presentation, @Nullable UsageViewManager.UsageViewStateListener listener) {
        if (searcherFactory == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(29);
        }
        if (processPresentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(30);
        }
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(31);
        }
        if (searchFor == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(32);
        }
        this.doSearchAndShow(searchFor, (Supplier<? extends UsageSearcher>)searcherFactory, presentation, processPresentation, listener);
    }

    public UsageView getSelectedUsageView() {
        Content content = UsageViewContentManager.getInstance((Project)this.project).getSelectedContent();
        if (content != null) {
            return (UsageView)content.getUserData(USAGE_VIEW_KEY);
        }
        return null;
    }

    @NlsContexts.ProgressTitle
    @NotNull
    public static String getProgressTitle(@NotNull UsageViewPresentation presentation) {
        if (presentation == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(33);
        }
        String string = UsageViewBundle.message((String)"search.progress.0.in.1", (Object[])new Object[]{presentation.getSearchString(), presentation.getScopeText()});
        if (string == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(34);
        }
        return string;
    }

    void showToolWindow(boolean activateWindow) {
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.project).getToolWindow("Find");
        toolWindow.show(null);
        if (activateWindow && !toolWindow.isActive()) {
            toolWindow.activate(null);
        }
    }

    @ApiStatus.Internal
    public static void showTooManyUsagesWarningLater(@NotNull Project project, @NotNull TooManyUsagesStatus tooManyUsagesStatus, @NotNull ProgressIndicator indicator, @Nullable UsageViewEx usageView, @NotNull Supplier<@NlsContexts.DialogMessage String> messageSupplier, @Nullable Consumer<? super UsageLimitUtil.Result> onUserClicked) {
        if (project == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(35);
        }
        if (tooManyUsagesStatus == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(36);
        }
        if (indicator == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(37);
        }
        if (messageSupplier == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(38);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (usageView != null && usageView.searchHasBeenCancelled() || indicator.isCanceled()) {
                return;
            }
            UsageLimitUtil.Result ret = UsageLimitUtil.showTooManyUsagesWarning((Project)project, (String)((String)messageSupplier.get()));
            if (ret == UsageLimitUtil.Result.ABORT) {
                if (usageView != null) {
                    usageView.cancelCurrentSearch();
                }
                indicator.cancel();
            }
            tooManyUsagesStatus.userResponded();
            if (onUserClicked != null) {
                onUserClicked.accept(ret);
            }
        });
    }

    @ApiStatus.Internal
    public static long getFileLength(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(39);
        }
        return (Long)ReadAction.compute(() -> virtualFile.isValid() ? virtualFile.getLength() : -1L);
    }

    @ApiStatus.Internal
    @NotNull
    public static String presentableSize(long bytes) {
        long megabytes = bytes / 0x100000L;
        String string = UsageViewBundle.message((String)"find.file.size.megabytes", (Object[])new Object[]{Long.toString(megabytes)});
        if (string == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(40);
        }
        return string;
    }

    @ApiStatus.Internal
    public static boolean isInScope(@NotNull Usage usage, @NotNull SearchScope searchScope, @NotNull SearchScope everythingScope) {
        if (usage == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(41);
        }
        if (searchScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(42);
        }
        if (everythingScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(43);
        }
        if (searchScope.equals(everythingScope)) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            VirtualFile file;
            if (usage instanceof PsiElementUsage) {
                PsiElementUsage psiElementUsage = (PsiElementUsage)usage;
                PsiElement element = psiElementUsage.getElement();
                if (element == null) {
                    return false;
                }
                if (searchScope instanceof EverythingGlobalScope || searchScope instanceof ProjectScopeImpl || searchScope instanceof ProjectAndLibrariesScope) {
                    return true;
                }
                file = PsiUtilCore.getVirtualFile((PsiElement)element);
            } else if (usage instanceof UsageInFile) {
                UsageInFile usageInFile = (UsageInFile)usage;
                file = usageInFile.getFile();
            } else {
                return false;
            }
            return file != null && UsageViewManagerImpl.isFileInScope(file, searchScope);
        });
    }

    private static boolean isFileInScope(@NotNull VirtualFile file, @NotNull SearchScope searchScope) {
        if (file == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(44);
        }
        if (searchScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(45);
        }
        if (file instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)file;
            file = window.getDelegate();
        }
        file = BackedVirtualFile.getOriginFileIfBacked((VirtualFile)file);
        return searchScope.contains(file);
    }

    @ApiStatus.Internal
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public static String outOfScopeMessage(int nUsages, @NotNull SearchScope searchScope) {
        if (searchScope == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(46);
        }
        String string = UsageViewBundle.message((String)"0.usages.are.out.of.scope", (Object[])new Object[]{nUsages, searchScope.getDisplayName()});
        if (string == null) {
            UsageViewManagerImpl.$$$reportNull$$$0(47);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 10, 14, 28, 34, 40, 47 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 21: 
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 28: 
            case 34: 
            case 40: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/UsageViewManagerImpl";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchedFor";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foundUsages";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 17: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searcherFactory";
                break;
            }
            case 19: 
            case 23: 
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchFor";
                break;
            }
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processPresentation";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooManyUsagesStatus";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageSupplier";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 42: 
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "everythingScope";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/UsageViewManagerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageView";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "showUsages";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxSearchScopeToWarnOfFallingOutOf";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getProgressTitle";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "presentableSize";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "outOfScopeMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createUsageView";
                break;
            }
            case 5: 
            case 6: 
            case 10: 
            case 14: 
            case 28: 
            case 34: 
            case 40: 
            case 47: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showUsages";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "searchAndShowUsages";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doSearchAndShow";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "informRankerMlService";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getMaxSearchScopeToWarnOfFallingOutOf";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getProgressTitle";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "showTooManyUsagesWarningLater";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getFileLength";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isFileInScope";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "outOfScopeMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 10, 14, 28, 34, 40, 47 -> new IllegalStateException(string);
        };
    }
}

