/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages.similarity;

import com.intellij.openapi.util.Ref;
import com.intellij.usages.similarity.clustering.ClusteringSearchSession;
import com.intellij.usages.similarity.clustering.Distance;
import com.intellij.usages.similarity.clustering.UsageCluster;
import com.intellij.usages.similarity.usageAdapter.SimilarUsage;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SilhouetteScore {
    @NotNull
    private final ClusteringSearchSession myClusteringSearchSession;

    public SilhouetteScore(@NotNull ClusteringSearchSession clusteringSearchSession) {
        if (clusteringSearchSession == null) {
            SilhouetteScore.$$$reportNull$$$0(0);
        }
        this.myClusteringSearchSession = clusteringSearchSession;
    }

    public double getSilhouetteScoreResult() {
        if (this.myClusteringSearchSession.getClusters().size() == 1) {
            return Double.NaN;
        }
        Ref overallSilhouetteScore = new Ref((Object)0.0);
        Ref usageCount = new Ref((Object)0);
        this.myClusteringSearchSession.getClusters().forEach(cluster -> cluster.getUsages().forEach(usage -> {
            usageCount.set((Object)((Integer)usageCount.get() + 1));
            double cohesion = SilhouetteScore.getCohesionIndex(cluster, usage);
            double separation = this.getSeparationIndex((UsageCluster)cluster, (SimilarUsage)usage);
            double silhouetteScore = (separation - cohesion) / Math.max(separation, cohesion);
            if (Double.isNaN(silhouetteScore) || Double.isInfinite(silhouetteScore)) {
                silhouetteScore = 0.0;
            }
            double finalSilhouetteScore = silhouetteScore;
            overallSilhouetteScore.set((Object)((Double)overallSilhouetteScore.get() + finalSilhouetteScore));
        }));
        return (Double)overallSilhouetteScore.get() / (double)((Integer)usageCount.get()).intValue();
    }

    private static double getCohesionIndex(@NotNull UsageCluster cluster, @NotNull SimilarUsage similarUsage) {
        if (cluster == null) {
            SilhouetteScore.$$$reportNull$$$0(1);
        }
        if (similarUsage == null) {
            SilhouetteScore.$$$reportNull$$$0(2);
        }
        Ref cohesionIndex = new Ref((Object)0.0);
        cluster.getUsages().forEach(usage -> cohesionIndex.set((Object)((Double)cohesionIndex.get() + Distance.jaccardDistanceExact(usage.getFeatures(), similarUsage.getFeatures()))));
        return (Double)cohesionIndex.get() / (double)(cluster.getUsages().size() - 1);
    }

    private double getSeparationIndex(@NotNull UsageCluster currentCluster, @NotNull SimilarUsage similarUsage) {
        if (currentCluster == null) {
            SilhouetteScore.$$$reportNull$$$0(3);
        }
        if (similarUsage == null) {
            SilhouetteScore.$$$reportNull$$$0(4);
        }
        HashMap<UsageCluster, Double> separationIndexPerCluster = new HashMap<UsageCluster, Double>();
        this.myClusteringSearchSession.getClusters().forEach(cluster -> {
            if (!cluster.getUsages().contains(similarUsage)) {
                cluster.getUsages().forEach(usage -> {
                    double similarity = Distance.jaccardDistanceExact(usage.getFeatures(), similarUsage.getFeatures());
                    separationIndexPerCluster.merge((UsageCluster)cluster, similarity, (oldValue, newValue) -> oldValue + similarity);
                });
                separationIndexPerCluster.put((UsageCluster)cluster, (Double)separationIndexPerCluster.get(cluster) / (double)cluster.getUsages().size());
            }
        });
        separationIndexPerCluster.put(currentCluster, 1.0);
        UsageCluster closestCluster = (UsageCluster)separationIndexPerCluster.entrySet().stream().min(Map.Entry.comparingByValue()).orElseThrow().getKey();
        return (Double)separationIndexPerCluster.get(closestCluster);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clusteringSearchSession";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cluster";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "similarUsage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCluster";
                break;
            }
        }
        objectArray2[1] = "com/intellij/find/findUsages/similarity/SilhouetteScore";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCohesionIndex";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSeparationIndex";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

