/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.markup.AttributesFlyweight;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageTreeColorsScheme;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class TextChunk {
    public static final TextChunk[] EMPTY_ARRAY = new TextChunk[0];
    private final AttributesFlyweight myAttributes;
    private final String myText;

    public TextChunk(@NotNull TextAttributes attributes, @NotNull String text) {
        if (attributes == null) {
            TextChunk.$$$reportNull$$$0(0);
        }
        if (text == null) {
            TextChunk.$$$reportNull$$$0(1);
        }
        this(attributes.getFlyweight(), text);
    }

    private TextChunk(@NotNull AttributesFlyweight attributes, @NotNull String text) {
        if (attributes == null) {
            TextChunk.$$$reportNull$$$0(2);
        }
        if (text == null) {
            TextChunk.$$$reportNull$$$0(3);
        }
        this.myAttributes = attributes;
        this.myText = text;
    }

    @NotNull
    public TextAttributes getAttributes() {
        TextAttributes textAttributes = TextAttributes.fromFlyweight((AttributesFlyweight)this.myAttributes);
        if (textAttributes == null) {
            TextChunk.$$$reportNull$$$0(4);
        }
        return textAttributes;
    }

    @NotNull
    @NlsSafe
    public String getText() {
        String string = this.myText;
        if (string == null) {
            TextChunk.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String toString() {
        return this.getText();
    }

    @Deprecated
    @Nullable
    public UsageType getType() {
        return null;
    }

    @NotNull
    public SimpleTextAttributes getSimpleAttributesIgnoreBackground() {
        SimpleTextAttributes simples = SimpleTextAttributes.fromTextAttributes((TextAttributes)this.getAttributes());
        SimpleTextAttributes simpleTextAttributes = simples = new SimpleTextAttributes(null, simples.getFgColor(), simples.getWaveColor(), simples.getStyle());
        if (simpleTextAttributes == null) {
            TextChunk.$$$reportNull$$$0(6);
        }
        return simpleTextAttributes;
    }

    private static TextAttributes defaultAttributes() {
        return UsageTreeColorsScheme.getInstance().getScheme().getAttributes(HighlighterColors.TEXT);
    }

    @NotNull
    static Object compact(@NotNull @NotNull TextChunk @NotNull [] chunks) {
        if (chunks == null) {
            TextChunk.$$$reportNull$$$0(7);
        }
        return TextChunk.replaceDefaultAttributeChunksWithStrings(TextChunk.compactSequentialChunksWithSameAttributes(chunks));
    }

    @NotNull
    private static @NotNull List<@NotNull TextChunk> compactSequentialChunksWithSameAttributes(@NotNull @NotNull TextChunk @NotNull [] chunks) {
        if (chunks == null) {
            TextChunk.$$$reportNull$$$0(8);
        }
        if (chunks.length == 0) {
            List<TextChunk> list = Collections.emptyList();
            if (list == null) {
                TextChunk.$$$reportNull$$$0(9);
            }
            return list;
        }
        ArrayList<TextChunk> result = new ArrayList<TextChunk>(chunks.length);
        StringBuilder currentText = new StringBuilder();
        AttributesFlyweight currentAttributes = null;
        for (TextChunk chunk : chunks) {
            if (currentAttributes == null) {
                currentAttributes = chunk.myAttributes;
                currentText.append(chunk.myText);
                continue;
            }
            if (currentAttributes.equals((Object)chunk.myAttributes)) {
                currentText.append(chunk.myText);
                continue;
            }
            result.add(new TextChunk(currentAttributes, currentText.toString()));
            currentAttributes = chunk.myAttributes;
            currentText.setLength(0);
            currentText.append(chunk.myText);
        }
        result.add(new TextChunk(currentAttributes, currentText.toString()));
        ArrayList<TextChunk> arrayList = result;
        if (arrayList == null) {
            TextChunk.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    private static Object replaceDefaultAttributeChunksWithStrings(@NotNull @NotNull @Unmodifiable List<@NotNull TextChunk> chunks) {
        AttributesFlyweight defaultFlyweight;
        if (chunks == null) {
            TextChunk.$$$reportNull$$$0(11);
        }
        if (ContainerUtil.and(chunks, arg_0 -> TextChunk.lambda$replaceDefaultAttributeChunksWithStrings$0(defaultFlyweight = TextChunk.defaultAttributes().getFlyweight(), arg_0))) {
            TextChunk[] textChunkArray = chunks.size() == 1 ? chunks.get(0) : chunks.toArray(EMPTY_ARRAY);
            if (textChunkArray == null) {
                TextChunk.$$$reportNull$$$0(12);
            }
            return textChunkArray;
        }
        List result = ContainerUtil.map(chunks, chunk -> chunk.myAttributes.equals((Object)defaultFlyweight) ? chunk.myText : chunk);
        Object object = result.size() == 1 ? result.get(0) : ArrayUtil.toObjectArray((Collection)result);
        if (object == null) {
            TextChunk.$$$reportNull$$$0(13);
        }
        return object;
    }

    @NotNull
    static @NotNull TextChunk @NotNull [] inflate(@NotNull Object compact) {
        if (compact == null) {
            TextChunk.$$$reportNull$$$0(14);
        }
        if (compact instanceof TextChunk) {
            TextChunk[] textChunkArray = new TextChunk[]{(TextChunk)compact};
            if (textChunkArray == null) {
                TextChunk.$$$reportNull$$$0(15);
            }
            return textChunkArray;
        }
        if (compact instanceof TextChunk[]) {
            TextChunk[] textChunkArray = (TextChunk[])compact;
            if (textChunkArray == null) {
                TextChunk.$$$reportNull$$$0(16);
            }
            return textChunkArray;
        }
        TextAttributes defaultAttributes = TextChunk.defaultAttributes();
        if (compact instanceof String) {
            TextChunk[] textChunkArray = new TextChunk[]{new TextChunk(defaultAttributes, (String)compact)};
            if (textChunkArray == null) {
                TextChunk.$$$reportNull$$$0(17);
            }
            return textChunkArray;
        }
        TextChunk[] textChunkArray = ContainerUtil.map((Object[])((Object[])compact), stringOrChunk -> stringOrChunk instanceof String ? new TextChunk(defaultAttributes, (String)stringOrChunk) : (TextChunk)stringOrChunk).toArray(EMPTY_ARRAY);
        if (textChunkArray == null) {
            TextChunk.$$$reportNull$$$0(18);
        }
        return textChunkArray;
    }

    private static /* synthetic */ boolean lambda$replaceDefaultAttributeChunksWithStrings$0(AttributesFlyweight defaultFlyweight, TextChunk chunk) {
        return !chunk.myAttributes.equals((Object)defaultFlyweight);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 9, 10, 12, 13, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/TextChunk";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/TextChunk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleAttributesIgnoreBackground";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "compactSequentialChunksWithSameAttributes";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceDefaultAttributeChunksWithStrings";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "inflate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compact";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "compactSequentialChunksWithSameAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "replaceDefaultAttributeChunksWithStrings";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "inflate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 9, 10, 12, 13, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

