/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.similarity.features;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.similarity.bag.Bag;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageSimilarityFeaturesRecorder {
    @NotNull
    private final Bag myFeatures;
    @Nullable
    private final PsiElement myInitialContext;
    @NotNull
    private final PsiElement myUsage;

    public UsageSimilarityFeaturesRecorder(@Nullable PsiElement initialContext, @NotNull PsiElement usage) {
        if (usage == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(0);
        }
        this.myUsage = usage;
        this.myFeatures = new Bag();
        this.myInitialContext = initialContext;
    }

    private boolean isInSameTreeAsUsage(@NotNull PsiElement expression) {
        if (expression == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(1);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)expression, (boolean)false, element -> element == this.myUsage || element == this.myInitialContext) == this.myUsage || PsiTreeUtil.findFirstParent((PsiElement)this.myUsage, (boolean)false, element -> element == expression || element == this.myInitialContext) == expression;
    }

    @NotNull
    public Bag getFeatures() {
        Bag bag = this.myFeatures;
        if (bag == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(2);
        }
        return bag;
    }

    public void addFeature(@NotNull String tokenFeature) {
        if (tokenFeature == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(3);
        }
        this.myFeatures.add(tokenFeature);
    }

    public void addAllFeatures(@NotNull PsiElement element, @Nullable String tokenFeature) {
        if (element == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(4);
        }
        if (tokenFeature == null) {
            tokenFeature = PsiUtilCore.getElementType((PsiElement)element).toString();
        }
        if (Registry.is((String)"similarity.distinguish.usages.in.one.statement")) {
            tokenFeature = (this.isInSameTreeAsUsage(element) ? "USAGE: " : "CONTEXT: ") + (String)tokenFeature;
        }
        this.myFeatures.add((String)tokenFeature);
        if (element == this.myInitialContext) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent != this.myInitialContext) {
            this.addParentFeatures(parent, (String)tokenFeature, "GP:");
        }
        this.addParentFeatures(element, (String)tokenFeature, "P:");
        this.addSiblingFeatures(element, (String)tokenFeature);
    }

    private void addParentFeatures(@NotNull PsiElement element, @Nullable String tokenFeature, @NotNull String prefix) {
        if (element == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(6);
        }
        if (!Registry.is((String)"similarity.find.usages.use.parent.features")) {
            return;
        }
        PsiElement parent = element.getParent();
        if (parent != null) {
            this.myFeatures.add(tokenFeature + " " + prefix + " " + String.valueOf(PsiUtilCore.getElementType((PsiElement)parent)) + " " + UsageSimilarityFeaturesRecorder.getChildNumber(parent, element));
        }
    }

    private void addSiblingFeatures(@NotNull PsiElement element, @Nullable String tokenFeature) {
        if (element == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(7);
        }
        if (!Registry.is((String)"similarity.find.usages.use.sibling.features")) {
            return;
        }
        this.myFeatures.add(tokenFeature + " PREV: " + String.valueOf(UsageSimilarityFeaturesRecorder.getPrevMeaningfulSibling(element)));
        this.myFeatures.add(tokenFeature + " NEXT: " + String.valueOf(UsageSimilarityFeaturesRecorder.getNextMeaningfulSibling(element)));
    }

    private static int getChildNumber(@NotNull PsiElement parent, @NotNull PsiElement child) {
        if (parent == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(8);
        }
        if (child == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(9);
        }
        if (!Registry.is((String)"similarity.find.usages.use.parent.features.with.child.number")) {
            return -1;
        }
        PsiElement[] children = (PsiElement[])Arrays.stream(parent.getChildren()).filter(e -> !(e instanceof PsiWhiteSpace)).toArray(PsiElement[]::new);
        for (int i = 0; i < children.length; ++i) {
            if (children[i] != child) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private static PsiElement getNextMeaningfulSibling(@NotNull PsiElement element) {
        PsiElement nextSibling;
        if (element == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(10);
        }
        if ((nextSibling = element.getNextSibling()) != null) {
            while (nextSibling instanceof PsiWhiteSpace || nextSibling instanceof PsiComment) {
                nextSibling = nextSibling.getNextSibling();
            }
        }
        return nextSibling;
    }

    @Nullable
    private static PsiElement getPrevMeaningfulSibling(@NotNull PsiElement element) {
        PsiElement prevSibling;
        if (element == null) {
            UsageSimilarityFeaturesRecorder.$$$reportNull$$$0(11);
        }
        if ((prevSibling = element.getPrevSibling()) != null) {
            while (prevSibling instanceof PsiWhiteSpace || prevSibling instanceof PsiComment) {
                prevSibling = prevSibling.getPrevSibling();
            }
        }
        return prevSibling;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/similarity/features/UsageSimilarityFeaturesRecorder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenFeature";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/similarity/features/UsageSimilarityFeaturesRecorder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInSameTreeAsUsage";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFeature";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addAllFeatures";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addParentFeatures";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addSiblingFeatures";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildNumber";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNextMeaningfulSibling";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPrevMeaningfulSibling";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

