/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByLineRt;
import com.intellij.diff.comparison.ByWordRt;
import com.intellij.diff.comparison.CancellationChecker;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.TrimUtil;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.comparison.iterables.FairDiffIterable;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u001f B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0014\u001a\u00020\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0002J0\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u0013H$R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/diff/comparison/ChunkOptimizer;", "T", "", "myData1", "", "myData2", "myIterable", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "myIndicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "getMyData1", "()Ljava/util/List;", "getMyData2", "getMyIndicator", "()Lcom/intellij/diff/comparison/CancellationChecker;", "myRanges", "", "Lcom/intellij/diff/util/Range;", "build", "processLastRanges", "", "getShift", "", "touchSide", "Lcom/intellij/diff/util/Side;", "equalForward", "equalBackward", "range1", "range2", "WordChunkOptimizer", "LineChunkOptimizer", "intellij.platform.util.diff"})
public abstract class ChunkOptimizer<T> {
    @NotNull
    private final List<T> myData1;
    @NotNull
    private final List<T> myData2;
    @NotNull
    private final FairDiffIterable myIterable;
    @NotNull
    private final CancellationChecker myIndicator;
    @NotNull
    private final List<Range> myRanges;

    public ChunkOptimizer(@NotNull List<? extends T> myData1, @NotNull List<? extends T> myData2, @NotNull FairDiffIterable myIterable, @NotNull CancellationChecker myIndicator) {
        Intrinsics.checkNotNullParameter(myData1, (String)"myData1");
        Intrinsics.checkNotNullParameter(myData2, (String)"myData2");
        Intrinsics.checkNotNullParameter((Object)myIterable, (String)"myIterable");
        Intrinsics.checkNotNullParameter((Object)myIndicator, (String)"myIndicator");
        this.myData1 = myData1;
        this.myData2 = myData2;
        this.myIterable = myIterable;
        this.myIndicator = myIndicator;
        this.myRanges = new ArrayList();
    }

    @NotNull
    protected final List<T> getMyData1() {
        return this.myData1;
    }

    @NotNull
    protected final List<T> getMyData2() {
        return this.myData2;
    }

    @NotNull
    protected final CancellationChecker getMyIndicator() {
        return this.myIndicator;
    }

    @NotNull
    public final FairDiffIterable build() {
        for (Range range : this.myIterable.iterateUnchanged()) {
            this.myRanges.add(range);
            this.processLastRanges();
        }
        return DiffIterableUtil.fair(DiffIterableUtil.createUnchanged(this.myRanges, this.myData1.size(), this.myData2.size()));
    }

    private final void processLastRanges() {
        if (this.myRanges.size() < 2) {
            return;
        }
        Range range1 = this.myRanges.get(this.myRanges.size() - 2);
        Range range2 = this.myRanges.get(this.myRanges.size() - 1);
        if (range1.end1 != range2.start1 && range1.end2 != range2.start2) {
            return;
        }
        int count1 = range1.end1 - range1.start1;
        int count2 = range2.end1 - range2.start1;
        int equalForward = TrimUtil.expandForward(this.myData1, this.myData2, range1.end1, range1.end2, range1.end1 + count2, range1.end2 + count2);
        int equalBackward = TrimUtil.expandBackward(this.myData1, this.myData2, range2.start1 - count1, range2.start2 - count1, range2.start1, range2.start2);
        if (equalForward == 0 && equalBackward == 0) {
            return;
        }
        if (equalForward == count2) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + count2, range1.start2, range1.end2 + count2));
            this.processLastRanges();
            return;
        }
        if (equalBackward == count1) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range2.start1 - count1, range2.end1, range2.start2 - count1, range2.end2));
            this.processLastRanges();
            return;
        }
        Side touchSide = Side.Companion.fromLeft(range1.end1 == range2.start1);
        int shift = this.getShift(touchSide, equalForward, equalBackward, range1, range2);
        if (shift != 0) {
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.remove(this.myRanges.size() - 1);
            this.myRanges.add(new Range(range1.start1, range1.end1 + shift, range1.start2, range1.end2 + shift));
            this.myRanges.add(new Range(range2.start1 + shift, range2.end1, range2.start2 + shift, range2.end2));
        }
    }

    protected abstract int getShift(@NotNull Side var1, int var2, int var3, @NotNull Range var4, @NotNull Range var5);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ0\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J?\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0017J?\u0010\u0018\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer;", "Lcom/intellij/diff/comparison/ChunkOptimizer;", "Lcom/intellij/diff/comparison/ByLineRt$Line;", "lines1", "", "lines2", "changes", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "getShift", "", "touchSide", "Lcom/intellij/diff/util/Side;", "equalForward", "equalBackward", "range1", "Lcom/intellij/diff/util/Range;", "range2", "getUnchangedBoundaryShift", "threshold", "(Lcom/intellij/diff/util/Side;IILcom/intellij/diff/util/Range;Lcom/intellij/diff/util/Range;I)Ljava/lang/Integer;", "getChangedBoundaryShift", "Companion", "intellij.platform.util.diff"})
    public static final class LineChunkOptimizer
    extends ChunkOptimizer<ByLineRt.Line> {
        @NotNull
        public static final Companion Companion = new Companion(null);

        public LineChunkOptimizer(@NotNull List<ByLineRt.Line> lines1, @NotNull List<ByLineRt.Line> lines2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter(lines1, (String)"lines1");
            Intrinsics.checkNotNullParameter(lines2, (String)"lines2");
            Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            super(lines1, lines2, changes, indicator);
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            Intrinsics.checkNotNullParameter((Object)((Object)touchSide), (String)"touchSide");
            Intrinsics.checkNotNullParameter((Object)range1, (String)"range1");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range2");
            Integer shift = null;
            int threshold = ComparisonUtil.getUnimportantLineCharCount();
            shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, 0);
            if (shift != null) {
                return shift;
            }
            shift = this.getUnchangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, threshold);
            if (shift != null) {
                return shift;
            }
            shift = this.getChangedBoundaryShift(touchSide, equalForward, equalBackward, range1, range2, threshold);
            if (shift != null) {
                return shift;
            }
            return 0;
        }

        private final Integer getUnchangedBoundaryShift(Side touchSide, int equalForward, int equalBackward, Range range1, Range range2, int threshold) {
            List touchLines = touchSide.selectNotNull(this.getMyData1(), this.getMyData2());
            int touchStart = touchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.Companion.findNextUnimportantLine(touchLines, touchStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.Companion.findPrevUnimportantLine(touchLines, touchStart - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.Companion.getShift(shiftForward, shiftBackward);
        }

        private final Integer getChangedBoundaryShift(Side touchSide, int equalForward, int equalBackward, Range range1, Range range2, int threshold) {
            Side nonTouchSide = touchSide.other();
            List nonTouchLines = nonTouchSide.selectNotNull(this.getMyData1(), this.getMyData2());
            int changeStart = nonTouchSide.select(range1.end1, range1.end2);
            int changeEnd = nonTouchSide.select(range2.start1, range2.start2);
            int shiftForward = LineChunkOptimizer.Companion.findNextUnimportantLine(nonTouchLines, changeStart, equalForward + 1, threshold);
            int shiftBackward = LineChunkOptimizer.Companion.findPrevUnimportantLine(nonTouchLines, changeEnd - 1, equalBackward + 1, threshold);
            return LineChunkOptimizer.Companion.getShift(shiftForward, shiftBackward);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J.\u0010\f\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001f\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/comparison/ChunkOptimizer$LineChunkOptimizer$Companion;", "", "<init>", "()V", "findNextUnimportantLine", "", "lines", "", "Lcom/intellij/diff/comparison/ByLineRt$Line;", "offset", "count", "threshold", "findPrevUnimportantLine", "getShift", "shiftForward", "shiftBackward", "(II)Ljava/lang/Integer;", "intellij.platform.util.diff"})
        public static final class Companion {
            private Companion() {
            }

            private final int findNextUnimportantLine(List<ByLineRt.Line> lines, int offset, int count, int threshold) {
                for (int i = 0; i < count; ++i) {
                    if (lines.get(offset + i).getNonSpaceChars() > threshold) continue;
                    return i;
                }
                return -1;
            }

            private final int findPrevUnimportantLine(List<ByLineRt.Line> lines, int offset, int count, int threshold) {
                for (int i = 0; i < count; ++i) {
                    if (lines.get(offset - i).getNonSpaceChars() > threshold) continue;
                    return i;
                }
                return -1;
            }

            private final Integer getShift(int shiftForward, int shiftBackward) {
                if (shiftForward == -1 && shiftBackward == -1) {
                    return null;
                }
                if (shiftForward == 0 || shiftBackward == 0) {
                    return 0;
                }
                return shiftForward != -1 ? Integer.valueOf(shiftForward) : Integer.valueOf(-shiftBackward);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018BC\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer;", "Lcom/intellij/diff/comparison/ChunkOptimizer;", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "words1", "", "words2", "myText1", "", "myText2", "changes", "Lcom/intellij/diff/comparison/iterables/FairDiffIterable;", "indicator", "Lcom/intellij/diff/comparison/CancellationChecker;", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/lang/CharSequence;Ljava/lang/CharSequence;Lcom/intellij/diff/comparison/iterables/FairDiffIterable;Lcom/intellij/diff/comparison/CancellationChecker;)V", "getShift", "", "touchSide", "Lcom/intellij/diff/util/Side;", "equalForward", "equalBackward", "range1", "Lcom/intellij/diff/util/Range;", "range2", "Companion", "intellij.platform.util.diff"})
    public static final class WordChunkOptimizer
    extends ChunkOptimizer<ByWordRt.InlineChunk> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final CharSequence myText1;
        @NotNull
        private final CharSequence myText2;

        public WordChunkOptimizer(@NotNull List<? extends ByWordRt.InlineChunk> words1, @NotNull List<? extends ByWordRt.InlineChunk> words2, @NotNull CharSequence myText1, @NotNull CharSequence myText2, @NotNull FairDiffIterable changes, @NotNull CancellationChecker indicator) {
            Intrinsics.checkNotNullParameter(words1, (String)"words1");
            Intrinsics.checkNotNullParameter(words2, (String)"words2");
            Intrinsics.checkNotNullParameter((Object)myText1, (String)"myText1");
            Intrinsics.checkNotNullParameter((Object)myText2, (String)"myText2");
            Intrinsics.checkNotNullParameter((Object)changes, (String)"changes");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            super(words1, words2, changes, indicator);
            this.myText1 = myText1;
            this.myText2 = myText2;
        }

        @Override
        protected int getShift(@NotNull Side touchSide, int equalForward, int equalBackward, @NotNull Range range1, @NotNull Range range2) {
            Intrinsics.checkNotNullParameter((Object)((Object)touchSide), (String)"touchSide");
            Intrinsics.checkNotNullParameter((Object)range1, (String)"range1");
            Intrinsics.checkNotNullParameter((Object)range2, (String)"range2");
            List touchWords = touchSide.selectNotNull(this.getMyData1(), this.getMyData2());
            CharSequence charSequence = touchSide.select(this.myText1, this.myText2);
            Intrinsics.checkNotNull((Object)charSequence);
            CharSequence touchText = charSequence;
            int touchStart = touchSide.select(range2.start1, range2.start2);
            if (WordChunkOptimizer.Companion.isSeparatedWithWhitespace(touchText, (ByWordRt.InlineChunk)touchWords.get(touchStart - 1), (ByWordRt.InlineChunk)touchWords.get(touchStart))) {
                return 0;
            }
            int leftShift = WordChunkOptimizer.Companion.findSequenceEdgeShift(touchText, touchWords, touchStart, equalForward, true);
            if (leftShift > 0) {
                return leftShift;
            }
            int rightShift = WordChunkOptimizer.Companion.findSequenceEdgeShift(touchText, touchWords, touchStart - 1, equalBackward, false);
            if (rightShift > 0) {
                return -rightShift;
            }
            return 0;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/diff/comparison/ChunkOptimizer$WordChunkOptimizer$Companion;", "", "<init>", "()V", "findSequenceEdgeShift", "", "text", "", "words", "", "Lcom/intellij/diff/comparison/ByWordRt$InlineChunk;", "offset", "count", "leftToRight", "", "isSeparatedWithWhitespace", "word1", "word2", "intellij.platform.util.diff"})
        public static final class Companion {
            private Companion() {
            }

            private final int findSequenceEdgeShift(CharSequence text, List<? extends ByWordRt.InlineChunk> words, int offset, int count, boolean leftToRight) {
                for (int i = 0; i < count; ++i) {
                    ByWordRt.InlineChunk word1 = null;
                    ByWordRt.InlineChunk word2 = null;
                    if (leftToRight) {
                        word1 = words.get(offset + i);
                        word2 = words.get(offset + i + 1);
                    } else {
                        word1 = words.get(offset - i - 1);
                        word2 = words.get(offset - i);
                    }
                    if (!this.isSeparatedWithWhitespace(text, word1, word2)) continue;
                    return i + 1;
                }
                return -1;
            }

            private final boolean isSeparatedWithWhitespace(CharSequence text, ByWordRt.InlineChunk word1, ByWordRt.InlineChunk word2) {
                if (word1 instanceof ByWordRt.NewlineChunk || word2 instanceof ByWordRt.NewlineChunk) {
                    return true;
                }
                int offset1 = word1.getOffset2();
                int offset2 = word2.getOffset1();
                for (int i = offset1; i < offset2; ++i) {
                    if (!TrimUtil.isSpaceEnterOrTab(text.charAt(i))) continue;
                    return true;
                }
                return false;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

