/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.io.URLUtil;
import com.intellij.util.lang.UrlClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResourceUtil {
    private ResourceUtil() {
    }

    public static byte @Nullable [] getResourceAsBytes(@NotNull String path, @NotNull ClassLoader classLoader) throws IOException {
        if (path == null) {
            ResourceUtil.$$$reportNull$$$0(0);
        }
        if (classLoader == null) {
            ResourceUtil.$$$reportNull$$$0(1);
        }
        return ResourceUtil.getResourceAsBytes(path, classLoader, false);
    }

    public static byte @Nullable [] getResourceAsBytes(@NotNull String path, @NotNull ClassLoader classLoader, boolean checkParents) throws IOException {
        if (path == null) {
            ResourceUtil.$$$reportNull$$$0(2);
        }
        if (classLoader == null) {
            ResourceUtil.$$$reportNull$$$0(3);
        }
        if (classLoader instanceof UrlClassLoader) {
            return ((UrlClassLoader)classLoader).getResourceAsBytes(path, checkParents);
        }
        InputStream stream = classLoader.getResourceAsStream(path);
        if (stream == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            byte[] byArray = stream.readAllBytes();
            return byArray;
        }
    }

    public static byte @Nullable [] getResourceAsBytesSafely(@NotNull String path, @NotNull ClassLoader classLoader) {
        if (path == null) {
            ResourceUtil.$$$reportNull$$$0(4);
        }
        if (classLoader == null) {
            ResourceUtil.$$$reportNull$$$0(5);
        }
        try {
            return ResourceUtil.getResourceAsBytes(path, classLoader);
        }
        catch (IOException e) {
            Logger.getInstance(ResourceUtil.class).info("Failed to load resource as bytes: " + path, (Throwable)e);
            return null;
        }
    }

    @Deprecated(forRemoval=true)
    public static URL getResource(@NotNull Class<?> loaderClass, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loaderClass == null) {
            ResourceUtil.$$$reportNull$$$0(6);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(7);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(8);
        }
        return ResourceUtil.getResource(loaderClass.getClassLoader(), basePath, fileName);
    }

    public static InputStream getResourceAsStream(@NotNull ClassLoader loader, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        String fixedPath;
        if (loader == null) {
            ResourceUtil.$$$reportNull$$$0(9);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(10);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(11);
        }
        if ((fixedPath = Strings.trimStart((String)Strings.trimEnd((String)basePath, (String)"/"), (String)"/")).isEmpty()) {
            return loader.getResourceAsStream(fileName);
        }
        List<String> bundles = ResourceUtil.calculateBundleNames(fixedPath, Locale.getDefault());
        for (String bundle : bundles) {
            InputStream stream = loader.getResourceAsStream(bundle + "/" + fileName);
            if (stream == null) continue;
            return stream;
        }
        return loader.getResourceAsStream(fixedPath + "/" + fileName);
    }

    public static URL getResource(@NotNull ClassLoader loader, @NonNls @NotNull String basePath, @NonNls @NotNull String fileName) {
        if (loader == null) {
            ResourceUtil.$$$reportNull$$$0(12);
        }
        if (basePath == null) {
            ResourceUtil.$$$reportNull$$$0(13);
        }
        if (fileName == null) {
            ResourceUtil.$$$reportNull$$$0(14);
        }
        String fixedPath = Strings.trimStart((String)Strings.trimEnd((String)basePath, (String)"/"), (String)"/");
        List<String> bundles = ResourceUtil.calculateBundleNames(fixedPath, Locale.getDefault());
        for (String bundle : bundles) {
            URL url = loader.getResource(bundle + "/" + fileName);
            if (url == null) continue;
            try {
                url.openConnection();
            }
            catch (IOException e) {
                continue;
            }
            return url;
        }
        return loader.getResource(fixedPath + "/" + fileName);
    }

    @NotNull
    private static List<String> calculateBundleNames(@NotNull String baseName, @NotNull Locale locale) {
        if (baseName == null) {
            ResourceUtil.$$$reportNull$$$0(15);
        }
        if (locale == null) {
            ResourceUtil.$$$reportNull$$$0(16);
        }
        ArrayList<String> result = new ArrayList<String>(3);
        result.add(0, baseName);
        String language = locale.getLanguage();
        int languageLength = language.length();
        String country = locale.getCountry();
        int countryLength = country.length();
        String variant = locale.getVariant();
        int variantLength = variant.length();
        if (languageLength + countryLength + variantLength == 0) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        StringBuilder temp = new StringBuilder(baseName);
        temp.append('_');
        temp.append(language);
        if (languageLength > 0) {
            result.add(0, temp.toString());
        }
        if (countryLength + variantLength == 0) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(18);
            }
            return arrayList;
        }
        temp.append('_');
        temp.append(country);
        if (countryLength > 0) {
            result.add(0, temp.toString());
        }
        if (variantLength == 0) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                ResourceUtil.$$$reportNull$$$0(19);
            }
            return arrayList;
        }
        temp.append('_');
        temp.append(variant);
        result.add(0, temp.toString());
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            ResourceUtil.$$$reportNull$$$0(20);
        }
        return arrayList;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static String loadText(@NotNull URL url) throws IOException {
        if (url == null) {
            ResourceUtil.$$$reportNull$$$0(21);
        }
        return ResourceUtil.loadText(URLUtil.openStream((URL)url));
    }

    @NotNull
    public static String loadText(@NotNull InputStream in) throws IOException {
        if (in == null) {
            ResourceUtil.$$$reportNull$$$0(22);
        }
        InputStream inputStream = in;
        String string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
        String string2 = string;
        if (string2 == null) {
            ResourceUtil.$$$reportNull$$$0(23);
        }
        return string2;
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loaderClass";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ResourceUtil";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ResourceUtil";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateBundleNames";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsBytesSafely";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResource";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getResourceAsStream";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateBundleNames";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19, 20, 23 -> new IllegalStateException(string);
        };
    }
}

