/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.Lz4Kt;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.util.SafeUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/io/LZ4Compressor;", "Lnet/jpountz/lz4/LZ4Compressor;", "<init>", "()V", "compress", "", "src", "", "srcOff", "srcLen", "dest", "destOff", "maxDestLen", "Ljava/nio/ByteBuffer;", "intellij.platform.util.ex"})
@ApiStatus.Internal
public final class LZ4Compressor
extends net.jpountz.lz4.LZ4Compressor {
    @NotNull
    public static final LZ4Compressor INSTANCE = new LZ4Compressor();

    private LZ4Compressor() {
    }

    public int compress(@NotNull byte[] src, int srcOff, int srcLen, @NotNull byte[] dest, int destOff, int maxDestLen) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SafeUtils.checkRange((byte[])src, (int)srcOff, (int)srcLen);
        SafeUtils.checkRange((byte[])dest, (int)destOff, (int)maxDestLen);
        int destEnd = destOff + maxDestLen;
        if (srcLen < 65547) {
            return Lz4Kt.access$compress64k(src, srcOff, srcLen, dest, destOff, destEnd);
        }
        int srcEnd = srcOff + srcLen;
        int srcLimit = srcEnd - 5;
        int mflimit = srcEnd - 12;
        int dOff = destOff;
        int sOff = srcOff + 1;
        int anchor = srcOff;
        int[] hashTable = (int[])Lz4Kt.access$getBiggerHashTable$p().get();
        Arrays.fill(hashTable, srcOff);
        block0: while (true) {
            int excess;
            int ref;
            int back;
            int forwardOff = sOff;
            int step = 1;
            int var18 = 1 << Lz4Kt.access$getSKIP_STRENGTH$p();
            do {
                sOff = forwardOff;
                if ((forwardOff += (step = var18++ >>> Lz4Kt.access$getSKIP_STRENGTH$p())) > mflimit) break block0;
                excess = Lz4Kt.access$hash(SafeUtils.readInt((byte[])src, (int)sOff));
                ref = SafeUtils.readInt((int[])hashTable, (int)excess);
                back = sOff - ref;
                SafeUtils.writeInt((int[])hashTable, (int)excess, (int)sOff);
            } while (back >= 65536 || !Lz4Kt.access$readIntEquals(src, ref, sOff));
            excess = Lz4Kt.access$commonBytesBackward(src, ref, sOff, srcOff, anchor);
            ref -= excess;
            int runLen = (sOff -= excess) - anchor;
            int tokenOff = dOff++;
            if (dOff + runLen + 8 + (runLen >>> 8) > destEnd) {
                throw new LZ4Exception("maxDestLen is too small");
            }
            if (runLen >= 15) {
                SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)240);
                dOff = Lz4Kt.access$writeLen(runLen - 15, dest, dOff);
            } else {
                SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)(runLen << 4));
            }
            Lz4Kt.access$wildArraycopy(src, anchor, dest, dOff, runLen);
            dOff += runLen;
            while (true) {
                SafeUtils.writeShortLE((byte[])dest, (int)dOff, (int)back);
                int matchLen = Lz4Kt.access$commonBytes(src, ref + 4, sOff += 4, srcLimit);
                if ((dOff += 2) + 6 + (matchLen >>> 8) > destEnd) {
                    throw new LZ4Exception("maxDestLen is too small");
                }
                sOff += matchLen;
                if (matchLen >= 15) {
                    SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)(dest[tokenOff] | 0xF));
                    dOff = Lz4Kt.access$writeLen(matchLen - 15, dest, dOff);
                } else {
                    SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)(dest[tokenOff] | matchLen));
                }
                if (sOff > mflimit) {
                    anchor = sOff;
                    break block0;
                }
                SafeUtils.writeInt((int[])hashTable, (int)Lz4Kt.access$hash(SafeUtils.readInt((byte[])src, (int)(sOff - 2))), (int)(sOff - 2));
                int h = Lz4Kt.access$hash(SafeUtils.readInt((byte[])src, (int)sOff));
                ref = SafeUtils.readInt((int[])hashTable, (int)h);
                SafeUtils.writeInt((int[])hashTable, (int)h, (int)sOff);
                back = sOff - ref;
                if (back >= 65536 || !Lz4Kt.access$readIntEquals(src, ref, sOff)) {
                    anchor = sOff++;
                    continue block0;
                }
                tokenOff = dOff++;
                SafeUtils.writeByte((byte[])dest, (int)tokenOff, (int)0);
            }
            break;
        }
        dOff = Lz4Kt.access$lastLiterals(src, anchor, srcEnd - anchor, dest, dOff, destEnd);
        return dOff - destOff;
    }

    public int compress(@NotNull ByteBuffer src, int srcOff, int srcLen, @NotNull ByteBuffer dest, int destOff, int maxDestLen) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!src.hasArray() || !dest.hasArray()) {
            throw new AssertionError((Object)"Do not support compression on direct buffers");
        }
        byte[] byArray = src.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
        int n = srcOff + src.arrayOffset();
        byte[] byArray2 = dest.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
        return this.compress(byArray, n, srcLen, byArray2, destOff + dest.arrayOffset(), maxDestLen);
    }
}

