/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.mvstore;

import com.intellij.openapi.diagnostic.Logger;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/io/mvstore/StoreErrorHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "dbFile", "Ljava/nio/file/Path;", "logSupplier", "Lkotlin/Function0;", "Lcom/intellij/openapi/diagnostic/Logger;", "<init>", "(Ljava/nio/file/Path;Lkotlin/jvm/functions/Function0;)V", "isStoreOpened", "", "uncaughtException", "", "t", "Ljava/lang/Thread;", "e", "", "intellij.platform.util.ex"})
final class StoreErrorHandler
implements Thread.UncaughtExceptionHandler {
    @Nullable
    private final Path dbFile;
    @NotNull
    private final Function0<Logger> logSupplier;
    @JvmField
    public boolean isStoreOpened;

    public StoreErrorHandler(@Nullable Path dbFile, @NotNull Function0<? extends Logger> logSupplier) {
        Intrinsics.checkNotNullParameter(logSupplier, (String)"logSupplier");
        this.dbFile = dbFile;
        this.logSupplier = logSupplier;
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Logger log = (Logger)this.logSupplier.invoke();
        if (this.isStoreOpened) {
            log.error("Store error (db=" + this.dbFile + ")", e);
        } else {
            log.warn("Store will be recreated (db=" + this.dbFile + ")", e);
        }
    }
}

