/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.Lz4Kt;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.jpountz.util.SafeUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/util/io/LZ4Decompressor;", "Lnet/jpountz/lz4/LZ4FastDecompressor;", "<init>", "()V", "decompress", "", "src", "", "srcOff", "dest", "destOff", "destLen", "Ljava/nio/ByteBuffer;", "intellij.platform.util.ex"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nlz4.kt\nKotlin\n*S Kotlin\n*F\n+ 1 lz4.kt\ncom/intellij/util/io/LZ4Decompressor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,476:1\n1#2:477\n*E\n"})
public final class LZ4Decompressor
extends LZ4FastDecompressor {
    @NotNull
    public static final LZ4Decompressor INSTANCE = new LZ4Decompressor();

    private LZ4Decompressor() {
    }

    public int decompress(@NotNull byte[] src, int srcOff, @NotNull byte[] dest, int destOff, int destLen) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SafeUtils.checkRange((byte[])src, (int)srcOff);
        SafeUtils.checkRange((byte[])dest, (int)destOff, (int)destLen);
        if (destLen == 0) {
            if (SafeUtils.readByte((byte[])src, (int)srcOff) != 0) {
                throw new LZ4Exception("Malformed input at " + srcOff);
            }
            return 1;
        }
        int destEnd = destOff + destLen;
        int sOff = srcOff;
        int dOff = destOff;
        while (true) {
            int matchCopyEnd;
            int literalCopyEnd;
            int token = SafeUtils.readByte((byte[])src, (int)sOff) & 0xFF;
            ++sOff;
            int literalLen = token >>> 4;
            if (literalLen == 15) {
                byte len = 0;
                while (true) {
                    byte by;
                    byte it = by = SafeUtils.readByte((byte[])src, (int)sOff++);
                    boolean bl = false;
                    len = it;
                    if (by != -1) break;
                    literalLen += 255;
                }
                literalLen += len & 0xFF;
            }
            if ((literalCopyEnd = dOff + literalLen) > destEnd - 8) {
                if (literalCopyEnd != destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                System.arraycopy(src, sOff, dest, dOff, literalLen);
                return (sOff += literalLen) - srcOff;
            }
            Lz4Kt.access$wildArraycopy(src, sOff, dest, dOff, literalLen);
            int matchDec = SafeUtils.readShortLE((byte[])src, (int)(sOff += literalLen));
            sOff += 2;
            int matchOff = literalCopyEnd - matchDec;
            if (matchOff < destOff) {
                throw new LZ4Exception("Malformed input at " + sOff);
            }
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len = 0;
                while (true) {
                    byte by;
                    byte it = by = SafeUtils.readByte((byte[])src, (int)sOff++);
                    boolean bl = false;
                    len = it;
                    if (by != -1) break;
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if ((matchCopyEnd = literalCopyEnd + (matchLen += 4)) > destEnd - 8) {
                if (matchCopyEnd > destEnd) {
                    throw new LZ4Exception("Malformed input at " + sOff);
                }
                Lz4Kt.access$safeIncrementalCopy(dest, matchOff, literalCopyEnd, matchLen);
            } else {
                Lz4Kt.access$wildIncrementalCopy(dest, matchOff, literalCopyEnd, matchCopyEnd);
            }
            dOff = matchCopyEnd;
        }
    }

    public int decompress(@NotNull ByteBuffer src, int srcOff, @NotNull ByteBuffer dest, int destOff, int destLen) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (src.hasArray() && dest.hasArray()) {
            byte[] byArray = src.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"array(...)");
            int n = srcOff + src.arrayOffset();
            byte[] byArray2 = dest.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
            return this.decompress(byArray, n, byArray2, destOff + dest.arrayOffset(), destLen);
        }
        throw new AssertionError((Object)"Do not support decompression on direct buffers");
    }
}

