/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.blobstorage;

import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.diagnostic.telemetry.PlatformScopesKt;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.util.io.storages.blobstorage.RecordAlreadyDeletedException;
import com.intellij.platform.util.io.storages.blobstorage.RecordLayout;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.blobstorage.BlobStorageStatistics;
import com.intellij.util.io.blobstorage.SpaceAllocationStrategy;
import com.intellij.util.io.blobstorage.StreamlinedBlobStorage;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BatchCallback;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class StreamlinedBlobStorageHelper
implements StreamlinedBlobStorage,
BlobStorageStatistics {
    protected static final int MAGIC_WORD = IOUtil.asciiToMagicWord((String)"SBlS");
    protected static final int FILE_STATUS_OPENED = 0;
    protected static final int FILE_STATUS_PROPERLY_CLOSED = 1;
    public static final int MAX_CAPACITY = 1048571;
    protected static final int MAX_REDIRECTS = 256;
    protected static final long MAX_FILE_LENGTH = 0x3FFFFFFF8L;
    protected final AtomicBoolean closed;
    protected final AtomicBoolean wasClosedProperly;
    @NotNull
    protected final SpaceAllocationStrategy allocationStrategy;
    protected final int pageSize;
    protected final ByteOrder byteOrder;
    protected final int maxCapacityForPageSize;
    private final ThreadLocal<ByteBuffer> threadLocalBuffer;
    private volatile int nextRecordId;
    protected final AtomicInteger recordsAllocated;
    protected final AtomicInteger recordsRelocated;
    protected final AtomicInteger recordsDeleted;
    protected final AtomicLong totalLiveRecordsPayloadBytes;
    protected final AtomicLong totalLiveRecordsCapacityBytes;

    protected StreamlinedBlobStorageHelper(@NotNull SpaceAllocationStrategy allocationStrategy, int pageSize, @NotNull ByteOrder byteOrder) {
        if (allocationStrategy == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(0);
        }
        if (byteOrder == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(1);
        }
        this.closed = new AtomicBoolean(false);
        this.wasClosedProperly = new AtomicBoolean(true);
        this.recordsAllocated = new AtomicInteger();
        this.recordsRelocated = new AtomicInteger();
        this.recordsDeleted = new AtomicInteger();
        this.totalLiveRecordsPayloadBytes = new AtomicLong();
        this.totalLiveRecordsCapacityBytes = new AtomicLong();
        if (pageSize < this.headerSize()) {
            throw new IllegalStateException("header(" + this.headerSize() + " b) must fit on 0th page(" + pageSize + " b)");
        }
        this.byteOrder = byteOrder;
        this.pageSize = pageSize;
        this.allocationStrategy = allocationStrategy;
        int defaultCapacity = allocationStrategy.defaultCapacity();
        this.threadLocalBuffer = ThreadLocal.withInitial(() -> {
            ByteBuffer buffer = ByteBuffer.allocate(defaultCapacity);
            buffer.order(byteOrder);
            return buffer;
        });
        this.maxCapacityForPageSize = pageSize - RecordLayout.ActualRecords.LargeRecord.INSTANCE.headerSize();
        if (this.maxCapacityForPageSize <= 0) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") is too small even for a record header(=" + RecordLayout.ActualRecords.LargeRecord.INSTANCE.headerSize() + "b)");
        }
    }

    public boolean wasClosedProperly() {
        return this.wasClosedProperly.get();
    }

    public boolean hasRecord(int recordId) throws IOException {
        return this.hasRecord(recordId, null);
    }

    public boolean isRecordActual(int recordActualLength) {
        return recordActualLength >= 0;
    }

    public int maxPayloadSupported() {
        return Math.min(this.maxCapacityForPageSize, 1048571);
    }

    public void closeAndClean() throws IOException {
        this.close();
        FileUtil.delete((Path)this.storagePath());
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int liveRecordsCount() throws ClosedStorageException {
        this.checkNotClosed();
        return this.recordsAllocated.get() - this.recordsDeleted.get() - this.recordsRelocated.get();
    }

    public int recordsAllocated() throws ClosedStorageException {
        this.checkNotClosed();
        return this.recordsAllocated.get();
    }

    public int recordsRelocated() throws ClosedStorageException {
        this.checkNotClosed();
        return this.recordsRelocated.get();
    }

    public int recordsDeleted() throws ClosedStorageException {
        this.checkNotClosed();
        return this.recordsDeleted.get();
    }

    public long totalLiveRecordsPayloadBytes() throws ClosedStorageException {
        this.checkNotClosed();
        return this.totalLiveRecordsPayloadBytes.get();
    }

    public long totalLiveRecordsCapacityBytes() throws ClosedStorageException {
        this.checkNotClosed();
        return this.totalLiveRecordsCapacityBytes.get();
    }

    public String toString() {
        try {
            return this.getClass().getSimpleName() + "[" + String.valueOf(this.storagePath()) + "]{nextRecordId: " + this.nextRecordId() + "}";
        }
        catch (IOException e) {
            return this.getClass().getSimpleName() + "[" + String.valueOf(this.storagePath()) + "]{closed}";
        }
    }

    @NotNull
    protected abstract Path storagePath();

    protected void checkNotClosed() throws ClosedStorageException {
        if (this.closed.get()) {
            throw new ClosedStorageException("Storage " + String.valueOf(this) + " is already closed");
        }
    }

    protected int headerSize() {
        return 64;
    }

    protected long recordsStartOffset() {
        long headerSize = this.headerSize();
        if (headerSize % 8L > 0L) {
            return (headerSize / 8L + 1L) * 8L;
        }
        return headerSize / 8L * 8L;
    }

    protected long idToOffset(int recordId) {
        return this.recordsStartOffset() + (long)(recordId - 1) * 8L;
    }

    protected int offsetToId(long offset) {
        long longId = (offset - this.recordsStartOffset()) / 8L + 1L;
        int id = (int)longId;
        assert (longId == (long)id) : "offset " + offset + " is out of Integer bounds";
        assert (id > 0) : "id " + id + " is not a valid id";
        return id;
    }

    protected int toOffsetOnPage(long offsetInFile) {
        return Math.toIntExact(offsetInFile % (long)this.pageSize);
    }

    protected int nextRecordId() throws IOException {
        return this.nextRecordId;
    }

    protected void updateNextRecordId(int nextRecordId) throws IOException {
        if (nextRecordId <= 0) {
            throw new IllegalArgumentException("nextRecordId(=" + nextRecordId + ") must be >0");
        }
        this.nextRecordId = nextRecordId;
    }

    protected int allocateSlotForRecord(int pageSize, int totalRecordSize, @NotNull IntRef actualRecordSize) throws IOException {
        if (actualRecordSize == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(2);
        }
        if (totalRecordSize > pageSize) {
            throw new IllegalArgumentException("recordSize(" + totalRecordSize + " b) must be <= pageSize(" + pageSize + " b)");
        }
        StreamlinedBlobStorageHelper streamlinedBlobStorageHelper = this;
        synchronized (streamlinedBlobStorageHelper) {
            long nextPageStartOffset;
            while (true) {
                int offsetOnPage;
                int recordSizeRoundedUp;
                long recordEndOffset;
                long endPage;
                int newRecordId;
                long recordStartOffset;
                long startPage;
                if ((startPage = (recordStartOffset = this.idToOffset(newRecordId = this.nextRecordId())) / (long)pageSize) == (endPage = (recordEndOffset = recordStartOffset + (long)(recordSizeRoundedUp = StreamlinedBlobStorageHelper.roundSizeUpToBucket(offsetOnPage = this.toOffsetOnPage(recordStartOffset), pageSize, totalRecordSize)) - 1L) / (long)pageSize)) {
                    actualRecordSize.set(recordSizeRoundedUp);
                    this.updateNextRecordId(this.offsetToId(recordEndOffset + 1L));
                    return newRecordId;
                }
                this.putSpaceFillerRecord(recordStartOffset, pageSize);
                nextPageStartOffset = (startPage + 1L) * (long)pageSize;
                this.updateNextRecordId(this.offsetToId(nextPageStartOffset));
                assert (this.idToOffset(this.nextRecordId()) == nextPageStartOffset) : "idToOffset(" + this.nextRecordId() + ")=" + this.idToOffset(this.nextRecordId()) + " != nextPageStartOffset(" + nextPageStartOffset + ")";
            }
        }
    }

    protected abstract void putSpaceFillerRecord(long var1, int var3) throws IOException;

    protected void checkRecordIdExists(int recordId) throws IllegalArgumentException, IOException {
        if (!this.isExistingRecordId(recordId)) {
            throw new IllegalArgumentException("recordId(" + recordId + ") is not valid: allocated ids are in (0, " + this.nextRecordId() + "), (wasClosedProperly: " + this.wasClosedProperly() + ")");
        }
    }

    protected void checkRedirectToId(int startingRecordId, int currentRecordId, int redirectToId) throws IOException {
        if (redirectToId == 0) {
            throw new RecordAlreadyDeletedException("Can't access record[" + startingRecordId + "/" + currentRecordId + "]: it was deleted (wasClosedProperly: " + this.wasClosedProperly() + ")");
        }
        if (!this.isExistingRecordId(redirectToId)) {
            throw new CorruptedException("record(" + startingRecordId + "/" + currentRecordId + ").redirectToId(=" + redirectToId + ") is not exist: allocated ids are in (0, " + this.nextRecordId() + "), (wasClosedProperly: " + this.wasClosedProperly() + ")");
        }
    }

    protected boolean isRecordIdAllocated(int recordId) throws IOException {
        return recordId < this.nextRecordId();
    }

    protected boolean isExistingRecordId(int recordId) throws IOException {
        return StreamlinedBlobStorageHelper.isValidRecordId(recordId) && this.isRecordIdAllocated(recordId);
    }

    /*
     * WARNING - void declaration
     */
    protected long nextRecordOffset(long recordOffset, @NotNull RecordLayout recordLayout, int n) {
        void recordCapacity;
        int headerSize;
        long nextOffset;
        int offsetOnPage;
        if (recordLayout == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(3);
        }
        if (this.pageSize - (offsetOnPage = this.toOffsetOnPage(nextOffset = recordOffset + (long)(headerSize = recordLayout.headerSize()) + (long)recordCapacity)) < headerSize) {
            throw new AssertionError((Object)("Bug: offsetOnPage(" + offsetOnPage + ") is too close to page border (" + this.pageSize + ")"));
        }
        return nextOffset;
    }

    protected static int roundSizeUpToBucket(int offset, int pageSize, int rawRecordSize) {
        int occupiedOnPage;
        int remainedOnPage;
        int recordSizeRoundedUp = rawRecordSize;
        if (recordSizeRoundedUp % 8 != 0) {
            recordSizeRoundedUp = (recordSizeRoundedUp / 8 + 1) * 8;
        }
        if (0 < (remainedOnPage = pageSize - (occupiedOnPage = offset + recordSizeRoundedUp)) && remainedOnPage < 8) {
            recordSizeRoundedUp += remainedOnPage;
        }
        assert (recordSizeRoundedUp >= rawRecordSize) : "roundedUpRecordSize(=" + recordSizeRoundedUp + ") must be >= rawRecordSize(=" + rawRecordSize + ")";
        return recordSizeRoundedUp;
    }

    protected static void checkRecordIdValid(int recordId) {
        if (!StreamlinedBlobStorageHelper.isValidRecordId(recordId)) {
            throw new IllegalArgumentException("recordId(" + recordId + ") is invalid: must be > 0");
        }
    }

    protected static boolean isValidRecordId(int recordId) {
        return recordId > 0;
    }

    protected static void checkCapacityHardLimit(int capacity) {
        if (!StreamlinedBlobStorageHelper.isCorrectCapacity(capacity)) {
            throw new IllegalArgumentException("capacity(=" + capacity + ") must be in [0, 1048571]");
        }
    }

    protected static void checkLengthHardLimit(int length) {
        if (!StreamlinedBlobStorageHelper.isCorrectLength(length)) {
            throw new IllegalArgumentException("length(=" + length + ") must be in [0, 1048571]");
        }
    }

    protected static boolean isCorrectCapacity(int capacity) {
        return 0 <= capacity && capacity <= 1048571;
    }

    protected static boolean isCorrectLength(int length) {
        return 0 <= length && length <= 1048571;
    }

    @NotNull
    protected ByteBuffer acquireTemporaryBuffer(int expectedRecordSizeHint) {
        ByteBuffer temp = this.threadLocalBuffer.get();
        if (temp != null && temp.capacity() >= expectedRecordSizeHint) {
            this.threadLocalBuffer.remove();
            ByteBuffer byteBuffer = temp.position(0).limit(0);
            if (byteBuffer == null) {
                StreamlinedBlobStorageHelper.$$$reportNull$$$0(4);
            }
            return byteBuffer;
        }
        int defaultCapacity = this.allocationStrategy.defaultCapacity();
        int capacity = Math.max(defaultCapacity, expectedRecordSizeHint);
        ByteBuffer buffer = ByteBuffer.allocate(capacity);
        buffer.order(this.byteOrder);
        ByteBuffer byteBuffer = buffer;
        if (byteBuffer == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(5);
        }
        return byteBuffer;
    }

    protected void releaseTemporaryBuffer(@NotNull ByteBuffer temp) {
        if (temp == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(6);
        }
        int defaultCapacity = this.allocationStrategy.defaultCapacity();
        if (temp.capacity() <= 2 * defaultCapacity) {
            this.threadLocalBuffer.set(temp);
        }
    }

    @NotNull
    public static BatchCallback setupReportingToOpenTelemetry(@NotNull Path fileName, @NotNull StreamlinedBlobStorageHelper storage) {
        if (fileName == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(7);
        }
        if (storage == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(8);
        }
        Meter meter = TelemetryManager.getInstance().getMeter(PlatformScopesKt.Storage);
        ObservableLongMeasurement recordsAllocated = meter.counterBuilder("StreamlinedBlobStorage.recordsAllocated").buildObserver();
        ObservableLongMeasurement recordsRelocated = meter.counterBuilder("StreamlinedBlobStorage.recordsRelocated").buildObserver();
        ObservableLongMeasurement recordsDeleted = meter.counterBuilder("StreamlinedBlobStorage.recordsDeleted").buildObserver();
        ObservableLongMeasurement totalLiveRecordsPayloadBytes = meter.upDownCounterBuilder("StreamlinedBlobStorage.totalLiveRecordsPayloadBytes").buildObserver();
        ObservableLongMeasurement totalLiveRecordsCapacityBytes = meter.upDownCounterBuilder("StreamlinedBlobStorage.totalLiveRecordsCapacityBytes").buildObserver();
        Attributes attributes = Attributes.builder().put("file", fileName.toString()).build();
        BatchCallback batchCallback = meter.batchCallback(() -> {
            try {
                recordsAllocated.record((long)storage.recordsAllocated(), attributes);
                recordsRelocated.record((long)storage.recordsRelocated(), attributes);
                recordsDeleted.record((long)storage.recordsDeleted(), attributes);
                totalLiveRecordsPayloadBytes.record(storage.totalLiveRecordsPayloadBytes(), attributes);
                totalLiveRecordsCapacityBytes.record(storage.totalLiveRecordsCapacityBytes(), attributes);
            }
            catch (ClosedStorageException closedStorageException) {
                // empty catch block
            }
        }, (ObservableMeasurement)recordsAllocated, new ObservableMeasurement[]{recordsRelocated, recordsDeleted, totalLiveRecordsPayloadBytes, totalLiveRecordsCapacityBytes});
        if (batchCallback == null) {
            StreamlinedBlobStorageHelper.$$$reportNull$$$0(9);
        }
        return batchCallback;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allocationStrategy";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteOrder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualRecordSize";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordLayout";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/blobstorage/StreamlinedBlobStorageHelper";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "temp";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/blobstorage/StreamlinedBlobStorageHelper";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireTemporaryBuffer";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setupReportingToOpenTelemetry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allocateSlotForRecord";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "nextRecordOffset";
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "releaseTemporaryBuffer";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setupReportingToOpenTelemetry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 9 -> new IllegalStateException(string);
        };
    }

    @VisibleForTesting
    public static final class HeaderLayout {
        public static final int MAGIC_WORD_OFFSET = 0;
        public static final int STORAGE_VERSION_OFFSET = 4;
        public static final int PAGE_SIZE_OFFSET = 8;
        public static final int FILE_STATUS_OFFSET = 12;
        public static final int NEXT_RECORD_ID_OFFSET = 16;
        public static final int RECORDS_ALLOCATED_OFFSET = 20;
        public static final int RECORDS_RELOCATED_OFFSET = 24;
        public static final int RECORDS_DELETED_OFFSET = 28;
        public static final int RECORDS_LIVE_TOTAL_PAYLOAD_SIZE_OFFSET = 32;
        public static final int RECORDS_LIVE_TOTAL_CAPACITY_SIZE_OFFSET = 40;
        public static final int DATA_FORMAT_VERSION_OFFSET = 48;
        public static final int FIRST_UNUSED_FIELD_OFFSET = 52;
        public static final int HEADER_SIZE = 64;
    }
}

