/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.mmapped;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.CleanableStorage;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class MMappedFileStorage
implements Closeable,
Unmappable,
CleanableStorage {
    static final Logger LOG = Logger.getInstance(MMappedFileStorage.class);
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(LOG, 1000L);
    public static final boolean FSYNC_ON_FLUSH_BY_DEFAULT = SystemProperties.getBooleanProperty((String)"MMappedFileStorage.FSYNC_BY_DEFAULT_ON_FLUSH", (boolean)false);
    private static final String UNMAP_ON_CLOSE_KIND = System.getProperty("MMappedFileStorage.UNMAP_ON_CLOSE", "never");
    private static final boolean UNMAP_ON_CLOSE_BY_DEFAULT = "always".equals(UNMAP_ON_CLOSE_KIND) || "on-windows".equals(UNMAP_ON_CLOSE_KIND) && SystemInfoRt.isWindows;
    private static final boolean FAIL_ON_FAILED_UNMAP = SystemProperties.getBooleanProperty((String)"idea.fs.fail-if-unmap-failed", (boolean)true);
    private static final boolean LOG_UNMAP_OPERATIONS = SystemProperties.getBooleanProperty((String)"MMappedFileStorage.LOG_UNMAP_OPERATIONS", (boolean)false);
    private static final boolean CRASH_TOLERANT_EXPANSION = SystemProperties.getBooleanProperty((String)"MMappedFileStorage.CRASH_TOLERANT_EXPANSION", (boolean)true);
    private static final boolean WARN_OF_DELETED_STORAGES_USE = SystemProperties.getBooleanProperty((String)"MMappedFileStorage.WARN_OF_DELETED_STORAGES_USE", (boolean)true);
    private static final int PAGES_TO_WARN_THRESHOLD = SystemProperties.getIntProperty((String)"vfs.memory-mapped-storage.pages-to-warn-threshold", (int)1024);
    private static volatile int openedStoragesCount = 0;
    private static final AtomicInteger totalPagesMapped = new AtomicInteger();
    private static final AtomicLong totalBytesMapped = new AtomicLong();
    private static final AtomicLong totalTimeForPageMapNs = new AtomicLong();
    private static final Map<Path, MMappedFileStorage> openedStorages = new HashMap<Path, MMappedFileStorage>();
    private final Path storagePath;
    private final int pageSize;
    private final int pageSizeMask;
    private final int pageSizeBits;
    private final FileChannel channel;
    private final transient Object pagesLock;
    private Page[] pages;
    private final RegionAllocationAtomicityLock regionAllocationAtomicityLock;
    private transient Exception closeStackTrace;
    @ApiStatus.Internal
    public static boolean DEBUG_INDEXES_WAS_DROPPED = false;

    MMappedFileStorage(@NotNull Path path, int pageSize, @NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock) throws IOException {
        if (path == null) {
            MMappedFileStorage.$$$reportNull$$$0(0);
        }
        if (regionAllocationAtomicityLock == null) {
            MMappedFileStorage.$$$reportNull$$$0(1);
        }
        this(path, pageSize, 0, regionAllocationAtomicityLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MMappedFileStorage(Path path, int pageSize, int pagesCountToMapInitially, @NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock) throws IOException {
        Path absolutePath;
        if (regionAllocationAtomicityLock == null) {
            MMappedFileStorage.$$$reportNull$$$0(2);
        }
        this.pagesLock = new Object();
        this.closeStackTrace = null;
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be >0");
        }
        if (Integer.bitCount(pageSize) != 1) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be a power of 2");
        }
        if (pagesCountToMapInitially < 0) {
            throw new IllegalArgumentException("pagesCountToMapInitially(=" + pagesCountToMapInitially + ") must be >= 0");
        }
        this.pageSizeBits = Integer.numberOfTrailingZeros(pageSize);
        this.pageSizeMask = pageSize - 1;
        this.pageSize = pageSize;
        this.storagePath = absolutePath = path.toAbsolutePath();
        this.regionAllocationAtomicityLock = regionAllocationAtomicityLock;
        Map<Path, MMappedFileStorage> map = openedStorages;
        synchronized (map) {
            MMappedFileStorage alreadyExistingStorage = openedStorages.get(absolutePath);
            if (alreadyExistingStorage != null) {
                throw new IllegalStateException("Storage[" + String.valueOf(absolutePath) + "] is already opened (and not yet closed) -- can't open same file more than once");
            }
            this.channel = FileChannel.open(this.storagePath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            this.pages = new Page[pagesCountToMapInitially];
            for (int i = 0; i < pagesCountToMapInitially; ++i) {
                this.pageByIndex(i);
            }
            openedStorages.put(absolutePath, this);
            ++openedStoragesCount;
        }
    }

    public Path storagePath() {
        return this.storagePath;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public ByteOrder byteOrder() {
        return ByteOrder.nativeOrder();
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long actualFileSize() throws IOException {
        Object object = this.pagesLock;
        synchronized (object) {
            long channelSize = this.channel.size();
            if ((channelSize & (long)this.pageSizeMask) != 0L) {
                throw new AssertionError((Object)("Bug: [" + String.valueOf(this.storagePath) + "].channelSize(=" + channelSize + ") is not pageSize(=" + this.pageSize + ")-aligned"));
            }
            return channelSize;
        }
    }

    @NotNull
    public Page pageByOffset(long offsetInFile) throws IOException {
        int pageIndex = this.pageIndexByOffset(offsetInFile);
        Page page = this.pageByIndex(pageIndex);
        if (page == null) {
            MMappedFileStorage.$$$reportNull$$$0(3);
        }
        return page;
    }

    @NotNull
    public Page pageByIndex(int pageIndex) throws IOException {
        Page page = MMappedFileStorage.pageOrNull(this.pages, pageIndex);
        if (page == null) {
            page = this.pageByIndexLocked(pageIndex);
        }
        Page page2 = page;
        if (page2 == null) {
            MMappedFileStorage.$$$reportNull$$$0(4);
        }
        return page2;
    }

    public int pageIndexByOffset(long offsetInFile) {
        if (offsetInFile < 0L) {
            throw new IllegalArgumentException("offsetInFile(=" + offsetInFile + ") must be >=0");
        }
        return (int)(offsetInFile >> this.pageSizeBits);
    }

    public int toOffsetInPage(long offsetInFile) {
        return (int)(offsetInFile & (long)this.pageSizeMask);
    }

    @Override
    public void close() throws IOException {
        this.close(UNMAP_ON_CLOSE_BY_DEFAULT);
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        this.close(true);
    }

    public void fsync() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.force(true);
        }
    }

    public void closeAndClean() throws IOException {
        this.closeAndUnsafelyUnmap();
        FileUtil.delete((Path)this.storagePath);
    }

    public void zeroizeRegion(long startOffsetInFile, long endOffsetInFile) throws IOException {
        int startOffsetInPage;
        int endOffsetInPage;
        if (startOffsetInFile < 0L) {
            throw new IllegalArgumentException("startOffsetInFile(=" + startOffsetInFile + ") must be >=0");
        }
        if (endOffsetInFile < 0L) {
            throw new IllegalArgumentException("endOffsetInFile(=" + endOffsetInFile + ") must be >=0");
        }
        for (long offset = startOffsetInFile; offset <= endOffsetInFile; offset += (long)(endOffsetInPage - startOffsetInPage + 1)) {
            Page page = this.pageByOffset(offset);
            ByteBuffer pageBuffer = page.rawPageBuffer();
            startOffsetInPage = this.toOffsetInPage(offset);
            endOffsetInPage = endOffsetInFile > page.lastOffsetInFile() ? this.pageSize - 1 : this.toOffsetInPage(endOffsetInFile);
            for (int pos = startOffsetInPage; pos <= endOffsetInPage; ++pos) {
                pageBuffer.put(pos, (byte)0);
            }
        }
    }

    public void zeroizeTillEOF(long startOffsetInFile) throws IOException {
        long actualFileSize = this.actualFileSize();
        if (actualFileSize == 0L) {
            return;
        }
        this.zeroizeRegion(startOffsetInFile, actualFileSize - 1L);
    }

    public String toString() {
        return "MMappedFileStorage[" + String.valueOf(this.storagePath) + "][" + this.pages.length + " pages of " + this.pageSize + "b]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean unmap) throws IOException {
        Map<Path, MMappedFileStorage> map;
        boolean actuallyClosed = false;
        try {
            map = this.pagesLock;
            synchronized (map) {
                if (this.channel.isOpen()) {
                    this.channel.close();
                    for (Page page : this.pages) {
                        if (page == null) continue;
                        MMappedFileStorage.unregisterMappedPage(this.pageSize);
                    }
                    actuallyClosed = true;
                }
                if (unmap) {
                    try {
                        for (Page page : this.pages) {
                            if (page == null) continue;
                            page.unmap();
                        }
                    }
                    finally {
                        Arrays.fill(this.pages, null);
                    }
                }
                this.closeStackTrace = new Exception("Close stack trace");
            }
        }
        finally {
            map = openedStorages;
            synchronized (map) {
                MMappedFileStorage removed = openedStorages.get(this.storagePath);
                if (removed == this) {
                    openedStorages.remove(this.storagePath);
                    --openedStoragesCount;
                }
            }
        }
        if (actuallyClosed && WARN_OF_DELETED_STORAGES_USE) {
            Path parent = this.storagePath.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                LOG.warn("Storage parent dir[" + String.valueOf(parent.toAbsolutePath()) + "] is not exist: storage files were removed while wasn't yet closed!");
            } else if (!Files.exists(this.storagePath, new LinkOption[0])) {
                LOG.warn("Storage[" + String.valueOf(this.storagePath.toAbsolutePath()) + "] is not exist: storage file was removed while wasn't yet closed!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page pageByIndexLocked(int pageIndex) throws IOException {
        Object object = this.pagesLock;
        synchronized (object) {
            Page page;
            if (!this.channel.isOpen()) {
                ClosedStorageException ex = new ClosedStorageException("Storage already closed");
                if (this.closeStackTrace != null) {
                    ex.addSuppressed((Throwable)this.closeStackTrace);
                }
                throw ex;
            }
            if (pageIndex >= this.pages.length) {
                this.pages = Arrays.copyOf(this.pages, pageIndex + 1);
            }
            if ((page = this.pages[pageIndex]) == null) {
                this.pages[pageIndex] = page = new Page(this.regionAllocationAtomicityLock, pageIndex, this.channel, this.pageSize, this.byteOrder());
                MMappedFileStorage.registerMappedPage(this.pageSize);
            }
            return page;
        }
    }

    @Nullable
    private static Page pageOrNull(Page[] pages, int pageIndex) {
        if (0 <= pageIndex && pageIndex < pages.length) {
            return pages[pageIndex];
        }
        return null;
    }

    public static int openedStoragesCount() {
        return openedStoragesCount;
    }

    public static int totalPagesMapped() {
        return totalPagesMapped.get();
    }

    public static long totalBytesMapped() {
        return totalBytesMapped.get();
    }

    public static long totalTimeForPageMap(@NotNull TimeUnit unit) {
        if (unit == null) {
            MMappedFileStorage.$$$reportNull$$$0(5);
        }
        return unit.convert(totalTimeForPageMapNs.get(), TimeUnit.NANOSECONDS);
    }

    private static void registerMappedPage(int pageSize) {
        int pagesMapped = totalPagesMapped.incrementAndGet();
        totalBytesMapped.addAndGet(pageSize);
        if (pagesMapped > PAGES_TO_WARN_THRESHOLD) {
            THROTTLED_LOG.warn("Too many pages were mapped: " + pagesMapped + " > " + PAGES_TO_WARN_THRESHOLD + " threshold. Total mapped size: " + totalBytesMapped.get() + " bytes, storages: " + openedStoragesCount);
        }
    }

    private static void unregisterMappedPage(int pageSize) {
        totalPagesMapped.decrementAndGet();
        totalBytesMapped.addAndGet(-pageSize);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regionAllocationAtomicityLock";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/mmapped/MMappedFileStorage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/mmapped/MMappedFileStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByOffset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pageByIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "totalTimeForPageMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static interface RegionAllocationAtomicityLock {
        public Region region(long var1, int var3) throws IOException;

        public static RegionAllocationAtomicityLock defaultLock(@NotNull Path mainStorageFile) {
            if (mainStorageFile == null) {
                RegionAllocationAtomicityLock.$$$reportNull$$$0(0);
            }
            if (CRASH_TOLERANT_EXPANSION) {
                return new FileBasedRegionAllocationLock(mainStorageFile);
            }
            return new NoLock();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainStorageFile", "com/intellij/platform/util/io/storages/mmapped/MMappedFileStorage$RegionAllocationAtomicityLock", "defaultLock"));
        }

        public static class FileBasedRegionAllocationLock
        implements RegionAllocationAtomicityLock {
            private final Path mainStoragePath;

            public FileBasedRegionAllocationLock(@NotNull Path mainStoragePath) {
                if (mainStoragePath == null) {
                    FileBasedRegionAllocationLock.$$$reportNull$$$0(0);
                }
                this.mainStoragePath = mainStoragePath;
            }

            @Override
            public Region region(long regionStartOffset, int pageSize) throws IOException {
                Path mappingLockPath = this.mainStoragePath.resolveSibling("." + String.valueOf(this.mainStoragePath.getFileName()) + "." + regionStartOffset + ".lock");
                return new RegionImpl(this.mainStoragePath, mappingLockPath, regionStartOffset, pageSize);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mainStoragePath", "com/intellij/platform/util/io/storages/mmapped/MMappedFileStorage$RegionAllocationAtomicityLock$FileBasedRegionAllocationLock", "<init>"));
            }

            private static final class RegionImpl
            implements Region {
                private final Path mainStoragePath;
                private final Path mappingLockFile;
                private final long regionStartOffset;
                private final int pageSize;

                /*
                 * WARNING - void declaration
                 */
                private RegionImpl(@NotNull Path mainStoragePath, @NotNull Path mappingLockFile, long regionStartOffset, int n) {
                    void pageSize;
                    if (mainStoragePath == null) {
                        RegionImpl.$$$reportNull$$$0(0);
                    }
                    if (mappingLockFile == null) {
                        RegionImpl.$$$reportNull$$$0(1);
                    }
                    this.mainStoragePath = mainStoragePath;
                    this.mappingLockFile = mappingLockFile;
                    this.regionStartOffset = regionStartOffset;
                    this.pageSize = pageSize;
                }

                @Override
                public void start() throws IOException {
                    try {
                        Files.createFile(this.mappingLockFile, new FileAttribute[0]);
                    }
                    catch (NoSuchFileException e) {
                        Path parent = this.mappingLockFile.getParent();
                        if (!Files.exists(parent, new LinkOption[0])) {
                            Path firstExistingParent = RegionImpl.firstExistingParent(parent);
                            throw new IOException("Parent dir[" + String.valueOf(parent.toAbsolutePath()) + "] is not exist/was removed -- can't create .lock-file.\nStorage file[" + String.valueOf(this.mainStoragePath) + "](exists: " + Files.exists(this.mainStoragePath, new LinkOption[0]) + "), First existing parent: [" + String.valueOf(firstExistingParent) + "], indexes were dropped: " + DEBUG_INDEXES_WAS_DROPPED, e);
                        }
                        throw new IOException("Can't create .lock-file for unknown reasons", e);
                    }
                    catch (FileAlreadyExistsException e) {
                        throw new IOException("lock-file[" + String.valueOf(this.mappingLockFile) + "] already created -- concurrent access?", e);
                    }
                }

                @Override
                public boolean isUnfinished() {
                    return Files.exists(this.mappingLockFile, new LinkOption[0]);
                }

                @Override
                public void finish() throws IOException {
                    Files.delete(this.mappingLockFile);
                }

                public String toString() {
                    return "FileBasedRegionAllocationLock[" + String.valueOf(this.mappingLockFile) + "][" + this.regionStartOffset + ".. +" + this.pageSize + "]";
                }

                @Nullable
                private static Path firstExistingParent(@NotNull Path parent) {
                    Path firstExistingParent;
                    if (parent == null) {
                        RegionImpl.$$$reportNull$$$0(2);
                    }
                    for (firstExistingParent = parent.toAbsolutePath(); firstExistingParent != null && !Files.exists(firstExistingParent, new LinkOption[0]); firstExistingParent = firstExistingParent.getParent()) {
                    }
                    return firstExistingParent;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "mainStoragePath";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "mappingLockFile";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "parent";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/platform/util/io/storages/mmapped/MMappedFileStorage$RegionAllocationAtomicityLock$FileBasedRegionAllocationLock$RegionImpl";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "<init>";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "firstExistingParent";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
        }

        public static class NoLock
        implements RegionAllocationAtomicityLock {
            @Override
            public Region region(long regionStartOffset, int pageSize) throws IOException {
                return new Region(this){

                    @Override
                    public boolean isUnfinished() {
                        return false;
                    }

                    @Override
                    public void start() throws IOException {
                    }

                    @Override
                    public void finish() throws IOException {
                    }
                };
            }
        }

        public static interface Region {
            public boolean isUnfinished();

            public void start() throws IOException;

            public void finish() throws IOException;
        }
    }

    public static final class Page {
        private final int pageIndex;
        private final int pageSize;
        private final long offsetInFile;
        private final ByteBuffer pageBuffer;

        private Page(@NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock, int pageIndex, @NotNull FileChannel channel, int pageSize, @NotNull ByteOrder byteOrder) throws IOException {
            if (regionAllocationAtomicityLock == null) {
                Page.$$$reportNull$$$0(0);
            }
            if (channel == null) {
                Page.$$$reportNull$$$0(1);
            }
            if (byteOrder == null) {
                Page.$$$reportNull$$$0(2);
            }
            this.pageIndex = pageIndex;
            this.pageSize = pageSize;
            this.offsetInFile = (long)pageIndex * (long)pageSize;
            this.pageBuffer = this.map(regionAllocationAtomicityLock, channel, pageSize).order(byteOrder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MappedByteBuffer map(@NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock, @NotNull FileChannel channel, int pageSize) throws IOException {
            if (regionAllocationAtomicityLock == null) {
                Page.$$$reportNull$$$0(3);
            }
            if (channel == null) {
                Page.$$$reportNull$$$0(4);
            }
            long startedAtNs = System.nanoTime();
            try {
                this.ensureFileRegionAllocatedAndZeroed(regionAllocationAtomicityLock, channel, pageSize);
                MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_WRITE, this.offsetInFile, pageSize);
                return mappedByteBuffer;
            }
            finally {
                long timeSpentNs = System.nanoTime() - startedAtNs;
                totalTimeForPageMapNs.addAndGet(timeSpentNs);
            }
        }

        private void ensureFileRegionAllocatedAndZeroed(@NotNull RegionAllocationAtomicityLock regionAllocationAtomicityLock, @NotNull FileChannel channel, int pageSize) throws IOException {
            RegionAllocationAtomicityLock.Region region;
            if (regionAllocationAtomicityLock == null) {
                Page.$$$reportNull$$$0(5);
            }
            if (channel == null) {
                Page.$$$reportNull$$$0(6);
            }
            if ((region = regionAllocationAtomicityLock.region(this.offsetInFile, pageSize)).isUnfinished()) {
                LOG.warn("mmapped file region " + String.valueOf(region) + " allocation & zeroing has been started, but hasn't been properly finished -- IDE was crashed/killed? -> try finishing the job");
                IOUtil.fillFileRegionWithZeros((FileChannel)channel, (long)this.offsetInFile, (long)(this.offsetInFile + (long)pageSize));
            } else {
                region.start();
                IOUtil.allocateFileRegion((FileChannel)channel, (long)(this.offsetInFile + (long)pageSize));
            }
            region.finish();
        }

        private void unmap() throws IOException {
            try {
                Page.unmapBuffer(this.pageBuffer);
            }
            catch (Throwable t) {
                if (FAIL_ON_FAILED_UNMAP) {
                    throw new IOException("Can't unmap pageBuffer", t);
                }
                THROTTLED_LOG.warn("Can't unmap pageBuffer explicitly -- rely on GC to do it eventually", t);
            }
        }

        public ByteBuffer rawPageBuffer() {
            return this.pageBuffer;
        }

        public long firstOffsetInFile() {
            return this.offsetInFile;
        }

        public long lastOffsetInFile() {
            return this.offsetInFile + (long)this.pageSize - 1L;
        }

        public String toString() {
            return "Page[#" + this.pageIndex + "][offset: " + this.offsetInFile + ", length: " + this.pageBuffer.capacity() + " b)";
        }

        private static void unmapBuffer(@NotNull ByteBuffer buffer) throws Exception {
            if (buffer == null) {
                Page.$$$reportNull$$$0(7);
            }
            if (!buffer.isDirect()) {
                return;
            }
            boolean result = ByteBufferUtil.cleanBuffer((ByteBuffer)buffer);
            if (LOG_UNMAP_OPERATIONS && result) {
                LOG.info("Buffer unmapped: " + String.valueOf(buffer));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regionAllocationAtomicityLock";
                    break;
                }
                case 1: 
                case 4: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "channel";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "byteOrder";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/mmapped/MMappedFileStorage$Page";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "map";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "ensureFileRegionAllocatedAndZeroed";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "unmapBuffer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

