/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.durablemap;

import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLog;
import com.intellij.platform.util.io.storages.durablemap.Compactable;
import com.intellij.platform.util.io.storages.durablemap.DurableMap;
import com.intellij.platform.util.io.storages.durablemap.EntryExternalizer;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.HashUtils;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Processor;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import java.io.IOException;
import java.util.function.BiPredicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class DurableMapOverAppendOnlyLog<K, V>
implements DurableMap<K, V>,
Unmappable {
    public static final int DATA_FORMAT_VERSION = 1;
    private final AppendOnlyLog keyValuesLog;
    private final DurableIntToMultiIntMap keyHashToIdMap;
    private final EqualityPolicy<? super K> keyEquality;
    @Nullable
    private final EqualityPolicy<? super V> valueEquality;
    private final EntryExternalizer<K, V> entryExternalizer;

    public DurableMapOverAppendOnlyLog(@NotNull AppendOnlyLog keyValuesLog, @NotNull DurableIntToMultiIntMap keyHashToIdMap, @NotNull EqualityPolicy<? super K> keyEquality, @Nullable EqualityPolicy<? super V> valueEquality, @NotNull EntryExternalizer<K, V> entryExternalizer) {
        if (keyValuesLog == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(0);
        }
        if (keyHashToIdMap == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(1);
        }
        if (keyEquality == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(2);
        }
        if (entryExternalizer == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(3);
        }
        this.keyValuesLog = keyValuesLog;
        this.keyHashToIdMap = keyHashToIdMap;
        this.keyEquality = keyEquality;
        this.valueEquality = valueEquality;
        this.entryExternalizer = entryExternalizer;
    }

    @Override
    public boolean containsMapping(@NotNull K key) throws IOException {
        int keyHash;
        int adjustedHash;
        int foundRecordId;
        if (key == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(4);
        }
        return (foundRecordId = this.keyHashToIdMap.lookup(adjustedHash = HashUtils.adjustHash(keyHash = this.keyEquality.getHashCode(key)), recordId -> {
            long logRecordId = DurableMapOverAppendOnlyLog.convertStoredIdToLogId(recordId);
            return (Boolean)this.keyValuesLog.read(logRecordId, recordBuffer -> {
                K recordKey = this.entryExternalizer.readKey(recordBuffer);
                return recordKey != null;
            });
        })) != 0;
    }

    @Override
    public V get(@NotNull K key) throws IOException {
        if (key == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(5);
        }
        int keyHash = this.keyEquality.getHashCode(key);
        int adjustedHash = HashUtils.adjustHash(keyHash);
        Ref resultRef = new Ref();
        this.keyHashToIdMap.lookup(adjustedHash, recordId -> {
            long logRecordId = DurableMapOverAppendOnlyLog.convertStoredIdToLogId(recordId);
            EntryExternalizer.Entry<Object, V> entry = this.readEntryIfKeyMatch(logRecordId, key);
            if (entry != null) {
                resultRef.set(entry);
                return true;
            }
            return false;
        });
        EntryExternalizer.Entry entry = (EntryExternalizer.Entry)resultRef.get();
        if (entry == null) {
            return null;
        }
        return entry.value();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(@NotNull K key, @Nullable V value) throws IOException {
        if (key == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(6);
        }
        int keyHash = this.keyEquality.getHashCode(key);
        int adjustedHash = HashUtils.adjustHash(keyHash);
        DurableIntToMultiIntMap durableIntToMultiIntMap = this.keyHashToIdMap;
        synchronized (durableIntToMultiIntMap) {
            Ref valueIsSameRef = new Ref((Object)Boolean.FALSE);
            int foundRecordId = this.keyHashToIdMap.lookup(adjustedHash, candidateRecordId -> {
                long logRecordId = DurableMapOverAppendOnlyLog.convertStoredIdToLogId(candidateRecordId);
                if (this.valueEquality != null) {
                    EntryExternalizer.Entry<Object, V> entryWithSameKey = this.readEntryIfKeyMatch(logRecordId, key);
                    if (entryWithSameKey == null) {
                        return false;
                    }
                    boolean valueIsSame = this.valuesEqualNullSafe(value, entryWithSameKey.value());
                    valueIsSameRef.set((Object)valueIsSame);
                } else {
                    K candidateKey = this.readKey(logRecordId);
                    if (candidateKey == null || !this.keyEquality.isEqual(key, candidateKey)) {
                        return false;
                    }
                    valueIsSameRef.set((Object)Boolean.FALSE);
                }
                return true;
            });
            boolean keyRecordExists = foundRecordId != 0;
            boolean valueIsSame = (Boolean)valueIsSameRef.get();
            if (keyRecordExists && valueIsSame) {
                return;
            }
            long logRecordId = this.appendEntry(key, value);
            int storedRecordId = DurableMapOverAppendOnlyLog.convertLogIdToStoredId(logRecordId);
            if (keyRecordExists) {
                if (value != null) {
                    this.keyHashToIdMap.replace(adjustedHash, foundRecordId, storedRecordId);
                } else {
                    this.keyHashToIdMap.remove(adjustedHash, foundRecordId);
                }
            } else if (value != null) {
                this.keyHashToIdMap.put(adjustedHash, storedRecordId);
            }
        }
    }

    @Override
    public void remove(@NotNull K key) throws IOException {
        if (key == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(7);
        }
        this.put(key, null);
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super K> processor) throws IOException {
        if (processor == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(8);
        }
        return this.keyHashToIdMap.forEach((keyHash, recordId) -> {
            K key = this.readKey(DurableMapOverAppendOnlyLog.convertStoredIdToLogId(recordId));
            if (key == null) {
                throw new AssertionError((Object)("(keyHash: " + keyHash + ", recordId: " + recordId + "): key can't be null, removed records must NOT be in keyHashToIdMap"));
            }
            return processor.process(key);
        });
    }

    @Override
    public boolean forEachEntry(@NotNull BiPredicate<? super K, ? super V> processor) throws IOException {
        if (processor == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(9);
        }
        return this.keyHashToIdMap.forEach((keyHash, recordId) -> {
            EntryExternalizer.Entry<K, V> entry = this.readEntry(DurableMapOverAppendOnlyLog.convertStoredIdToLogId(recordId));
            K key = entry.key();
            if (!entry.isValueVoid()) {
                V value = entry.value();
                return processor.test((K)key, (V)value);
            }
            return true;
        });
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.keyHashToIdMap.isEmpty();
    }

    @Override
    public int size() throws IOException {
        return this.keyHashToIdMap.size();
    }

    @Override
    @NotNull
    public Compactable.CompactionScore compactionScore() throws IOException {
        int activeRecords = this.keyHashToIdMap.size();
        int totalRecords = this.keyValuesLog.recordsCount();
        if (totalRecords == 0) {
            return new Compactable.CompactionScore(0.0);
        }
        double score = 1.0 - (double)activeRecords * 1.0 / (double)totalRecords;
        if (totalRecords < 512) {
            return new Compactable.CompactionScore(Math.max(score, 0.1));
        }
        return new Compactable.CompactionScore(score);
    }

    @Override
    @NotNull
    public <M extends DurableMap<K, V>> M compact(@NotNull ThrowableComputable<M, ? extends IOException> compactedMapFactory) throws IOException {
        if (compactedMapFactory == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(10);
        }
        DurableMap durableMap = (DurableMap)IOUtil.wrapSafely((AutoCloseable)((DurableMap)compactedMapFactory.compute()), compactedMap -> {
            this.keyHashToIdMap.forEach((keyHash, recordId) -> {
                EntryExternalizer.Entry<K, V> entry = this.readEntry(DurableMapOverAppendOnlyLog.convertStoredIdToLogId(recordId));
                if (!entry.isValueVoid()) {
                    compactedMap.put(entry.key(), entry.value());
                }
                return true;
            });
            return compactedMap;
        });
        if (durableMap == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(11);
        }
        return (M)durableMap;
    }

    @Override
    public void force() throws IOException {
        this.keyValuesLog.flush();
        this.keyHashToIdMap.flush();
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.keyHashToIdMap.isClosed();
    }

    @Override
    public void close() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = this.keyValuesLog::close;
        throwableRunnableArray[1] = this.keyHashToIdMap::close;
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't close " + String.valueOf(this.keyValuesLog) + "/" + String.valueOf(this.keyHashToIdMap)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't unmap " + String.valueOf(this.keyValuesLog) + "/" + String.valueOf(this.keyHashToIdMap)), (ThrowableRunnable[])new ThrowableRunnable[]{() -> {
            AppendOnlyLog patt0$temp = this.keyValuesLog;
            if (patt0$temp instanceof Unmappable) {
                Unmappable unmappable = (Unmappable)patt0$temp;
                unmappable.closeAndUnsafelyUnmap();
            } else {
                this.keyValuesLog.close();
            }
        }, () -> {
            DurableIntToMultiIntMap patt0$temp = this.keyHashToIdMap;
            if (patt0$temp instanceof Unmappable) {
                Unmappable unmappable = (Unmappable)patt0$temp;
                unmappable.closeAndUnsafelyUnmap();
            } else {
                this.keyHashToIdMap.close();
            }
        }});
    }

    public void closeAndClean() throws IOException {
        ThrowableRunnable[] throwableRunnableArray = new ThrowableRunnable[2];
        throwableRunnableArray[0] = () -> ((AppendOnlyLog)this.keyValuesLog).closeAndClean();
        throwableRunnableArray[1] = () -> ((DurableIntToMultiIntMap)this.keyHashToIdMap).closeAndClean();
        ExceptionUtil.runAllAndRethrowAllExceptions(IOException.class, () -> new IOException("Can't closeAndClean " + String.valueOf(this.keyValuesLog) + "/" + String.valueOf(this.keyHashToIdMap)), (ThrowableRunnable[])throwableRunnableArray);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.keyValuesLog) + "]";
    }

    static int convertLogIdToStoredId(long logRecordId) {
        int intStoredId = (int)logRecordId;
        if ((long)intStoredId != logRecordId) {
            throw new AssertionError((Object)("Overflow: logRecordId(=" + logRecordId + ") > MAX_INT(2147483647)"));
        }
        return intStoredId;
    }

    static long convertStoredIdToLogId(int storedRecordId) {
        return storedRecordId;
    }

    private boolean valuesEqualNullSafe(@Nullable V value, @Nullable V anotherValue) {
        if (anotherValue == null && value == null) {
            return true;
        }
        if (this.valueEquality == null) {
            return false;
        }
        return anotherValue != null && value != null && this.valueEquality.isEqual(value, anotherValue);
    }

    /*
     * WARNING - void declaration
     */
    private EntryExternalizer.Entry<K, V> readEntryIfKeyMatch(long logRecordId, @NotNull K k) throws IOException {
        void expectedKey;
        if (k == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(12);
        }
        return (EntryExternalizer.Entry)this.keyValuesLog.read(logRecordId, recordBuffer -> this.entryExternalizer.readIfKeyMatch(recordBuffer, expectedKey));
    }

    private EntryExternalizer.Entry<K, V> readEntry(long logRecordId) throws IOException {
        return (EntryExternalizer.Entry)this.keyValuesLog.read(logRecordId, this.entryExternalizer::read);
    }

    @Nullable
    private K readKey(long logRecordId) throws IOException {
        return (K)this.keyValuesLog.read(logRecordId, this.entryExternalizer::readKey);
    }

    private long appendEntry(@NotNull K key, @Nullable V value) throws IOException {
        if (key == null) {
            DurableMapOverAppendOnlyLog.$$$reportNull$$$0(13);
        }
        DataExternalizerEx.KnownSizeRecordWriter entryWriter = this.entryExternalizer.writerFor(key, value);
        return this.keyValuesLog.append(entryWriter, entryWriter.recordSize());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValuesLog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyHashToIdMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyEquality";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryExternalizer";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compactedMapFactory";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/util/io/storages/durablemap/DurableMapOverAppendOnlyLog";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/DurableMapOverAppendOnlyLog";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "compact";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "containsMapping";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachEntry";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "compact";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readEntryIfKeyMatch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendEntry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

