/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.intmultimaps;

import com.intellij.openapi.util.IntRef;
import com.intellij.platform.util.io.storages.intmultimaps.DurableIntToMultiIntMap;
import com.intellij.platform.util.io.storages.intmultimaps.Int2IntMultimap;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class NonDurableNonParallelIntToMultiIntMap
implements DurableIntToMultiIntMap {
    private final Int2IntMultimap multimap;

    public NonDurableNonParallelIntToMultiIntMap() {
        this.multimap = new Int2IntMultimap();
    }

    public NonDurableNonParallelIntToMultiIntMap(int capacity, float loadFactor) {
        this.multimap = new Int2IntMultimap(capacity, loadFactor);
    }

    @Override
    public synchronized boolean put(int key, int value) throws IOException {
        return this.multimap.put(key, value);
    }

    @Override
    public synchronized boolean replace(int key, int oldValue, int newValue) throws IOException {
        return this.multimap.replace(key, oldValue, newValue);
    }

    @Override
    public synchronized boolean has(int key, int value) throws IOException {
        return this.multimap.has(key, value);
    }

    @Override
    public synchronized int lookup(int key, @NotNull DurableIntToMultiIntMap.ValueAcceptor valuesAcceptor) throws IOException {
        if (valuesAcceptor == null) {
            NonDurableNonParallelIntToMultiIntMap.$$$reportNull$$$0(0);
        }
        IntRef returnValue = new IntRef(0);
        this.multimap.lookup(key, (int value) -> {
            try {
                if (valuesAcceptor.accept(value)) {
                    returnValue.set(value);
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        return returnValue.get();
    }

    @Override
    public synchronized int lookupOrInsert(int key, @NotNull DurableIntToMultiIntMap.ValueAcceptor valuesAcceptor, @NotNull DurableIntToMultiIntMap.ValueCreator valueCreator) throws IOException {
        if (valuesAcceptor == null) {
            NonDurableNonParallelIntToMultiIntMap.$$$reportNull$$$0(1);
        }
        if (valueCreator == null) {
            NonDurableNonParallelIntToMultiIntMap.$$$reportNull$$$0(2);
        }
        IntRef returnValue = new IntRef(0);
        this.multimap.lookup(key, (int value) -> {
            try {
                if (valuesAcceptor.accept(value)) {
                    returnValue.set(value);
                    return false;
                }
                return true;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
        if (returnValue.get() != 0) {
            return returnValue.get();
        }
        int newValue = valueCreator.newValueForKey(key);
        this.multimap.put(key, newValue);
        return newValue;
    }

    @Override
    public synchronized boolean remove(int key, int value) throws IOException {
        return this.multimap.remove(key, value);
    }

    @Override
    public synchronized int size() {
        return this.multimap.size();
    }

    @Override
    public synchronized boolean isEmpty() throws IOException {
        return this.multimap.size() == 0;
    }

    @Override
    public synchronized boolean forEach(@NotNull DurableIntToMultiIntMap.KeyValueProcessor processor) {
        if (processor == null) {
            NonDurableNonParallelIntToMultiIntMap.$$$reportNull$$$0(3);
        }
        return this.multimap.forEach((int key, int value) -> {
            try {
                return processor.process(key, value);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Override
    public synchronized void clear() throws IOException {
        this.multimap.clear();
    }

    @Override
    public synchronized boolean isClosed() {
        return false;
    }

    @Override
    public synchronized void flush() throws IOException {
    }

    @Override
    public synchronized void close() throws IOException {
    }

    public synchronized void closeAndClean() throws IOException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valuesAcceptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueCreator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/intmultimaps/NonDurableNonParallelIntToMultiIntMap";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "lookup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupOrInsert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "forEach";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

