/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import com.intellij.util.io.blobstorage.ByteBufferWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public interface DataExternalizerEx<T> {
    public T read(@NotNull ByteBuffer var1) throws IOException;

    public KnownSizeRecordWriter writerFor(@NotNull T var1) throws IOException;

    default public boolean isRecordSizeConstant() {
        return this.recordSizeIfConstant() > 0;
    }

    default public int recordSizeIfConstant() {
        return -1;
    }

    public static <K> DataExternalizerEx<K> adapt(final @NotNull DataExternalizer<K> oldSchoolDescriptor) {
        if (oldSchoolDescriptor == null) {
            DataExternalizerEx.$$$reportNull$$$0(0);
        }
        if (oldSchoolDescriptor instanceof KeyDescriptor) {
            return KeyDescriptorEx.adapt((KeyDescriptor)oldSchoolDescriptor);
        }
        if (oldSchoolDescriptor instanceof DataExternalizerEx) {
            return (DataExternalizerEx)oldSchoolDescriptor;
        }
        return new DataExternalizerEx<K>(){

            @Override
            public K read(@NotNull ByteBuffer input) throws IOException {
                if (input == null) {
                    1.$$$reportNull$$$0(0);
                }
                int bytesAvailable = input.remaining();
                byte[] contentAsArray = new byte[bytesAvailable];
                input.get(contentAsArray);
                return oldSchoolDescriptor.read((DataInput)new DataInputStream((InputStream)new UnsyncByteArrayInputStream(contentAsArray)));
            }

            @Override
            public KnownSizeRecordWriter writerFor(@NotNull K key) throws IOException {
                if (key == null) {
                    1.$$$reportNull$$$0(1);
                }
                UnsyncByteArrayOutputStream stream = new UnsyncByteArrayOutputStream(64);
                try (DataOutputStream os = new DataOutputStream((OutputStream)stream);){
                    oldSchoolDescriptor.save((DataOutput)os, key);
                }
                ByteArraySequence byteArraySequence = stream.toByteArraySequence();
                return new ByteArrayWriter(byteArraySequence.getInternalBuffer(), byteArraySequence.getOffset(), byteArraySequence.getLength());
            }

            public String toString() {
                return "DataExternalizerAdapter[adapted: " + String.valueOf(oldSchoolDescriptor) + "]";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "input";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "key";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/platform/util/io/storages/DataExternalizerEx$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "writerFor";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    public static KnownSizeRecordWriter fromBytes(byte @NotNull [] bytes) {
        if (bytes == null) {
            DataExternalizerEx.$$$reportNull$$$0(1);
        }
        return new ByteArrayWriter(bytes, 0, bytes.length);
    }

    public static KnownSizeRecordWriter fromBytes(@NotNull ByteArraySequence bytes) {
        if (bytes == null) {
            DataExternalizerEx.$$$reportNull$$$0(2);
        }
        return new ByteArrayWriter(bytes.getInternalBuffer(), bytes.getOffset(), bytes.getLength());
    }

    public static KnownSizeRecordWriter fromBytes(byte @NotNull [] bytes, int offset, int length) {
        if (bytes == null) {
            DataExternalizerEx.$$$reportNull$$$0(3);
        }
        return new ByteArrayWriter(bytes, offset, length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSchoolDescriptor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/DataExternalizerEx";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adapt";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "fromBytes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class ByteArrayWriter
    implements ByteArrayExposingWriter {
        private final byte[] bytes;
        private final int startingOffset;
        private final int length;

        public ByteArrayWriter(byte @NotNull [] bytes) {
            if (bytes == null) {
                ByteArrayWriter.$$$reportNull$$$0(0);
            }
            this(bytes, 0, bytes.length);
        }

        public ByteArrayWriter(byte @NotNull [] bytes, int startingOffset, int length) {
            if (bytes == null) {
                ByteArrayWriter.$$$reportNull$$$0(1);
            }
            this.bytes = bytes;
            this.startingOffset = startingOffset;
            this.length = length;
        }

        @Override
        public ByteBuffer write(@NotNull ByteBuffer data) throws IOException {
            if (data == null) {
                ByteArrayWriter.$$$reportNull$$$0(2);
            }
            return data.put(this.bytes, this.startingOffset, this.length);
        }

        @Override
        public int recordSize() {
            return this.length;
        }

        public String toString() {
            return "ByteArrayWriter[" + IOUtil.toHexString((byte[])Arrays.copyOfRange(this.bytes, this.startingOffset, this.startingOffset + this.length)) + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bytes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/DataExternalizerEx$ByteArrayWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ByteArrayExposingWriter
    extends KnownSizeRecordWriter {
    }

    public static interface KnownSizeRecordWriter
    extends ByteBufferWriter {
        public static final KnownSizeRecordWriter NOTHING = new KnownSizeRecordWriter(){

            @Override
            public ByteBuffer write(@NotNull ByteBuffer data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return data;
            }

            @Override
            public int recordSize() {
                return 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/platform/util/io/storages/DataExternalizerEx$KnownSizeRecordWriter$1", "write"));
            }
        };

        public ByteBuffer write(@NotNull ByteBuffer var1) throws IOException;

        public int recordSize();
    }
}

