/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.appendonlylog;

import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.io.ContentTooBigException;
import com.intellij.platform.util.io.storages.AlignmentUtils;
import com.intellij.platform.util.io.storages.appendonlylog.AppendOnlyLog;
import com.intellij.platform.util.io.storages.mmapped.MMappedFileStorage;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.ClosedStorageException;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.Unmappable;
import com.intellij.util.io.blobstorage.ByteBufferReader;
import com.intellij.util.io.blobstorage.ByteBufferWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public final class AppendOnlyLogOverMMappedFile
implements AppendOnlyLog,
Unmappable {
    private static final boolean MORE_DIAGNOSTIC_INFORMATION = SystemProperties.getBooleanProperty((String)"AppendOnlyLogOverMMappedFile.MORE_DIAGNOSTIC_INFORMATION", (boolean)true);
    private static final boolean APPEND_LOG_DUMP_ON_ERROR = SystemProperties.getBooleanProperty((String)"AppendOnlyLogOverMMappedFile.APPEND_LOG_DUMP_ON_ERROR", (boolean)true);
    private static final int DEBUG_DUMP_REGION_WIDTH = 256;
    private static final int MAX_RECORD_SIZE_TO_DUMP = SystemProperties.getIntProperty((String)"AppendOnlyLogOverMMappedFile.MAX_RECORD_SIZE_TO_DUMP", (int)256);
    private static final VarHandle INT32_OVER_BYTE_BUFFER = MethodHandles.byteBufferViewVarHandle(int[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private static final VarHandle INT64_OVER_BYTE_BUFFER = MethodHandles.byteBufferViewVarHandle(long[].class, ByteOrder.nativeOrder()).withInvokeExactBehavior();
    private static final int UNSET_VALUE = 0;
    public static final int MAGIC_WORD = IOUtil.asciiToMagicWord((String)"AOLM");
    public static final int CURRENT_IMPLEMENTATION_VERSION = 2;
    public static final int MAX_PAYLOAD_SIZE = 0x3FFFFFFF;
    @NotNull
    private final MMappedFileStorage storage;
    private transient MMappedFileStorage.Page headerPage;
    private final long startOfRecoveredRegion;
    private final long endOfRecoveredRegion;
    private final boolean wasClosedProperly;

    public AppendOnlyLogOverMMappedFile(@NotNull MMappedFileStorage storage) throws IOException {
        long nextRecordToBeCommittedOffset;
        if (storage == null) {
            AppendOnlyLogOverMMappedFile.$$$reportNull$$$0(0);
        }
        this.storage = storage;
        boolean fileIsEmpty = storage.actualFileSize() == 0L;
        int pageSize = storage.pageSize();
        if (!AlignmentUtils.is32bAligned(pageSize)) {
            throw new IllegalArgumentException("storage.pageSize(=" + pageSize + ") must be 32b-aligned");
        }
        this.headerPage = storage.pageByOffset(0L);
        ByteBuffer headerPageBuffer = this.headerPageBuffer();
        if (fileIsEmpty) {
            HeaderLayout.putMagicWord(headerPageBuffer, MAGIC_WORD);
            HeaderLayout.putImplementationVersion(headerPageBuffer, 2);
            HeaderLayout.putPageSize(headerPageBuffer, pageSize);
        } else {
            AppendOnlyLogOverMMappedFile.checkFileParamsCompatible(storage.storagePath(), headerPageBuffer, pageSize);
        }
        long nextRecordToBeAllocatedOffset = this.getLongHeaderField(16);
        if (nextRecordToBeAllocatedOffset == 0L) {
            nextRecordToBeAllocatedOffset = 64L;
            this.setLongHeaderField(16, nextRecordToBeAllocatedOffset);
        }
        if ((nextRecordToBeCommittedOffset = this.getLongHeaderField(24)) == 0L) {
            nextRecordToBeCommittedOffset = 64L;
            this.setLongHeaderField(24, nextRecordToBeCommittedOffset);
        }
        if (nextRecordToBeCommittedOffset < nextRecordToBeAllocatedOffset) {
            this.startOfRecoveredRegion = nextRecordToBeCommittedOffset;
            this.endOfRecoveredRegion = nextRecordToBeAllocatedOffset;
            long successfullyRecoveredUntil = this.recoverRegion(nextRecordToBeCommittedOffset, nextRecordToBeAllocatedOffset);
            long fileSize = storage.actualFileSize();
            if (fileSize < successfullyRecoveredUntil) {
                throw new AssertionError((Object)("file(=" + String.valueOf(storage.storagePath()) + ").size(=" + fileSize + ") < recoveredUntil(=" + successfullyRecoveredUntil + ")"));
            }
            storage.zeroizeTillEOF(successfullyRecoveredUntil);
            nextRecordToBeCommittedOffset = successfullyRecoveredUntil;
            nextRecordToBeAllocatedOffset = successfullyRecoveredUntil;
            IntRef recordsCount = new IntRef(0);
            this.forEachRecord((recordId, buffer) -> {
                recordsCount.inc();
                return true;
            }, successfullyRecoveredUntil);
            this.setIntHeaderField(32, recordsCount.get());
        } else {
            this.startOfRecoveredRegion = -1L;
            this.endOfRecoveredRegion = -1L;
        }
        this.wasClosedProperly = this.getIntHeaderField(36) == 0;
        this.setIntHeaderField(36, 1);
        storage.fsync();
        this.setLongHeaderField(16, nextRecordToBeAllocatedOffset);
        this.setLongHeaderField(24, nextRecordToBeCommittedOffset);
    }

    public int getImplementationVersion() throws IOException {
        return HeaderLayout.readImplementationVersion(this.headerPageBuffer());
    }

    public int getDataVersion() throws IOException {
        return this.getIntHeaderField(8);
    }

    public void setDataVersion(int version) throws IOException {
        this.setIntHeaderField(8, version);
    }

    @Override
    public int recordsCount() throws IOException {
        return this.getIntHeaderField(32);
    }

    public int getUserDefinedHeaderField(int fieldNo) throws IOException {
        int headerOffset = 40 + fieldNo * 4;
        return this.getIntHeaderField(headerOffset);
    }

    public void setUserDefinedHeaderField(int fieldNo, int headerFieldValue) throws IOException {
        int headerOffset = 40 + fieldNo * 4;
        this.setIntHeaderField(headerOffset, headerFieldValue);
    }

    public boolean wasRecoveryNeeded() {
        return this.startOfRecoveredRegion >= 0L && this.endOfRecoveredRegion > this.startOfRecoveredRegion;
    }

    public Path storagePath() {
        return this.storage.storagePath();
    }

    @Override
    public long append(@NotNull ByteBufferWriter writer, int payloadSize) throws IOException {
        if (writer == null) {
            AppendOnlyLogOverMMappedFile.$$$reportNull$$$0(1);
        }
        if (payloadSize < 0) {
            throw new IllegalArgumentException("Can't write record with payloadSize(=" + payloadSize + ") < 0");
        }
        int pageSize = this.storage.pageSize();
        if (payloadSize > pageSize - 4) {
            throw new ContentTooBigException("payloadSize(=" + payloadSize + ") is too big: record with header must fit pageSize(=" + pageSize + ")");
        }
        int totalRecordLength = RecordLayout.calculateRecordLength(payloadSize);
        long recordOffsetInFile = this.allocateSpaceForRecord(totalRecordLength);
        AlignmentUtils.assert32bAligned(recordOffsetInFile, "recordOffsetInFile");
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        int offsetInPage = this.storage.toOffsetInPage(recordOffsetInFile);
        RecordLayout.putDataRecord(page.rawPageBuffer(), offsetInPage, payloadSize, writer);
        this.tryCommitRecord(recordOffsetInFile, totalRecordLength);
        return AppendOnlyLogOverMMappedFile.recordOffsetToId(recordOffsetInFile);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T read(long recordId, @NotNull ByteBufferReader<T> byteBufferReader) throws IOException {
        void reader;
        long recordsAllocatedUpTo;
        long recordOffsetInFile;
        if (byteBufferReader == null) {
            AppendOnlyLogOverMMappedFile.$$$reportNull$$$0(2);
        }
        if ((recordOffsetInFile = AppendOnlyLogOverMMappedFile.recordIdToOffset(recordId)) >= (recordsAllocatedUpTo = this.firstUnAllocatedOffset())) {
            throw new IllegalArgumentException("Can't read recordId(=" + recordId + ", offset: " + recordOffsetInFile + "]: outside of allocated region [<" + recordsAllocatedUpTo + "] " + this.moreDiagnosticInfo(recordOffsetInFile));
        }
        MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
        int recordOffsetInPage = this.storage.toOffsetInPage(recordOffsetInFile);
        ByteBuffer pageBuffer = page.rawPageBuffer();
        int recordHeader = RecordLayout.readHeader(pageBuffer, recordOffsetInPage);
        if (!RecordLayout.isDataHeader(recordHeader)) {
            throw new IOException("record[" + recordId + "][@" + recordOffsetInFile + "] is PaddingRecord(header=" + Integer.toHexString(recordHeader) + ") -- i.e. has no data. " + this.moreDiagnosticInfo(recordOffsetInFile));
        }
        if (!RecordLayout.isRecordCommitted(recordHeader)) {
            throw new IOException("record[" + recordId + "][@" + recordOffsetInFile + "] is not commited: (header=" + Integer.toHexString(recordHeader) + ") either not yet written or corrupted. " + this.moreDiagnosticInfo(recordOffsetInFile) + (String)(APPEND_LOG_DUMP_ON_ERROR ? "\n" + this.dumpContentAroundId(recordId, 256, MAX_RECORD_SIZE_TO_DUMP) : ""));
        }
        int payloadLength = RecordLayout.extractPayloadLength(recordHeader);
        if (!RecordLayout.isFitIntoPage(pageBuffer, recordOffsetInPage, payloadLength)) {
            throw new IOException("record[" + recordId + "][@" + recordOffsetInFile + "].payloadLength(=" + payloadLength + ") is incorrect: page[0.." + pageBuffer.limit() + "], committedUpTo: " + this.firstUnCommittedOffset() + ", allocatedUpTo: " + this.firstUnAllocatedOffset() + ". " + this.moreDiagnosticInfo(recordOffsetInFile) + (String)(APPEND_LOG_DUMP_ON_ERROR ? "\n" + this.dumpContentAroundId(recordId, 256, MAX_RECORD_SIZE_TO_DUMP) : ""));
        }
        ByteBuffer recordDataSlice = pageBuffer.slice(recordOffsetInPage + 4, payloadLength).order(pageBuffer.order());
        return (T)reader.read(recordDataSlice);
    }

    @Override
    public boolean isValidId(long recordId) throws IOException {
        if (recordId <= 0L) {
            return false;
        }
        long recordOffset = AppendOnlyLogOverMMappedFile.recordIdToOffsetUnchecked(recordId);
        if (!AlignmentUtils.is32bAligned(recordOffset)) {
            return false;
        }
        return recordOffset < this.firstUnAllocatedOffset();
    }

    @Override
    public boolean forEachRecord(@NotNull AppendOnlyLog.RecordReader reader) throws IOException {
        if (reader == null) {
            AppendOnlyLogOverMMappedFile.$$$reportNull$$$0(3);
        }
        long firstUnallocatedOffset = this.firstUnAllocatedOffset();
        return this.forEachRecord(reader, firstUnallocatedOffset);
    }

    public void clear() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet");
    }

    @Override
    public void flush() throws IOException {
        this.flush(MMappedFileStorage.FSYNC_ON_FLUSH_BY_DEFAULT);
    }

    public void flush(boolean fsync) throws IOException {
        if (fsync) {
            this.storage.fsync();
        }
    }

    @Override
    public boolean isEmpty() throws IOException {
        return this.firstUnAllocatedOffset() == 64L && this.firstUnCommittedOffset() == 64L;
    }

    public boolean wasClosedProperly() {
        return this.wasClosedProperly;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.storage.isOpen()) {
            this.setIntHeaderField(36, 0);
            this.flush();
            this.storage.close();
            this.headerPage = null;
        }
    }

    public void closeAndUnsafelyUnmap() throws IOException {
        this.close();
        this.storage.closeAndUnsafelyUnmap();
    }

    public void closeAndClean() throws IOException {
        this.close();
        this.storage.closeAndClean();
    }

    public String toString() {
        return "AppendOnlyLogOverMMappedFile[" + String.valueOf(this.storage.storagePath()) + "]{wasClosedProperly: " + this.wasClosedProperly + "}";
    }

    public static void checkFileParamsCompatible(@NotNull Path storagePath, @NotNull ByteBuffer headerPageBuffer, int pageSize) throws IOException {
        int magicWord;
        if (storagePath == null) {
            AppendOnlyLogOverMMappedFile.$$$reportNull$$$0(4);
        }
        if (headerPageBuffer == null) {
            AppendOnlyLogOverMMappedFile.$$$reportNull$$$0(5);
        }
        if ((magicWord = HeaderLayout.readMagicWord(headerPageBuffer)) != MAGIC_WORD) {
            throw new IOException("[" + String.valueOf(storagePath) + "] is of incorrect type: .magicWord(=" + magicWord + ", '" + IOUtil.magicWordToASCII((int)magicWord) + "') != " + MAGIC_WORD + " expected");
        }
        int implementationVersion = HeaderLayout.readImplementationVersion(headerPageBuffer);
        if (implementationVersion != 2) {
            throw new IOException("[" + String.valueOf(storagePath) + "].implementationVersion(=" + implementationVersion + ") is not supported: 2 is the currently supported version.");
        }
        int filePageSize = HeaderLayout.readPageSize(headerPageBuffer);
        if (pageSize != filePageSize) {
            throw new IOException("[" + String.valueOf(storagePath) + "]: file created with pageSize=" + filePageSize + " but current storage.pageSize=" + pageSize);
        }
    }

    private long allocateSpaceForRecord(int totalRecordLength) throws IOException {
        long recordOffsetInFile;
        int recordOffsetInPage;
        int remainingOnPage;
        int pageSize = this.storage.pageSize();
        if (totalRecordLength > pageSize) {
            throw new IllegalArgumentException("totalRecordLength(=" + totalRecordLength + ") must fit the page(=" + pageSize + ")");
        }
        while (true) {
            if (totalRecordLength <= (remainingOnPage = pageSize - (recordOffsetInPage = this.storage.toOffsetInPage(recordOffsetInFile = this.firstUnAllocatedOffset())))) {
                if (!this.casFirstUnAllocatedOffset(recordOffsetInFile, recordOffsetInFile + (long)totalRecordLength)) continue;
                return recordOffsetInFile;
            }
            if (remainingOnPage < 4) break;
            if (!this.casFirstUnAllocatedOffset(recordOffsetInFile, recordOffsetInFile + (long)remainingOnPage)) continue;
            MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
            RecordLayout.putPaddingRecord(page.rawPageBuffer(), recordOffsetInPage);
        }
        throw new AssertionError((Object)("Bug: remainingOnPage(=" + remainingOnPage + ") < RECORD_HEADER(=4),but records must be 32b-aligned, so it must never happen. recordOffsetInFile(=" + recordOffsetInFile + "), recordOffsetInPage(=" + recordOffsetInPage + "), totalRecordLength(=" + totalRecordLength + ")"));
    }

    private void tryCommitRecord(long currentRecordOffsetInFile, int totalRecordLength) throws IOException {
        this.tryCommitFinalizedRecords();
    }

    private void tryCommitFinalizedRecords() throws IOException {
        int dataRecordsToCommit;
        long nextUncommittedRecordOffset;
        long firstUnCommittedRecordOffset;
        do {
            nextUncommittedRecordOffset = firstUnCommittedRecordOffset = this.firstUnCommittedOffset();
            long allocatedUpTo = this.firstUnAllocatedOffset();
            dataRecordsToCommit = 0;
            while (nextUncommittedRecordOffset < allocatedUpTo) {
                MMappedFileStorage.Page page = this.storage.pageByOffset(nextUncommittedRecordOffset);
                int offsetInPage = this.storage.toOffsetInPage(nextUncommittedRecordOffset);
                int recordHeader = RecordLayout.readHeader(page.rawPageBuffer(), offsetInPage);
                int totalRecordLength = RecordLayout.extractRecordLength(recordHeader);
                if (totalRecordLength == 0) break;
                if (RecordLayout.isDataHeader(recordHeader)) {
                    ++dataRecordsToCommit;
                }
                nextUncommittedRecordOffset = this.nextRecordOffset(nextUncommittedRecordOffset, totalRecordLength);
            }
            if (nextUncommittedRecordOffset != firstUnCommittedRecordOffset) continue;
            return;
        } while (!this.casFirstUnCommittedOffset(firstUnCommittedRecordOffset, nextUncommittedRecordOffset));
        this.addToDataRecordsCount(dataRecordsToCommit);
    }

    private long nextRecordOffset(long recordOffsetInFile, int totalRecordLength) {
        AlignmentUtils.assert32bAligned(recordOffsetInFile, "recordOffsetInFile");
        long nextRecordOffset = AlignmentUtils.roundUpToInt32(recordOffsetInFile + (long)totalRecordLength);
        int pageSize = this.storage.pageSize();
        int offsetInPage = this.storage.toOffsetInPage(nextRecordOffset);
        int remainingOnPage = pageSize - offsetInPage;
        if (remainingOnPage < 4) {
            throw new IllegalStateException("remainingOnPage(=" + remainingOnPage + ") <= recordHeader(=4)");
        }
        return nextRecordOffset;
    }

    private long firstUnAllocatedOffset() throws IOException {
        return this.getLongHeaderField(16);
    }

    private boolean casFirstUnAllocatedOffset(long currentValue, long newValue) throws IOException {
        return INT64_OVER_BYTE_BUFFER.compareAndSet(this.headerPageBuffer(), 16, currentValue, newValue);
    }

    private long firstUnCommittedOffset() throws IOException {
        return this.getLongHeaderField(24);
    }

    private boolean casFirstUnCommittedOffset(long currentValue, long newValue) throws IOException {
        return INT64_OVER_BYTE_BUFFER.compareAndSet(this.headerPageBuffer(), 24, currentValue, newValue);
    }

    private int addToDataRecordsCount(int recordsCommitted) throws IOException {
        return INT32_OVER_BYTE_BUFFER.getAndAdd(this.headerPageBuffer(), 32, recordsCommitted);
    }

    private boolean forEachRecord(@NotNull AppendOnlyLog.RecordReader reader, long untilOffset) throws IOException {
        if (reader == null) {
            AppendOnlyLogOverMMappedFile.$$$reportNull$$$0(6);
        }
        int pageSize = this.storage.pageSize();
        long recordOffsetInFile = 64L;
        while (recordOffsetInFile < untilOffset) {
            MMappedFileStorage.Page page = this.storage.pageByOffset(recordOffsetInFile);
            int recordOffsetInPage = this.storage.toOffsetInPage(recordOffsetInFile);
            ByteBuffer pageBuffer = page.rawPageBuffer();
            if (pageSize - recordOffsetInPage < 4) {
                throw new IOException(this.getClass().getSimpleName() + " corrupted: recordOffsetInPage(=" + recordOffsetInPage + ") less than RECORD_HEADER(=4b) left until pageEnd(" + pageSize + ") -- all records must be 32b-aligned");
            }
            int recordHeader = RecordLayout.readHeader(pageBuffer, recordOffsetInPage);
            if (recordHeader == 0) {
                return true;
            }
            int recordLength = RecordLayout.extractRecordLength(recordHeader);
            if (RecordLayout.isDataHeader(recordHeader)) {
                if (RecordLayout.isRecordCommitted(recordHeader)) {
                    int payloadLength = RecordLayout.extractPayloadLength(recordHeader);
                    long recordId = AppendOnlyLogOverMMappedFile.recordOffsetToId(recordOffsetInFile);
                    if (!RecordLayout.isFitIntoPage(pageBuffer, recordOffsetInPage, payloadLength)) {
                        throw new IOException("record[" + recordId + "][@" + recordOffsetInFile + "].payloadLength(=" + payloadLength + "):  is incorrect: page[0.." + pageBuffer.limit() + "]" + this.moreDiagnosticInfo(recordOffsetInFile));
                    }
                    ByteBuffer recordDataSlice = pageBuffer.slice(recordOffsetInPage + 4, payloadLength).order(pageBuffer.order());
                    boolean shouldContinue = reader.read(recordId, recordDataSlice);
                    if (!shouldContinue) {
                        return false;
                    }
                }
            } else if (RecordLayout.isPaddingHeader(recordHeader)) {
                if (!RecordLayout.isRecordCommitted(recordHeader)) {
                    throw new IOException("padding.header(" + recordHeader + ") is not committed -- bug?");
                }
            } else {
                throw new IOException("header(=" + recordHeader + "](@offset=" + recordOffsetInFile + "): not a padding, nor a data record" + this.moreDiagnosticInfo(recordOffsetInFile));
            }
            recordOffsetInFile = this.nextRecordOffset(recordOffsetInFile, recordLength);
        }
        return true;
    }

    private long recoverRegion(long nextRecordToBeCommittedOffset, long nextRecordToBeAllocatedOffset) throws IOException {
        int pageSize = this.storage.pageSize();
        long offsetInFile = nextRecordToBeCommittedOffset;
        while (offsetInFile < nextRecordToBeAllocatedOffset) {
            MMappedFileStorage.Page page = this.storage.pageByOffset(offsetInFile);
            int recordOffsetInPage = this.storage.toOffsetInPage(offsetInFile);
            ByteBuffer pageBuffer = page.rawPageBuffer();
            if (pageSize - recordOffsetInPage <= 4) {
                throw new IOException(this.getClass().getSimpleName() + " corrupted: recordOffsetInPage(=" + recordOffsetInPage + ") less than RECORD_HEADER(=4b) left until pageEnd(" + pageSize + ") -- all records must be 32b-aligned");
            }
            int recordHeader = RecordLayout.readHeader(pageBuffer, recordOffsetInPage);
            int recordLength = RecordLayout.extractRecordLength(recordHeader);
            if (recordLength == 0) {
                return offsetInFile;
            }
            if (RecordLayout.isDataHeader(recordHeader)) {
                if (!RecordLayout.isRecordCommitted(recordHeader)) {
                    RecordLayout.putPaddingRecord(pageBuffer, recordOffsetInPage, recordLength);
                }
            } else if (RecordLayout.isPaddingHeader(recordHeader)) {
                if (!RecordLayout.isRecordCommitted(recordHeader)) {
                    throw new IOException("padding.header(" + recordHeader + ") is not committed -- bug?");
                }
            } else {
                throw new IOException("header(=" + recordHeader + "](@offset=" + offsetInFile + "): not a padding, nor a data record");
            }
            offsetInFile = this.nextRecordOffset(offsetInFile, recordLength);
        }
        return nextRecordToBeAllocatedOffset;
    }

    private String moreDiagnosticInfo(long recordOffsetInFile) {
        if (!MORE_DIAGNOSTIC_INFORMATION) {
            return "";
        }
        if (this.startOfRecoveredRegion < 0L && this.endOfRecoveredRegion < 0L) {
            return "(There was no recovery, it can't be related to it" + (this.wasClosedProperly ? "" : " -- but storage wasn't closed properly") + ")";
        }
        if (recordOffsetInFile >= this.startOfRecoveredRegion && recordOffsetInFile < this.endOfRecoveredRegion) {
            return "(Record is in the recovered region [" + this.startOfRecoveredRegion + ".." + this.endOfRecoveredRegion + ") " + (this.wasClosedProperly ? "" : " and storage wasn't closed properly, ") + "so it may be due to some un-recovered records)";
        }
        return "(There was a recovery " + (this.wasClosedProperly ? "" : "and storage wasn't closed properly, ") + "so it may be due to some un-recovered records, but the record is outside the region [" + this.startOfRecoveredRegion + ".." + this.endOfRecoveredRegion + ") recovered)";
    }

    private String dumpContentAroundId(long aroundRecordId, int regionWidth, int maxRecordSizeToDump) throws IOException {
        StringBuilder sb = new StringBuilder("Log content around id: " + aroundRecordId + " +/- " + regionWidth + " (first uncommitted offset: " + this.firstUnCommittedOffset() + ", first unallocated: " + this.firstUnAllocatedOffset() + ")\n");
        this.forEachRecord((recordId, buffer) -> {
            boolean insideNeighbourRegion;
            long recordOffset = AppendOnlyLogOverMMappedFile.recordIdToOffset(recordId);
            int recordSize = buffer.remaining();
            long nextRecordId = AppendOnlyLogOverMMappedFile.recordOffsetToId(this.nextRecordOffset(recordOffset, recordSize));
            boolean insideQuestionableRecord = recordId <= aroundRecordId && aroundRecordId <= nextRecordId;
            boolean bl = insideNeighbourRegion = aroundRecordId - (long)regionWidth <= recordId && recordId <= aroundRecordId + (long)regionWidth;
            if (insideQuestionableRecord || insideNeighbourRegion) {
                String bufferAsHex = recordSize > maxRecordSizeToDump ? IOUtil.toHexString((ByteBuffer)buffer.limit(buffer.position() + maxRecordSizeToDump).slice()) + " ... " : IOUtil.toHexString((ByteBuffer)buffer.slice());
                sb.append(insideQuestionableRecord ? "*" : "").append("[id: ").append(recordId).append(']').append("[offset: ").append(recordOffset).append(']').append("[len: ").append(recordSize).append(']').append("[hex: ").append(bufferAsHex).append("]\n");
            }
            return recordId <= aroundRecordId + (long)regionWidth;
        });
        return sb.toString();
    }

    @VisibleForTesting
    public static long recordOffsetToId(long recordOffset) {
        AlignmentUtils.assert32bAligned(recordOffset, "recordOffsetInFile");
        return (recordOffset - 64L >> 2) + 1L;
    }

    @VisibleForTesting
    public static long recordIdToOffset(long recordId) {
        if (recordId <= 0L) {
            throw new IllegalArgumentException("recordId(=" + recordId + ") is negative or NULL_ID -- can't be read");
        }
        long offset = AppendOnlyLogOverMMappedFile.recordIdToOffsetUnchecked(recordId);
        if (!AlignmentUtils.is32bAligned(offset)) {
            throw new IllegalArgumentException("recordId(=" + recordId + ") is invalid: recordOffsetInFile(=" + offset + ") is not 32b-aligned");
        }
        return offset;
    }

    private static long recordIdToOffsetUnchecked(long recordId) {
        return (recordId - 1L << 2) + 64L;
    }

    private ByteBuffer headerPageBuffer() throws IOException {
        MMappedFileStorage.Page _headerPage = this.headerPage;
        if (_headerPage == null) {
            throw new ClosedStorageException("[" + String.valueOf(this.storagePath()) + "] is already closed");
        }
        return _headerPage.rawPageBuffer();
    }

    private int getIntHeaderField(int headerRelativeOffsetBytes) throws IOException {
        Objects.checkIndex(headerRelativeOffsetBytes, 61);
        return INT32_OVER_BYTE_BUFFER.getVolatile(this.headerPageBuffer(), headerRelativeOffsetBytes);
    }

    private long getLongHeaderField(int headerRelativeOffsetBytes) throws IOException {
        Objects.checkIndex(headerRelativeOffsetBytes, 57);
        return INT64_OVER_BYTE_BUFFER.getVolatile(this.headerPageBuffer(), headerRelativeOffsetBytes);
    }

    private void setIntHeaderField(int headerRelativeOffsetBytes, int headerFieldValue) throws IOException {
        Objects.checkIndex(headerRelativeOffsetBytes, 61);
        INT32_OVER_BYTE_BUFFER.setVolatile(this.headerPageBuffer(), headerRelativeOffsetBytes, headerFieldValue);
    }

    private void setLongHeaderField(int headerRelativeOffsetBytes, long headerFieldValue) throws IOException {
        Objects.checkIndex(headerRelativeOffsetBytes, 57);
        INT64_OVER_BYTE_BUFFER.setVolatile(this.headerPageBuffer(), headerRelativeOffsetBytes, headerFieldValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storagePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerPageBuffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/appendonlylog/AppendOnlyLogOverMMappedFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "append";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "forEachRecord";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFileParamsCompatible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static final class RecordLayout {
        private static final int RECORD_TYPE_MASK = Integer.MIN_VALUE;
        private static final int RECORD_TYPE_DATA = 0;
        private static final int RECORD_TYPE_PADDING = Integer.MIN_VALUE;
        private static final int COMMITED_STATUS_MASK = 0x40000000;
        private static final int COMMITED_STATUS_OK = 0x40000000;
        private static final int COMMITED_STATUS_NOT_YET = 0;
        private static final int RECORD_LENGTH_MASK = 0x3FFFFFFF;
        private static final int HEADER_OFFSET = 0;
        private static final int DATA_OFFSET = 4;
        private static final int RECORD_HEADER_SIZE = 4;

        public static void putDataRecord(@NotNull ByteBuffer buffer, int offsetInBuffer, byte[] data) {
            if (buffer == null) {
                RecordLayout.$$$reportNull$$$0(0);
            }
            INT32_OVER_BYTE_BUFFER.setVolatile(buffer, offsetInBuffer + 0, RecordLayout.dataRecordHeader(data.length, false));
            buffer.put(offsetInBuffer + 4, data);
            INT32_OVER_BYTE_BUFFER.setVolatile(buffer, offsetInBuffer + 0, RecordLayout.dataRecordHeader(data.length, true));
        }

        public static void putDataRecord(@NotNull ByteBuffer buffer, int offsetInBuffer, int payloadSize, ByteBufferWriter writer) throws IOException {
            if (buffer == null) {
                RecordLayout.$$$reportNull$$$0(1);
            }
            INT32_OVER_BYTE_BUFFER.setVolatile(buffer, offsetInBuffer + 0, RecordLayout.dataRecordHeader(payloadSize, false));
            ByteBuffer writableRegionSlice = buffer.slice(offsetInBuffer + 4, payloadSize).order(buffer.order());
            writer.write(writableRegionSlice);
            INT32_OVER_BYTE_BUFFER.setVolatile(buffer, offsetInBuffer + 0, RecordLayout.dataRecordHeader(payloadSize, true));
        }

        public static void putPaddingRecord(@NotNull ByteBuffer buffer, int offsetInBuffer) {
            if (buffer == null) {
                RecordLayout.$$$reportNull$$$0(2);
            }
            int remainsToPad = buffer.capacity() - offsetInBuffer;
            RecordLayout.putPaddingRecord(buffer, offsetInBuffer, remainsToPad);
        }

        private static int dataRecordHeader(int payloadLength, boolean commited) {
            int totalRecordSize = payloadLength + 4;
            if ((totalRecordSize & 0xC0000000) != 0) {
                throw new IllegalArgumentException("totalRecordSize(=" + totalRecordSize + ") must have 2 highest bits 0");
            }
            return totalRecordSize | (commited ? 0x40000000 : 0);
        }

        private static void putPaddingRecord(@NotNull ByteBuffer buffer, int offsetInBuffer, int remainsToPad) {
            if (buffer == null) {
                RecordLayout.$$$reportNull$$$0(3);
            }
            if (remainsToPad < 4) {
                throw new IllegalArgumentException("Can't create PaddingRecord for " + remainsToPad + "b leftover, must be >4 b left:buffer.capacity(=" + buffer.capacity() + "), offsetInBuffer(=" + offsetInBuffer + ")");
            }
            int header = RecordLayout.paddingRecordHeader(remainsToPad);
            INT32_OVER_BYTE_BUFFER.setVolatile(buffer, offsetInBuffer + 0, header);
        }

        private static int paddingRecordHeader(int lengthToPad) {
            if (lengthToPad == 0) {
                throw new IllegalArgumentException("lengthToPad(=" + lengthToPad + ") must be >0");
            }
            int totalRecordSize = lengthToPad;
            if ((totalRecordSize & 0xC0000000) != 0) {
                throw new IllegalArgumentException("lengthToPad(=" + lengthToPad + ") must have 2 highest bits 0");
            }
            return totalRecordSize | Integer.MIN_VALUE | 0x40000000;
        }

        private static int readRecordLength(ByteBuffer buffer, int offsetInBuffer) {
            int header = RecordLayout.readHeader(buffer, offsetInBuffer);
            return RecordLayout.extractRecordLength(header);
        }

        private static int extractRecordLength(int header) {
            return AlignmentUtils.roundUpToInt32(header & 0x3FFFFFFF);
        }

        private static int extractPayloadLength(int header) {
            return (header & 0x3FFFFFFF) - 4;
        }

        private static boolean isPaddingHeader(int header) {
            return (header & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        }

        private static boolean isDataHeader(int header) {
            return (header & Integer.MIN_VALUE) == 0;
        }

        private static boolean isRecordCommitted(int header) {
            return (header & 0x40000000) == 0x40000000;
        }

        public static int readHeader(ByteBuffer buffer, int offsetInBuffer) {
            return INT32_OVER_BYTE_BUFFER.getVolatile(buffer, offsetInBuffer + 0);
        }

        public static int calculateRecordLength(int payloadSize) {
            return AlignmentUtils.roundUpToInt32(payloadSize + 4);
        }

        public static boolean isFitIntoPage(ByteBuffer pageBuffer, int recordOffsetInPage, int payloadLength) {
            return recordOffsetInPage + 4 + payloadLength <= pageBuffer.limit();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "buffer";
            objectArray2[1] = "com/intellij/platform/util/io/storages/appendonlylog/AppendOnlyLogOverMMappedFile$RecordLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putDataRecord";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putPaddingRecord";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class HeaderLayout {
        public static final int MAGIC_WORD_OFFSET = 0;
        public static final int IMPLEMENTATION_VERSION_OFFSET = 4;
        public static final int EXTERNAL_VERSION_OFFSET = 8;
        public static final int PAGE_SIZE_OFFSET = 12;
        public static final int NEXT_RECORD_TO_BE_ALLOCATED_OFFSET = 16;
        public static final int NEXT_RECORD_TO_BE_COMMITTED_OFFSET = 24;
        public static final int RECORDS_COUNT_OFFSET = 32;
        public static final int STORAGE_STATUS = 36;
        private static final int STORAGE_STATUS_OPENED = 1;
        private static final int STORAGE_STATUS_CLOSED = 0;
        public static final int FIRST_UNUSED_OFFSET = 40;
        public static final int HEADER_SIZE = 64;

        public static int readMagicWord(@NotNull ByteBuffer buffer) {
            if (buffer == null) {
                HeaderLayout.$$$reportNull$$$0(0);
            }
            return buffer.getInt(0);
        }

        public static int readImplementationVersion(@NotNull ByteBuffer buffer) {
            if (buffer == null) {
                HeaderLayout.$$$reportNull$$$0(1);
            }
            return buffer.getInt(4);
        }

        public static int readPageSize(@NotNull ByteBuffer buffer) {
            if (buffer == null) {
                HeaderLayout.$$$reportNull$$$0(2);
            }
            return buffer.getInt(12);
        }

        public static void putMagicWord(@NotNull ByteBuffer buffer, int magicWord) {
            if (buffer == null) {
                HeaderLayout.$$$reportNull$$$0(3);
            }
            buffer.putInt(0, magicWord);
        }

        public static void putImplementationVersion(@NotNull ByteBuffer buffer, int implVersion) {
            if (buffer == null) {
                HeaderLayout.$$$reportNull$$$0(4);
            }
            buffer.putInt(4, implVersion);
        }

        public static void putPageSize(@NotNull ByteBuffer buffer, int pageSize) {
            if (buffer == null) {
                HeaderLayout.$$$reportNull$$$0(5);
            }
            buffer.putInt(12, pageSize);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "buffer";
            objectArray2[1] = "com/intellij/platform/util/io/storages/appendonlylog/AppendOnlyLogOverMMappedFile$HeaderLayout";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readMagicWord";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readImplementationVersion";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "readPageSize";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putMagicWord";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putImplementationVersion";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "putPageSize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

