/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.util.io.storages.durablemap;

import com.intellij.platform.util.io.storages.DataExternalizerEx;
import com.intellij.platform.util.io.storages.KeyDescriptorEx;
import com.intellij.platform.util.io.storages.durablemap.EntryExternalizer;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultEntryExternalizer<K, V>
implements EntryExternalizer<K, V> {
    private static final int HEADER_SIZE = 4;
    @NotNull
    private final KeyDescriptorEx<K> keyDescriptor;
    @NotNull
    private final DataExternalizerEx<V> valueExternalizer;

    public DefaultEntryExternalizer(@NotNull KeyDescriptorEx<K> keyDescriptor, @NotNull DataExternalizerEx<V> valueExternalizer) {
        if (keyDescriptor == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(0);
        }
        if (valueExternalizer == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(1);
        }
        this.keyDescriptor = keyDescriptor;
        this.valueExternalizer = valueExternalizer;
    }

    @Override
    public DataExternalizerEx.KnownSizeRecordWriter writerFor(@NotNull K key, @Nullable V value) throws IOException {
        DataExternalizerEx.KnownSizeRecordWriter keyWriter;
        int keySize;
        if (key == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(2);
        }
        if ((keySize = (keyWriter = this.keyDescriptor.writerFor(key)).recordSize()) < 0) {
            throw new AssertionError((Object)("keySize(" + String.valueOf(key) + ")=" + keySize + ": must be strictly positive"));
        }
        if (value == null) {
            return new NullValueEntryWriter(keyWriter);
        }
        DataExternalizerEx.KnownSizeRecordWriter valueWriter = this.valueExternalizer.writerFor(value);
        return new NonNullValueEntryWriter(keyWriter, valueWriter);
    }

    @Override
    @NotNull
    public EntryExternalizer.Entry<K, V> read(@NotNull ByteBuffer input) throws IOException {
        if (input == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(3);
        }
        int header = DefaultEntryExternalizer.readHeader(input);
        int keyRecordSize = DefaultEntryExternalizer.keySize(header);
        boolean valueIsNull = DefaultEntryExternalizer.isValueVoid(header);
        int recordSize = input.remaining();
        ByteBuffer keyRecordSlice = input.position(4).limit(4 + keyRecordSize);
        Object key = this.keyDescriptor.read(keyRecordSlice);
        if (valueIsNull) {
            return new EntryExternalizer.Entry<Object, Object>(key, null);
        }
        ByteBuffer valueRecordSlice = input.position(4 + keyRecordSize).limit(recordSize);
        V candidateValue = this.valueExternalizer.read(valueRecordSlice);
        return new EntryExternalizer.Entry<Object, V>(key, candidateValue);
    }

    @Override
    public DataExternalizerEx.KnownSizeRecordWriter writerForEntryHeader(@NotNull K key) throws IOException {
        DataExternalizerEx.KnownSizeRecordWriter keyWriter;
        int keySize;
        if (key == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(4);
        }
        if ((keySize = (keyWriter = this.keyDescriptor.writerFor(key)).recordSize()) < 0) {
            throw new AssertionError((Object)("keySize(" + String.valueOf(key) + ")=" + keySize + ": must be strictly positive"));
        }
        return new NonNullValueEntryWriter(keyWriter, DataExternalizerEx.KnownSizeRecordWriter.NOTHING);
    }

    @Override
    @Nullable
    public EntryExternalizer.Entry<K, V> readIfKeyMatch(@NotNull ByteBuffer input, @NotNull K expectedKey) throws IOException {
        if (input == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(5);
        }
        if (expectedKey == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(6);
        }
        int header = DefaultEntryExternalizer.readHeader(input);
        int keyRecordSize = DefaultEntryExternalizer.keySize(header);
        boolean valueIsNull = DefaultEntryExternalizer.isValueVoid(header);
        int recordSize = input.remaining();
        ByteBuffer keyRecordSlice = input.position(4).limit(4 + keyRecordSize);
        Object candidateKey = this.keyDescriptor.read(keyRecordSlice);
        if (!this.keyDescriptor.isEqual(expectedKey, candidateKey)) {
            return null;
        }
        if (valueIsNull) {
            return new EntryExternalizer.Entry<K, Object>(expectedKey, null);
        }
        ByteBuffer valueRecordSlice = input.position(4 + keyRecordSize).limit(recordSize);
        V candidateValue = this.valueExternalizer.read(valueRecordSlice);
        return new EntryExternalizer.Entry<K, V>(expectedKey, candidateValue);
    }

    @Override
    @Nullable
    public K readKey(@NotNull ByteBuffer input) throws IOException {
        if (input == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(7);
        }
        int header = DefaultEntryExternalizer.readHeader(input);
        int keyRecordSize = DefaultEntryExternalizer.keySize(header);
        boolean valueIsNull = DefaultEntryExternalizer.isValueVoid(header);
        if (valueIsNull) {
            return null;
        }
        ByteBuffer keyRecordSlice = input.position(4).limit(4 + keyRecordSize);
        return (K)this.keyDescriptor.read(keyRecordSlice);
    }

    private static int readHeader(@NotNull ByteBuffer keyBuffer) {
        if (keyBuffer == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(8);
        }
        return keyBuffer.getInt(0);
    }

    private static void putHeader(@NotNull ByteBuffer keyBuffer, int keySize, boolean valueEmpty) {
        if (keyBuffer == null) {
            DefaultEntryExternalizer.$$$reportNull$$$0(9);
        }
        if (keySize < 0) {
            throw new IllegalArgumentException("keySize(=" + keySize + ") must have highest bit 0");
        }
        if (valueEmpty) {
            int highestBitMask = 32768;
            keyBuffer.putInt(0, keySize | highestBitMask);
        } else {
            keyBuffer.putInt(0, keySize);
        }
    }

    private static int keySize(int header) {
        int highestBitMask = 32768;
        return header & ~highestBitMask;
    }

    private static boolean isValueVoid(int header) {
        int highestBitMask = 32768;
        return (header & highestBitMask) != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyDescriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExternalizer";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedKey";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyBuffer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/DefaultEntryExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "writerFor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writerForEntryHeader";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readIfKeyMatch";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "readKey";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "readHeader";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "putHeader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class NullValueEntryWriter
    extends Record
    implements DataExternalizerEx.KnownSizeRecordWriter {
        @NotNull
        private final DataExternalizerEx.KnownSizeRecordWriter keyWriter;
        private final int keySize;

        NullValueEntryWriter(@NotNull DataExternalizerEx.KnownSizeRecordWriter keyWriter) {
            if (keyWriter == null) {
                NullValueEntryWriter.$$$reportNull$$$0(0);
            }
            this(keyWriter, keyWriter.recordSize());
        }

        private NullValueEntryWriter(@NotNull DataExternalizerEx.KnownSizeRecordWriter keyWriter, int keySize) {
            if (keyWriter == null) {
                NullValueEntryWriter.$$$reportNull$$$0(1);
            }
            this.keyWriter = keyWriter;
            this.keySize = keySize;
        }

        @Override
        public ByteBuffer write(@NotNull ByteBuffer buffer) throws IOException {
            if (buffer == null) {
                NullValueEntryWriter.$$$reportNull$$$0(2);
            }
            DefaultEntryExternalizer.putHeader(buffer, this.keySize, true);
            this.keyWriter.write(buffer.position(4).limit(4 + this.keySize));
            return buffer;
        }

        @Override
        public int recordSize() {
            return 4 + this.keySize;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{NullValueEntryWriter.class, "keyWriter;keySize", "keyWriter", "keySize"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{NullValueEntryWriter.class, "keyWriter;keySize", "keyWriter", "keySize"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{NullValueEntryWriter.class, "keyWriter;keySize", "keyWriter", "keySize"}, this, o);
        }

        @NotNull
        public DataExternalizerEx.KnownSizeRecordWriter keyWriter() {
            DataExternalizerEx.KnownSizeRecordWriter knownSizeRecordWriter = this.keyWriter;
            if (knownSizeRecordWriter == null) {
                NullValueEntryWriter.$$$reportNull$$$0(3);
            }
            return knownSizeRecordWriter;
        }

        public int keySize() {
            return this.keySize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyWriter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/util/io/storages/durablemap/DefaultEntryExternalizer$NullValueEntryWriter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/DefaultEntryExternalizer$NullValueEntryWriter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "keyWriter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "write";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class NonNullValueEntryWriter
    implements DataExternalizerEx.KnownSizeRecordWriter {
        private final DataExternalizerEx.KnownSizeRecordWriter keyWriter;
        private final DataExternalizerEx.KnownSizeRecordWriter valueWriter;
        private final int keySize;
        private final int valueSize;

        NonNullValueEntryWriter(@NotNull DataExternalizerEx.KnownSizeRecordWriter keyWriter, @NotNull DataExternalizerEx.KnownSizeRecordWriter valueWriter) {
            if (keyWriter == null) {
                NonNullValueEntryWriter.$$$reportNull$$$0(0);
            }
            if (valueWriter == null) {
                NonNullValueEntryWriter.$$$reportNull$$$0(1);
            }
            this.keyWriter = keyWriter;
            this.valueWriter = valueWriter;
            this.keySize = keyWriter.recordSize();
            this.valueSize = valueWriter.recordSize();
        }

        @Override
        public ByteBuffer write(@NotNull ByteBuffer buffer) throws IOException {
            if (buffer == null) {
                NonNullValueEntryWriter.$$$reportNull$$$0(2);
            }
            DefaultEntryExternalizer.putHeader(buffer, this.keySize, false);
            this.keyWriter.write(buffer.position(4).limit(4 + this.keySize));
            this.valueWriter.write(buffer.position(4 + this.keySize).limit(4 + this.keySize + this.valueSize));
            return buffer;
        }

        @Override
        public int recordSize() {
            return 4 + this.keySize + this.valueSize;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyWriter";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueWriter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buffer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/platform/util/io/storages/durablemap/DefaultEntryExternalizer$NonNullValueEntryWriter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "write";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

