/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.JavaVersionShimKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0018B1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0011\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003J\u0013\u0010\u000e\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\bH\u0002R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/util/lang/JavaVersion;", "", "feature", "", "minor", "update", "build", "ea", "", "<init>", "(IIIIZ)V", "compareTo", "other", "isAtLeast", "equals", "", "hashCode", "toFeatureString", "", "toFeatureMinorUpdateString", "toString", "formatVersionTo", "upToFeature", "upToUpdate", "Companion", "intellij.platform.util.multiplatform"})
public final class JavaVersion
implements Comparable<JavaVersion> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final int feature;
    @JvmField
    public final int minor;
    @JvmField
    public final int update;
    @JvmField
    public final int build;
    @JvmField
    public final boolean ea;
    private static final int MAX_ACCEPTED_VERSION = 50;

    private JavaVersion(int feature, int minor, int update, int build, boolean ea) {
        this.feature = feature;
        this.minor = minor;
        this.update = update;
        this.build = build;
        this.ea = ea;
        if (!(this.feature >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.minor >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.update >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.build >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public int compareTo(@NotNull JavaVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int diff = this.feature - other.feature;
        if (diff != 0) {
            return diff;
        }
        diff = this.minor - other.minor;
        if (diff != 0) {
            return diff;
        }
        diff = this.update - other.update;
        if (diff != 0) {
            return diff;
        }
        diff = this.build - other.build;
        if (diff != 0) {
            return diff;
        }
        return (this.ea ? 0 : 1) - (other.ea ? 0 : 1);
    }

    public final boolean isAtLeast(int feature) {
        return this.feature >= feature;
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JavaVersion && this.feature == ((JavaVersion)other).feature && this.minor == ((JavaVersion)other).minor && this.update == ((JavaVersion)other).update && this.build == ((JavaVersion)other).build && this.ea == ((JavaVersion)other).ea;
    }

    public int hashCode() {
        int hash = this.feature;
        hash = 31 * hash + this.minor;
        hash = 31 * hash + this.update;
        hash = 31 * hash + this.build;
        hash = 31 * hash + (this.ea ? 1231 : 1237);
        return hash;
    }

    @NotNull
    public final String toFeatureString() {
        return this.formatVersionTo(true, true);
    }

    @NotNull
    public final String toFeatureMinorUpdateString() {
        return this.formatVersionTo(false, true);
    }

    @NotNull
    public String toString() {
        return this.formatVersionTo(false, false);
    }

    private final String formatVersionTo(boolean upToFeature, boolean upToUpdate) {
        StringBuilder sb = new StringBuilder();
        if (this.feature > 8) {
            sb.append(this.feature);
            if (!upToFeature) {
                if (this.minor > 0 || this.update > 0) {
                    sb.append('.').append(this.minor);
                }
                if (this.update > 0) {
                    sb.append('.').append(this.update);
                }
                if (!upToUpdate) {
                    if (this.ea) {
                        sb.append("-ea");
                    }
                    if (this.build > 0) {
                        sb.append('+').append(this.build);
                    }
                }
            }
        } else {
            sb.append("1.").append(this.feature);
            if (!upToFeature) {
                if (this.minor > 0 || this.update > 0 || this.ea || this.build > 0) {
                    sb.append('.').append(this.minor);
                }
                if (this.update > 0) {
                    sb.append('_').append(this.update);
                }
                if (!upToUpdate) {
                    if (this.ea) {
                        sb.append("-ea");
                    }
                    if (this.build > 0) {
                        sb.append("-b").append(this.build);
                    }
                }
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JavaVersion compose(int feature, int minor, int update, int build, boolean ea) throws IllegalArgumentException {
        return Companion.compose(feature, minor, update, build, ea);
    }

    @Deprecated(message="Use CurrentJavaVersion.currentJavaVersion() instead", replaceWith=@ReplaceWith(expression="com.intellij.util.lang.CurrentJavaVersion.currentJavaVersion()", imports={}), level=DeprecationLevel.ERROR)
    @JvmStatic
    @NotNull
    public static final JavaVersion current() {
        return Companion.current();
    }

    @JvmStatic
    @NotNull
    public static final JavaVersion parse(@NotNull String versionString) throws IllegalArgumentException {
        return Companion.parse(versionString);
    }

    @JvmStatic
    @Nullable
    public static final JavaVersion tryParse(@Nullable String versionString) {
        return Companion.tryParse(versionString);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JavaVersion compose(int feature, int minor, int update, int build) throws IllegalArgumentException {
        return Companion.compose(feature, minor, update, build);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JavaVersion compose(int feature, int minor, int update) throws IllegalArgumentException {
        return Companion.compose(feature, minor, update);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JavaVersion compose(int feature, int minor) throws IllegalArgumentException {
        return Companion.compose(feature, minor);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final JavaVersion compose(int feature) throws IllegalArgumentException {
        return Companion.compose(feature);
    }

    public /* synthetic */ JavaVersion(int feature, int minor, int update, int build, boolean ea, DefaultConstructorMarker $constructor_marker) {
        this(feature, minor, update, build, ea);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\fH\u0007J\b\u0010\r\u001a\u00020\u0005H\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/lang/JavaVersion$Companion;", "", "<init>", "()V", "compose", "Lcom/intellij/util/lang/JavaVersion;", "feature", "", "minor", "update", "build", "ea", "", "current", "MAX_ACCEPTED_VERSION", "parse", "versionString", "", "startsWithWord", "s", "word", "tryParse", "intellij.platform.util.multiplatform"})
    @SourceDebugExtension(value={"SMAP\nJavaVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaVersion.kt\ncom/intellij/util/lang/JavaVersion$Companion\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,279:1\n106#2:280\n78#2,22:281\n*S KotlinDebug\n*F\n+ 1 JavaVersion.kt\ncom/intellij/util/lang/JavaVersion$Companion\n*L\n170#1:280\n170#1:281,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final JavaVersion compose(int feature, int minor, int update, int build, boolean ea) throws IllegalArgumentException {
            return new JavaVersion(feature, minor, update, build, ea, null);
        }

        public static /* synthetic */ JavaVersion compose$default(Companion companion, int n, int n2, int n3, int n4, boolean bl, int n5, Object object) throws IllegalArgumentException {
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            if ((n5 & 0x10) != 0) {
                bl = false;
            }
            return companion.compose(n, n2, n3, n4, bl);
        }

        @Deprecated(message="Use CurrentJavaVersion.currentJavaVersion() instead", replaceWith=@ReplaceWith(expression="com.intellij.util.lang.CurrentJavaVersion.currentJavaVersion()", imports={}), level=DeprecationLevel.ERROR)
        @JvmStatic
        @NotNull
        public final JavaVersion current() {
            return JavaVersionShimKt.currentJavaVersionPlatformSpecific();
        }

        @JvmStatic
        @NotNull
        public final JavaVersion parse(@NotNull String versionString) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
            String $this$trim$iv = versionString;
            boolean $i$f$trim22 = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String str = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            Pair[] $i$f$trim22 = new Pair[]{TuplesKt.to((Object)"Runtime Environment", (Object)"(build "), TuplesKt.to((Object)"OpenJ9", (Object)"version "), TuplesKt.to((Object)"GraalVM", (Object)"Java ")};
            Map trimmingMap = MapsKt.mapOf((Pair[])$i$f$trim22);
            for (String keyToDetect : trimmingMap.keySet()) {
                if (!StringsKt.contains$default((CharSequence)str, (CharSequence)keyToDetect, (boolean)false, (int)2, null)) continue;
                CharSequence charSequence = str;
                Object v = trimmingMap.get(keyToDetect);
                Intrinsics.checkNotNull(v);
                int p = StringsKt.indexOf$default((CharSequence)charSequence, (String)((String)v), (int)0, (boolean)false, (int)6, null);
                if (p <= 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)str.substring(p), (String)"substring(...)");
            }
            List numbers = new ArrayList();
            List separators = new ArrayList();
            int length = str.length();
            int p = 0;
            boolean number = false;
            while (p < length) {
                String part;
                int start = p;
                while (p < length && Character.isDigit(str.charAt(p)) == number) {
                    ++p;
                }
                Intrinsics.checkNotNullExpressionValue((Object)str.substring(start, p), (String)"substring(...)");
                (number ? numbers : separators).add(part);
                number = !number;
            }
            if (!numbers.isEmpty() && !separators.isEmpty()) {
                try {
                    int feature = Integer.parseInt((String)numbers.get(0));
                    int minor = 0;
                    int update = 0;
                    int build = 0;
                    boolean ea = false;
                    boolean bl = 5 <= feature ? feature < 50 : false;
                    if (bl) {
                        for (p = 1; p < separators.size() && Intrinsics.areEqual((Object)".", separators.get(p)); ++p) {
                        }
                        if (p > 1 && numbers.size() > 2) {
                            minor = Integer.parseInt((String)numbers.get(1));
                            update = Integer.parseInt((String)numbers.get(2));
                        }
                        if (p < separators.size()) {
                            String s = (String)separators.get(p);
                            if (!(((CharSequence)s).length() == 0) && s.charAt(0) == '-') {
                                boolean bl3 = ea = this.startsWithWord(s, "-ea") || this.startsWithWord(s, "-internal");
                                if (p < numbers.size() && s.charAt(s.length() - 1) == '+') {
                                    build = Integer.parseInt((String)numbers.get(p));
                                }
                                ++p;
                            }
                            if (build == 0 && p < separators.size() && p < numbers.size() && Intrinsics.areEqual((Object)"+", separators.get(p))) {
                                build = Integer.parseInt((String)numbers.get(p));
                            }
                        }
                        return new JavaVersion(feature, minor, update, build, ea, null);
                    }
                    if (feature == 1 && numbers.size() > 1 && separators.size() > 1 && Intrinsics.areEqual((Object)".", separators.get(1)) && (feature = Integer.parseInt((String)numbers.get(1))) <= 50) {
                        if (numbers.size() > 2 && separators.size() > 2 && Intrinsics.areEqual((Object)".", separators.get(2))) {
                            minor = Integer.parseInt((String)numbers.get(2));
                            if (numbers.size() > 3 && separators.size() > 3 && Intrinsics.areEqual((Object)"_", separators.get(3))) {
                                update = Integer.parseInt((String)numbers.get(3));
                                if (separators.size() > 4) {
                                    String s = (String)separators.get(4);
                                    if (!(((CharSequence)s).length() == 0) && s.charAt(0) == '-') {
                                        ea = this.startsWithWord(s, "-ea") || this.startsWithWord(s, "-internal");
                                    }
                                    for (p = 4; p < separators.size() && !StringsKt.endsWith$default((String)((String)separators.get(p)), (String)"-b", (boolean)false, (int)2, null); ++p) {
                                    }
                                    if (p < numbers.size()) {
                                        build = Integer.parseInt((String)numbers.get(p));
                                    }
                                }
                            }
                        }
                        return new JavaVersion(feature, minor, update, build, ea, null);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException(versionString);
        }

        private final boolean startsWithWord(String s, String word) {
            return StringsKt.startsWith$default((String)s, (String)word, (boolean)false, (int)2, null) && (s.length() == word.length() || !Character.isLetterOrDigit(s.charAt(word.length())));
        }

        @JvmStatic
        @Nullable
        public final JavaVersion tryParse(@Nullable String versionString) {
            if (versionString != null) {
                try {
                    return this.parse(versionString);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return null;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final JavaVersion compose(int feature, int minor, int update, int build) throws IllegalArgumentException {
            return com.intellij.util.lang.JavaVersion$Companion.compose$default(this, feature, minor, update, build, false, 16, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final JavaVersion compose(int feature, int minor, int update) throws IllegalArgumentException {
            return com.intellij.util.lang.JavaVersion$Companion.compose$default(this, feature, minor, update, 0, false, 24, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final JavaVersion compose(int feature, int minor) throws IllegalArgumentException {
            return com.intellij.util.lang.JavaVersion$Companion.compose$default(this, feature, minor, 0, 0, false, 28, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final JavaVersion compose(int feature) throws IllegalArgumentException {
            return com.intellij.util.lang.JavaVersion$Companion.compose$default(this, feature, 0, 0, 0, false, 30, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

