/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.svg.AdaptiveImageOrigin;
import com.intellij.ui.svg.AdaptiveImageRenderer;
import com.intellij.ui.svg.AdaptiveImageRendererEvent;
import com.intellij.ui.svg.AdaptiveImageViewKt;
import com.intellij.ui.svg.AdaptiveImagesManager;
import com.intellij.ui.svg.FloatDimensions;
import com.intellij.ui.svg.ImageDimension;
import com.intellij.ui.svg.ViewState;
import com.intellij.util.DataUrl;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.html.UtilsKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0017\u0018\u0000 L2\u00020\u0001:\u0001LB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0017H\u0002J\u0010\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0019H\u0002J\n\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0019H\u0016J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000203H\u0016J\"\u00108\u001a\u0004\u0018\u0001032\u0006\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u0002032\u0006\u0010;\u001a\u00020<H\u0016J3\u0010=\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u000b2\u0006\u0010:\u001a\u0002032\f\u0010>\u001a\b\u0012\u0004\u0012\u00020<0?H\u0016\u00a2\u0006\u0002\u0010@J&\u0010A\u001a\u00020\u001e2\b\u0010B\u001a\u0004\u0018\u00010C2\b\u0010:\u001a\u0004\u0018\u0001032\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010F\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u0019H\u0016J\u0018\u0010G\u001a\u00020\u00172\u0006\u0010H\u001a\u00020\u000b2\u0006\u0010I\u001a\u00020\u000bH\u0002J\u0012\u0010J\u001a\u00020\u001e2\b\u0010K\u001a\u0004\u0018\u00010\u0001H\u0016R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/ui/svg/AdaptiveImageView;", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "<init>", "(Ljavax/swing/text/Element;)V", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "getScaleContext", "()Lcom/intellij/ui/scale/ScaleContext;", "sysScale", "", "getSysScale", "()F", "myImageRenderer", "Lcom/intellij/ui/svg/AdaptiveImageRenderer;", "myState", "Lcom/intellij/ui/svg/ViewState;", "myCachedContainer", "Ljava/awt/Container;", "myCachedDocument", "Ljavax/swing/text/Document;", "myPreferredImageViewDimensions", "Lcom/intellij/ui/svg/FloatDimensions;", "myBorder", "", "myVerticalAlign", "myWidthAttrValue", "myHeightAttrValue", "updateStateFromAttrs", "", "updatePreferredImageViewDimensions", "", "updateRenderDims", "logicalDims", "handleRendererEvent", "evt", "Lcom/intellij/ui/svg/AdaptiveImageRendererEvent;", "getIntAttr", "name", "Ljavax/swing/text/html/HTML$Attribute;", "defaultValue", "getImageOrigin", "Lcom/intellij/ui/svg/AdaptiveImageOrigin;", "getPreferredSpan", "axis", "getToolTipText", "", "x", "y", "allocation", "Ljava/awt/Shape;", "paint", "g", "Ljava/awt/Graphics;", "alloc", "modelToView", "pos", "a", "b", "Ljavax/swing/text/Position$Bias;", "viewToModel", "bias", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "changedUpdate", "e", "Ljavax/swing/event/DocumentEvent;", "f", "Ljavax/swing/text/ViewFactory;", "getAlignment", "computeViewDimensions", "defaultWidth", "defaultHeight", "setParent", "parent", "Companion", "intellij.platform.util.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nAdaptiveImageView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdaptiveImageView.kt\ncom/intellij/ui/svg/AdaptiveImageView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n1#2:299\n434#3:300\n507#3,5:301\n122#4,4:306\n122#4,4:310\n13#4:314\n*S KotlinDebug\n*F\n+ 1 AdaptiveImageView.kt\ncom/intellij/ui/svg/AdaptiveImageView\n*L\n138#1:300\n138#1:301,5\n142#1:306,4\n150#1:310,4\n263#1:314\n*E\n"})
public class AdaptiveImageView
extends View {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private AdaptiveImageRenderer myImageRenderer;
    @NotNull
    private ViewState myState;
    @Nullable
    private Container myCachedContainer;
    @Nullable
    private Document myCachedDocument;
    @NotNull
    private FloatDimensions myPreferredImageViewDimensions;
    private int myBorder;
    private float myVerticalAlign;
    private int myWidthAttrValue;
    private int myHeightAttrValue;
    private static final int DEFAULT_BORDER = 0;
    private static final int DEFAULT_WIDTH = 32;
    private static final int DEFAULT_HEIGHT = 32;
    @NotNull
    public static final String ADAPTIVE_IMAGES_MANAGER_PROPERTY = "adaptiveImagesManager";
    @NotNull
    private static final Logger LOG;

    public AdaptiveImageView(@NotNull Element elem) {
        Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
        super(elem);
        this.myState = new ViewState.Idle();
        this.myPreferredImageViewDimensions = new FloatDimensions(32.0f, 32.0f);
        this.myWidthAttrValue = -1;
        this.myHeightAttrValue = -1;
        this.updateStateFromAttrs();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ScaleContext getScaleContext() {
        Container container = this.myCachedContainer;
        Container container2 = container;
        if (container == null) return null;
        Container container3 = container2;
        Component p0 = container3;
        boolean bl = false;
        if (!StartupUiUtil.isJreHiDPI(p0)) return null;
        Container container4 = container3;
        container2 = container4;
        if (container4 == null) return null;
        container3 = container2;
        ScaleContext.Companion companion = ScaleContext.Companion;
        Component p02 = container3;
        boolean bl2 = false;
        ScaleContext scaleContext = companion.create(p02);
        return scaleContext;
    }

    private final float getSysScale() {
        ScaleContext scaleContext = this.getScaleContext();
        return scaleContext != null ? (float)scaleContext.getScale(ScaleType.SYS_SCALE) : 1.0f;
    }

    private final void updateStateFromAttrs() {
        HTML.Attribute attribute = HTML.Attribute.BORDER;
        Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"BORDER");
        this.myBorder = this.getIntAttr(attribute, 0);
        Object alignment = this.getElement().getAttributes().getAttribute(HTML.Attribute.ALIGN);
        float vAlign = 1.0f;
        if (alignment != null) {
            if (Intrinsics.areEqual((Object)"top", (Object)(alignment = alignment.toString()))) {
                vAlign = 0.0f;
            } else if (Intrinsics.areEqual((Object)"middle", (Object)alignment)) {
                vAlign = 0.5f;
            }
        }
        this.myVerticalAlign = vAlign;
        HTML.Attribute attribute2 = HTML.Attribute.WIDTH;
        Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"WIDTH");
        this.myWidthAttrValue = this.getIntAttr(attribute2, -1);
        HTML.Attribute attribute3 = HTML.Attribute.HEIGHT;
        Intrinsics.checkNotNullExpressionValue((Object)attribute3, (String)"HEIGHT");
        this.myHeightAttrValue = this.getIntAttr(attribute3, -1);
        AdaptiveImageRenderer adaptiveImageRenderer = this.myImageRenderer;
        if (adaptiveImageRenderer != null) {
            adaptiveImageRenderer.setOrigin(this.getImageOrigin());
        }
        this.updatePreferredImageViewDimensions();
    }

    private final boolean updatePreferredImageViewDimensions() {
        FloatDimensions floatDimensions;
        ViewState state = this.myState;
        if (state instanceof ViewState.Loaded) {
            Float logicalHeight;
            Float logicalWidth = switch (WhenMappings.$EnumSwitchMapping$0[((ViewState.Loaded)state).getDims().getWidth().getUnit().ordinal()]) {
                case 1 -> Float.valueOf(((ViewState.Loaded)state).getDims().getWidth().getValue());
                case 2 -> Float.valueOf(((ViewState.Loaded)state).getDims().getWidth().getValue() * 10.0f);
                case 3 -> Float.valueOf(((ViewState.Loaded)state).getDims().getWidth().getValue() * 5.0f);
                default -> null;
            };
            switch (WhenMappings.$EnumSwitchMapping$0[((ViewState.Loaded)state).getDims().getHeight().getUnit().ordinal()]) {
                case 1: {
                    Float f = Float.valueOf(((ViewState.Loaded)state).getDims().getHeight().getValue());
                    break;
                }
                case 2: {
                    Float f = Float.valueOf(((ViewState.Loaded)state).getDims().getHeight().getValue() * 10.0f);
                    break;
                }
                case 3: {
                    Float f = Float.valueOf(((ViewState.Loaded)state).getDims().getHeight().getValue() * 5.0f);
                    break;
                }
                default: {
                    Float f = logicalHeight = null;
                }
            }
            if (logicalHeight == null || logicalWidth == null) {
                logicalWidth = Float.valueOf(((ViewState.Loaded)state).getDims().getFallBack().getWidth());
                logicalHeight = Float.valueOf(((ViewState.Loaded)state).getDims().getFallBack().getHeight());
            }
            floatDimensions = this.computeViewDimensions(logicalWidth.floatValue(), logicalHeight.floatValue());
        } else if (state instanceof ViewState.LoadError || state instanceof ViewState.SrcParseError) {
            icon = AdaptiveImageViewKt.access$getNotLoadedIcon();
            floatDimensions = this.computeViewDimensions(icon.getIconWidth(), icon.getIconHeight());
        } else if (state instanceof ViewState.Idle) {
            icon = AdaptiveImageViewKt.access$getLoadingIcon();
            floatDimensions = this.computeViewDimensions(icon.getIconWidth(), icon.getIconHeight());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        FloatDimensions newDimensions = floatDimensions;
        if (!Intrinsics.areEqual((Object)newDimensions, (Object)this.myPreferredImageViewDimensions)) {
            this.myPreferredImageViewDimensions = newDimensions;
            return true;
        }
        return false;
    }

    private final void updateRenderDims(FloatDimensions logicalDims) {
        block0: {
            AdaptiveImageRenderer adaptiveImageRenderer = this.myImageRenderer;
            if (adaptiveImageRenderer == null) break block0;
            adaptiveImageRenderer.setRenderConfig(logicalDims.getWidth(), logicalDims.getHeight(), this.getSysScale());
        }
    }

    private final void handleRendererEvent(AdaptiveImageRendererEvent evt) {
        block9: {
            block8: {
                ViewState viewState;
                AdaptiveImageRendererEvent adaptiveImageRendererEvent = evt;
                if (adaptiveImageRendererEvent instanceof AdaptiveImageRendererEvent.Loaded) {
                    viewState = new ViewState.Loaded(((AdaptiveImageRendererEvent.Loaded)evt).getDimensions());
                } else if (adaptiveImageRendererEvent instanceof AdaptiveImageRendererEvent.Rasterized) {
                    viewState = new ViewState.Loaded(((AdaptiveImageRendererEvent.Rasterized)evt).getDimensions());
                } else if (adaptiveImageRendererEvent instanceof AdaptiveImageRendererEvent.Error) {
                    viewState = new ViewState.LoadError();
                } else if (adaptiveImageRendererEvent instanceof AdaptiveImageRendererEvent.Unloaded) {
                    viewState = new ViewState.Idle();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                this.myState = viewState;
                if (!this.updatePreferredImageViewDimensions()) break block8;
                this.preferenceChanged(null, true, true);
                break block9;
            }
            Container container = this.getContainer();
            if (container == null) break block9;
            container.repaint();
        }
    }

    private final int getIntAttr(HTML.Attribute name, int defaultValue) {
        Element element = this.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getElement(...)");
        return UtilsKt.getIntAttr(element, name, defaultValue);
    }

    /*
     * WARNING - void declaration
     */
    private final AdaptiveImageOrigin getImageOrigin() {
        void $this$getOrHandleException$iv;
        Object $this$getImageOrigin_u24lambda_u243;
        void $this$filterTo$iv$iv;
        Object object = this.getElement().getAttributes().getAttribute(HTML.Attribute.SRC);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return null;
        }
        String src = string;
        Object $this$filter$iv = src;
        boolean $i$f$filter = false;
        CharSequence charSequence = (CharSequence)$this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(!CharsKt.isWhitespace((char)it))) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String filteredSrc = ((StringBuilder)destination$iv$iv).toString();
        if (DataUrl.Companion.isDataUrl(filteredSrc)) {
            Object $this$getImageOrigin_u24lambda_u241;
            $this$filter$iv = this;
            try {
                $this$getImageOrigin_u24lambda_u241 = (AdaptiveImageView)$this$filter$iv;
                boolean bl = false;
                $this$getImageOrigin_u24lambda_u241 = Result.constructor-impl((Object)new AdaptiveImageOrigin.DataUrl(DataUrl.Companion.parse(filteredSrc)));
            }
            catch (Throwable bl) {
                $this$getImageOrigin_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            Object $this$getOrHandleException$iv2 = $this$getImageOrigin_u24lambda_u241;
            boolean $i$f$getOrHandleException = false;
            Object bl = $this$getOrHandleException$iv2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)bl);
            if (throwable != null) {
                Throwable e$iv = throwable;
                boolean bl2 = false;
                LoggerKt.rethrowControlFlowException((Throwable)e$iv);
                Throwable e = e$iv;
                boolean bl3 = false;
                LOG.warn("Failed to parse data url", e);
            }
            return (AdaptiveImageOrigin)(Result.isFailure-impl((Object)bl) ? null : bl);
        }
        Document document = this.getDocument();
        Intrinsics.checkNotNull((Object)document, (String)"null cannot be cast to non-null type javax.swing.text.html.HTMLDocument");
        URL docBase = ((HTMLDocument)document).getBase();
        Object $i$f$getOrHandleException = this;
        try {
            $this$getImageOrigin_u24lambda_u243 = $i$f$getOrHandleException;
            boolean bl = false;
            String string2 = new URL(docBase, filteredSrc).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            $this$getImageOrigin_u24lambda_u243 = Result.constructor-impl((Object)new AdaptiveImageOrigin.Url(string2));
        }
        catch (Throwable throwable) {
            $this$getImageOrigin_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        $i$f$getOrHandleException = $this$getImageOrigin_u24lambda_u243;
        boolean $i$f$getOrHandleException2 = false;
        void var6_15 = $this$getOrHandleException$iv;
        Throwable throwable = Result.exceptionOrNull-impl((Object)var6_15);
        if (throwable != null) {
            Throwable e$iv = throwable;
            boolean bl = false;
            LoggerKt.rethrowControlFlowException((Throwable)e$iv);
            Throwable e = e$iv;
            boolean bl4 = false;
            LOG.warn("Error generating image src URL", e);
        }
        return (AdaptiveImageOrigin)(Result.isFailure-impl((Object)var6_15) ? null : var6_15);
    }

    @Override
    public float getPreferredSpan(int axis) {
        return switch (axis) {
            case 0 -> this.myPreferredImageViewDimensions.getWidth() + (float)(2 * this.myBorder);
            case 1 -> this.myPreferredImageViewDimensions.getHeight() + (float)(2 * this.myBorder);
            default -> throw new IllegalArgumentException("Invalid axis: " + axis);
        };
    }

    @Override
    @Nullable
    public String getToolTipText(float x, float y, @NotNull Shape allocation) {
        Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        Object object = super.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
        return object instanceof String ? (String)object : null;
    }

    @Override
    public void paint(@NotNull Graphics g, @NotNull Shape alloc) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)alloc, (String)"alloc");
        Rectangle bounds = alloc.getBounds();
        int contentWidth = bounds.width - 2 * this.myBorder;
        int contentHeight = bounds.height - 2 * this.myBorder;
        if (contentWidth <= 0 || contentHeight <= 0) {
            return;
        }
        this.updateRenderDims(new FloatDimensions(contentWidth, contentHeight));
        ViewState viewState = this.myState;
        if (viewState instanceof ViewState.LoadError || viewState instanceof ViewState.SrcParseError) {
            AdaptiveImageViewKt.access$getNotLoadedIcon().paintIcon(null, g, bounds.x + this.myBorder, bounds.y + this.myBorder);
        } else if (viewState instanceof ViewState.Idle || viewState instanceof ViewState.Loaded) {
            BufferedImage image;
            AdaptiveImageRenderer adaptiveImageRenderer = this.myImageRenderer;
            BufferedImage bufferedImage = image = adaptiveImageRenderer != null ? adaptiveImageRenderer.getRenderedImage() : null;
            if (image != null) {
                StartupUiUtil.drawImage(g, image, new Rectangle(bounds.x + this.myBorder, bounds.y + this.myBorder, contentWidth, contentHeight), null);
            } else {
                AdaptiveImageViewKt.access$getLoadingIcon().paintIcon(null, g, bounds.x + this.myBorder, bounds.y + this.myBorder);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    @Nullable
    public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        boolean bl = p0 <= pos ? pos <= p1 : false;
        if (bl) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    @Override
    public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] bias) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)bias, (String)"bias");
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width)) {
            Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Forward, (String)"Forward");
            return this.getStartOffset();
        }
        Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Backward, (String)"Backward");
        return this.getEndOffset();
    }

    @Override
    public void changedUpdate(@Nullable DocumentEvent e, @Nullable Shape a, @Nullable ViewFactory f) {
        super.changedUpdate(e, a, f);
        this.updateStateFromAttrs();
        this.preferenceChanged(null, true, true);
    }

    @Override
    public float getAlignment(int axis) {
        return axis == 1 ? this.myVerticalAlign : super.getAlignment(axis);
    }

    private final FloatDimensions computeViewDimensions(float defaultWidth, float defaultHeight) {
        double aspectRatio = (double)defaultWidth / (double)defaultHeight;
        if (this.myWidthAttrValue >= 0 && this.myHeightAttrValue >= 0) {
            return new FloatDimensions(this.myWidthAttrValue, this.myHeightAttrValue);
        }
        if (this.myWidthAttrValue >= 0) {
            return new FloatDimensions(this.myWidthAttrValue, (float)((double)this.myWidthAttrValue / aspectRatio));
        }
        if (this.myHeightAttrValue >= 0) {
            return new FloatDimensions((float)((double)this.myHeightAttrValue * aspectRatio), this.myHeightAttrValue);
        }
        return new FloatDimensions(defaultWidth, defaultHeight);
    }

    @Override
    public void setParent(@Nullable View parent) {
        AdaptiveImagesManager imagesManager;
        super.setParent(parent);
        this.myCachedContainer = this.getContainer();
        this.myCachedDocument = this.getDocument();
        if (this.myImageRenderer == null && (imagesManager = (AdaptiveImagesManager)this.getDocument().getProperty(ADAPTIVE_IMAGES_MANAGER_PROPERTY)) != null) {
            this.myImageRenderer = imagesManager.createRenderer((Function1<? super AdaptiveImageRendererEvent, Unit>)((Function1)new Function1<AdaptiveImageRendererEvent, Unit>((Object)this){

                public final void invoke(AdaptiveImageRendererEvent p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    AdaptiveImageView.access$handleRendererEvent((AdaptiveImageView)this.receiver, p0);
                }
            }));
            this.updateStateFromAttrs();
        }
    }

    public static final /* synthetic */ void access$handleRendererEvent(AdaptiveImageView $this, AdaptiveImageRendererEvent evt) {
        $this.handleRendererEvent(evt);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AdaptiveImageView.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/svg/AdaptiveImageView$Companion;", "", "<init>", "()V", "DEFAULT_BORDER", "", "DEFAULT_WIDTH", "DEFAULT_HEIGHT", "ADAPTIVE_IMAGES_MANAGER_PROPERTY", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ImageDimension.Unit.values().length];
            try {
                nArray[ImageDimension.Unit.PX.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageDimension.Unit.EM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ImageDimension.Unit.EX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

