/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.github.weisj.jsvg.attributes.font.SVGFont;
import com.github.weisj.jsvg.nodes.SVG;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.svg.JSvgDocumentFactoryKt;
import com.intellij.ui.svg.SvgViewBox;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.xml.dom.StaxFactory;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/svg/JSvgDocument;", "", "document", "Lcom/github/weisj/jsvg/nodes/SVG;", "width", "", "height", "<init>", "(Lcom/github/weisj/jsvg/nodes/SVG;FF)V", "getWidth", "()F", "getHeight", "createImage", "Ljava/awt/image/BufferedImage;", "preferredWidth", "", "preferredHeight", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/awt/image/BufferedImage;", "Companion", "intellij.platform.util.ui"})
@ApiStatus.Internal
public final class JSvgDocument {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SVG document;
    private final float width;
    private final float height;

    public JSvgDocument(@NotNull SVG document, float width, float height) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        this.document = document;
        this.width = width;
        this.height = height;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    @NotNull
    public final BufferedImage createImage(@Nullable Integer preferredWidth, @Nullable Integer preferredHeight) {
        float width = 0.0f;
        float height = 0.0f;
        if (preferredHeight == null && preferredWidth == null) {
            width = this.width;
            height = this.height;
        } else if (preferredHeight != null && preferredWidth != null) {
            width = preferredWidth.intValue();
            height = preferredHeight.intValue();
        } else if (preferredHeight != null) {
            height = preferredHeight.intValue();
            width = height * this.width / this.height;
        } else {
            Integer n = preferredWidth;
            Intrinsics.checkNotNull((Object)n);
            width = n.intValue();
            height = width * this.height / this.width;
        }
        BufferedImage bufferedImage = ImageUtil.createImage(ScaleContext.Companion.create(), (double)width, (double)height, 2, PaintUtil.RoundingMode.ROUND);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        BufferedImage bi = bufferedImage;
        Graphics2D g = bi.createGraphics();
        ImageUtil.applyQualityRenderingHints(g);
        this.document.renderWithSize(width, height, SVGFont.defaultFontSize(), g);
        return bi;
    }

    @JvmStatic
    @NotNull
    public static final JSvgDocument create(@NotNull InputStream inputStream) throws IOException {
        return Companion.create(inputStream);
    }

    @JvmStatic
    @NotNull
    public static final JSvgDocument create(@NotNull byte[] data) throws IOException {
        return Companion.create(data);
    }

    @JvmStatic
    @NotNull
    public static final JSvgDocument create(@NotNull XMLStreamReader2 xmlStreamReader) throws IOException {
        return Companion.create(xmlStreamReader);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/ui/svg/JSvgDocument$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/ui/svg/JSvgDocument;", "inputStream", "Ljava/io/InputStream;", "data", "", "xmlStreamReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "intellij.platform.util.ui"})
    @SourceDebugExtension(value={"SMAP\nJSvgDocument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSvgDocument.kt\ncom/intellij/ui/svg/JSvgDocument$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JSvgDocument create(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return this.create(StaxFactory.createXmlStreamReader$default((InputStream)inputStream, null, (int)2, null));
        }

        @JvmStatic
        @NotNull
        public final JSvgDocument create(@NotNull byte[] data) throws IOException {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return this.create(StaxFactory.createXmlStreamReader((byte[])data));
        }

        @JvmStatic
        @NotNull
        public final JSvgDocument create(@NotNull XMLStreamReader2 xmlStreamReader) throws IOException {
            float f;
            float f2;
            Intrinsics.checkNotNullParameter((Object)xmlStreamReader, (String)"xmlStreamReader");
            SVG svg = JSvgDocumentFactoryKt.createJSvgDocument$default(xmlStreamReader, null, 2, null);
            SvgViewBox viewBox = new SvgViewBox(svg);
            Float f3 = Float.valueOf(svg.getWidth().raw());
            float it = ((Number)f3).floatValue();
            boolean bl = false;
            Float f4 = Math.abs(it) <= Float.MAX_VALUE ? f3 : null;
            if (f4 != null) {
                f2 = f4.floatValue();
            } else {
                Float f5 = Float.valueOf(viewBox.getWidth());
                float it2 = ((Number)f5).floatValue();
                boolean bl2 = false;
                Float f6 = it2 > 0.0f ? f5 : null;
                f2 = f6 != null ? f6.floatValue() : 16.0f;
            }
            float width = f2;
            Float f7 = Float.valueOf(svg.getHeight().raw());
            float it3 = ((Number)f7).floatValue();
            boolean bl3 = false;
            Float f8 = Math.abs(it3) <= Float.MAX_VALUE ? f7 : null;
            if (f8 != null) {
                f = f8.floatValue();
            } else {
                Float f9 = Float.valueOf(viewBox.getHeight());
                float it4 = ((Number)f9).floatValue();
                boolean bl4 = false;
                Float f10 = it4 > 0.0f ? f9 : null;
                f = f10 != null ? f10.floatValue() : 16.0f;
            }
            float height = f;
            return new JSvgDocument(svg, width, height);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

