/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/ui/ListUiUtil;", "", "<init>", "()V", "WithTallRow", "Selection", "intellij.platform.util.ui"})
public final class ListUiUtil {
    @NotNull
    public static final ListUiUtil INSTANCE = new ListUiUtil();

    private ListUiUtil() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u0012\u0010\b\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/util/ui/ListUiUtil$Selection;", "", "<init>", "()V", "installSelectionOnFocus", "Ljava/awt/event/FocusListener;", "list", "Ljavax/swing/JList;", "installSelectionOnRightClick", "Ljava/awt/event/MouseListener;", "intellij.platform.util.ui"})
    public static final class Selection {
        @NotNull
        public static final Selection INSTANCE = new Selection();

        private Selection() {
        }

        @NotNull
        public final FocusListener installSelectionOnFocus(@NotNull JList<?> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            FocusListener listener2 = new FocusAdapter(list){
                final /* synthetic */ JList<?> $list;
                {
                    this.$list = $list;
                }

                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (this.$list.isSelectionEmpty() && this.$list.getModel().getSize() > 0) {
                        this.$list.setSelectedIndex(0);
                    }
                }
            };
            list.addFocusListener(listener2);
            return listener2;
        }

        @NotNull
        public final MouseListener installSelectionOnRightClick(@NotNull JList<?> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            MouseListener listener2 = new MouseAdapter(list){
                final /* synthetic */ JList<?> $list;
                {
                    this.$list = $list;
                }

                public void mousePressed(MouseEvent e) {
                    int row;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingUtilities.isRightMouseButton(e) && (row = this.$list.locationToIndex(e.getPoint())) != -1) {
                        this.$list.setSelectedIndex(row);
                    }
                }
            };
            list.addMouseListener(listener2);
            return listener2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\"\u0010\u000e\u001a\u00020\t2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/util/ui/ListUiUtil$WithTallRow;", "", "<init>", "()V", "selectionBackground", "Lcom/intellij/ui/JBColor;", "unfocusedSelectionBackground", "alternativeRowBackground", "foreground", "Ljava/awt/Color;", "isSelected", "", "hasFocus", "secondaryForeground", "background", "list", "Ljavax/swing/JList;", "alternativeBackground", "intellij.platform.util.ui"})
    public static final class WithTallRow {
        @NotNull
        public static final WithTallRow INSTANCE = new WithTallRow();
        @NotNull
        private static final JBColor selectionBackground = new JBColor(15595262, 4606541);
        @NotNull
        private static final JBColor unfocusedSelectionBackground = new JBColor(0xF5F5F5, 4606541);
        @NotNull
        private static final JBColor alternativeRowBackground = new JBColor(0xFFFFFF, 0x313335);

        private WithTallRow() {
        }

        @NotNull
        public final Color foreground(boolean isSelected, boolean hasFocus) {
            Color color;
            Color color2 = UIUtil.getListForeground();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getListForeground(...)");
            Color color3 = color2;
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionForeground", color3) : JBColor.namedColor("Table.lightSelectionInactiveForeground", color3);
                Intrinsics.checkNotNull((Object)jBColor);
                color = jBColor;
            } else {
                JBColor jBColor = JBColor.namedColor("Table.foreground", color3);
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
                color = jBColor;
            }
            return color;
        }

        @NotNull
        public final Color secondaryForeground(boolean isSelected, boolean hasFocus) {
            Color color;
            if (isSelected) {
                color = this.foreground(true, hasFocus);
            } else {
                JBColor jBColor = JBColor.namedColor("Component.infoForeground", UIUtil.getContextHelpForeground());
                Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
                color = jBColor;
            }
            return color;
        }

        @NotNull
        public final Color background(@NotNull JList<?> list, boolean isSelected, boolean hasFocus) {
            Color color;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionBackground", selectionBackground) : JBColor.namedColor("Table.lightSelectionInactiveBackground", unfocusedSelectionBackground);
                Intrinsics.checkNotNull((Object)jBColor);
                color = jBColor;
            } else {
                Color color2 = list.getBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getBackground(...)");
            }
            return color;
        }

        @NotNull
        public final Color alternativeBackground(boolean isSelected, boolean hasFocus) {
            Color color;
            if (isSelected) {
                JBColor jBColor = hasFocus ? JBColor.namedColor("Table.lightSelectionBackground", selectionBackground) : JBColor.namedColor("Table.lightSelectionInactiveBackground", unfocusedSelectionBackground);
                Intrinsics.checkNotNull((Object)jBColor);
                color = jBColor;
            } else {
                JBColor jBColor = JBColor.namedColor("Table.alternativeRowBackground", alternativeRowBackground);
                Intrinsics.checkNotNull((Object)jBColor);
                color = jBColor;
            }
            return color;
        }
    }
}

