/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.util.ui.AvatarPresentation;
import com.intellij.util.ui.AvatarUtils;
import com.intellij.util.ui.ColorPalette;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\nR\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/intellij/util/ui/PaletteAvatarPresentation;", "Lcom/intellij/util/ui/AvatarPresentation;", "name", "", "gradientSeed", "palette", "Lcom/intellij/util/ui/ColorPalette;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/util/ui/ColorPalette;)V", "getName", "()Ljava/lang/String;", "getGradientSeed", "getPalette", "()Lcom/intellij/util/ui/ColorPalette;", "colors", "Lkotlin/Pair;", "Ljava/awt/Color;", "shortName", "getShortName", "color1", "getColor1", "()Ljava/awt/Color;", "color2", "getColor2", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.platform.util.ui"})
public final class PaletteAvatarPresentation
implements AvatarPresentation {
    @NotNull
    private final String name;
    @NotNull
    private final String gradientSeed;
    @NotNull
    private final ColorPalette palette;
    @NotNull
    private final Pair<Color, Color> colors;
    @NotNull
    private final String shortName;

    public PaletteAvatarPresentation(@NotNull String name, @NotNull String gradientSeed, @NotNull ColorPalette palette) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)gradientSeed, (String)"gradientSeed");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this.name = name;
        this.gradientSeed = gradientSeed;
        this.palette = palette;
        this.colors = this.palette.gradient(this.gradientSeed);
        this.shortName = AvatarUtils.INSTANCE.initials(this.name);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getGradientSeed() {
        return this.gradientSeed;
    }

    @NotNull
    public final ColorPalette getPalette() {
        return this.palette;
    }

    @Override
    @NotNull
    public String getShortName() {
        return this.shortName;
    }

    @Override
    @NotNull
    public Color getColor1() {
        return (Color)this.colors.getFirst();
    }

    @Override
    @NotNull
    public Color getColor2() {
        return (Color)this.colors.getSecond();
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.gradientSeed;
    }

    @NotNull
    public final ColorPalette component3() {
        return this.palette;
    }

    @NotNull
    public final PaletteAvatarPresentation copy(@NotNull String name, @NotNull String gradientSeed, @NotNull ColorPalette palette) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)gradientSeed, (String)"gradientSeed");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new PaletteAvatarPresentation(name, gradientSeed, palette);
    }

    public static /* synthetic */ PaletteAvatarPresentation copy$default(PaletteAvatarPresentation paletteAvatarPresentation, String string, String string2, ColorPalette colorPalette, int n, Object object) {
        if ((n & 1) != 0) {
            string = paletteAvatarPresentation.name;
        }
        if ((n & 2) != 0) {
            string2 = paletteAvatarPresentation.gradientSeed;
        }
        if ((n & 4) != 0) {
            colorPalette = paletteAvatarPresentation.palette;
        }
        return paletteAvatarPresentation.copy(string, string2, colorPalette);
    }

    @NotNull
    public String toString() {
        return "PaletteAvatarPresentation(name=" + this.name + ", gradientSeed=" + this.gradientSeed + ", palette=" + this.palette + ")";
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.gradientSeed.hashCode();
        result = result * 31 + this.palette.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PaletteAvatarPresentation)) {
            return false;
        }
        PaletteAvatarPresentation paletteAvatarPresentation = (PaletteAvatarPresentation)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)paletteAvatarPresentation.name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.gradientSeed, (Object)paletteAvatarPresentation.gradientSeed)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.palette, (Object)paletteAvatarPresentation.palette);
    }
}

