/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.ExtendableHTMLViewFactory;
import com.intellij.util.ui.html.UtilsKt;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.html.HTML;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0096\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/util/ui/Base64ImagesExtension;", "Lcom/intellij/util/ui/ExtendableHTMLViewFactory$Extension;", "<init>", "()V", "invoke", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "defaultView", "BufferedImageView", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nExtendableHTMLViewFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtendableHTMLViewFactory.kt\ncom/intellij/util/ui/Base64ImagesExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,598:1\n1#2:599\n23#3:600\n23#3:601\n*S KotlinDebug\n*F\n+ 1 ExtendableHTMLViewFactory.kt\ncom/intellij/util/ui/Base64ImagesExtension\n*L\n323#1:600\n326#1:601\n*E\n"})
final class Base64ImagesExtension
implements ExtendableHTMLViewFactory.Extension {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public View invoke(@NotNull Element elem, @NotNull View defaultView) {
        Base64ImagesExtension $this$thisLogger$iv;
        Object it;
        Object object;
        Object object2;
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
                Intrinsics.checkNotNullParameter((Object)defaultView, (String)"defaultView");
                if (!Intrinsics.areEqual((Object)"img", (Object)elem.getName())) {
                    return null;
                }
                Object object3 = elem.getAttributes().getAttribute(HTML.Attribute.SRC);
                object2 = object3 instanceof String ? (String)object3 : null;
                if (object2 == null) break block15;
                it = object = object2;
                boolean bl = false;
                object2 = StringsKt.startsWith$default((String)it, (String)"data:image", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)((CharSequence)it), (CharSequence)"base64", (boolean)false, (int)2, null) ? object : null;
                if (object2 != null) break block16;
            }
            return null;
        }
        String src = object2;
        object = new char[1];
        object[0] = 44;
        it = object = StringsKt.split$default((CharSequence)src, (char[])object, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Object object4 = it.size() == 2 ? object : null;
        if (object4 == null || (object4 = (String)object4.get(1)) == null) {
            return null;
        }
        Object encodedImage = object4;
        try {
            BufferedImage bufferedImage;
            it = new ByteArrayInputStream(Base64.getDecoder().decode((String)encodedImage));
            Throwable throwable = null;
            try {
                InputStream p0 = (InputStream)it;
                boolean bl2 = false;
                BufferedImage bufferedImage2 = ImageIO.read(p0);
                bufferedImage = bufferedImage2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)it, (Throwable)throwable);
            }
            if (bufferedImage == null) {
                return null;
            }
            BufferedImage image = bufferedImage;
            return new BufferedImageView(elem, image);
        }
        catch (IllegalArgumentException e) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Base64ImagesExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug((Throwable)e);
        }
        catch (IOException e) {
            $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Base64ImagesExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug((Throwable)e);
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\tH\u0016J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H\u0016J\"\u0010\u001f\u001a\u0004\u0018\u00010\u00192\u0006\u0010 \u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"H\u0016J3\u0010#\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00192\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\"0%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\tH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/util/ui/Base64ImagesExtension$BufferedImageView;", "Ljavax/swing/text/View;", "elem", "Ljavax/swing/text/Element;", "bufferedImage", "Ljava/awt/image/BufferedImage;", "<init>", "(Ljavax/swing/text/Element;Ljava/awt/image/BufferedImage;)V", "width", "", "height", "border", "vAlign", "", "getIntAttr", "name", "Ljavax/swing/text/html/HTML$Attribute;", "defaultValue", "getPreferredSpan", "axis", "getToolTipText", "", "x", "y", "allocation", "Ljava/awt/Shape;", "paint", "", "g", "Ljava/awt/Graphics;", "a", "modelToView", "pos", "b", "Ljavax/swing/text/Position$Bias;", "viewToModel", "bias", "", "(FFLjava/awt/Shape;[Ljavax/swing/text/Position$Bias;)I", "getAlignment", "Companion", "intellij.platform.util.ui"})
    private static final class BufferedImageView
    extends View {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final BufferedImage bufferedImage;
        private final int width;
        private final int height;
        private final int border;
        private final float vAlign;
        private static final int DEFAULT_BORDER = 0;

        public BufferedImageView(@NotNull Element elem, @NotNull BufferedImage bufferedImage) {
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            Intrinsics.checkNotNullParameter((Object)bufferedImage, (String)"bufferedImage");
            super(elem);
            this.bufferedImage = bufferedImage;
            HTML.Attribute attribute = HTML.Attribute.WIDTH;
            Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"WIDTH");
            int width = this.getIntAttr(attribute, -1);
            HTML.Attribute attribute2 = HTML.Attribute.HEIGHT;
            Intrinsics.checkNotNullExpressionValue((Object)attribute2, (String)"HEIGHT");
            int height = this.getIntAttr(attribute2, -1);
            int aspectRatio = this.bufferedImage.getWidth() / this.bufferedImage.getHeight();
            if (width < 0 && height < 0) {
                this.width = this.bufferedImage.getWidth();
                this.height = this.bufferedImage.getHeight();
            } else if (width < 0) {
                this.width = height * aspectRatio;
                this.height = height;
            } else if (height < 0) {
                this.width = width;
                this.height = width / aspectRatio;
            } else {
                this.width = width;
                this.height = height;
            }
            HTML.Attribute attribute3 = HTML.Attribute.BORDER;
            Intrinsics.checkNotNullExpressionValue((Object)attribute3, (String)"BORDER");
            this.border = this.getIntAttr(attribute3, 0);
            Object alignment = elem.getAttributes().getAttribute(HTML.Attribute.ALIGN);
            float vAlign = 1.0f;
            if (alignment != null) {
                if (Intrinsics.areEqual((Object)"top", (Object)(alignment = alignment.toString()))) {
                    vAlign = 0.0f;
                } else if (Intrinsics.areEqual((Object)"middle", (Object)alignment)) {
                    vAlign = 0.5f;
                }
            }
            this.vAlign = vAlign;
        }

        private final int getIntAttr(HTML.Attribute name, int defaultValue) {
            Element element = this.getElement();
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getElement(...)");
            return UtilsKt.getIntAttr(element, name, defaultValue);
        }

        @Override
        public float getPreferredSpan(int axis) {
            return switch (axis) {
                case 0 -> this.width + 2 * this.border;
                case 1 -> this.height + 2 * this.border;
                default -> throw new IllegalArgumentException("Invalid axis: " + axis);
            };
        }

        @Override
        @Nullable
        public String getToolTipText(float x, float y, @NotNull Shape allocation) {
            Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
            Object object = super.getElement().getAttributes().getAttribute(HTML.Attribute.ALT);
            return object instanceof String ? (String)object : null;
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull Shape a) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Rectangle bounds = a.getBounds();
            g.drawImage(this.bufferedImage, bounds.x + this.border, bounds.y + this.border, this.width, this.height, null);
        }

        @Override
        @Nullable
        public Shape modelToView(int pos, @NotNull Shape a, @NotNull Position.Bias b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            int p0 = this.getStartOffset();
            int p1 = this.getEndOffset();
            boolean bl = p0 <= pos ? pos <= p1 : false;
            if (bl) {
                Rectangle r = a.getBounds();
                if (pos == p1) {
                    r.x += r.width;
                }
                r.width = 0;
                return r;
            }
            return null;
        }

        @Override
        public int viewToModel(float x, float y, @NotNull Shape a, @NotNull Position.Bias[] bias) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)bias, (String)"bias");
            Rectangle alloc = (Rectangle)a;
            if (x < (float)(alloc.x + alloc.width)) {
                Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Forward, (String)"Forward");
                return this.getStartOffset();
            }
            Intrinsics.checkNotNullExpressionValue((Object)Position.Bias.Backward, (String)"Backward");
            return this.getEndOffset();
        }

        @Override
        public float getAlignment(int axis) {
            return axis == 1 ? this.vAlign : super.getAlignment(axis);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/util/ui/Base64ImagesExtension$BufferedImageView$Companion;", "", "<init>", "()V", "DEFAULT_BORDER", "", "intellij.platform.util.ui"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

