/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.scale;

import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.DerivedScaleType;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.Scale;
import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.lang.ref.WeakReference;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 (2\u00020\u0001:\u0001(B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0012\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0017\b\u0012\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u001f\u0010\u0019\u001a\u00020\u0016\"\b\b\u0000\u0010\u001a*\u00020\u00012\u0006\u0010\u001b\u001a\u0002H\u001aH\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0013\u0010\u001d\u001a\u00020\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0017\u0010$\u001a\u0002H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u0001H\u0016\u00a2\u0006\u0002\u0010%J\b\u0010&\u001a\u00020'H\u0016R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/ui/scale/ScaleContext;", "Lcom/intellij/ui/scale/UserScaleContext;", "<init>", "()V", "scale", "Lcom/intellij/ui/scale/Scale;", "(Lcom/intellij/ui/scale/Scale;)V", "scales", "", "([Lcom/intellij/ui/scale/Scale;)V", "sysScale", "componentRef", "Ljava/lang/ref/WeakReference;", "Ljava/awt/Component;", "derivePixScale", "", "getScale", "type", "Lcom/intellij/ui/scale/ScaleType;", "getScaleObject", "Lcom/intellij/ui/scale/DerivedScaleType;", "update", "", "setScale", "copyWithScale", "updateAll", "T", "scaleContext", "(Lcom/intellij/ui/scale/UserScaleContext;)Z", "equals", "other", "", "hashCode", "", "dispose", "", "copy", "()Lcom/intellij/ui/scale/UserScaleContext;", "toString", "", "Companion", "intellij.platform.util.ui"})
public final class ScaleContext
extends UserScaleContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Scale sysScale = ScaleType.SYS_SCALE.of(JBUIScale.sysScale());
    @Nullable
    private WeakReference<Component> componentRef;

    public ScaleContext() {
        this.pixScale = this.derivePixScale();
    }

    private ScaleContext(Scale scale) {
        this();
        switch (WhenMappings.$EnumSwitchMapping$0[scale.type.ordinal()]) {
            case 1: {
                this.usrScale = scale;
                break;
            }
            case 2: {
                this.objScale = scale;
                break;
            }
            case 3: {
                this.sysScale = scale;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.pixScale = this.derivePixScale();
    }

    private ScaleContext(Scale[] scales) {
        this();
        block5: for (Scale scale : scales) {
            switch (WhenMappings.$EnumSwitchMapping$0[scale.type.ordinal()]) {
                case 1: {
                    this.usrScale = scale;
                    continue block5;
                }
                case 2: {
                    this.objScale = scale;
                    continue block5;
                }
                case 3: {
                    this.sysScale = scale;
                    continue block5;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        this.pixScale = this.derivePixScale();
    }

    @Override
    protected double derivePixScale() {
        return this.getScale(DerivedScaleType.DEV_SCALE) * super.derivePixScale();
    }

    @Override
    public double getScale(@NotNull ScaleType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type == ScaleType.SYS_SCALE ? this.sysScale.value : super.getScale(type);
    }

    @Override
    @NotNull
    protected Scale getScaleObject(@NotNull ScaleType type) {
        Scale scale;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (type == ScaleType.SYS_SCALE) {
            scale = this.sysScale;
        } else {
            Scale scale2 = super.getScaleObject(type);
            scale = scale2;
            Intrinsics.checkNotNullExpressionValue((Object)scale2, (String)"getScaleObject(...)");
        }
        return scale;
    }

    @Override
    public double getScale(@NotNull DerivedScaleType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1 -> {
                if (JreHiDpiUtil.isJreHiDPIEnabled()) {
                    yield this.sysScale.value;
                }
                yield 1.0;
            }
            case 2 -> this.usrScale.value * this.objScale.value;
            case 3 -> this.pixScale;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean update() {
        boolean updated = this.setScale(ScaleType.USR_SCALE.of(JBUIScale.INSTANCE.getUserScale$intellij_platform_util_ui()));
        if (this.componentRef != null) {
            WeakReference<Component> weakReference = this.componentRef;
            Intrinsics.checkNotNull(weakReference);
            Component component = (Component)weakReference.get();
            if (component != null) {
                updated = this.setScale(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(component.getGraphicsConfiguration()))) || updated;
            }
        }
        return this.onUpdated(updated);
    }

    @Override
    public boolean setScale(@NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        if (this.isScaleOverridden(scale)) {
            return false;
        }
        if (scale.type == ScaleType.SYS_SCALE) {
            boolean updated = !Intrinsics.areEqual((Object)this.sysScale, (Object)scale);
            this.sysScale = scale;
            return this.onUpdated(updated);
        }
        return super.setScale(scale);
    }

    @NotNull
    public final ScaleContext copyWithScale(@NotNull Scale scale) {
        ScaleContext result;
        block0: {
            Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
            Scale[] scaleArray = new Scale[4];
            Intrinsics.checkNotNullExpressionValue((Object)this.usrScale, (String)"usrScale");
            scaleArray[1] = this.sysScale;
            Intrinsics.checkNotNullExpressionValue((Object)this.objScale, (String)"objScale");
            scaleArray[3] = scale;
            result = new ScaleContext(scaleArray);
            EnumSet enumSet = this.overriddenScales;
            if (enumSet == null) break block0;
            EnumSet it = enumSet;
            boolean bl = false;
            result.overriddenScales = it.clone();
        }
        return result;
    }

    @Override
    protected <T extends UserScaleContext> boolean updateAll(@NotNull T scaleContext) {
        Intrinsics.checkNotNullParameter(scaleContext, (String)"scaleContext");
        boolean updated = super.updateAll(scaleContext);
        if (!(scaleContext instanceof ScaleContext)) {
            return updated;
        }
        WeakReference<Component> weakReference = this.componentRef;
        if (weakReference != null) {
            weakReference.clear();
        }
        this.componentRef = ((ScaleContext)scaleContext).componentRef;
        return this.setScale(((ScaleContext)scaleContext).sysScale) || updated;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return super.equals(other) && other instanceof ScaleContext ? ((ScaleContext)other).sysScale.value == this.sysScale.value : false;
    }

    @Override
    public int hashCode() {
        return Double.hashCode(this.sysScale.value) * 31 + super.hashCode();
    }

    @Override
    public void dispose() {
        block0: {
            super.dispose();
            WeakReference<Component> weakReference = this.componentRef;
            if (weakReference == null) break block0;
            weakReference.clear();
        }
    }

    @Override
    @NotNull
    public <T extends UserScaleContext> T copy() {
        Scale[] scaleArray = new Scale[3];
        Intrinsics.checkNotNullExpressionValue((Object)this.usrScale, (String)"usrScale");
        scaleArray[1] = this.sysScale;
        Intrinsics.checkNotNullExpressionValue((Object)this.objScale, (String)"objScale");
        ScaleContext result = new ScaleContext(scaleArray);
        result.updateAll((UserScaleContext)this);
        return (T)result;
    }

    @Override
    @NotNull
    public String toString() {
        return this.usrScale + ", " + this.sysScale + ", " + this.objScale + ", " + this.pixScale;
    }

    @JvmStatic
    @NotNull
    public static final ScaleContext createIdentity() {
        return Companion.createIdentity();
    }

    @JvmStatic
    @NotNull
    public static final ScaleContext create(@Nullable Component component) {
        return Companion.create(component);
    }

    @JvmStatic
    @NotNull
    public static final ScaleContext create(@Nullable Graphics2D g) {
        return Companion.create(g);
    }

    @JvmStatic
    @NotNull
    public static final ScaleContext create(@NotNull Scale scale) {
        return Companion.create(scale);
    }

    @JvmStatic
    @NotNull
    public static final ScaleContext create() {
        return Companion.create();
    }

    public /* synthetic */ ScaleContext(Scale[] scales, DefaultConstructorMarker $constructor_marker) {
        this(scales);
    }

    public /* synthetic */ ScaleContext(Scale scale, DefaultConstructorMarker $constructor_marker) {
        this(scale);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\u000e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0012\u0010\u0006\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u001b\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0013H\u0007\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0006\u001a\u00020\u0005H\u0007\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/scale/ScaleContext$Companion;", "", "<init>", "()V", "createIdentity", "Lcom/intellij/ui/scale/ScaleContext;", "create", "context", "Lcom/intellij/ui/scale/UserScaleContext;", "component", "Ljava/awt/Component;", "gc", "Ljava/awt/GraphicsConfiguration;", "g", "Ljava/awt/Graphics2D;", "scale", "Lcom/intellij/ui/scale/Scale;", "of", "scales", "", "([Lcom/intellij/ui/scale/Scale;)Lcom/intellij/ui/scale/ScaleContext;", "intellij.platform.util.ui"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ScaleContext createIdentity() {
            Scale[] scaleArray = new Scale[]{ScaleType.USR_SCALE.of(1.0f), ScaleType.SYS_SCALE.of(1.0f)};
            return new ScaleContext(scaleArray, null);
        }

        @NotNull
        public final ScaleContext create(@NotNull UserScaleContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            ScaleContext result = new ScaleContext();
            result.update(context);
            return result;
        }

        @JvmStatic
        @NotNull
        public final ScaleContext create(@Nullable Component component) {
            if (component == null) {
                return new ScaleContext();
            }
            ScaleContext context = this.create(component.getGraphicsConfiguration());
            context.componentRef = new WeakReference<Component>(component);
            return context;
        }

        @NotNull
        public final ScaleContext create(@Nullable GraphicsConfiguration gc) {
            return new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(gc)), null);
        }

        @JvmStatic
        @NotNull
        public final ScaleContext create(@Nullable Graphics2D g) {
            return new ScaleContext(ScaleType.SYS_SCALE.of(JBUIScale.sysScale(g)), null);
        }

        @JvmStatic
        @NotNull
        public final ScaleContext create(@NotNull Scale scale) {
            Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
            return new ScaleContext(scale, null);
        }

        @TestOnly
        @NotNull
        public final ScaleContext of(@NotNull Scale[] scales) {
            Intrinsics.checkNotNullParameter((Object)scales, (String)"scales");
            return new ScaleContext(scales, null);
        }

        @JvmStatic
        @NotNull
        public final ScaleContext create() {
            return new ScaleContext();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScaleType.values().length];
            try {
                nArray[ScaleType.USR_SCALE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaleType.OBJ_SCALE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScaleType.SYS_SCALE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DerivedScaleType.values().length];
            try {
                nArray[DerivedScaleType.DEV_SCALE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DerivedScaleType.EFF_USR_SCALE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DerivedScaleType.PIX_SCALE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

