/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J`\u0010 \u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006,"}, d2={"Lcom/intellij/util/ui/WrapLayout;", "Ljava/awt/FlowLayout;", "<init>", "()V", "align", "", "(I)V", "hgap", "vgap", "(III)V", "fillWidth", "", "getFillWidth", "()Z", "setFillWidth", "(Z)V", "preferredLayoutSize", "Ljava/awt/Dimension;", "target", "Ljava/awt/Container;", "minimumLayoutSize", "layoutSize", "preferred", "addRow", "", "dim", "rowWidth", "rowHeight", "layoutContainer", "preferredSize", "m", "Ljava/awt/Component;", "moveComponents", "_x", "y", "width", "_height", "rowStart", "rowEnd", "ltr", "useBaseline", "ascent", "", "descent", "intellij.platform.util.ui"})
public class WrapLayout
extends FlowLayout {
    private boolean fillWidth;

    public WrapLayout() {
    }

    public WrapLayout(int align) {
        super(align);
    }

    public WrapLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    public final boolean getFillWidth() {
        return this.fillWidth;
    }

    public final void setFillWidth(boolean bl) {
        this.fillWidth = bl;
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.layoutSize(target, true);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Dimension minimum = this.layoutSize(target, false);
        minimum.width -= this.getHgap() + 1;
        return minimum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Dimension layoutSize(Container target, boolean preferred) {
        Object object = target.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Container container = target;
            while (container.getSize().width == 0 && container.getParent() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)container.getParent(), (String)"getParent(...)");
            }
            int targetWidth = container.getSize().width;
            if (targetWidth == 0) {
                targetWidth = Integer.MAX_VALUE;
            }
            int hgap = this.getHgap();
            int vgap = this.getVgap();
            Insets insets = target.getInsets();
            int horizontalInsetsAndGap = insets.left + insets.right + hgap * 2;
            int maxWidth = targetWidth - horizontalInsetsAndGap;
            Dimension dim = new Dimension(0, 0);
            int rowWidth = 0;
            int rowHeight = 0;
            int nmembers = target.getComponentCount();
            for (int i = 0; i < nmembers; ++i) {
                Dimension d;
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (preferred) {
                    Intrinsics.checkNotNull((Object)m);
                    v1 = this.preferredSize(m);
                } else {
                    v1 = d = m.getMinimumSize();
                }
                if (rowWidth + hgap + d.width > maxWidth) {
                    this.addRow(dim, rowWidth, rowHeight);
                    rowWidth = 0;
                    rowHeight = 0;
                }
                if (rowWidth != 0) {
                    rowWidth += hgap;
                }
                rowWidth += d.width;
                rowHeight = Math.max(rowHeight, d.height);
            }
            this.addRow(dim, rowWidth, rowHeight);
            dim.width += horizontalInsetsAndGap;
            dim.height += insets.top + insets.bottom + vgap * 2;
            Container scrollPane = SwingUtilities.getAncestorOfClass(JScrollPane.class, target);
            if (scrollPane != null && target.isValid()) {
                dim.width -= hgap + 1;
            }
            dim.width = Math.min(dim.width, maxWidth);
            Dimension dimension = dim;
            return dimension;
        }
    }

    private final void addRow(Dimension dim, int rowWidth, int rowHeight) {
        dim.width = Math.max(dim.width, rowWidth);
        if (dim.height > 0) {
            dim.height += this.getVgap();
        }
        dim.height += rowHeight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object object = target.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            boolean useBaseline = this.getAlignOnBaseline();
            int[] ascent = new int[nmembers];
            int[] descent = new int[nmembers];
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Intrinsics.checkNotNull((Object)m);
                Dimension d = this.preferredSize(m);
                m.setSize(d.width, d.height);
                if (useBaseline) {
                    int baseline = m.getBaseline(d.width, d.height);
                    if (baseline >= 0) {
                        ascent[i] = baseline;
                        descent[i] = d.height - baseline;
                    } else {
                        ascent[i] = -1;
                    }
                }
                if (x == 0 || x + d.width <= maxwidth) {
                    x += d.width + this.getHgap();
                    rowh = Math.max(rowh, d.height);
                    continue;
                }
                rowh = this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, i, ltr, useBaseline, ascent, descent);
                x = d.width + this.getHgap();
                y += this.getVgap() + rowh;
                rowh = d.height;
                start = i;
            }
            int n = this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, nmembers, ltr, useBaseline, ascent, descent);
        }
    }

    private final Dimension preferredSize(Component m) {
        return new Dimension(Math.max(m.getPreferredSize().width, m.getMinimumSize().width), Math.max(m.getPreferredSize().height, m.getMinimumSize().height));
    }

    private final int moveComponents(Container target, int _x, int y, int width, int _height, int rowStart, int rowEnd, boolean ltr, boolean useBaseline, int[] ascent, int[] descent) {
        int x = _x;
        int height = _height;
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        int maxAscent = 0;
        int nonBaselineHeight = 0;
        int baselineOffset = 0;
        if (useBaseline) {
            int maxDescent = 0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ascent[i] >= 0) {
                    maxAscent = Math.max(maxAscent, ascent[i]);
                    maxDescent = Math.max(maxDescent, descent[i]);
                    continue;
                }
                nonBaselineHeight = Math.max(m.getHeight(), nonBaselineHeight);
            }
            height = Math.max(maxAscent + maxDescent, nonBaselineHeight);
            baselineOffset = (height - maxAscent - maxDescent) / 2;
        }
        double expand = 1.0;
        if (this.fillWidth) {
            double sum = 0.0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                sum += (double)Math.max(m.getPreferredSize().width, m.getMinimumSize().width);
            }
            expand = (double)target.getWidth() / sum;
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            int w;
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            int cy = useBaseline && ascent[i] >= 0 ? y + baselineOffset + maxAscent - ascent[i] : y + (height - m.getHeight()) / 2;
            int n = w = this.fillWidth ? (int)Math.floor((double)Math.max(m.getPreferredSize().width, m.getMinimumSize().width) * expand) : m.getWidth();
            if (ltr) {
                m.setBounds(x, cy, w, m.getHeight());
            } else {
                m.setBounds(target.getWidth() - x - w, cy, w, m.getHeight());
            }
            x += m.getWidth() + this.getHgap();
        }
        return height;
    }
}

