// Copyright 2000-2025 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package com.intellij.icons;

import com.intellij.ui.IconManager;
import org.jetbrains.annotations.NotNull;

import javax.swing.*;

import org.jetbrains.annotations.ApiStatus.ScheduledForRemoval;

/**
 * NOTE THIS FILE IS AUTO-GENERATED
 * DO NOT EDIT IT BY HAND, run "Generate icon classes" configuration instead
 */
public class AllIcons {
  private static @NotNull Icon load(@NotNull String path, int cacheKey, int flags) {
    return IconManager.getInstance().loadRasterizedIcon(path, AllIcons.class.getClassLoader(), cacheKey, flags);
  }
  private static @NotNull Icon load(@NotNull String expUIPath, @NotNull String path, int cacheKey, int flags) {
    return IconManager.getInstance().loadRasterizedIcon(path, expUIPath, AllIcons.class.getClassLoader(), cacheKey, flags);
  }

  public static final class Actions {
    /** 16x16 */ public static final @NotNull Icon AddDirectory = load("expui/actions/addDirectory.svg", 1001061326, 2);
    /** 16x16 */ public static final @NotNull Icon AddFile = load("expui/actions/addFile.svg", "actions/addFile.svg", -401992031, 2);
    /** 16x16 */ public static final @NotNull Icon AddList = load("expui/bookmarks/addBookmarksList.svg", "actions/addList.svg", 687312006, 2);
    /** 16x16 */ public static final @NotNull Icon AddMulticaret = load("expui/general/add.svg", "actions/AddMulticaret.svg", 14246848, 2);
    /** 16x16 */ public static final @NotNull Icon AddToDictionary = load("expui/actions/addToDictionary.svg", "actions/addToDictionary.svg", -854911886, 2);
    /** 16x16 */ public static final @NotNull Icon Annotate = load("expui/general/listFiles.svg", "actions/annotate.svg", -264543398, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowCollapse = load("expui/general/chevronLeft.svg", "actions/arrowCollapse.svg", -296923721, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowExpand = load("expui/general/chevronRight.svg", "actions/arrowExpand.svg", 2111993468, 2);
    /** 16x16 */ public static final @NotNull Icon Attach = load("expui/actions/attach.svg", 312051375, 2);
    /** 16x16 */ public static final @NotNull Icon Back = load("expui/general/left.svg", "actions/back.svg", 1990199139, 2);
    /** 16x16 */ public static final @NotNull Icon BuildAutoReloadChanges = load("expui/actions/buildAutoReloadChanges.svg", "actions/buildAutoReloadChanges.svg", 1799776131, 2);
    /** 16x16 */ public static final @NotNull Icon BuildLoadChanges = load("expui/actions/buildLoadChanges.svg", "actions/buildLoadChanges.svg", -2056072706, 2);
    /** 16x16 */ public static final @NotNull Icon Cancel = load("expui/general/close.svg", "actions/cancel.svg", -263776084, 2);
    /** 16x16 */ public static final @NotNull Icon ChangeView = load("expui/actions/changeView.svg", "actions/changeView.svg", -598441630, 2);
    /** 12x12 */ public static final @NotNull Icon Checked = load("expui/actions/checked.svg", "actions/checked.svg", -988548294, 0);
    /** 12x12 */ public static final @NotNull Icon Checked_selected = load("actions/checked_selected.svg", -434989657, 0);
    /** 16x16 */ public static final @NotNull Icon CheckMulticaret = load("actions/CheckMulticaret.svg", 164939994, 2);
    /** 16x16 */ public static final @NotNull Icon CheckOut = load("expui/vcs/update.svg", "actions/checkOut.svg", 464330888, 2);
    /** 16x16 */ public static final @NotNull Icon ClearCash = load("expui/actions/clearCash.svg", 1918690860, 2);
    /** 16x16 */ public static final @NotNull Icon Close = load("expui/general/closeSmall.svg", "actions/close.svg", 340159074, 0);
    /** 16x16 */ public static final @NotNull Icon CloseDarkGrey = load("actions/closeDarkGrey.svg", -770212526, 2);
    /** 16x16 */ public static final @NotNull Icon CloseHovered = load("expui/general/closeSmallHovered.svg", "actions/closeHovered.svg", 874802347, 0);
    /** 16x16 */ public static final @NotNull Icon Collapseall = load("expui/general/collapseAll.svg", "actions/collapseall.svg", 49808704, 2);
    /** 16x16 */ public static final @NotNull Icon Colors = load("actions/colors.svg", 1344876210, 2);
    /** 16x16 */ public static final @NotNull Icon Commit = load("expui/vcs/commit.svg", "actions/commit.svg", 1634981977, 2);
    /** 16x16 */ public static final @NotNull Icon Compile = load("expui/build/build.svg", "actions/compile.svg", -74779340, 2);
    /** 16x16 */ public static final @NotNull Icon Copy = load("expui/general/copy.svg", "actions/copy.svg", 472024350, 2);
    /** 16x16 */ public static final @NotNull Icon DeleteTag = load("actions/deleteTag.svg", -206512106, 2);
    /** 16x16 */ public static final @NotNull Icon DeleteTagHover = load("actions/deleteTagHover.svg", -1791200756, 2);
    /** 16x16 */ public static final @NotNull Icon DependencyAnalyzer = load("expui/build/dependencyAnalyzer.svg", "actions/dependencyAnalyzer.svg", -456221722, 2);
    /** 16x16 */ public static final @NotNull Icon DiagramDiff = load("expui/actions/diagramDiff.svg", "actions/diagramDiff.svg", 1592610798, 2);
    /** 16x16 */ public static final @NotNull Icon Diff = load("expui/vcs/diff.svg", "actions/diff.svg", 585433782, 2);
    /** 16x17 */ public static final @NotNull Icon DiffWithClipboard = load("expui/actions/diffWithClipboard.svg", "actions/diffWithClipboard.svg", 2000090926, 2);
    /** 16x16 */ public static final @NotNull Icon Download = load("expui/general/download.svg", "actions/download.svg", 107885055, 2);
    /** 16x16 */ public static final @NotNull Icon Dump = load("expui/run/dumpThreads.svg", "actions/dump.svg", -846856013, 2);
    /** 16x16 */ public static final @NotNull Icon DynamicUsages = load("actions/dynamicUsages.svg", -522036272, 2);
    /** 16x16 */ public static final @NotNull Icon Edit = load("expui/general/edit.svg", "actions/edit.svg", -483863471, 2);
    /** 16x16 */ public static final @NotNull Icon EditScheme = load("expui/general/edit.svg", "actions/editScheme.svg", -2140024882, 2);
    /** 16x16 */ public static final @NotNull Icon EditSource = load("expui/general/edit.svg", "actions/editSource.svg", 1733514533, 2);
    /** 16x16 */ public static final @NotNull Icon EnableNewUi = load("actions/enableNewUi.svg", 944382817, 0);
    /** 16x16 */ public static final @NotNull Icon EnableNewUiSelected = load("actions/enableNewUiSelected.svg", 1993898906, 0);
    /** 16x16 */ public static final @NotNull Icon Execute = load("expui/run/run.svg", "actions/execute.svg", 917793291, 10);
    /** 16x16 */ public static final @NotNull Icon Exit = load("expui/general/exit.svg", "actions/exit.svg", -83756038, 2);
    /** 16x16 */ public static final @NotNull Icon Expandall = load("expui/general/expandAll.svg", "actions/expandall.svg", 879771216, 2);
    /** 16x16 */ public static final @NotNull Icon Find = load("expui/general/search.svg", "actions/find.svg", 1275373899, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowNextMatches = load("expui/general/chevronDown.svg", "actions/findAndShowNextMatches.svg", -1547028108, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowNextMatchesSmall = load("expui/general/chevronDown.svg", "actions/findAndShowNextMatchesSmall.svg", 1412713913, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowPrevMatches = load("expui/general/chevronUp.svg", "actions/findAndShowPrevMatches.svg", 1577129294, 2);
    /** 16x16 */ public static final @NotNull Icon FindAndShowPrevMatchesSmall = load("expui/general/chevronUp.svg", "actions/findAndShowPrevMatchesSmall.svg", -641725766, 2);
    /** 16x16 */ public static final @NotNull Icon FindBackward = load("expui/actions/findBackward.svg", "actions/findBackward.svg", 1373712790, 2);
    /** 16x16 */ public static final @NotNull Icon FindEntireFile = load("expui/actions/findEntireFile.svg", "actions/findEntireFile.svg", -875287273, 2);
    /** 16x16 */ public static final @NotNull Icon FindForward = load("expui/actions/findForward.svg", "actions/findForward.svg", -2015650359, 2);
    /** 16x16 */ public static final @NotNull Icon ForceRefresh = load("expui/actions/forceRefresh.svg", "actions/forceRefresh.svg", 1506719599, 2);
    /** 16x16 */ public static final @NotNull Icon Forward = load("expui/general/right.svg", "actions/forward.svg", 625314766, 2);
    /** 16x16 */ public static final @NotNull Icon GC = load("expui/general/delete.svg", "actions/gc.svg", -382610359, 2);
    /** 16x16 */ public static final @NotNull Icon GeneratedFolder = load("expui/actions/generated.svg", "actions/generatedFolder.svg", -1188638644, 2);
    /** 16x16 */ public static final @NotNull Icon GroupBy = load("expui/general/show.svg", "actions/groupBy.svg", 73174374, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByClass = load("expui/actions/groupByClass.svg", "actions/GroupByClass.svg", 833211609, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByFile = load("expui/actions/groupByFile.svg", "actions/GroupByFile.svg", -1739369473, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByMethod = load("expui/actions/groupByMethod.svg", "actions/groupByMethod.svg", -172508434, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByModule = load("expui/actions/groupByModule.svg", "actions/GroupByModule.svg", 762451994, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByModuleGroup = load("expui/actions/groupByModuleGroup.svg", "actions/GroupByModuleGroup.svg", -1876724743, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByPackage = load("expui/actions/groupByPackage.svg", "actions/GroupByPackage.svg", -2005050728, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByPrefix = load("actions/GroupByPrefix.svg", -1453880873, 2);
    /** 16x16 */ public static final @NotNull Icon GroupByTestProduction = load("expui/actions/groupByTestProduction.svg", "actions/groupByTestProduction.svg", -1535893700, 2);
    /** 16x16 */ public static final @NotNull Icon Help = load("expui/general/help.svg", "actions/help.svg", 1634111868, 2);
    /** 16x16 */ public static final @NotNull Icon Highlighting = load("expui/actions/highlighting.svg", "actions/highlighting.svg", -207354251, 2);
    /** 9x5 */ public static final @NotNull Icon InlayDropTriangle = load("actions/inlayDropTriangle.svg", -995758888, 0);
    /** 12x12 */ public static final @NotNull Icon InlayGear = load("expui/codeInsight/inlaySettings.svg", "actions/inlayGear.svg", 1238199129, 0);
    /** 12x12 */ public static final @NotNull Icon InlayGlobe = load("expui/codeInsight/inlayGlobe.svg", "actions/inlayGlobe.svg", 2099234919, 0);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInComments = load("expui/codeInsight/inlayRenameInComments.svg", "actions/inlayRenameInComments.svg", 1405010969, 0);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInCommentsActive = load("expui/codeInsight/inlayRenameInCommentsActive.svg", "actions/inlayRenameInCommentsActive.svg", 1577110730, 2);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInNoCodeFiles = load("expui/codeInsight/inlayRenameInNoCodeFiles.svg", "actions/inlayRenameInNoCodeFiles.svg", 457631883, 0);
    /** 12x12 */ public static final @NotNull Icon InlayRenameInNoCodeFilesActive = load("expui/codeInsight/inlayRenameInNoCodeFilesActive.svg", "actions/inlayRenameInNoCodeFilesActive.svg", -471103115, 2);
    /** 12x12 */ public static final @NotNull Icon InlaySecuredShield = load("expui/codeInsight/inlaySecuredShield.svg", "actions/inlaySecuredShield.svg", -658413079, 0);
    /** 12x12 */ public static final @NotNull Icon InlineDropFrame = load("actions/inlineDropFrame.svg", -1741854760, 2);
    /** 12x12 */ public static final @NotNull Icon InlineDropFrameSelected = load("actions/inlineDropFrameSelected.svg", 600697658, 2);
    /** 16x16 */ public static final @NotNull Icon InSelection = load("expui/actions/inSelection.svg", "actions/inSelection.svg", 1095183570, 2);
    /** 16x16 */ public static final @NotNull Icon Install = load("expui/actions/install.svg", "actions/install.svg", -1205666017, 2);
    /** 16x16 */ public static final @NotNull Icon IntentionBulb = load("expui/codeInsight/intentionBulb.svg", "actions/intentionBulb.svg", -42443329, 2);
    /** 16x16 */ public static final @NotNull Icon IntentionBulbGrey = load("expui/codeInsight/intentionBulbGrey.svg", "actions/intentionBulbGrey.svg", 738364044, 2);
    /** 16x16 */ public static final @NotNull Icon Learn = load("expui/actions/learn.svg", "actions/learn.svg", -1694136226, 2);
    /** 16x16 */ public static final @NotNull Icon Lightning = load("expui/actions/lightning.svg", "actions/lightning.svg", 1372299981, 2);
    /** 16x16 */ public static final @NotNull Icon ListChanges = load("expui/vcs/changes.svg", "actions/listChanges.svg", -1946328934, 2);
    /** 16x16 */ public static final @NotNull Icon ListFiles = load("expui/general/listFiles.svg", "actions/listFiles.svg", -1292692624, 2);
    /** 16x16 */ public static final @NotNull Icon MatchCase = load("expui/inline/matchCase.svg", "actions/matchCase.svg", 669255855, 0);
    /** 16x16 */ public static final @NotNull Icon MatchCaseHovered = load("expui/inline/matchCase.svg", "actions/matchCaseHovered.svg", -484151390, 0);
    /** 16x16 */ public static final @NotNull Icon MatchCaseSelected = load("expui/inline/matchCase.svg", "actions/matchCaseSelected.svg", -1865066843, 0);
    /** 16x16 */ public static final @NotNull Icon MenuCut = load("expui/general/cut.svg", "actions/menu-cut.svg", 246355046, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_cut = MenuCut;
    /** 16x16 */ public static final @NotNull Icon MenuOpen = load("expui/general/open.svg", "actions/menu-open.svg", 736641834, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_open = MenuOpen;
    /** 16x16 */ public static final @NotNull Icon MenuPaste = load("expui/general/paste.svg", "actions/menu-paste.svg", -1575072734, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_paste = MenuPaste;
    /** 16x16 */ public static final @NotNull Icon MenuSaveall = load("expui/general/save.svg", "actions/menu-saveall.svg", 63691479, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Menu_saveall = MenuSaveall;
    /** 16x16 */ public static final @NotNull Icon Minimap = load("expui/actions/minimap.svg", "actions/minimap.svg", -319068080, 2);
    /** 16x16 */ public static final @NotNull Icon ModuleDirectory = load("expui/nodes/module.svg", "actions/moduleDirectory.svg", -1320924233, 2);
    /** 16x16 */ public static final @NotNull Icon More = load("expui/general/moreVertical.svg", "actions/more.svg", 2111376411, 10);
    /** 16x16 */ public static final @NotNull Icon MoreHorizontal = load("expui/general/moreHorizontal.svg", "actions/moreHorizontal.svg", -2048319791, 2);
    /** 12x12 */ public static final @NotNull Icon MoveToButton = load("expui/actions/moveToButton.svg", "actions/move-to-button.svg", -118707213, 2);
    /** 16x16 */ public static final @NotNull Icon MoveDown = load("expui/general/moveDown.svg", "actions/moveDown.svg", -2118323295, 2);
    /** 16x16 */ public static final @NotNull Icon MoveTo2 = load("expui/actions/moveToWindow.svg", "actions/MoveTo2.svg", 1643543562, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToBottomLeft = load("expui/actions/moveToBottomLeft.svg", "actions/moveToBottomLeft.svg", -571630777, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToBottomRight = load("expui/actions/moveToBottomRight.svg", "actions/moveToBottomRight.svg", 1506844169, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToLeftBottom = load("expui/actions/moveToLeftBottom.svg", "actions/moveToLeftBottom.svg", -1888615188, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToLeftTop = load("expui/actions/moveToLeftTop.svg", "actions/moveToLeftTop.svg", 1131863880, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToRightBottom = load("expui/actions/moveToRightBottom.svg", "actions/moveToRightBottom.svg", 2029282363, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToRightTop = load("expui/actions/moveToRightTop.svg", "actions/moveToRightTop.svg", 2034850953, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToTopLeft = load("actions/moveToTopLeft.svg", 1557541143, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToTopRight = load("actions/moveToTopRight.svg", 1602400676, 2);
    /** 16x16 */ public static final @NotNull Icon MoveToWindow = load("expui/actions/moveToWindow.svg", "actions/moveToWindow.svg", 434637226, 2);
    /** 16x16 */ public static final @NotNull Icon MoveUp = load("expui/general/moveUp.svg", "actions/moveUp.svg", 462475104, 2);
    /** 16x16 */ public static final @NotNull Icon New = load("actions/new.svg", 418266197, 2);
    /** 16x16 */ public static final @NotNull Icon NewFolder = load("expui/actions/newFolder.svg", "actions/newFolder.svg", 1755918051, 2);
    /** 16x16 */ public static final @NotNull Icon NextOccurence = load("expui/general/down.svg", "actions/nextOccurence.svg", -462515105, 2);
    /** 16x16 */ public static final @NotNull Icon OfflineMode = load("expui/build/toggleOfflineMode.svg", "actions/offlineMode.svg", 1767884287, 2);
    /** 16x16 */ public static final @NotNull Icon OpenNewTab = load("expui/general/openNewTab.svg", "actions/openNewTab.svg", 1663264499, 2);
    /** 16x16 */ public static final @NotNull Icon Pause = load("expui/run/pause.svg", "actions/pause.svg", -1885569410, 2);
    /** 16x16 */ public static final @NotNull Icon PinTab = load("expui/general/pin.svg", "actions/pinTab.svg", -1265255697, 0);
    /** 16x16 */ public static final @NotNull Icon Play_back = load("expui/actions/playBack.svg", "actions/play_back.svg", -1317377797, 2);
    /** 16x16 */ public static final @NotNull Icon Play_first = load("expui/actions/playFirst.svg", "actions/play_first.svg", -987505166, 2);
    /** 16x16 */ public static final @NotNull Icon Play_forward = load("expui/actions/playForward.svg", "actions/play_forward.svg", 84808551, 2);
    /** 16x16 */ public static final @NotNull Icon Play_last = load("expui/actions/playLast.svg", "actions/play_last.svg", 1200003259, 2);
    /** 16x16 */ public static final @NotNull Icon PopFrame = load("expui/actions/popFrame.svg", "actions/popFrame.svg", -2061379356, 2);
    /** 26x26 */ public static final @NotNull Icon PresentationAssistantSettings = load("actions/presentationAssistantSettings.svg", -1777013294, 0);
    /** 16x16 */ public static final @NotNull Icon PreserveCase = load("expui/inline/preserveCase.svg", "actions/preserveCase.svg", 1309462994, 0);
    /** 16x16 */ public static final @NotNull Icon PreserveCaseHover = load("expui/inline/preserveCase.svg", "actions/preserveCaseHover.svg", 819147333, 0);
    /** 16x16 */ public static final @NotNull Icon PreserveCaseSelected = load("expui/inline/preserveCase.svg", "actions/preserveCaseSelected.svg", 456685590, 0);
    /** 16x16 */ public static final @NotNull Icon PrettyPrint = load("expui/json/object.svg", "actions/prettyPrint.svg", -1796124934, 2);
    /** 16x16 */ public static final @NotNull Icon Preview = load("expui/actions/preview.svg", "actions/preview.svg", -611174879, 2);
    /** 16x16 */ public static final @NotNull Icon PreviewDetails = load("expui/general/previewVertically.svg", "actions/previewDetails.svg", -784397614, 2);
    /** 16x16 */ public static final @NotNull Icon PreviewDetailsVertically = load("expui/general/previewHorizontally.svg", "actions/previewDetailsVertically.svg", -2143150468, 2);
    /** 16x16 */ public static final @NotNull Icon PreviousOccurence = load("expui/general/up.svg", "actions/previousOccurence.svg", -753321803, 2);
    /** 16x16 */ public static final @NotNull Icon Profile = load("expui/run/profile.svg", "actions/profile.svg", 296104332, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileBlue = load("expui/actions/profileBlue.svg", "actions/profileBlue.svg", 1511636999, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileCPU = load("expui/actions/profileCPU.svg", "actions/profileCPU.svg", 343461760, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileMemory = load("expui/actions/profileMemory.svg", "actions/profileMemory.svg", -744762259, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileRed = load("expui/actions/profileRed.svg", "actions/profileRed.svg", 1685012249, 2);
    /** 16x16 */ public static final @NotNull Icon ProfileYellow = load("expui/actions/profileYellow.svg", "actions/profileYellow.svg", -1080286067, 2);
    /** 16x16 */ public static final @NotNull Icon ProjectDirectory = load("expui/actions/projectDirectory.svg", "actions/projectDirectory.svg", 2070345485, 2);
    /** 16x16 */ public static final @NotNull Icon ProjectWideAnalysisOff = load("expui/general/projectWideAnalysisOff.svg", "actions/projectWideAnalysisOff.svg", 1724481315, 2);
    /** 16x16 */ public static final @NotNull Icon ProjectWideAnalysisOn = load("expui/general/projectWideAnalysisOn.svg", "actions/projectWideAnalysisOn.svg", -1997754020, 2);
    /** 16x16 */ public static final @NotNull Icon Properties = load("expui/actions/properties.svg", "actions/properties.svg", -2069838629, 2);
    /** 16x16 */ public static final @NotNull Icon QuickfixBulb = load("expui/codeInsight/quickfixBulb.svg", "actions/quickfixBulb.svg", 504966466, 2);
    /** 16x16 */ public static final @NotNull Icon QuickfixOffBulb = load("expui/codeInsight/quickfixOffBulb.svg", "actions/quickfixOffBulb.svg", 1578042208, 2);
    /** 16x16 */ public static final @NotNull Icon RealIntentionBulb = load("expui/actions/realIntentionBulb.svg", "actions/realIntentionBulb.svg", -278510297, 2);
    /** 16x16 */ public static final @NotNull Icon Rebuild = load("expui/build/rebuild.svg", "actions/rebuild.svg", 1344326415, 2);
    /** 16x16 */ public static final @NotNull Icon Redo = load("expui/general/redo.svg", "actions/redo.svg", 570708211, 2);
    /** 16x16 */ public static final @NotNull Icon RefactoringBulb = load("expui/actions/refactoringBulb.svg", "actions/refactoringBulb.svg", 1311756364, 2);
    /** 16x16 */ public static final @NotNull Icon ReformatCode = load("expui/actions/reformatCode.svg", "actions/reformatCode.svg", 1951359266, 2);
    /** 16x16 */ public static final @NotNull Icon Refresh = load("expui/general/refresh.svg", "actions/refresh.svg", -1006736095, 2);
    /** 16x16 */ public static final @NotNull Icon Regex = load("expui/inline/regex.svg", "actions/regex.svg", -427608526, 0);
    /** 16x16 */ public static final @NotNull Icon RegexHovered = load("expui/inline/regex.svg", "actions/regexHovered.svg", 277788380, 0);
    /** 16x16 */ public static final @NotNull Icon RegexSelected = load("expui/inline/regex.svg", "actions/regexSelected.svg", -1236895115, 0);
    /** 16x16 */ public static final @NotNull Icon RemoveMulticaret = load("expui/general/remove.svg", "actions/RemoveMulticaret.svg", -1355504116, 2);
    /** 16x16 */ public static final @NotNull Icon Replace = load("expui/actions/replace.svg", "actions/replace.svg", -1345158078, 2);
    /** 14x14 */ public static final @NotNull Icon Report = load("expui/actions/report.svg", "actions/report.svg", -500605036, 2);
    /** 16x16 */ public static final @NotNull Icon Rerun = load("expui/run/rerun.svg", "actions/rerun.svg", 1211368783, 10);
    /** 16x16 */ public static final @NotNull Icon RerunAutomatically = load("expui/actions/rerunAutomatically.svg", "actions/rerunAutomatically.svg", -404420348, 2);
    /** 16x16 */ public static final @NotNull Icon Restart = load("expui/run/restart.svg", "actions/restart.svg", -1074337097, 2);
    /** 16x16 */ public static final @NotNull Icon RestartDebugger = load("expui/run/restartDebug.svg", "actions/restartDebugger.svg", 893306448, 10);
    /** 16x16 */ public static final @NotNull Icon RestartFrame = load("expui/run/restartFrame.svg", "actions/restartFrame.svg", 251948842, 2);
    /** 16x16 */ public static final @NotNull Icon RestartStop = load("expui/actions/restartStop.svg", 1857418841, 2);
    /** 16x16 */ public static final @NotNull Icon Resume = load("expui/run/resume.svg", "actions/resume.svg", 1214638615, 10);
    /** 16x16 */ public static final @NotNull Icon Rollback = load("expui/vcs/revert.svg", "actions/rollback.svg", 2087548212, 2);
    /** 16x16 */ public static final @NotNull Icon RunAll = load("expui/actions/runAll.svg", "actions/runAll.svg", -398248691, 2);
    /** 16x16 */ public static final @NotNull Icon RunAnything = load("expui/general/runAnything.svg", "actions/runAnything.svg", -1866617388, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Run_anything = RunAnything;
    /** 16x16 */ public static final @NotNull Icon RunToCursor = load("expui/run/runToCursor.svg", "actions/runToCursor.svg", -378582672, 2);
    /** 16x16 */ public static final @NotNull Icon Scratch = load("expui/fileTypes/scratch.svg", "actions/scratch.svg", -459337085, 2);
    /** 16x16 */ public static final @NotNull Icon Search = load("expui/general/search.svg", "actions/search.svg", -2085119439, 0);
    /** 16x16 */ public static final @NotNull Icon SearchNewLine = load("expui/inline/newLine.svg", "actions/searchNewLine.svg", 1127889338, 0);
    /** 16x16 */ public static final @NotNull Icon SearchNewLineHover = load("expui/inline/newLine.svg", "actions/searchNewLineHover.svg", 988702348, 0);
    /** 16x16 */ public static final @NotNull Icon SearchWithHistory = load("expui/inline/searchHistory.svg", "actions/searchWithHistory.svg", 1432525015, 0);
    /** 16x16 */ public static final @NotNull Icon Selectall = load("expui/actions/selectAll.svg", "actions/selectall.svg", -42839868, 2);
    /** 16x16 */ public static final @NotNull Icon SetDefault = load("expui/actions/checked.svg", "actions/setDefault.svg", -1583117311, 2);
    /** 14x14 */ public static final @NotNull Icon Share = load("expui/general/show.svg", "actions/share.png", 0, 1);
    /** 16x16 */ public static final @NotNull Icon ShortcutFilter = load("expui/actions/shortcutFilter.svg", "actions/shortcutFilter.svg", -1865443324, 2);
    /** 16x16 */ public static final @NotNull Icon Show = load("expui/general/show.svg", "actions/show.svg", 106880337, 2);
    /** 16x16 */ public static final @NotNull Icon ShowAsTree = load("expui/general/showAsTree.svg", "actions/showAsTree.svg", -1651129437, 2);
    /** 16x16 */ public static final @NotNull Icon ShowCode = load("expui/actions/toggleVisibility.svg", "actions/showCode.svg", 960964407, 2);
    /** 16x16 */ public static final @NotNull Icon ShowImportStatements = load("expui/actions/showImportStatements.svg", "actions/showImportStatements.svg", 703949292, 2);
    /** 16x16 */ public static final @NotNull Icon ShowReadAccess = load("expui/actions/showReadAccess.svg", "actions/showReadAccess.svg", -1565481823, 2);
    /** 16x16 */ public static final @NotNull Icon ShowWriteAccess = load("expui/actions/showWriteAccess.svg", "actions/showWriteAccess.svg", 13731892, 2);
    /** 16x16 */ public static final @NotNull Icon SplitHorizontally = load("expui/general/splitHorizontally.svg", "actions/splitHorizontally.svg", 1504815794, 2);
    /** 16x16 */ public static final @NotNull Icon SplitVertically = load("expui/general/splitVertically.svg", "actions/splitVertically.svg", 438630781, 2);
    /** 16x16 */ public static final @NotNull Icon StartDebugger = load("expui/run/debug.svg", "actions/startDebugger.svg", 1950427196, 10);
    /** 16x16 */ public static final @NotNull Icon StartMemoryProfile = load("expui/actions/startMemoryProfile.svg", "actions/startMemoryProfile.svg", -1333802318, 2);
    /** 16x16 */ public static final @NotNull Icon StepOut = load("expui/run/stepOut.svg", "actions/stepOut.svg", -525700232, 2);
    /** 16x16 */ public static final @NotNull Icon StepOutCodeBlock = load("expui/run/stepOutCodeBlock.svg", "actions/stepOutCodeBlock.svg", 1629750131, 2);
    /** 16x16 */ public static final @NotNull Icon StopAndRestart = load("actions/stopAndRestart.svg", 1639589680, 2);
    /** 16x16 */ public static final @NotNull Icon StopRefresh = load("expui/actions/stopRefresh.svg", "actions/stopRefresh.svg", -1056556267, 2);
    /** 16x16 */ public static final @NotNull Icon StopWatch = load("expui/actions/stopWatch.svg", "actions/stopWatch.svg", -1197416482, 0);
    /** 16x16 */ public static final @NotNull Icon Stub = load("actions/stub.svg", -953319628, 2);
    /** 16x16 */ public static final @NotNull Icon SuggestedRefactoringBulb = load("expui/actions/suggestedRefactoringBulb.svg", "actions/suggestedRefactoringBulb.svg", 1703386418, 2);
    /** 16x16 */ public static final @NotNull Icon Suspend = load("expui/run/stop.svg", "actions/suspend.svg", 43249293, 10);
    /** 16x16 */ public static final @NotNull Icon SwapPanels = load("expui/actions/swapPanels.svg", "actions/swapPanels.svg", -1733374780, 2);
    /** 16x16 */ public static final @NotNull Icon SynchronizeScrolling = load("expui/actions/synchronizeScrolling.svg", "actions/synchronizeScrolling.svg", 1717611130, 2);
    /** 16x16 */ public static final @NotNull Icon SyncPanels = load("actions/syncPanels.svg", 1293631191, 2);
    /** 16x16 */ public static final @NotNull Icon ToggleSoftWrap = load("expui/general/softWrap.svg", "actions/toggleSoftWrap.svg", 605284848, 2);
    /** 16x16 */ public static final @NotNull Icon ToggleVisibility = load("expui/actions/toggleVisibility.svg", "actions/toggleVisibility.svg", 374335214, 2);
    /** 16x16 */ public static final @NotNull Icon TraceInto = load("expui/run/stepInto.svg", "actions/traceInto.svg", -402354793, 2);
    /** 16x16 */ public static final @NotNull Icon TraceOver = load("expui/run/stepOver.svg", "actions/traceOver.svg", 1371545688, 2);
    /** 16x16 */ public static final @NotNull Icon Undo = load("expui/general/undo.svg", "actions/undo.svg", -1189463185, 2);
    /** 16x16 */ public static final @NotNull Icon Uninstall = load("expui/actions/uninstall.svg", "actions/uninstall.svg", -536173621, 2);
    /** 16x16 */ public static final @NotNull Icon Unselectall = load("expui/actions/unselectAll.svg", "actions/unselectall.svg", 1710075134, 2);
    /** 14x14 */ public static final @NotNull Icon Unshare = load("expui/actions/unshare.svg", "actions/unshare.png", 0, 1);
    /** 16x16 */ public static final @NotNull Icon Upload = load("expui/general/upload.svg", "actions/upload.svg", -1680651230, 2);
    /** 16x16 */ public static final @NotNull Icon ViewAsImage = load("expui/actions/viewAsImage.svg", -384883859, 2);
    /** 16x16 */ public static final @NotNull Icon Words = load("expui/inline/exactWords.svg", "actions/words.svg", -2038279531, 0);
    /** 16x16 */ public static final @NotNull Icon WordsHovered = load("expui/inline/exactWords.svg", "actions/wordsHovered.svg", 1488302022, 0);
    /** 16x16 */ public static final @NotNull Icon WordsSelected = load("expui/inline/exactWords.svg", "actions/wordsSelected.svg", 128086410, 0);

    /** @deprecated to be removed (use expandable text field instead, see https://plugins.jetbrains.com/docs/intellij/built-in-button.html) */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval
    public static final @NotNull Icon ShowViewer = load("actions/showViewer.png", 0, 0);
  }

  public static final class Breakpoints {
    /** 14x14 */ public static final @NotNull Icon BreakpointFieldUnsuspendentDisabled = load("expui/breakpoints/breakpointFieldUnsuspendentDisabled.svg", -1363984560, 2);
    /** 14x14 */ public static final @NotNull Icon BreakpointMethodUnsuspendentDisabled = load("expui/breakpoints/breakpointMethodUnsuspendentDisabled.svg", 2054364640, 2);
    /** 14x14 */ public static final @NotNull Icon BreakpointUnsuspendentDisabled = load("expui/breakpoints/breakpointUnsuspendentDisabled.svg", 1020097126, 2);
    /** 14x14 */ public static final @NotNull Icon MultipleBreakpointsDisabled = load("expui/breakpoints/multipleBreakpointsDisabled.svg", -358532645, 2);
    /** 14x14 */ public static final @NotNull Icon MultipleBreakpointsMuted = load("expui/breakpoints/multipleBreakpointsMuted.svg", -1544664600, 2);
  }

  public static final class Chooser {
    /** 16x16 */ public static final @NotNull Icon Bottom = load("expui/general/down.svg", "chooser/bottom.svg", -411920834, 2);
    /** 16x16 */ public static final @NotNull Icon Left = load("expui/general/left.svg", "chooser/left.svg", 277946192, 2);
    /** 16x16 */ public static final @NotNull Icon Right = load("expui/general/right.svg", "chooser/right.svg", 51906324, 2);
    /** 16x16 */ public static final @NotNull Icon Top = load("expui/general/up.svg", "chooser/top.svg", -1137586550, 2);
  }

  public static final class CodeStyle {
    /** 16x16 */ public static final @NotNull Icon AddNewSectionRule = load("codeStyle/AddNewSectionRule.svg", -370510395, 2);
  }

  public static final class CodeWithMe {
    /** 16x16 */ public static final @NotNull Icon CwmAccess = load("expui/codeWithMe/cwmAccess.svg", "codeWithMe/cwmAccess.svg", -49419993, 2);
    /** 12x16 */ public static final @NotNull Icon CwmAccessDotOff = load("codeWithMe/cwmAccessDotOff.svg", -914994633, 2);
    /** 12x16 */ public static final @NotNull Icon CwmAccessDotOn = load("codeWithMe/cwmAccessDotOn.svg", -1553449755, 2);
    /** 16x16 */ public static final @NotNull Icon CwmAccessOff = load("codeWithMe/cwmAccessOff.svg", 1653401446, 2);
    /** 16x16 */ public static final @NotNull Icon CwmAccessOn = load("codeWithMe/cwmAccessOn.svg", 1998726206, 2);
    /** 11x11 */ public static final @NotNull Icon CwmCamAvatarOff = load("expui/codeWithMe/cwmCamAvatarOff.svg", "codeWithMe/cwmCamAvatarOff.svg", -1026282674, 2);
    /** 11x11 */ public static final @NotNull Icon CwmCamAvatarOn = load("expui/codeWithMe/cwmCamAvatarOn.svg", "codeWithMe/cwmCamAvatarOn.svg", -1040341363, 2);
    /** 16x16 */ public static final @NotNull Icon CwmCamOff = load("expui/codeWithMe/cwmCamOff.svg", "codeWithMe/cwmCamOff.svg", -539405379, 2);
    /** 16x16 */ public static final @NotNull Icon CwmCamOn = load("expui/codeWithMe/cwmCamOn.svg", "codeWithMe/cwmCamOn.svg", 1600186319, 2);
    /** 16x16 */ public static final @NotNull Icon CwmDisableCall = load("expui/codeWithMe/cwmDisableCall.svg", "codeWithMe/cwmDisableCall.svg", -1089173198, 2);
    /** 16x16 */ public static final @NotNull Icon CwmEnableCall = load("expui/codeWithMe/cwmEnableCall.svg", "codeWithMe/cwmEnableCall.svg", 493078410, 2);
    /** 16x16 */ public static final @NotNull Icon CwmFollow = load("codeWithMe/cwmFollow.svg", 32250033, 2);
    /** 16x16 */ public static final @NotNull Icon CwmFollowMe = load("codeWithMe/cwmFollowMe.svg", 469126743, 2);
    /** 16x16 */ public static final @NotNull Icon CwmForceFollowMe = load("codeWithMe/cwmForceFollowMe.svg", -674675027, 2);
    /** 16x16 */ public static final @NotNull Icon CwmFullSync = load("codeWithMe/cwmFullSync.svg", -669424970, 2);
    /** 17x17 */ public static final @NotNull Icon CwmIconModificator = load("expui/codeWithMe/cwmIconModificator.svg", "codeWithMe/cwmIconModificator.svg", 327722312, 2);
    /** 16x16 */ public static final @NotNull Icon CwmIconModificatorMenu = load("expui/codeWithMe/cwmIconModificatorMenu.svg", "codeWithMe/cwmIconModificatorMenu.svg", 1065499989, 2);
    /** 16x16 */ public static final @NotNull Icon CwmInvite = load("expui/codeWithMe/cwmInvite.svg", "codeWithMe/cwmInvite.svg", -728953088, 2);
    /** 16x16 */ public static final @NotNull Icon CwmJoin = load("codeWithMe/cwmJoin.svg", 161649229, 2);
    /** 16x16 */ public static final @NotNull Icon CwmJump = load("codeWithMe/cwmJump.svg", 1649603449, 2);
    /** 16x16 */ public static final @NotNull Icon CwmKick = load("codeWithMe/cwmKick.svg", -671665416, 2);
    /** 16x16 */ public static final @NotNull Icon CwmLeaveCall = load("codeWithMe/cwmLeaveCall.svg", -1767616763, 2);
    /** 16x16 */ public static final @NotNull Icon CwmLogoToolbar = load("codeWithMe/cwmLogoToolbar.svg", 438915304, 0);
    /** 11x11 */ public static final @NotNull Icon CwmMicAvatarOff = load("expui/codeWithMe/cwmMicAvatarOff.svg", "codeWithMe/cwmMicAvatarOff.svg", -1210484612, 2);
    /** 11x11 */ public static final @NotNull Icon CwmMicAvatarOn = load("expui/codeWithMe/cwmMicAvatarOn.svg", "codeWithMe/cwmMicAvatarOn.svg", 1985059266, 2);
    /** 16x16 */ public static final @NotNull Icon CwmMicOff = load("expui/codeWithMe/cwmMicOff.svg", "codeWithMe/cwmMicOff.svg", 1631410875, 2);
    /** 16x16 */ public static final @NotNull Icon CwmMicOn = load("expui/codeWithMe/cwmMicOn.svg", "codeWithMe/cwmMicOn.svg", 467840411, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissionEdit = load("expui/codeWithMe/cwmPermissionEdit.svg", "codeWithMe/cwmPermissionEdit.svg", 1394955003, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissionFull = load("expui/codeWithMe/cwmPermissionFull.svg", "codeWithMe/cwmPermissionFull.svg", -507224064, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissions = load("expui/codeWithMe/cwmPermissions.svg", "codeWithMe/cwmPermissions.svg", -739028255, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissionsDenied = load("expui/codeWithMe/cwmPermissionsDenied.svg", "codeWithMe/cwmPermissionsDenied.svg", 741643246, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissionsGranted = load("expui/codeWithMe/cwmPermissionsGranted.svg", "codeWithMe/cwmPermissionsGranted.svg", 89346274, 2);
    /** 16x16 */ public static final @NotNull Icon CwmPermissionView = load("expui/codeWithMe/cwmPermissionView.svg", "codeWithMe/cwmPermissionView.svg", 355418495, 2);
    /** 16x16 */ public static final @NotNull Icon CwmScreenInBrowserOff = load("expui/codeWithMe/cwmScreenInBrowserOff.svg", "codeWithMe/cwmScreenInBrowserOff.svg", -345267809, 2);
    /** 16x16 */ public static final @NotNull Icon CwmScreenInBrowserOn = load("expui/codeWithMe/cwmScreenInBrowserOn.svg", "codeWithMe/cwmScreenInBrowserOn.svg", -1399166947, 2);
    /** 16x16 */ public static final @NotNull Icon CwmScreenOff = load("expui/codeWithMe/cwmScreenOff.svg", "codeWithMe/cwmScreenOff.svg", -1526254437, 2);
    /** 16x16 */ public static final @NotNull Icon CwmScreenOn = load("expui/codeWithMe/cwmScreenOn.svg", "codeWithMe/cwmScreenOn.svg", -1799304670, 2);
    /** 16x16 */ public static final @NotNull Icon CwmShared = load("expui/codeWithMe/cwmShare.svg", "codeWithMe/cwmShared.svg", -2035204589, 2);
    /** 11x11 */ public static final @NotNull Icon CwmSharingAvatarOn = load("expui/codeWithMe/cwmSharingAvatarOn.svg", 104822006, 2);
    /** 16x16 */ public static final @NotNull Icon CwmTerminate = load("expui/general/close.svg", "codeWithMe/cwmTerminate.svg", -1812972690, 2);
    /** 14x14 */ public static final @NotNull Icon CwmVerified = load("expui/codeWithMe/cwmVerified.svg", "codeWithMe/cwmVerified.svg", 1403626713, 2);
    /** 16x16 */ public static final @NotNull Icon Users = load("expui/codeWithMe/cwmUsers.svg", "codeWithMe/users.svg", 479861302, 2);
  }

  public static final class Debugger {
    /** 16x16 */ public static final @NotNull Icon AddToWatch = load("expui/debugger/addToWatch.svg", "debugger/addToWatch.svg", 409901811, 2);
    /** 16x16 */ public static final @NotNull Icon AttachToProcess = load("expui/run/attachToProcess.svg", "debugger/attachToProcess.svg", 1092374815, 2);
    /** 16x16 */ public static final @NotNull Icon ClassLevelWatch = load("expui/debugger/classLevelWatch.svg", "debugger/classLevelWatch.svg", -270615083, 2);
    /** 16x16 */ public static final @NotNull Icon Console = load("expui/fileTypes/shell.svg", "debugger/console.svg", -1395573079, 2);
    /** 16x16 */ public static final @NotNull Icon Db_array = load("expui/debugger/dbArray.svg", "debugger/db_array.svg", -929290955, 2);
    /** 16x16 */ public static final @NotNull Icon Db_db_object = load("expui/debugger/dbObject.svg", "debugger/db_db_object.svg", -1037510563, 0);
    /** 12x12 */ public static final @NotNull Icon Db_dep_field_breakpoint = load("expui/breakpoints/breakpointFieldDependent.svg", "debugger/db_dep_field_breakpoint.svg", -729657692, 2);
    /** 12x12 */ public static final @NotNull Icon Db_dep_line_breakpoint = load("expui/breakpoints/breakpointDependent.svg", "debugger/db_dep_line_breakpoint.svg", -692069594, 2);
    /** 12x12 */ public static final @NotNull Icon Db_dep_method_breakpoint = load("expui/breakpoints/breakpointMethodDependent.svg", "debugger/db_dep_method_breakpoint.svg", -1761959681, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_breakpoint = load("expui/breakpoints/breakpointDisabled.svg", "debugger/db_disabled_breakpoint.svg", 957231502, 2);
    /** 16x16 */ public static final @NotNull Icon Db_disabled_breakpoint_process = load("debugger/db_disabled_breakpoint_process.svg", 1726672811, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_exception_breakpoint = load("expui/breakpoints/breakpointExceptionDisabled.svg", "debugger/db_disabled_exception_breakpoint.svg", 347218996, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_field_breakpoint = load("expui/breakpoints/breakpointFieldDisabled.svg", "debugger/db_disabled_field_breakpoint.svg", 855700018, 2);
    /** 12x12 */ public static final @NotNull Icon Db_disabled_method_breakpoint = load("expui/breakpoints/breakpointMethodDisabled.svg", "debugger/db_disabled_method_breakpoint.svg", -2102319101, 2);
    /** 16x16 */ public static final @NotNull Icon Db_evaluateNode = load("expui/run/evaluateExpression.svg", "debugger/db_evaluateNode.svg", 825992965, 0);
    /** 12x12 */ public static final @NotNull Icon Db_exception_breakpoint = load("expui/breakpoints/breakpointException.svg", "debugger/db_exception_breakpoint.svg", 1464164799, 2);
    /** 12x12 */ public static final @NotNull Icon Db_field_breakpoint = load("expui/breakpoints/breakpointField.svg", "debugger/db_field_breakpoint.svg", 33099766, 2);
    /** 12x12 */ public static final @NotNull Icon Db_invalid_breakpoint = load("expui/breakpoints/breakpointInvalid.svg", "debugger/db_invalid_breakpoint.svg", 1226767521, 2);
    /** 12x12 */ public static final @NotNull Icon Db_method_breakpoint = load("expui/breakpoints/breakpointMethod.svg", "debugger/db_method_breakpoint.svg", 2086010053, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_breakpoint = load("expui/breakpoints/breakpointMuted.svg", "debugger/db_muted_breakpoint.svg", 837968042, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_dep_field_breakpoint = load("expui/breakpoints/breakpointFieldMutedDependent.svg", "debugger/db_muted_dep_field_breakpoint.svg", -1794532402, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_dep_line_breakpoint = load("expui/breakpoints/breakpointMutedDependent.svg", "debugger/db_muted_dep_line_breakpoint.svg", 114287810, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_dep_method_breakpoint = load("expui/breakpoints/breakpointMethodMutedDependent.svg", "debugger/db_muted_dep_method_breakpoint.svg", -1185397526, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_disabled_breakpoint = load("expui/breakpoints/breakpointMutedDisabled.svg", "debugger/db_muted_disabled_breakpoint.svg", 265327728, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_disabled_field_breakpoint = load("expui/breakpoints/breakpointFieldMutedDisabled.svg", "debugger/db_muted_disabled_field_breakpoint.svg", -1868522351, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_disabled_method_breakpoint = load("expui/breakpoints/breakpointMethodMutedDisabled.svg", "debugger/db_muted_disabled_method_breakpoint.svg", -1055846849, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_field_breakpoint = load("expui/breakpoints/breakpointFieldMuted.svg", "debugger/db_muted_field_breakpoint.svg", -416319835, 2);
    /** 12x12 */ public static final @NotNull Icon Db_muted_method_breakpoint = load("expui/breakpoints/breakpointMethodMuted.svg", "debugger/db_muted_method_breakpoint.svg", -155879651, 2);
    /** 12x12 */ public static final @NotNull Icon Db_no_suspend_breakpoint = load("expui/breakpoints/breakpointUnsuspendent.svg", "debugger/db_no_suspend_breakpoint.svg", -1486058223, 2);
    /** 12x12 */ public static final @NotNull Icon Db_no_suspend_field_breakpoint = load("expui/breakpoints/breakpointFieldUnsuspendent.svg", "debugger/db_no_suspend_field_breakpoint.svg", 1406642810, 2);
    /** 12x12 */ public static final @NotNull Icon Db_no_suspend_method_breakpoint = load("expui/breakpoints/breakpointMethodUnsuspendent.svg", "debugger/db_no_suspend_method_breakpoint.svg", 434900251, 2);
    /** 12x12 */ public static final @NotNull Icon Db_obsolete = load("expui/breakpoints/breakpointObsolete.svg", "debugger/db_obsolete.svg", 892802114, 2);
    /** 16x16 */ public static final @NotNull Icon Db_primitive = load("expui/debugger/dbPrimitive.svg", "debugger/db_primitive.svg", -1494955799, 0);
    /** 12x12 */ public static final @NotNull Icon Db_set_breakpoint = load("expui/breakpoints/breakpoint.svg", "debugger/db_set_breakpoint.svg", 40000634, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_breakpoint = load("expui/breakpoints/breakpointValid.svg", "debugger/db_verified_breakpoint.svg", -82047563, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_field_breakpoint = load("expui/breakpoints/breakpointFieldValid.svg", "debugger/db_verified_field_breakpoint.svg", 341339981, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_method_breakpoint = load("expui/breakpoints/breakpointMethodValid.svg", "debugger/db_verified_method_breakpoint.svg", -1402274643, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_no_suspend_breakpoint = load("expui/breakpoints/breakpointUnsuspendentValid.svg", "debugger/db_verified_no_suspend_breakpoint.svg", -1107478585, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_no_suspend_field_breakpoint = load("expui/breakpoints/breakpointFieldUnsuspendentValid.svg", "debugger/db_verified_no_suspend_field_breakpoint.svg", 668596864, 2);
    /** 12x12 */ public static final @NotNull Icon Db_verified_no_suspend_method_breakpoint = load("expui/breakpoints/breakpointMethodUnsuspendentValid.svg", "debugger/db_verified_no_suspend_method_breakpoint.svg", 1053525169, 2);
    /** 16x16 */ public static final @NotNull Icon Db_watch = load("expui/debugger/watch.svg", "debugger/db_watch.svg", -1666860072, 0);
    /** 16x16 */ public static final @NotNull Icon DebuggerSync = load("expui/debugger/debuggerSync.svg", -370007676, 2);
    /** 16x16 */ public static final @NotNull Icon EvaluateExpression = load("expui/run/evaluateExpression.svg", "debugger/evaluateExpression.svg", -1762455063, 2);
    /** 16x16 */ public static final @NotNull Icon EvaluationResult = load("expui/debugger/evaluationResult.svg", "debugger/evaluationResult.svg", 1466088690, 2);
    /** 16x16 */ public static final @NotNull Icon ExecuteCurrentStatement = load("expui/debugger/executeCurrentStatement.svg", "debugger/executeCurrentStatement.svg", -43244894, 2);
    /** 16x16 */ public static final @NotNull Icon ForceRunToCursor = load("expui/run/forceRunToCursor.svg", "debugger/forceRunToCursor.svg", 1765887966, 2);
    /** 16x16 */ public static final @NotNull Icon ForceStepInto = load("expui/run/forceStepInto.svg", "debugger/forceStepInto.svg", -897444087, 2);
    /** 16x16 */ public static final @NotNull Icon ForceStepOver = load("expui/run/forceStepOver.svg", "debugger/forceStepOver.svg", 1412423475, 2);
    /** 16x16 */ public static final @NotNull Icon Frame = load("expui/debugger/frame.svg", "debugger/frame.svg", -388104166, 2);
    /** 16x16 */ public static final @NotNull Icon Freeze = load("expui/debugger/freeze.svg", "debugger/freeze.svg", 754396711, 2);
    /** 16x16 */ public static final @NotNull Icon FreezeAll = load("expui/debugger/freezeAll.svg", "debugger/freezeAll.svg", 1588999303, 2);
    /** 16x16 */ public static final @NotNull Icon KillProcess = load("expui/run/killProcess.svg", "debugger/killProcess.svg", 1100470732, 2);
    /** 12x12 */ public static final @NotNull Icon LambdaBreakpoint = load("expui/breakpoints/breakpointLambda.svg", "debugger/LambdaBreakpoint.svg", -2130747183, 2);
    /** 12x12 */ public static final @NotNull Icon MultipleBreakpoints = load("expui/breakpoints/multipleBreakpoints.svg", "debugger/MultipleBreakpoints.svg", -1140485658, 2);
    /** 14x14 */ public static final @NotNull Icon MultipleBreakpointsDisabled = load("debugger/multipleBreakpointsDisabled.svg", -358532645, 2);
    /** 14x14 */ public static final @NotNull Icon MultipleBreakpointsMuted = load("debugger/multipleBreakpointsMuted.svg", -1544664600, 2);
    /** 16x16 */ public static final @NotNull Icon MuteBreakpoints = load("expui/run/muteBreakpoints.svg", "debugger/muteBreakpoints.svg", 896463102, 2);
    /** 12x12 */ public static final @NotNull Icon NextStatement = load("expui/debugger/nextStatement.svg", "debugger/nextStatement.svg", -1096276944, 2);
    /** 16x16 */ public static final @NotNull Icon Overhead = load("expui/debugger/overhead.svg", "debugger/overhead.svg", -837590875, 2);
    /** 16x16 */ public static final @NotNull Icon PromptInput = load("expui/debugger/promptInput.svg", "debugger/promptInput.svg", -1485755492, 2);
    /** 16x16 */ public static final @NotNull Icon PromptInputHistory = load("expui/debugger/promptInputHistory.svg", "debugger/promptInputHistory.svg", -526772481, 2);
    /** 7x9 */ public static final @NotNull Icon Question_badge = load("expui/breakpoints/questionBadge.svg", "debugger/question_badge.svg", -1174769014, 2);
    /** 16x16 */ public static final @NotNull Icon RestoreLayout = load("expui/general/layout.svg", "debugger/restoreLayout.svg", 2034206966, 2);
    /** 16x16 */ public static final @NotNull Icon Selfreference = load("expui/debugger/selfReference.svg", "debugger/selfreference.svg", 1895404117, 2);
    /** 16x16 */ public static final @NotNull Icon ShowCurrentFrame = load("expui/run/showCurrentFrame.svg", "debugger/showCurrentFrame.svg", 1735060707, 2);
    /** 16x16 */ public static final @NotNull Icon SmartStepInto = load("expui/run/smartStepInto.svg", "debugger/smartStepInto.svg", 1962394045, 2);
    /** 16x16 */ public static final @NotNull Icon SpecialVar = load("expui/debugger/specialVar.svg", "debugger/specialVar.svg", 670495800, 0);
    /** 16x16 */ public static final @NotNull Icon StepIntoMyCode = load("expui/debugger/stepIntoMyCode.svg", "debugger/stepIntoMyCode.svg", -1224060921, 2);
    /** 16x16 */ public static final @NotNull Icon Thaw = load("expui/debugger/thaw.svg", "debugger/thaw.svg", 858407095, 0);
    /** 16x16 */ public static final @NotNull Icon ThawAll = load("expui/debugger/thawAll.svg", "debugger/thawAll.svg", -247611348, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadAtBreakpoint = load("expui/debugger/threadAtBreakpoint.svg", "debugger/threadAtBreakpoint.svg", -2130465671, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadCurrent = load("expui/debugger/threadCurrent.svg", "debugger/threadCurrent.svg", -580743407, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadDaemon = load("expui/debugger/threadDaemon.svg", -783029600, 2);
    /** 16x16 */ public static final @NotNull Icon ThreadFrozen = load("expui/debugger/threadFrozen.svg", "debugger/threadFrozen.svg", 579300096, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadGroup = load("expui/debugger/threads.svg", "debugger/threadGroup.svg", 1735881944, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadGroupCurrent = load("expui/debugger/threadGroupCurrent.svg", "debugger/threadGroupCurrent.svg", -46476841, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadRunning = load("expui/debugger/threadRunning.svg", "debugger/threadRunning.svg", 1288287186, 0);
    /** 16x16 */ public static final @NotNull Icon Threads = load("expui/debugger/threads.svg", "debugger/threads.svg", 49928727, 2);

    public static final class ThreadStates {
      /** 16x16 */ public static final @NotNull Icon Idle = load("expui/status/success.svg", "debugger/threadStates/idle.svg", -623903127, 2);
      /** 16x16 */ public static final @NotNull Icon Socket = load("debugger/threadStates/socket.svg", 1241843581, 2);
    }

    /** 16x16 */ public static final @NotNull Icon ThreadSuspended = load("expui/debugger/threads.svg", "debugger/threadSuspended.svg", 1956118369, 0);
    /** 16x16 */ public static final @NotNull Icon ThreadVirtual = load("expui/debugger/threadVirtual.svg", 706712162, 2);
    /** 16x16 */ public static final @NotNull Icon Value = load("expui/debugger/value.svg", "debugger/value.svg", 2139427402, 0);
    /** 16x16 */ public static final @NotNull Icon VariablesTab = load("expui/debugger/variablesTab.svg", "debugger/variablesTab.svg", -2045357702, 2);
    /** 16x16 */ public static final @NotNull Icon ViewBreakpoints = load("expui/run/viewBreakpoints.svg", "debugger/viewBreakpoints.svg", -1788984126, 2);
    /** 16x16 */ public static final @NotNull Icon Watch = load("expui/debugger/watch.svg", "debugger/watch.svg", 366548176, 2);
    /** 16x16 */ public static final @NotNull Icon WatchLastReturnValue = load("expui/debugger/watchLastReturnValue.svg", "debugger/watchLastReturnValue.svg", 1692442305, 2);
  }

  public static final class Diff {
    /** 14x14 */ public static final @NotNull Icon AddComment_14x14 = load("diff/addComment@14x14.svg", -467598878, 2);
    /** 16x16 */ public static final @NotNull Icon ApplyNotConflicts = load("expui/diff/applyNotConflicts.svg", "diff/applyNotConflicts.svg", 2046764338, 2);
    /** 16x16 */ public static final @NotNull Icon ApplyNotConflictsLeft = load("expui/diff/applyNotConflictsLeft.svg", "diff/applyNotConflictsLeft.svg", -1820078354, 2);
    /** 16x16 */ public static final @NotNull Icon ApplyNotConflictsRight = load("expui/diff/applyNotConflictsRight.svg", "diff/applyNotConflictsRight.svg", 1493717263, 2);
    /** 12x12 */ public static final @NotNull Icon Arrow = load("expui/diff/arrow@14x14.svg", "diff/arrow.svg", 18637087, 2);
    /** 12x12 */ public static final @NotNull Icon ArrowLeftDown = load("expui/diff/arrowLeftDown@14x14.svg", "diff/arrowLeftDown.svg", -542232582, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowLeftRight = load("expui/diff/arrowLeftRight.svg", "diff/arrowLeftRight.svg", 531104972, 2);
    /** 12x12 */ public static final @NotNull Icon ArrowRight = load("expui/diff/arrowRight@14x14.svg", "diff/arrowRight.svg", 159038091, 2);
    /** 12x12 */ public static final @NotNull Icon ArrowRightDown = load("expui/diff/arrowRightDown@14x14.svg", "diff/arrowRightDown.svg", 1918722830, 2);
    /** 16x16 */ public static final @NotNull Icon Compare3LeftMiddle = load("expui/diff/compare3LeftMiddle.svg", "diff/compare3LeftMiddle.svg", -1106456972, 2);
    /** 16x16 */ public static final @NotNull Icon Compare3LeftRight = load("expui/diff/compare3LeftRight.svg", "diff/compare3LeftRight.svg", 1173322498, 2);
    /** 16x16 */ public static final @NotNull Icon Compare3MiddleRight = load("expui/diff/compare3MiddleRight.svg", "diff/compare3MiddleRight.svg", -481544731, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4LeftBottom = load("expui/diff/compare4LeftBottom.svg", "diff/compare4LeftBottom.svg", -1414732150, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4LeftMiddle = load("expui/diff/compare4LeftMiddle.svg", "diff/compare4LeftMiddle.svg", 1134934754, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4LeftRight = load("expui/diff/compare4LeftRight.svg", "diff/compare4LeftRight.svg", -820874572, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4MiddleBottom = load("expui/diff/compare4MiddleBottom.svg", "diff/compare4MiddleBottom.svg", 1839574208, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4MiddleRight = load("expui/diff/compare4MiddleRight.svg", "diff/compare4MiddleRight.svg", 1406454663, 2);
    /** 16x16 */ public static final @NotNull Icon Compare4RightBottom = load("expui/diff/compare4RightBottom.svg", "diff/compare4RightBottom.svg", -838729167, 2);
    /** 12x12 */ public static final @NotNull Icon GutterCheckBox = load("expui/diff/gutterCheckBox@14x14.svg", "diff/gutterCheckBox.svg", 1404993646, 2);
    /** 12x12 */ public static final @NotNull Icon GutterCheckBoxIndeterminate = load("expui/diff/gutterCheckBoxIndeterminate@14x14.svg", "diff/gutterCheckBoxIndeterminate.svg", 463858440, 2);
    /** 12x12 */ public static final @NotNull Icon GutterCheckBoxSelected = load("expui/diff/gutterCheckBoxSelected@14x14.svg", "diff/gutterCheckBoxSelected.svg", 514644427, 2);
    /** 14x14 */ public static final @NotNull Icon HiddenComment_14x14 = load("diff/hiddenComment@14x14.svg", 964058965, 2);
    /** 16x16 */ public static final @NotNull Icon Lock = load("expui/diff/disableEditing.svg", "diff/lock.svg", 1074340224, 2);
    /** 12x12 */ public static final @NotNull Icon MagicResolve = load("expui/diff/magicResolve@14x14.svg", "diff/magicResolve.svg", 1858456010, 2);
    /** 16x16 */ public static final @NotNull Icon MagicResolveToolbar = load("expui/diff/magicResolveToolbar.svg", "diff/magicResolveToolbar.svg", 485340428, 2);
    /** 12x12 */ public static final @NotNull Icon Remove = load("expui/diff/remove@14x14.svg", "diff/remove.svg", 1317117219, 2);
    /** 12x12 */ public static final @NotNull Icon Revert = load("expui/diff/revert@14x14.svg", "diff/revert.svg", -889517433, 2);
  }

  public static final class Duplicates {
    /** 16x16 */ public static final @NotNull Icon SendToTheLeft = load("expui/duplicates/sendToTheLeft.svg", "duplicates/sendToTheLeft.png", 0, 1);
    /** 16x16 */ public static final @NotNull Icon SendToTheLeftGrayed = load("expui/duplicates/sendToTheLeftGrayed.svg", "duplicates/sendToTheLeftGrayed.png", 0, 7);
    /** 16x16 */ public static final @NotNull Icon SendToTheRight = load("expui/duplicates/sendToTheRight.svg", "duplicates/sendToTheRight.png", 0, 1);
    /** 16x16 */ public static final @NotNull Icon SendToTheRightGrayed = load("expui/duplicates/sendToTheRightGrayed.svg", "duplicates/sendToTheRightGrayed.png", 0, 7);
  }

  /** 16x16 */ public static final @NotNull Icon Empty = load("expui/empty.svg", -1490989631, 0);

  public static final class FileTypes {
    /** 16x16 */ public static final @NotNull Icon AddAny = load("expui/fileTypes/addAny.svg", "fileTypes/addAny.svg", 978449674, 0);
    /** 16x16 */ public static final @NotNull Icon Any_type = load("expui/fileTypes/anyType.svg", "fileTypes/any_type.svg", 1453411109, 0);
    /** 16x16 */ public static final @NotNull Icon Archive = load("expui/fileTypes/archive.svg", "fileTypes/archive.svg", 2114774615, 0);
    /** 16x16 */ public static final @NotNull Icon AS = load("expui/fileTypes/actionScript.svg", "fileTypes/as.svg", -1805543846, 0);
    /** 16x16 */ public static final @NotNull Icon Aspectj = load("expui/fileTypes/aspectJ.svg", "fileTypes/aspectj.svg", 469536666, 0);
    /** 16x16 */ public static final @NotNull Icon BinaryData = load("expui/fileTypes/binaryData.svg", "fileTypes/binaryData.svg", -208960886, 2);
    /** 16x16 */ public static final @NotNull Icon Config = load("expui/fileTypes/config.svg", "fileTypes/config.svg", 416412449, 0);
    /** 16x16 */ public static final @NotNull Icon Contexts = load("expui/fileTypes/contexts.svg", "fileTypes/contexts.svg", 589986144, 0);
    /** 16x16 */ public static final @NotNull Icon ContextsModifier = load("expui/fileTypes/contextsModifier.svg", "fileTypes/contextsModifier.svg", 11227132, 0);
    /** 16x16 */ public static final @NotNull Icon Css = load("expui/fileTypes/css.svg", "fileTypes/css.svg", -1827987051, 0);
    /** 16x16 */ public static final @NotNull Icon Csv = load("expui/fileTypes/csv.svg", -1498141192, 2);
    /** 16x16 */ public static final @NotNull Icon Custom = load("expui/fileTypes/text.svg", "fileTypes/custom.svg", 1692794144, 0);
    /** 16x16 */ public static final @NotNull Icon Diagram = load("expui/fileTypes/diagram.svg", "fileTypes/diagram.svg", 692669001, 0);
    /** 16x16 */ public static final @NotNull Icon Dtd = load("expui/fileTypes/xml.svg", "fileTypes/dtd.svg", -1804958231, 0);
    /** 16x16 */ public static final @NotNull Icon Font = load("expui/fileTypes/font.svg", -1762443308, 2);
    /** 16x16 */ public static final @NotNull Icon Gitignore = load("expui/fileTypes/gitignore.svg", -264194071, 0);
    /** 16x16 */ public static final @NotNull Icon Hprof = load("fileTypes/hprof.svg", 2107471584, 0);
    /** 16x16 */ public static final @NotNull Icon Htaccess = load("fileTypes/htaccess.svg", -1026396371, 0);
    /** 16x16 */ public static final @NotNull Icon Html = load("expui/fileTypes/html.svg", "fileTypes/html.svg", 944305592, 0);
    /** 16x16 */ public static final @NotNull Icon Http = load("expui/fileTypes/http.svg", "fileTypes/http.svg", -990310078, 0);
    /** 16x16 */ public static final @NotNull Icon I18n = load("expui/fileTypes/i18n.svg", "fileTypes/i18n.svg", 1594775427, 0);
    /** 16x16 */ public static final @NotNull Icon Idl = load("expui/fileTypes/idl.svg", "fileTypes/idl.svg", 1130770662, 0);
    /** 16x16 */ public static final @NotNull Icon Image = load("expui/fileTypes/image.svg", "fileTypes/image.svg", -266191706, 0);
    /** 16x16 */ public static final @NotNull Icon Java = load("expui/fileTypes/java.svg", "fileTypes/java.svg", 1296658493, 0);
    /** 16x16 */ public static final @NotNull Icon JavaClass = load("expui/fileTypes/javaClass.svg", "fileTypes/javaClass.svg", -776048542, 0);
    /** 16x16 */ public static final @NotNull Icon JavaOutsideSource = load("expui/fileTypes/java.svg", "fileTypes/javaOutsideSource.svg", 192400757, 0);
    /** 16x16 */ public static final @NotNull Icon JavaScript = load("expui/fileTypes/javaScript.svg", "fileTypes/javaScript.svg", -605773144, 0);
    /** 16x16 */ public static final @NotNull Icon Jfr = load("expui/fileTypes/jfr.svg", "fileTypes/jfr.svg", 243156876, 0);
    /** 16x16 */ public static final @NotNull Icon Json = load("expui/fileTypes/json.svg", "fileTypes/json.svg", -1463584567, 2);
    /** 16x16 */ public static final @NotNull Icon JsonSchema = load("expui/fileTypes/jsonSchema.svg", "fileTypes/jsonSchema.svg", -2026062432, 2);
    /** 16x16 */ public static final @NotNull Icon Jsp = load("expui/fileTypes/jsp.svg", "fileTypes/jsp.svg", -476790980, 0);
    /** 16x16 */ public static final @NotNull Icon Jspx = load("expui/fileTypes/jspx.svg", "fileTypes/jspx.svg", -576899393, 0);
    /** 16x16 */ public static final @NotNull Icon Manifest = load("expui/fileTypes/manifest.svg", "fileTypes/manifest.svg", -119717710, 0);
    /** 16x16 */ public static final @NotNull Icon MicrosoftWindows = load("expui/fileTypes/microsoftWindows.svg", "fileTypes/microsoftWindows.svg", 10953923, 0);
    /** 16x16 */ public static final @NotNull Icon Perl = load("expui/fileTypes/perl.svg", -895068164, 2);
    /** 16x16 */ public static final @NotNull Icon Properties = load("expui/fileTypes/properties.svg", "fileTypes/properties.svg", -1983560201, 0);
    /** 16x16 */ public static final @NotNull Icon Regexp = load("expui/fileTypes/regexp.svg", "fileTypes/regexp.svg", -1788323989, 0);
    /** 16x16 */ public static final @NotNull Icon SourceMap = load("expui/fileTypes/sourceMap.svg", -252663656, 2);
    /** 16x16 */ public static final @NotNull Icon Text = load("expui/fileTypes/text.svg", "fileTypes/text.svg", -444897274, 0);
    /** 16x16 */ public static final @NotNull Icon UiForm = load("expui/fileTypes/uiForm.svg", "fileTypes/uiForm.svg", -734581860, 0);
    /** 16x16 */ public static final @NotNull Icon Unknown = load("expui/fileTypes/unknown.svg", "fileTypes/unknown.svg", 1094896438, 0);
    /** 16x16 */ public static final @NotNull Icon WsdlFile = load("expui/fileTypes/wsdl.svg", "fileTypes/wsdlFile.svg", 85447754, 0);
    /** 16x16 */ public static final @NotNull Icon Xhtml = load("expui/fileTypes/xhtml.svg", "fileTypes/xhtml.svg", -2145170158, 0);
    /** 16x16 */ public static final @NotNull Icon Xml = load("expui/fileTypes/xml.svg", "fileTypes/xml.svg", 280641247, 0);
    /** 16x16 */ public static final @NotNull Icon XsdFile = load("expui/fileTypes/xsd.svg", "fileTypes/xsdFile.svg", -786038641, 0);
    /** 16x16 */ public static final @NotNull Icon Yaml = load("expui/fileTypes/yaml.svg", "fileTypes/yaml.svg", 118579768, 0);
  }

  public static final class General {
    /** 16x16 */ public static final @NotNull Icon ActualZoom = load("expui/image/actualZoom.svg", "general/actualZoom.svg", -749904846, 2);
    /** 16x16 */ public static final @NotNull Icon Add = load("expui/general/add.svg", "general/add.svg", -906460278, 2);
    /** 20x20 */ public static final @NotNull Icon Add_20x20 = load("expui/general/add@20x20.svg", 1639986855, 2);
    /** 16x16 */ public static final @NotNull Icon AddJdk = load("general/addJdk.svg", 1591845252, 2);
    /** 38x15 */ public static final @NotNull Icon Alpha = load("general/alpha.svg", -764382938, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowDown = load("expui/general/chevronDown.svg", "general/arrowDown.svg", 2097510840, 2);
    /** 9x5 */ public static final @NotNull Icon ArrowDownSmall = load("general/arrowDownSmall.svg", -53159950, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowLeft = load("expui/general/chevronLeft.svg", "general/arrowLeft.svg", -1023615143, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowRight = load("expui/general/chevronRight.svg", "general/arrowRight.svg", -1701680638, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowSplitCenterH = load("general/arrowSplitCenterH.svg", 181912966, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowSplitCenterV = load("general/arrowSplitCenterV.svg", -26894177, 2);
    /** 16x16 */ public static final @NotNull Icon ArrowUp = load("expui/general/chevronUp.svg", "general/arrowUp.svg", 927591433, 2);
    /** 16x16 */ public static final @NotNull Icon AutoscrollFromSource = load("expui/general/autoscrollFromSource.svg", "general/autoscrollFromSource.svg", -169479441, 2);
    /** 16x16 */ public static final @NotNull Icon AutoscrollToSource = load("expui/general/autoscrollToSource.svg", "general/autoscrollToSource.svg", -114858249, 2);
    /** 16x16 */ public static final @NotNull Icon Balloon = load("expui/general/balloon.svg", "general/balloon.svg", -1411993183, 2);
    /** 16x16 */ public static final @NotNull Icon BalloonError = load("expui/status/error.svg", "general/balloonError.svg", 1753843976, 2);
    /** 16x16 */ public static final @NotNull Icon BalloonInformation = load("expui/status/info.svg", "general/balloonInformation.svg", -271775484, 2);
    /** 16x16 */ public static final @NotNull Icon BalloonWarning = load("expui/status/warning.svg", "general/balloonWarning.svg", -1328195733, 2);
    /** 12x12 */ public static final @NotNull Icon BalloonWarning12 = load("general/balloonWarning12.svg", -1427088229, 2);
    /** 32x15 */ public static final @NotNull Icon Beta = load("general/beta.svg", -226198495, 2);
    /** 8x4 */ public static final @NotNull Icon ButtonDropTriangle = load("general/buttonDropTriangle.svg", -1607029215, 2);
    /** 16x16 */ public static final @NotNull Icon ChevronDown = load("expui/general/chevronDown.svg", "general/chevron-down.svg", -2068897744, 0);
    /** 16x16 */ public static final @NotNull Icon ChevronLeft = load("expui/general/chevronLeft.svg", "general/chevron-left.svg", -1889245888, 0);
    /** 16x16 */ public static final @NotNull Icon ChevronRight = load("expui/general/chevronRight.svg", "general/chevron-right.svg", 1620488986, 0);
    /** 16x16 */ public static final @NotNull Icon ChevronUp = load("expui/general/chevronUp.svg", "general/chevron-up.svg", -1865839854, 0);
    /** 16x16 */ public static final @NotNull Icon ChevronDownLargeWhite = load("expui/general/chevronDownLargeWhite.svg", -508498087, 0);
    /** 16x16 */ public static final @NotNull Icon Close = load("expui/general/close.svg", -540869824, 2);
    /** 16x16 */ public static final @NotNull Icon CloseSmall = load("expui/general/closeSmall.svg", 1113795489, 2);
    /** 16x16 */ public static final @NotNull Icon CloseSmallHovered = load("expui/general/closeSmallHovered.svg", -1502078120, 2);
    /** 16x16 */ public static final @NotNull Icon CollapseComponent = load("expui/inline/collapse.svg", "general/collapseComponent.svg", -223599744, 0);
    /** 16x16 */ public static final @NotNull Icon CollapseComponentHover = load("expui/inline/collapse.svg", "general/collapseComponentHover.svg", 304417159, 0);
    /** 16x16 */ public static final @NotNull Icon ContextHelp = load("expui/general/questionMark.svg", "general/contextHelp.svg", -495733641, 0);
    /** 16x16 */ public static final @NotNull Icon Copy = load("expui/general/copy.svg", -960424066, 2);
    /** 16x16 */ public static final @NotNull Icon CopyHovered = load("expui/general/copy.svg", "general/copyHovered.svg", 1241014029, 0);
    /** 16x16 */ public static final @NotNull Icon DebugDisabled = load("expui/general/debugDisabled.svg", "general/debugDisabled.svg", -800655499, 2);
    /** 16x16 */ public static final @NotNull Icon Delete = load("expui/general/delete.svg", -262115518, 2);
    /** 2x19 */ public static final @NotNull Icon Divider = load("general/divider.svg", 1530070674, 2);
    /** 16x16 */ public static final @NotNull Icon Drag = load("expui/general/drag.svg", "general/drag.svg", -2025384894, 0);
    /** 16x16 */ public static final @NotNull Icon Dropdown = load("expui/general/dropdown.svg", "general/dropdown.svg", -533882060, 2);
    /** 13x13 */ public static final @NotNull Icon DropdownGutter = load("expui/general/dropdownGutter.svg", "general/dropdownGutter.svg", 1280408843, 2);
    /** 2x20 */ public static final @NotNull Icon DropPlace = load("general/dropPlace.svg", 1169886511, 2);
    /** 16x16 */ public static final @NotNull Icon EditorPreviewVertical = load("expui/general/editorPreviewVertical.svg", 1066008888, 2);
    /** 9x9 */ public static final @NotNull Icon Ellipsis = load("general/ellipsis.svg", 1368119836, 2);
    /** 16x16 */ public static final @NotNull Icon Error = load("expui/status/error.svg", "general/error.svg", 549099408, 0);
    /** 32x32 */ public static final @NotNull Icon ErrorDialog = load("expui/general/errorDialog.svg", "general/errorDialog.svg", 1980950697, 0);
    /** 16x16 */ public static final @NotNull Icon ExclMark = load("general/exclMark.svg", 62835047, 2);
    /** 16x16 */ public static final @NotNull Icon ExpandComponent = load("expui/inline/expand.svg", "general/expandComponent.svg", -1669702338, 0);
    /** 16x16 */ public static final @NotNull Icon ExpandComponentHover = load("expui/inline/expand.svg", "general/expandComponentHover.svg", 526423086, 0);
    /** 16x16 */ public static final @NotNull Icon Export = load("expui/general/export.svg", -737835750, 2);
    /** 16x16 */ public static final @NotNull Icon ExternalTools = load("expui/general/externalTools.svg", "general/externalTools.svg", -1590890409, 2);
    /** 16x16 */ public static final @NotNull Icon Filter = load("expui/general/filter.svg", "general/filter.svg", 1693457313, 2);
    /** 16x16 */ public static final @NotNull Icon FitContent = load("expui/image/fitContent.svg", "general/fitContent.svg", 1016654152, 2);
    /** 16x16 */ public static final @NotNull Icon Gear = load("expui/inline/inlineSettings.svg", "general/gear.svg", 1176080624, 0);
    /** 16x16 */ public static final @NotNull Icon GearHover = load("expui/inline/inlineSettings.svg", "general/gearHover.svg", -142737575, 0);
    /** 16x16 */ public static final @NotNull Icon GearPlain = load("expui/general/settings.svg", "general/gearPlain.svg", -595181203, 2);
    /** 16x16 */ public static final @NotNull Icon GreenCheckmark = load("expui/general/greenCheckmark.svg", "general/greenCheckmark.svg", 1355926933, 2);
    /** 16x16 */ public static final @NotNull Icon Groups = load("expui/general/groups.svg", -2073085413, 2);
    /** 16x16 */ public static final @NotNull Icon Hashtag = load("expui/general/hashtag.svg", 859350157, 2);
    /** 16x16 */ public static final @NotNull Icon HideToolWindow = load("expui/general/hide.svg", "general/hideToolWindow.svg", -24888126, 2);
    /** 16x16 */ public static final @NotNull Icon History = load("expui/general/history.svg", -1313586434, 2);
    /** 16x16 */ public static final @NotNull Icon ImplementingMethod = load("expui/general/showToImplement.svg", "general/implementingMethod.svg", -286814761, 1);
    /** 16x16 */ public static final @NotNull Icon IndentDetected = load("expui/general/indentDetected.svg", 1513743707, 2);
    /** 16x16 */ public static final @NotNull Icon Information = load("expui/status/info.svg", "general/information.svg", 45152184, 0);
    /** 32x32 */ public static final @NotNull Icon InformationDialog = load("expui/general/informationDialog.svg", "general/informationDialog.svg", -143059635, 0);
    /** 16x16 */ public static final @NotNull Icon InheritedMethod = load("expui/hierarchy/classHierarchy.svg", "general/inheritedMethod.svg", 2120980341, 0);
    /** 16x16 */ public static final @NotNull Icon Inline_edit = load("expui/inline/inlineEdit.svg", "general/inline_edit.svg", -1009519585, 0);
    /** 16x16 */ public static final @NotNull Icon Inline_edit_hovered = load("expui/inline/inlineEdit.svg", "general/inline_edit_hovered.svg", -499944757, 0);
    /** 16x16 */ public static final @NotNull Icon InlineAdd = load("expui/inline/inlineAdd.svg", "general/inlineAdd.svg", -1067637940, 0);
    /** 16x16 */ public static final @NotNull Icon InlineAddHover = load("expui/inline/inlineAdd.svg", "general/inlineAddHover.svg", 784751211, 0);
    /** 16x16 */ public static final @NotNull Icon InlineClose = load("expui/inline/inlineClose.svg", "general/inlineClose.svg", 774702438, 0);
    /** 16x16 */ public static final @NotNull Icon InlineCloseHover = load("expui/inline/inlineClose.svg", "general/inlineCloseHover.svg", -77817716, 0);
    /** 16x16 */ public static final @NotNull Icon InlineCopy = load("expui/inline/copy.svg", "general/inlineCopy.svg", 782384917, 0);
    /** 16x16 */ public static final @NotNull Icon InlineCopyHover = load("expui/inline/copy.svg", "general/inlineCopyHover.svg", -467328403, 0);
    /** 16x16 */ public static final @NotNull Icon InlineRefresh = load("expui/inline/refresh.svg", "general/inlineRefresh.svg", -425729140, 0);
    /** 16x16 */ public static final @NotNull Icon InlineRefreshHover = load("expui/inline/refresh.svg", "general/inlineRefreshHover.svg", -1094217311, 0);
    /** 16x16 */ public static final @NotNull Icon InlineVariables = load("expui/inline/variables.svg", "general/inlineVariables.svg", -1649990655, 0);
    /** 16x16 */ public static final @NotNull Icon InlineVariablesHover = load("expui/inline/variables.svg", "general/inlineVariablesHover.svg", 1790736450, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsError = load("expui/general/inspections/inspectionsError.svg", "general/inspectionsError.svg", -1536825243, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsErrorEmpty = load("expui/general/inspections/inspectionsErrorEmpty.svg", "general/inspectionsErrorEmpty.svg", -1306194391, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsEye = load("expui/general/inspections/inspectionsEye.svg", "general/inspectionsEye.svg", 1945529681, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsGrammar = load("expui/general/inspections/inspectionsGrammar.svg", "general/inspectionsGrammar.svg", -2001714586, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsMixed = load("expui/general/inspections/inspectionsMixed.svg", "general/inspectionsMixed.svg", -1563908295, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsOK = load("expui/general/inspections/inspectionsOK.svg", "general/inspectionsOK.svg", 2050720021, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsOKEmpty = load("expui/general/inspections/inspectionsOKEmpty.svg", "general/inspectionsOKEmpty.svg", -147695886, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsPause = load("expui/general/inspections/inspectionsPause.svg", "general/inspectionsPause.svg", 1426069888, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsPowerSaveMode = load("expui/general/inspections/inspectionsPowerSaveMode.svg", "general/inspectionsPowerSaveMode.svg", -1738215750, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsTrafficOff = load("expui/general/inspections/inspectionsTrafficOff.svg", "general/inspectionsTrafficOff.svg", -1141682828, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsTypos = load("expui/general/inspections/inspectionsTypos.svg", "general/inspectionsTypos.svg", 1930719485, 2);
    /** 16x16 */ public static final @NotNull Icon InspectionsWarning = load("expui/general/inspections/inspectionsWarning.svg", "general/inspectionsWarning.svg", 1067540192, 0);
    /** 16x16 */ public static final @NotNull Icon InspectionsWarningEmpty = load("expui/general/inspections/inspectionsWarningEmpty.svg", "general/inspectionsWarningEmpty.svg", -845558838, 0);
    /** 16x16 */ public static final @NotNull Icon Keyboard = load("expui/general/keyboard.svg", 1621148328, 2);
    /** 16x16 */ public static final @NotNull Icon Language = load("expui/general/language.svg", "general/language.svg", -447457469, 0);
    /** 16x16 */ public static final @Deprecated @NotNull Icon LocalizationSettings = Language;
    /** 16x16 */ public static final @NotNull Icon Layout = load("expui/general/related.svg", "general/layout.svg", -1749612722, 2);
    /** 16x16 */ public static final @NotNull Icon LayoutEditorOnly = load("expui/general/editorOnly.svg", "general/layoutEditorOnly.svg", -570440550, 2);
    /** 16x16 */ public static final @NotNull Icon LayoutEditorPreview = load("expui/general/editorPreview.svg", "general/layoutEditorPreview.svg", 1995065496, 2);
    /** 16x16 */ public static final @NotNull Icon LayoutPreviewOnly = load("expui/general/previewOnly.svg", "general/layoutPreviewOnly.svg", 1323537588, 2);
    /** 16x16 */ public static final @NotNull Icon Learn = load("expui/general/learn.svg", 735868097, 2);
    /** 14x14 */ public static final @NotNull Icon LinkDropTriangle = load("expui/general/chevronDown.svg", "general/linkDropTriangle.svg", -2144062286, 2);
    /** 16x16 */ public static final @NotNull Icon Locate = load("expui/general/locate.svg", "general/locate.svg", 1990903521, 2);
    /** 16x16 */ public static final @NotNull Icon Menu = load("expui/general/menu.svg", -687974999, 2);
    /** 13x13 */ public static final @NotNull Icon Modified = load("expui/fileTypes/modified.svg", "general/modified.svg", 1281377481, 2);
    /** 13x13 */ public static final @NotNull Icon ModifiedSelected = load("general/modifiedSelected.svg", 251018616, 0);
    /** 16x16 */ public static final @NotNull Icon MoreTabs = load("general/moreTabs.svg", -82809530, 2);
    /** 16x16 */ public static final @NotNull Icon Mouse = load("general/mouse.svg", 1719479873, 2);
    /** 38x16 */ public static final @NotNull Icon New_badge = load("general/new_badge.svg", 394698412, 2);
    /** 16x16 */ public static final @NotNull Icon Note = load("expui/status/infoOutline.svg", "general/note.svg", -2137204668, 0);
    /** 24x24 */ public static final @NotNull Icon NotificationError = load("general/notificationError.svg", -172459168, 2);
    /** 24x24 */ public static final @NotNull Icon NotificationInfo = load("general/notificationInfo.svg", -1956337174, 2);
    /** 24x24 */ public static final @NotNull Icon NotificationWarning = load("general/notificationWarning.svg", -2071056609, 2);
    /** 16x16 */ public static final @NotNull Icon OpenDisk = load("expui/inline/browse.svg", "general/openDisk.svg", -1791475405, 0);
    /** 16x16 */ public static final @NotNull Icon OpenDiskHover = load("expui/inline/browse.svg", "general/openDiskHover.svg", -1393284946, 0);
    /** 16x16 */ public static final @NotNull Icon OpenInToolWindow = load("expui/general/openInToolWindow.svg", "general/openInToolWindow.svg", -523447725, 2);
    /** 16x16 */ public static final @NotNull Icon OverridenMethod = load("expui/general/overriddenMethod.svg", "general/overridenMethod.svg", -669366949, 0);
    /** 16x16 */ public static final @NotNull Icon OverridingMethod = load("expui/general/overridingMethod.svg", "general/overridingMethod.svg", -1929631314, 0);
    /** 16x16 */ public static final @NotNull Icon Pin = load("expui/general/pin.svg", -1207779727, 2);
    /** 16x16 */ public static final @NotNull Icon Pin_tab = load("expui/general/pin.svg", "general/pin_tab.svg", -1317540920, 2);
    /** 16x16 */ public static final @NotNull Icon PinHovered = load("expui/general/pinHovered.svg", -906336284, 2);
    /** 16x16 */ public static final @NotNull Icon PinSelected = load("expui/general/pinSelected.svg", -301810349, 2);
    /** 16x16 */ public static final @NotNull Icon PinSelectedHovered = load("expui/general/pinSelectedHovered.svg", -1799036301, 2);
    /** 16x16 */ public static final @NotNull Icon PreviewHorizontally = load("expui/general/previewHorizontally.svg", 470930964, 2);
    /** 16x16 */ public static final @NotNull Icon Print = load("expui/general/print.svg", "general/print.svg", 1255099068, 2);
    /** 9x9 */ public static final @NotNull Icon ProjectConfigurable = load("expui/general/projectConfigurable.svg", "general/projectConfigurable.svg", -225972190, 0);
    /** 16x16 */ public static final @NotNull Icon ProjectStructure = load("expui/general/projectStructure.svg", "general/projectStructure.svg", 42198412, 2);
    /** 16x16 */ public static final @NotNull Icon ProjectTab = load("expui/runConfigurations/application.svg", "general/projectTab.svg", 1853358628, 0);
    /** 32x32 */ public static final @NotNull Icon QuestionDialog = load("expui/general/questionDialog.svg", "general/questionDialog.svg", -1957202168, 0);
    /** 16x16 */ public static final @NotNull Icon ReaderMode = load("expui/general/readerMode.svg", "general/readerMode.svg", -808241020, 2);
    /** 16x16 */ public static final @NotNull Icon Refresh = load("expui/general/refresh.svg", 323445437, 2);
    /** 16x16 */ public static final @NotNull Icon RefreshAuto = load("expui/general/refreshAuto.svg", -1813763351, 2);
    /** 16x16 */ public static final @NotNull Icon Remove = load("expui/general/remove.svg", "general/remove.svg", 1967957495, 2);
    /** 16x16 */ public static final @NotNull Icon Reset = load("expui/general/reset.svg", "general/reset.svg", 505829495, 2);
    /** 16x16 */ public static final @NotNull Icon RunWithCoverage = load("expui/run/runWithCoverage.svg", "general/runWithCoverage.svg", 259168745, 2);
    /** 16x16 */ public static final @NotNull Icon SelectIn = load("expui/general/selectIn.svg", -1402413017, 2);
    /** 16x16 */ public static final @NotNull Icon SeparatorH = load("expui/general/separatorHorizontal.svg", "general/separatorH.svg", 89692098, 2);
    /** 16x16 */ public static final @NotNull Icon Settings = load("expui/general/settings.svg", "general/settings.svg", -2083563258, 2);
    /** 16x16 */ public static final @NotNull Icon Show = load("expui/general/show.svg", 1378226210, 2);
    /** 16x16 */ public static final @NotNull Icon Show_to_implement = load("expui/general/showToImplement.svg", "general/show_to_implement.svg", -590429028, 7);
    /** 16x16 */ public static final @NotNull Icon ShowInfos = load("expui/status/infoOutline.svg", "general/showInfos.svg", 1114268817, 2);
    /** 16x16 */ public static final @NotNull Icon ShowWarning = load("expui/status/warningOutline.svg", "general/showWarning.svg", -496649249, 2);
    /** 32x32 */ public static final @NotNull Icon SuccessDialog = load("expui/general/successDialog.svg", "general/successDialog.svg", -1746944171, 0);
    /** 48x48 */ public static final @NotNull Icon SuccessLogin = load("expui/general/successLogin.svg", "general/successLogin.svg", 1387742290, 0);
    /** 16x16 */ public static final @NotNull Icon TbHidden = load("general/tbHidden.svg", -1372883698, 2);
    /** 16x16 */ public static final @NotNull Icon TbShown = load("general/tbShown.svg", 2114435265, 2);
    /** 32x32 */ public static final @NotNull Icon Tip = load("general/tip.svg", 347466127, 2);
    /** 16x16 */ public static final @NotNull Icon TodoDefault = load("general/todoDefault.svg", -1889168094, 0);
    /** 16x16 */ public static final @NotNull Icon TodoImportant = load("general/todoImportant.svg", -1313768031, 0);
    /** 16x16 */ public static final @NotNull Icon TodoQuestion = load("general/todoQuestion.svg", 1766217913, 0);
    /** 16x16 */ public static final @NotNull Icon Tree = load("expui/general/tree.svg", "general/tree.svg", 699730744, 0);
    /** 16x16 */ public static final @NotNull Icon TreeHovered = load("expui/general/treeHovered.svg", "general/treeHovered.svg", -805484505, 0);
    /** 16x16 */ public static final @NotNull Icon TreeSelected = load("expui/general/treeSelected.svg", "general/treeSelected.svg", -1128936978, 0);
    /** 32x16 */ public static final @NotNull Icon TrialBadge = load("general/trialBadge.svg", -1779199569, 0);
    /** 16x16 */ public static final @NotNull Icon User = load("expui/general/user.svg", "general/user.svg", 100112941, 0);
    /** 16x16 */ public static final @NotNull Icon Vcs = load("expui/general/vcs.svg", 1023462254, 2);
    /** 16x16 */ public static final @NotNull Icon Warning = load("expui/status/warning.svg", "general/warning.svg", 748587837, 2);
    /** 16x16 */ public static final @NotNull Icon WarningDecorator = load("general/warningDecorator.svg", 382605295, 2);
    /** 32x32 */ public static final @NotNull Icon WarningDialog = load("expui/general/warningDialog.svg", "general/warningDialog.svg", 1499563703, 0);
    /** 16x16 */ public static final @NotNull Icon Web = load("expui/toolwindows/web.svg", "general/web.svg", -530155959, 2);
    /** 20x20 */ public static final @NotNull Icon WindowsMenu_20x20 = load("expui/general/windowsMenu@20x20.svg", 2146328371, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomIn = load("general/zoomIn.svg", -997549918, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomOut = load("general/zoomOut.svg", -2077385866, 2);
  }

  public static final class Graph {
    /** 16x16 */ public static final @NotNull Icon ActualZoom = load("expui/image/actualZoom.svg", "graph/actualZoom.svg", -749904846, 2);
    /** 16x16 */ public static final @NotNull Icon Grid = load("expui/image/grid.svg", "graph/grid.svg", -1237582463, 2);
    /** 16x16 */ public static final @NotNull Icon Layout = load("expui/graph/graphLayout.svg", "graph/layout.svg", -1749612722, 2);
    /** 16x16 */ public static final @NotNull Icon NodeSelectionMode = load("graph/nodeSelectionMode.svg", 1917705211, 2);
    /** 16x16 */ public static final @NotNull Icon SnapToGrid = load("graph/snapToGrid.svg", 9684427, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomIn = load("expui/image/zoomIn.svg", "graph/zoomIn.svg", -997549918, 2);
    /** 16x16 */ public static final @NotNull Icon ZoomOut = load("expui/image/zoomOut.svg", "graph/zoomOut.svg", -2077385866, 2);
  }

  public static final class Gutter {
    /** 12x12 */ public static final @NotNull Icon Bookmark = load("expui/gutter/bookmark.svg", "gutter/bookmark.svg", -1199562302, 2);
    /** 12x12 */ public static final @NotNull Icon Colors = load("expui/gutter/colors.svg", "gutter/colors.svg", 1484944411, 2);
    /** 12x12 */ public static final @NotNull Icon DataSchema = load("expui/gutter/dataSchema.svg", "gutter/dataSchema.svg", 1208855961, 0);
    /** 12x12 */ public static final @NotNull Icon ExtAnnotation = load("expui/gutter/extAnnotation.svg", "gutter/extAnnotation.svg", -445411767, 2);
    /** 9x9 */ public static final @NotNull Icon Fold = load("expui/gutter/fold.svg", -900984947, 2);
    /** 9x9 */ public static final @NotNull Icon FoldBottom = load("expui/gutter/foldBottom.svg", 1021558638, 2);
    /** 12x12 */ public static final @NotNull Icon ImplementedMethod = load("expui/gutter/implementedMethod.svg", "gutter/implementedMethod.svg", -130645494, 7);
    /** 12x12 */ public static final @NotNull Icon ImplementingFunctionalInterface = load("expui/gutter/implementingFunctionalInterface.svg", "gutter/implementingFunctionalInterface.svg", 88310694, 2);
    /** 12x12 */ public static final @NotNull Icon ImplementingMethod = load("expui/gutter/implementingMethod.svg", "gutter/implementingMethod.svg", 329611273, 7);
    /** 12x12 */ public static final @NotNull Icon Java9Service = load("gutter/java9Service.svg", -1643500109, 2);
    /** 12x12 */ public static final @NotNull Icon JavadocEdit = load("expui/gutter/javadocEdit.svg", "gutter/javadocEdit.svg", -206870149, 0);
    /** 12x12 */ public static final @NotNull Icon JavadocRead = load("expui/gutter/javadocRead.svg", "gutter/javadocRead.svg", -1066074866, 0);
    /** 12x12 */ public static final @NotNull Icon Mnemonic = load("expui/gutter/mnemonic.svg", "gutter/mnemonic.svg", -1479293770, 2);
    /** 12x12 */ public static final @NotNull Icon OverridenMethod = load("expui/gutter/overridenMethod.svg", "gutter/overridenMethod.svg", -1850381458, 2);
    /** 12x12 */ public static final @NotNull Icon OverridingMethod = load("expui/gutter/overridingMethod.svg", "gutter/overridingMethod.svg", 2079881534, 2);
    /** 12x12 */ public static final @NotNull Icon ReadAccess = load("expui/gutter/readAccess.svg", "gutter/readAccess.svg", 1716318348, 2);
    /** 12x12 */ public static final @NotNull Icon RecursiveMethod = load("expui/gutter/recursiveMethod.svg", "gutter/recursiveMethod.svg", 30131460, 2);
    /** 14x14 */ public static final @NotNull Icon RunInQueue = load("expui/gutter/runInQueue.svg", -134130707, 2);
    /** 12x12 */ public static final @NotNull Icon SiblingInheritedMethod = load("expui/gutter/siblingInheritedMethod.svg", "gutter/siblingInheritedMethod.svg", 829470965, 7);
    /** 12x12 */ public static final @NotNull Icon SuggestedRefactoringBulb = load("expui/gutter/suggestedRefactoring.svg", "gutter/suggestedRefactoringBulb.svg", -1399925877, 2);
    /** 13x12 */ public static final @NotNull Icon SuggestedRefactoringBulbDisabled = load("expui/gutter/suggestedRefactoringDisabled.svg", "gutter/suggestedRefactoringBulbDisabled.svg", 1536207532, 2);
    /** 9x9 */ public static final @NotNull Icon Unfold = load("expui/gutter/unfold.svg", 1115053017, 2);
    /** 8x8 */ public static final @NotNull Icon Unique = load("gutter/unique.svg", -1736716054, 2);
    /** 12x12 */ public static final @NotNull Icon Web = load("expui/gutter/web.svg", "gutter/web.svg", 2053425302, 0);
    /** 12x12 */ public static final @NotNull Icon WriteAccess = load("expui/gutter/writeAccess.svg", "gutter/writeAccess.svg", 167078343, 2);
  }

  public static final class Hierarchy {
    /** 16x16 */ public static final @NotNull Icon Class = load("expui/hierarchy/classHierarchy.svg", "hierarchy/class.svg", -1713004025, 2);
    /** 8x8 */ public static final @NotNull Icon MethodDefined = load("hierarchy/methodDefined.svg", -1395173220, 2);
    /** 8x8 */ public static final @NotNull Icon MethodNotDefined = load("hierarchy/methodNotDefined.svg", -94139299, 2);
    /** 8x8 */ public static final @NotNull Icon ShouldDefineMethod = load("hierarchy/shouldDefineMethod.svg", -1917914362, 2);
    /** 16x16 */ public static final @NotNull Icon Subtypes = load("expui/hierarchy/subtypes.svg", "hierarchy/subtypes.svg", -748976261, 2);
    /** 16x16 */ public static final @NotNull Icon Supertypes = load("expui/hierarchy/supertypes.svg", "hierarchy/supertypes.svg", 1982793890, 2);
  }

  public static final class Icons {
    public static final class Ide {
      /** 12x12 */ public static final @NotNull Icon MenuArrow = load("expui/general/chevronRight.svg", "icons/ide/menuArrow.svg", -1268083604, 2);
      /** 12x12 */ public static final @NotNull Icon MenuArrowSelected = load("expui/general/chevronRight.svg", "icons/ide/menuArrowSelected.svg", -772233447, 2);
      /** 12x12 */ public static final @NotNull Icon NextStep = load("icons/ide/nextStep.svg", 314473918, 2);
      /** 12x12 */ public static final @NotNull Icon NextStepInverted = load("icons/ide/nextStepInverted.svg", 799136074, 0);
    }
  }

  public static final class Ide {
    /** 16x16 */ public static final @NotNull Icon ConfigFile = load("expui/ide/configFile.svg", "ide/configFile.svg", -796008080, 2);
    /** 20x20 */ public static final @NotNull Icon Dislike = load("ide/dislike.svg", -695373408, 2);
    /** 20x20 */ public static final @NotNull Icon DislikeDimmed = load("ide/dislikeDimmed.svg", 1288357052, 2);
    /** 20x20 */ public static final @NotNull Icon DislikeSelected = load("ide/dislikeSelected.svg", 843594024, 2);
    /** 6x6 */ public static final @NotNull Icon ErrorPoint = load("ide/errorPoint.svg", 1599629614, 2);
    /** 14x14 */ public static final @NotNull Icon External_link_arrow = load("expui/ide/externalLink.svg", "ide/external_link_arrow.svg", -1698491733, 0);
    /** 14x14 */ public static final @NotNull Icon ExternalLinkArrowWhite = load("expui/ide/externalLinkWhite.svg", "ide/externalLinkArrowWhite.svg", 555726287, 0);
    /** 16x16 */ public static final @NotNull Icon FatalErrorRead = load("expui/status/errorOutline.svg", "ide/fatalError-read.svg", -2061937514, 2);
    /** 16x16 */ public static final @NotNull Icon FatalError = load("expui/status/error.svg", "ide/fatalError.svg", -1290263519, 2);
    /** 16x16 */ public static final @NotNull Icon Feedback = load("ide/feedback.svg", -1579460810, 2);
    /** 32x32 */ public static final @NotNull Icon FeedbackRating = load("expui/ide/feedbackRating.svg", "ide/feedbackRating.svg", 2100656760, 2);
    /** 32x32 */ public static final @NotNull Icon FeedbackRatingFocused = load("expui/ide/feedbackRatingFocused.svg", "ide/feedbackRatingFocused.svg", -49762505, 2);
    /** 32x32 */ public static final @NotNull Icon FeedbackRatingFocusedOn = load("expui/ide/feedbackRatingFocusedOn.svg", "ide/feedbackRatingFocusedOn.svg", 1557121691, 2);
    /** 32x32 */ public static final @NotNull Icon FeedbackRatingOn = load("expui/ide/feedbackRatingOn.svg", "ide/feedbackRatingOn.svg", 1102075748, 0);
    /** 32x32 */ public static final @NotNull Icon FeedbackRatingOnFocused = load("ide/feedbackRatingOnFocused.svg", -1692491005, 0);
    /** 16x16 */ public static final @NotNull Icon Gift = load("expui/ide/gift.svg", "ide/gift.svg", -1423934596, 2);
    /** 16x16 */ public static final @NotNull Icon HectorOff = load("ide/hectorOff.svg", 756397077, 2);
    /** 16x16 */ public static final @NotNull Icon HectorOn = load("ide/hectorOn.svg", 1387966645, 2);
    /** 16x16 */ public static final @NotNull Icon HectorSyntax = load("ide/hectorSyntax.svg", -415840178, 2);
    /** 16x16 */ public static final @NotNull Icon IncomingChangesOn = load("expui/vcs/shelve.svg", "ide/incomingChangesOn.svg", -1613666636, 2);
    /** 20x20 */ public static final @NotNull Icon Like = load("ide/like.svg", 1499648038, 2);
    /** 20x20 */ public static final @NotNull Icon LikeDimmed = load("ide/likeDimmed.svg", 449955239, 2);
    /** 20x20 */ public static final @NotNull Icon LikeSelected = load("ide/likeSelected.svg", 1058551001, 2);
    /** 12x12 */ public static final @NotNull Icon Link = load("expui/general/chevronRight.svg", "ide/link.svg", 941220318, 2);
    /** 16x16 */ public static final @NotNull Icon LocalScope = load("expui/ide/localScope.svg", "ide/localScope.svg", -204717233, 0);
    /** 16x16 */ public static final @NotNull Icon LocalScopeAction = load("expui/ide/localScope.svg", "ide/localScopeAction.svg", 1217252486, 2);

    public static final class Macro {
      /** 16x16 */ public static final @NotNull Icon Recording_1 = load("ide/macro/recording_1.svg", -1059376498, 2);
      /** 16x16 */ public static final @NotNull Icon Recording_2 = load("ide/macro/recording_2.svg", 1778470624, 2);
      /** 16x16 */ public static final @NotNull Icon Recording_3 = load("ide/macro/recording_3.svg", 837328046, 2);
      /** 16x16 */ public static final @NotNull Icon Recording_4 = load("ide/macro/recording_4.svg", 1660145659, 2);
    }

    /** 5x15 */ public static final @NotNull Icon NavBarSeparator = load("ide/NavBarSeparator.svg", -1162104101, 0);

    public static final class Notification {
      /** 16x16 */ public static final @NotNull Icon Close = load("expui/general/close.svg", "ide/notification/close.svg", 1584784857, 0);
      /** 16x16 */ public static final @NotNull Icon CloseHover = load("expui/general/close.svg", "ide/notification/closeHover.svg", 1527044621, 0);
      /** 16x16 */ public static final @NotNull Icon Collapse = load("expui/general/chevronUp.svg", "ide/notification/collapse.svg", -1861195698, 0);
      /** 16x16 */ public static final @NotNull Icon CollapseHover = load("expui/general/chevronUp.svg", "ide/notification/collapseHover.svg", 927244540, 0);
      /** 16x16 */ public static final @NotNull Icon DropTriangle = load("ide/notification/dropTriangle.svg", 940690666, 0);
      /** 16x16 */ public static final @NotNull Icon ErrorEvents = load("ide/notification/errorEvents.svg", -1286535741, 2);
      /** 16x16 */ public static final @NotNull Icon Expand = load("expui/general/chevronDown.svg", "ide/notification/expand.svg", 1653669363, 0);
      /** 16x16 */ public static final @NotNull Icon ExpandHover = load("expui/general/chevronDown.svg", "ide/notification/expandHover.svg", -721297507, 0);
      /** 16x16 */ public static final @NotNull Icon Gear = load("expui/general/moreVertical.svg", "ide/notification/gear.svg", -1024063089, 0);
      /** 16x16 */ public static final @NotNull Icon GearHover = load("expui/general/moreVertical.svg", "ide/notification/gearHover.svg", 892988590, 0);
      /** 16x16 */ public static final @NotNull Icon IdeUpdate = load("expui/general/ideUpdate.svg", "ide/notification/ideUpdate.svg", 1292803931, 2);
      /** 16x16 */ public static final @NotNull Icon InfoEvents = load("ide/notification/infoEvents.svg", -2030964812, 2);
      /** 16x16 */ public static final @NotNull Icon NoEvents = load("ide/notification/noEvents.svg", -1171205959, 2);
      /** 16x16 */ public static final @NotNull Icon PluginUpdate = load("expui/general/pluginUpdate.svg", "ide/notification/pluginUpdate.svg", -1031760915, 2);
      /** 16x16 */ public static final @NotNull Icon WarningEvents = load("ide/notification/warningEvents.svg", 115050516, 2);
    }

    /** 16x16 */ public static final @NotNull Icon OutgoingChangesOn = load("expui/vcs/unshelve.svg", "ide/outgoingChangesOn.svg", 1711755766, 2);
    /** 16x16 */ public static final @NotNull Icon Pipette = load("expui/image/colorPicker.svg", "ide/pipette.svg", 721447979, 2);
    /** 16x16 */ public static final @NotNull Icon PipetteRollover = load("expui/image/colorPickerRollover.svg", "ide/pipetteRollover.svg", -1988890684, 2);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Pipette_rollover = PipetteRollover;
    /** 16x16 */ public static final @NotNull Icon PowerSaveMode = load("expui/general/inspections/inspectionsPowerSaveMode.svg", "ide/powerSaveMode.svg", 2079928345, 2);
    /** 11x11 */ public static final @NotNull Icon Rating = load("ide/rating.svg", -1336366891, 2);
    /** 11x11 */ public static final @NotNull Icon Rating1 = load("ide/rating1.svg", 482124723, 2);
    /** 11x11 */ public static final @NotNull Icon Rating2 = load("ide/rating2.svg", 1573976644, 2);
    /** 11x11 */ public static final @NotNull Icon Rating3 = load("ide/rating3.svg", 792801940, 2);
    /** 11x11 */ public static final @NotNull Icon Rating4 = load("ide/rating4.svg", 2056312954, 2);
    /** 16x16 */ public static final @NotNull Icon Readonly = load("expui/general/locked.svg", "ide/readonly.svg", -856016362, 2);
    /** 16x16 */ public static final @NotNull Icon Readwrite = load("expui/general/unlocked.svg", "ide/readwrite.svg", 124199055, 2);

    public static final class RoundShadow {
      /** 4x14 */ public static final @NotNull Icon Bottom = load("ide/roundShadow/bottom.svg", -1917828898, 0);
      /** 18x22 */ public static final @NotNull Icon BottomLeft = load("ide/roundShadow/bottomLeft.svg", -840209443, 0);
      /** 18x22 */ public static final @NotNull Icon BottomRight = load("ide/roundShadow/bottomRight.svg", -1924172356, 0);
      /** 10x4 */ public static final @NotNull Icon Left = load("ide/roundShadow/left.svg", 255627543, 0);
      /** 10x4 */ public static final @NotNull Icon Right = load("ide/roundShadow/right.svg", -1007162035, 0);
      /** 4x6 */ public static final @NotNull Icon Top = load("ide/roundShadow/top.svg", -1418501693, 0);
      /** 18x14 */ public static final @NotNull Icon TopLeft = load("ide/roundShadow/topLeft.svg", -1970444543, 0);
      /** 18x14 */ public static final @NotNull Icon TopRight = load("ide/roundShadow/topRight.svg", 2056222615, 0);
    }

    public static final class Shadow {
      /** 4x14 */ public static final @NotNull Icon Bottom = load("ide/shadow/bottom.svg", 840768513, 0);
      /** 18x22 */ public static final @NotNull Icon BottomLeft = load("ide/shadow/bottomLeft.svg", -1321651824, 0);
      /** 18x22 */ public static final @NotNull Icon BottomRight = load("ide/shadow/bottomRight.svg", -1422492136, 0);
      /** 10x4 */ public static final @NotNull Icon Left = load("ide/shadow/left.svg", 520335762, 0);
      /** 10x4 */ public static final @NotNull Icon Right = load("ide/shadow/right.svg", -1918848779, 0);
      /** 4x6 */ public static final @NotNull Icon Top = load("ide/shadow/top.svg", 1747780384, 0);
      /** 18x14 */ public static final @NotNull Icon TopLeft = load("ide/shadow/topLeft.svg", -1319076940, 0);
      /** 18x14 */ public static final @NotNull Icon TopRight = load("ide/shadow/topRight.svg", -1876858180, 0);
    }

    /** 16x16 */ public static final @NotNull Icon SharedScope = load("expui/ide/sharedScope.svg", 1730249074, 2);
    /** 7x10 */ public static final @NotNull Icon Statusbar_arrows = load("ide/statusbar_arrows.svg", -1346411249, 2);
    /** 16x16 */ public static final @NotNull Icon UpDown = load("ide/upDown.svg", 1037605312, 2);
  }

  /** 100x100 */ public static final @NotNull Icon Idea_logo_welcome = load("idea_logo_welcome.png", 0, 0);

  public static final class Javaee {
    /** 16x16 */ public static final @NotNull Icon Home = load("expui/javaee/home.svg", "javaee/home.svg", -1237867469, 0);
    /** 16x16 */ public static final @NotNull Icon PersistenceEntity = load("expui/javaee/persistenceEntity.svg", "javaee/persistenceEntity.svg", -1760169920, 0);
    /** 16x16 */ public static final @NotNull Icon UpdateRunningApplication = load("expui/javaee/updateRunningApplication.svg", "javaee/updateRunningApplication.svg", -1226692740, 2);
    /** 16x16 */ public static final @NotNull Icon WebModuleGroup = load("expui/javaee/webModuleGroup.svg", "javaee/webModuleGroup.svg", -1530207639, 0);
    /** 16x16 */ public static final @NotNull Icon WebService = load("expui/javaee/webService.svg", "javaee/WebService.svg", 835251380, 0);
    /** 16x16 */ public static final @NotNull Icon WebServiceClient = load("expui/javaee/webServiceClient.svg", "javaee/WebServiceClient.svg", -251783954, 0);
  }

  public static final class Json {
    /** 16x16 */ public static final @NotNull Icon Array = load("expui/json/array.svg", "json/array.svg", 1494844844, 2);
    /** 16x16 */ public static final @NotNull Icon Object = load("expui/json/object.svg", "json/object.svg", -1268113296, 2);
  }

  public static final class Language {
    /** 16x16 */ public static final @NotNull Icon GO = load("language/go.svg", -1894540570, 2);
    /** 16x16 */ public static final @NotNull Icon Kotlin = load("language/kotlin.svg", -412084699, 2);
    /** 16x16 */ public static final @NotNull Icon Php = load("expui/language/php.svg", "language/php.svg", 185644961, 0);
    /** 16x16 */ public static final @NotNull Icon Python = load("language/python.svg", -543505712, 2);
    /** 16x16 */ public static final @NotNull Icon Ruby = load("language/ruby.svg", -1736610380, 2);
    /** 16x16 */ public static final @NotNull Icon Rust = load("language/rust.svg", 1109219129, 2);
    /** 16x16 */ public static final @NotNull Icon Scala = load("expui/language/scala.svg", "language/scala.svg", -2014474853, 2);
  }

  public static final class Linux {
    /** 16x16 */ public static final @NotNull Icon Linux = load("linux/linux.svg", 122737916, 2);

    public static final class Theme {
      public static final class Gnome {
        /** 24x24 */ public static final @NotNull Icon Close = load("linux/theme/gnome/close.svg", 1041465849, 2);
        /** 24x24 */ public static final @NotNull Icon CloseHover = load("linux/theme/gnome/closeHover.svg", 1128310649, 2);
        /** 24x24 */ public static final @NotNull Icon CloseInactive = load("linux/theme/gnome/closeInactive.svg", -235239049, 2);
        /** 24x24 */ public static final @NotNull Icon ClosePressed = load("linux/theme/gnome/closePressed.svg", 1451669122, 2);
        /** 24x24 */ public static final @NotNull Icon Maximize = load("linux/theme/gnome/maximize.svg", -621030100, 2);
        /** 24x24 */ public static final @NotNull Icon MaximizeHover = load("linux/theme/gnome/maximizeHover.svg", 1326518692, 2);
        /** 24x24 */ public static final @NotNull Icon MaximizeInactive = load("linux/theme/gnome/maximizeInactive.svg", -28016208, 2);
        /** 24x24 */ public static final @NotNull Icon MaximizePressed = load("linux/theme/gnome/maximizePressed.svg", -420670284, 2);
        /** 24x24 */ public static final @NotNull Icon Minimize = load("linux/theme/gnome/minimize.svg", 2127745494, 2);
        /** 24x24 */ public static final @NotNull Icon MinimizeHover = load("linux/theme/gnome/minimizeHover.svg", -162281172, 2);
        /** 24x24 */ public static final @NotNull Icon MinimizeInactive = load("linux/theme/gnome/minimizeInactive.svg", -593078237, 2);
        /** 24x24 */ public static final @NotNull Icon MinimizePressed = load("linux/theme/gnome/minimizePressed.svg", 206506381, 2);
        /** 24x24 */ public static final @NotNull Icon Restore = load("linux/theme/gnome/restore.svg", 1668500755, 2);
        /** 24x24 */ public static final @NotNull Icon RestoreHover = load("linux/theme/gnome/restoreHover.svg", 801105303, 2);
        /** 24x24 */ public static final @NotNull Icon RestoreInactive = load("linux/theme/gnome/restoreInactive.svg", -1904649367, 2);
        /** 24x24 */ public static final @NotNull Icon RestorePressed = load("linux/theme/gnome/restorePressed.svg", -304033883, 2);
      }

      public static final class Kde {
        /** 20x20 */ public static final @NotNull Icon Close = load("linux/theme/kde/close.svg", -446927126, 2);
        /** 20x20 */ public static final @NotNull Icon CloseHover = load("linux/theme/kde/closeHover.svg", -206211498, 2);
        /** 20x20 */ public static final @NotNull Icon CloseInactive = load("linux/theme/kde/closeInactive.svg", 1668092313, 2);
        /** 20x20 */ public static final @NotNull Icon ClosePressed = load("linux/theme/kde/closePressed.svg", 1743614163, 2);
        /** 20x20 */ public static final @NotNull Icon Maximize = load("linux/theme/kde/maximize.svg", -553937177, 2);
        /** 20x20 */ public static final @NotNull Icon MaximizeHover = load("linux/theme/kde/maximizeHover.svg", 1967476149, 2);
        /** 20x20 */ public static final @NotNull Icon MaximizeInactive = load("linux/theme/kde/maximizeInactive.svg", 2057692852, 2);
        /** 20x20 */ public static final @NotNull Icon MaximizePressed = load("linux/theme/kde/maximizePressed.svg", -903581244, 2);
        /** 20x20 */ public static final @NotNull Icon Minimize = load("linux/theme/kde/minimize.svg", 1785825068, 2);
        /** 20x20 */ public static final @NotNull Icon MinimizeHover = load("linux/theme/kde/minimizeHover.svg", 174163678, 2);
        /** 20x20 */ public static final @NotNull Icon MinimizeInactive = load("linux/theme/kde/minimizeInactive.svg", -2124271439, 2);
        /** 20x20 */ public static final @NotNull Icon MinimizePressed = load("linux/theme/kde/minimizePressed.svg", -1544125646, 2);
        /** 20x20 */ public static final @NotNull Icon Restore = load("linux/theme/kde/restore.svg", -746065059, 2);
        /** 20x20 */ public static final @NotNull Icon RestoreHover = load("linux/theme/kde/restoreHover.svg", -812531410, 2);
        /** 20x20 */ public static final @NotNull Icon RestoreInactive = load("linux/theme/kde/restoreInactive.svg", 1544088754, 2);
        /** 20x20 */ public static final @NotNull Icon RestorePressed = load("linux/theme/kde/restorePressed.svg", 1276612883, 2);
      }
    }
  }

  public static final class Mac {
    /** 55x55 */ public static final @NotNull Icon AppIconOk512 = load("mac/appIconOk512.png", 0, 0);

    public static final class Touchbar {
      /** 16x16 */ public static final @NotNull Icon PopoverArrow = load("mac/touchbar/popoverArrow.svg", -92240585, 0);
      /** 24x24 */ public static final @NotNull Icon PopoverClose = load("mac/touchbar/popoverClose.svg", 2008917722, 0);
    }
  }

  public static final class MeetNewUi {
    /** 16x16 */ public static final @NotNull Icon DarkTheme = load("expui/meetNewUi/darkTheme.svg", -1512620599, 2);
    /** 16x16 */ public static final @NotNull Icon DarkThemeSelected = load("expui/meetNewUi/darkThemeSelected.svg", -462276083, 2);
    /** 88x48 */ public static final @NotNull Icon DensityCompact = load("expui/meetNewUi/densityCompact.svg", -103938576, 2);
    /** 88x48 */ public static final @NotNull Icon DensityDefault = load("expui/meetNewUi/densityDefault.svg", 691969220, 2);
    /** 16x16 */ public static final @NotNull Icon LightTheme = load("expui/meetNewUi/lightTheme.svg", -1581474989, 2);
    /** 16x16 */ public static final @NotNull Icon LightThemeSelected = load("expui/meetNewUi/lightThemeSelected.svg", -475397519, 2);
    /** 16x16 */ public static final @NotNull Icon SystemTheme = load("expui/meetNewUi/systemTheme.svg", -924931239, 2);
    /** 16x16 */ public static final @NotNull Icon SystemThemeSelected = load("expui/meetNewUi/systemThemeSelected.svg", -1377130003, 2);
  }

  public static final class Modules {
    /** 16x16 */ public static final @NotNull Icon AddExcludedRoot = load("modules/addExcludedRoot.svg", -551171712, 2);
    /** 16x16 */ public static final @NotNull Icon Annotation = load("expui/nodes/annotationFolder.svg", "modules/annotation.svg", 394273456, 0);
    /** 16x16 */ public static final @NotNull Icon EditFolder = load("expui/nodes/editFolder.svg", "modules/editFolder.svg", -260654478, 0);
    /** 16x16 */ public static final @NotNull Icon ExcludedGeneratedRoot = load("expui/nodes/excludedGenerated.svg", "modules/excludedGeneratedRoot.svg", -1551632995, 0);
    /** 16x16 */ public static final @NotNull Icon ExcludeRoot = load("expui/nodes/excludeRoot.svg", "modules/excludeRoot.svg", -875115505, 0);
    /** 16x16 */ public static final @NotNull Icon GeneratedFolder = load("expui/nodes/generated.svg", "modules/generatedFolder.svg", -874293965, 0);
    /** 16x16 */ public static final @NotNull Icon GeneratedSourceRoot = load("expui/nodes/generatedSource.svg", "modules/generatedSourceRoot.svg", -1921810842, 0);
    /** 16x16 */ public static final @NotNull Icon GeneratedTestRoot = load("expui/nodes/generatedTestRoot.svg", "modules/generatedTestRoot.svg", -1234922153, 0);
    /** 16x16 */ public static final @NotNull Icon ResourcesRoot = load("expui/nodes/resourcesRoot.svg", "modules/resourcesRoot.svg", -1812051386, 0);
    /** 16x16 */ public static final @NotNull Icon SourceRoot = load("expui/nodes/sourceRoot.svg", "modules/sourceRoot.svg", 1687981214, 0);
    /** 16x16 */ public static final @NotNull Icon SourceRootFileLayer = load("expui/nodes/sourceRootFileLayer.svg", "modules/sourceRootFileLayer.svg", 241453801, 0);
    /** 16x16 */ public static final @NotNull Icon Split = load("expui/actions/split.svg", "modules/split.svg", 2103687526, 2);
    /** 16x16 */ public static final @NotNull Icon TestResourcesRoot = load("expui/nodes/testResourcesRoot.svg", "modules/testResourcesRoot.svg", 779023858, 0);
    /** 16x16 */ public static final @NotNull Icon TestRoot = load("expui/nodes/testRoot.svg", "modules/testRoot.svg", -1260358372, 0);
    /** 16x16 */ public static final @NotNull Icon UnloadedModule = load("expui/nodes/unloadedModule.svg", "modules/unloadedModule.svg", 1516131730, 0);
    /** 16x16 */ public static final @NotNull Icon UnmarkWebroot = load("expui/nodes/unmarkWebRoot.svg", "modules/unmarkWebroot.svg", -501724615, 0);
  }

  public static final class Nodes {
    /** 16x16 */ public static final @NotNull Icon AbstractClass = load("expui/nodes/classAbstract.svg", "nodes/abstractClass.svg", 1529379927, 0);
    /** 16x16 */ public static final @NotNull Icon AbstractException = load("expui/nodes/abstractException.svg", "nodes/abstractException.svg", 123181811, 0);
    /** 16x16 */ public static final @NotNull Icon AbstractMethod = load("expui/nodes/methodAbstract.svg", "nodes/abstractMethod.svg", -368983524, 1);
    /** 16x16 */ public static final @NotNull Icon Alias = load("expui/nodes/alias.svg", "nodes/alias.svg", -1977759261, 0);
    /** 16x16 */ public static final @NotNull Icon Annotationtype = load("expui/nodes/annotation.svg", "nodes/annotationtype.svg", 155742257, 0);
    /** 16x16 */ public static final @NotNull Icon AnonymousClass = load("expui/nodes/classAnonymous.svg", "nodes/anonymousClass.svg", -1373375692, 0);
    /** 16x16 */ public static final @NotNull Icon Artifact = load("expui/nodes/artifact.svg", "nodes/artifact.svg", 1929766435, 0);
    /** 16x16 */ public static final @NotNull Icon Aspect = load("nodes/aspect.svg", 1476698583, 0);
    /** 16x16 */ public static final @NotNull Icon Bookmark = load("expui/bookmarks/bookmark.svg", "nodes/bookmark.svg", 2046286300, 2);
    /** 16x16 */ public static final @NotNull Icon BookmarkGroup = load("expui/bookmarks/bookmarksList.svg", "nodes/bookmarkGroup.svg", -1602832368, 0);
    /** 16x16 */ public static final @NotNull Icon C_plocal = load("expui/nodes/accessLocal.svg", "nodes/c_plocal.svg", -633055103, 0);
    /** 16x16 */ public static final @NotNull Icon C_private = load("expui/nodes/accessPrivate.svg", "nodes/c_private.svg", 1641390720, 0);
    /** 16x16 */ public static final @NotNull Icon C_protected = load("expui/nodes/accessProtected.svg", "nodes/c_protected.svg", 1689517295, 0);
    /** 16x16 */ public static final @NotNull Icon C_public = load("expui/nodes/accessPublic.svg", "nodes/c_public.svg", -440432317, 0);
    /** 16x16 */ public static final @NotNull Icon Class = load("expui/nodes/class.svg", "nodes/class.svg", 1223421377, 0);
    /** 16x16 */ public static final @NotNull Icon ClassInitializer = load("expui/nodes/classInitializer.svg", "nodes/classInitializer.svg", -65487192, 0);
    /** 16x16 */ public static final @NotNull Icon CompiledClassesFolder = load("expui/nodes/compiledClassesFolder.svg", "nodes/compiledClassesFolder.svg", -698597684, 0);
    /** 16x16 */ public static final @NotNull Icon ConfigFolder = load("expui/build/taskGroup.svg", "nodes/configFolder.svg", -1322890185, 0);
    /** 16x16 */ public static final @NotNull Icon Console = load("expui/fileTypes/shell.svg", "nodes/console.svg", 1497553448, 0);
    /** 16x16 */ public static final @NotNull Icon Constant = load("expui/nodes/constant.svg", "nodes/constant.svg", -1342227936, 0);
    /** 16x16 */ public static final @NotNull Icon Constructor = load("expui/nodes/constructor.svg", "nodes/constructor.svg", 1815954927, 0);
    /** 16x16 */ public static final @NotNull Icon Controller = load("expui/nodes/controller.svg", "nodes/controller.svg", 1122138685, 0);
    /** 16x16 */ public static final @NotNull Icon CopyOfFolder = load("expui/nodes/copyOfFolder.svg", "nodes/copyOfFolder.svg", 992788029, 0);
    /** 16x16 */ public static final @NotNull Icon CustomRegion = load("nodes/customRegion.svg", 254535518, 0);
    /** 16x16 */ public static final @NotNull Icon DataColumn = load("expui/nodes/dataColumn.svg", "nodes/dataColumn.svg", 691664730, 0);
    /** 16x16 */ public static final @NotNull Icon DataSchema = load("expui/nodes/dataSchema.svg", "nodes/dataSchema.svg", 2036274303, 0);
    /** 16x16 */ public static final @NotNull Icon DataTables = load("expui/nodes/dataTables.svg", "nodes/DataTables.svg", 1993063626, 0);
    /** 16x16 */ public static final @NotNull Icon Deploy = load("expui/actions/deploy.svg", "nodes/deploy.svg", 1429101484, 0);
    /** 16x16 */ public static final @NotNull Icon Desktop = load("expui/nodes/desktop.svg", "nodes/desktop.svg", 1826699477, 2);
    /** 16x16 */ public static final @NotNull Icon DoneMark = load("nodes/doneMark.svg", -259465383, 2);
    /** 16x16 */ public static final @NotNull Icon Editorconfig = load("expui/fileTypes/editorConfig.svg", "nodes/editorconfig.svg", 1192785032, 0);
    /** 16x16 */ public static final @NotNull Icon EmptyNode = load("nodes/emptyNode.svg", 671336322, 0);
    /** 16x16 */ public static final @NotNull Icon EnterpriseProject = load("expui/nodes/ideaProject.svg", "nodes/enterpriseProject.svg", -1455672461, 0);
    /** 16x16 */ public static final @NotNull Icon EntryPoints = load("expui/nodes/entryPoints.svg", "nodes/entryPoints.svg", 2109113074, 0);
    /** 16x16 */ public static final @NotNull Icon Enum = load("expui/nodes/enum.svg", "nodes/enum.svg", 1074876923, 1);
    /** 16x16 */ public static final @NotNull Icon ErrorIntroduction = load("expui/nodes/errorIntroduction.svg", "nodes/errorIntroduction.svg", -1789951081, 1);
    /** 16x16 */ public static final @NotNull Icon ErrorMark = load("nodes/errorMark.svg", -2007730075, 2);
    /** 16x16 */ public static final @NotNull Icon ExceptionClass = load("expui/nodes/exception.svg", "nodes/exceptionClass.svg", 995470706, 0);
    /** 16x16 */ public static final @NotNull Icon ExcludedFromCompile = load("nodes/excludedFromCompile.svg", 1557593468, 0);
    /** 16x16 */ public static final @NotNull Icon ExtractedFolder = load("nodes/extractedFolder.svg", -198727752, 0);
    /** 16x16 */ public static final @NotNull Icon Favorite = load("expui/nodes/star.svg", "nodes/favorite.svg", -98407992, 0);
    /** 16x16 */ public static final @NotNull Icon Field = load("expui/nodes/field.svg", "nodes/field.svg", 1506095758, 0);
    /** 16x16 */ public static final @NotNull Icon FieldPK = load("nodes/fieldPK.svg", 583823163, 0);
    /** 16x16 */ public static final @NotNull Icon FilePrivate = load("nodes/filePrivate.svg", 260959244, 0);
    /** 16x16 */ public static final @NotNull Icon FinalMark = load("expui/nodes/finalMark.svg", "nodes/finalMark.svg", -993330370, 0);
    /** 16x16 */ public static final @NotNull Icon Folder = load("expui/nodes/folder.svg", "nodes/folder.svg", -298158278, 0);
    /** 16x16 */ public static final @NotNull Icon FolderGithub = load("expui/nodes/folderGithub.svg", 117108111, 2);
    /** 16x16 */ public static final @NotNull Icon Function = load("expui/nodes/function.svg", "nodes/function.svg", 1027695397, 0);
    /** 16x16 */ public static final @NotNull Icon Gvariable = load("expui/nodes/gvariable.svg", "nodes/gvariable.svg", 1184723774, 0);
    /** 16x16 */ public static final @NotNull Icon HomeFolder = load("expui/nodes/homeFolder.svg", "nodes/homeFolder.svg", 898285507, 2);
    /** 16x16 */ public static final @NotNull Icon IdeaModule = load("expui/fileTypes/ideaModule.svg", "nodes/ideaModule.svg", 2092323770, 0);
    /** 16x16 */ public static final @NotNull Icon IdeaProject = load("expui/nodes/ideaProject.svg", "nodes/ideaProject.svg", -1164546981, 0);
    /** 16x16 */ public static final @NotNull Icon Include = load("expui/nodes/include.svg", "nodes/include.svg", -1043076621, 0);
    /** 16x16 */ public static final @NotNull Icon Interface = load("expui/nodes/interface.svg", "nodes/interface.svg", -371611298, 1);
    /** 16x16 */ public static final @NotNull Icon JarDirectory = load("nodes/jarDirectory.svg", -692661187, 0);
    /** 16x16 */ public static final @NotNull Icon JavaDocFolder = load("nodes/javaDocFolder.svg", 135532303, 0);
    /** 16x16 */ public static final @NotNull Icon JavaModule = load("expui/nodes/moduleJava.svg", "nodes/javaModule.svg", 2003423238, 0);
    /** 16x16 */ public static final @NotNull Icon JunitTestMark = load("expui/nodes/junitTestMark.svg", "nodes/junitTestMark.svg", -1344036663, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapAnt = load("expui/nodes/folder.svg", "nodes/keymapAnt.svg", 1301975081, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapEditor = load("expui/nodes/folder.svg", "nodes/keymapEditor.svg", 1477064864, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapMainMenu = load("expui/nodes/folder.svg", "nodes/keymapMainMenu.svg", 797253808, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapOther = load("expui/nodes/folder.svg", "nodes/keymapOther.svg", 1894798752, 0);
    /** 16x16 */ public static final @NotNull Icon KeymapTools = load("expui/nodes/folder.svg", "nodes/keymapTools.svg", 1353039843, 0);
    /** 16x16 */ public static final @NotNull Icon Lambda = load("expui/nodes/lambda.svg", "nodes/lambda.svg", 1626830622, 0);
    /** 16x16 */ public static final @NotNull Icon Library = load("expui/nodes/library.svg", 954949276, 2);
    /** 16x16 */ public static final @NotNull Icon Locked = load("expui/nodes/locked.svg", "nodes/locked.svg", 1553434086, 0);
    /** 16x16 */ public static final @NotNull Icon LogFolder = load("expui/nodes/logFolder.svg", "nodes/logFolder.svg", 1356256727, 2);
    /** 16x16 */ public static final @NotNull Icon Method = load("expui/nodes/method.svg", "nodes/method.svg", 769751382, 1);
    /** 16x16 */ public static final @NotNull Icon MethodReference = load("expui/nodes/methodReference.svg", "nodes/methodReference.svg", -1852540687, 1);
    /** 16x16 */ public static final @NotNull Icon Mnemonic = load("expui/bookmarks/mnemonic.svg", "nodes/mnemonic.svg", 421519755, 2);
    /** 16x16 */ public static final @NotNull Icon ModelClass = load("expui/nodes/modelClass.svg", "nodes/modelClass.svg", 555452729, 0);
    /** 16x16 */ public static final @NotNull Icon Models = load("expui/nodes/models.svg", "nodes/models.svg", 1624215709, 0);
    /** 16x16 */ public static final @NotNull Icon Module = load("expui/nodes/module.svg", "nodes/Module.svg", -1084587309, 0);
    /** 8x8 */ public static final @NotNull Icon Module8x8 = load("expui/nodes/module8x8.svg", -887506793, 2);
    /** 16x16 */ public static final @NotNull Icon ModuleGroup = load("expui/nodes/moduleGroup.svg", "nodes/moduleGroup.svg", 612825130, 0);
    /** 16x16 */ public static final @NotNull Icon MultipleTypeDefinitions = load("expui/nodes/multipleTypeDefinitions.svg", "nodes/multipleTypeDefinitions.svg", 255042021, 0);
    /** 16x16 */ public static final @NotNull Icon NativeLibrariesFolder = load("nodes/nativeLibrariesFolder.svg", -934491736, 0);
    /** 16x16 */ public static final @NotNull Icon NewParameter = load("expui/nodes/parameter.svg", "nodes/newParameter.svg", 812802746, 0);
    /** 16x16 */ public static final @NotNull Icon NodePlaceholder = load("nodes/nodePlaceholder.svg", 1483179468, 0);
    /** 16x16 */ public static final @NotNull Icon NotFavoriteOnHover = load("expui/nodes/starEmpty.svg", "nodes/notFavoriteOnHover.svg", -694542628, 0);
    /** 16x16 */ public static final @NotNull Icon ObjectTypeAttribute = load("expui/nodes/attribute.svg", "nodes/objectTypeAttribute.svg", -868289358, 0);
    /** 16x16 */ public static final @NotNull Icon Package = load("expui/nodes/package.svg", "nodes/package.svg", 1437619971, 0);
    /** 16x16 */ public static final @NotNull Icon PackageLocal = load("expui/nodes/accessLocal.svg", "nodes/packageLocal.svg", -1819537581, 0);
    /** 16x16 */ public static final @NotNull Icon Padlock = load("expui/diff/disableEditing.svg", "nodes/padlock.svg", -179511723, 0);
    /** 16x16 */ public static final @NotNull Icon Parameter = load("expui/nodes/parameter.svg", "nodes/parameter.svg", -2136427129, 0);
    /** 16x16 */ public static final @NotNull Icon Plugin = load("expui/nodes/plugin.svg", "nodes/plugin.svg", 1733633283, 0);
    /** 16x16 */ public static final @NotNull Icon PluginJB = load("expui/nodes/pluginJB.svg", "nodes/pluginJB.svg", -1193894334, 0);
    /** 16x16 */ public static final @NotNull Icon Pluginnotinstalled = load("expui/nodes/plugin.svg", "nodes/pluginnotinstalled.svg", -75865196, 0);
    /** 16x16 */ public static final @NotNull Icon Pluginobsolete = load("expui/nodes/plugin.svg", "nodes/pluginobsolete.svg", -1473078649, 0);
    /** 16x16 */ public static final @NotNull Icon PluginRestart = load("expui/nodes/plugin.svg", "nodes/pluginRestart.svg", -60848417, 0);
    /** 16x16 */ public static final @NotNull Icon PpInvalid = load("expui/nodes/ppInvalid.svg", "nodes/ppInvalid.svg", -908667763, 0);
    /** 16x16 */ public static final @NotNull Icon PpJar = load("expui/fileTypes/archive.svg", "nodes/ppJar.svg", 571724618, 0);
    /** 16x16 */ public static final @NotNull Icon PpJdk = load("expui/nodes/jdk.svg", "nodes/ppJdk.svg", 436331905, 0);
    /** 16x16 */ public static final @NotNull Icon PpLib = load("expui/nodes/library.svg", "nodes/ppLib.svg", 1687530585, 0);
    /** 16x16 */ public static final @NotNull Icon PpLibFolder = load("expui/nodes/libraryFolder.svg", "nodes/ppLibFolder.svg", 1117226175, 0);
    /** 16x16 */ public static final @NotNull Icon PpWeb = load("expui/nodes/ppWeb.svg", "nodes/ppWeb.svg", -1732456971, 0);
    /** 16x16 */ public static final @NotNull Icon Private = load("expui/nodes/accessPrivate.svg", "nodes/private.svg", -1342521175, 0);
    /** 16x16 */ public static final @NotNull Icon ProcessMark = load("expui/nodes/processMark.svg", "nodes/processMark.svg", -1538708812, 2);
    /** 16x16 */ public static final @NotNull Icon Project = load("expui/runConfigurations/application.svg", "nodes/project.svg", -1691051087, 0);
    /** 16x16 */ public static final @NotNull Icon Property = load("expui/nodes/property.svg", "nodes/property.svg", 2074391394, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyRead = load("expui/nodes/property.svg", "nodes/propertyRead.svg", -1755987461, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyReadStatic = load("expui/nodes/property.svg", "nodes/propertyReadStatic.svg", 505197717, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyReadWrite = load("expui/nodes/property.svg", "nodes/propertyReadWrite.svg", -1794806549, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyReadWriteStatic = load("expui/nodes/property.svg", "nodes/propertyReadWriteStatic.svg", 1819982940, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyWrite = load("expui/nodes/property.svg", "nodes/propertyWrite.svg", 1460565487, 0);
    /** 16x16 */ public static final @NotNull Icon PropertyWriteStatic = load("expui/nodes/property.svg", "nodes/propertyWriteStatic.svg", 2120003686, 0);
    /** 16x16 */ public static final @NotNull Icon Protected = load("expui/nodes/accessProtected.svg", "nodes/protected.svg", 2076038344, 0);
    /** 16x16 */ public static final @NotNull Icon Public = load("expui/nodes/accessPublic.svg", "nodes/public.svg", 1720533817, 0);
    /** 16x16 */ public static final @NotNull Icon ReadAccess = load("expui/actions/showReadAccess.svg", "nodes/read-access.svg", 1692583040, 0);
    /** 16x16 */ public static final @NotNull Icon Record = load("expui/nodes/record.svg", "nodes/record.svg", -1827827309, 0);
    /** 16x16 */ public static final @NotNull Icon Related = load("expui/nodes/related.svg", "nodes/related.svg", 1655583391, 0);
    /** 16x16 */ public static final @NotNull Icon ResourceBundle = load("expui/nodes/resourceBundle.svg", "nodes/resourceBundle.svg", -157836139, 0);
    /** 16x16 */ public static final @NotNull Icon RunnableMark = load("expui/nodes/runnableMark.svg", "nodes/runnableMark.svg", 8747712, 0);
    /** 16x16 */ public static final @NotNull Icon RwAccess = load("nodes/rw-access.svg", -2056540925, 0);
    /** 16x16 */ public static final @Deprecated @NotNull Icon Rw_access = RwAccess;
    /** 16x16 */ public static final @NotNull Icon SecurityRole = load("expui/nodes/securityRole.svg", "nodes/securityRole.svg", -963350414, 0);
    /** 16x16 */ public static final @NotNull Icon Services = load("expui/nodes/services.svg", "nodes/services.svg", -74459343, 0);
    /** 16x16 */ public static final @NotNull Icon Servlet = load("expui/nodes/servlet.svg", "nodes/servlet.svg", -1451210760, 0);
    /** 16x16 */ public static final @NotNull Icon Shared = load("expui/nodes/shared.svg", "nodes/shared.svg", -700350789, 0);
    /** 16x16 */ public static final @NotNull Icon SortBySeverity = load("expui/nodes/sortBySeverity.svg", "nodes/sortBySeverity.svg", -1406088260, 2);
    /** 16x16 */ public static final @NotNull Icon Ssh = load("expui/nodes/ssh.svg", "nodes/ssh.svg", 1941773502, 0);
    /** 16x16 */ public static final @NotNull Icon Static = load("expui/nodes/static.svg", "nodes/static.svg", 2117384057, 0);
    /** 16x16 */ public static final @NotNull Icon StaticMark = load("expui/nodes/staticMark.svg", "nodes/staticMark.svg", -1188889986, 0);
    /** 16x16 */ public static final @NotNull Icon Symlink = load("expui/nodes/symlink.svg", "nodes/symlink.svg", 806877714, 0);
    /** 16x16 */ public static final @NotNull Icon TabAlert = load("expui/nodes/tabAlert.svg", "nodes/tabAlert.svg", 1341232361, 0);
    /** 16x16 */ public static final @NotNull Icon TabPin = load("nodes/tabPin.svg", 524417993, 0);
    /** 16x16 */ public static final @NotNull Icon Tag = load("expui/nodes/tag.svg", "nodes/tag.svg", -650679793, 0);
    /** 16x16 */ public static final @NotNull Icon Target = load("nodes/target.svg", 1367051030, 0);
    /** 16x16 */ public static final @NotNull Icon Template = load("expui/nodes/template.svg", "nodes/template.svg", 734446626, 0);
    /** 16x16 */ public static final @NotNull Icon TemplateRoot = load("expui/nodes/templateRoot.svg", "nodes/templateRoot.svg", 6261950, 0);
    /** 16x16 */ public static final @NotNull Icon Test = load("expui/nodes/test.svg", "nodes/test.svg", 744303023, 0);
    /** 16x16 */ public static final @NotNull Icon TestGroup = load("expui/nodes/testGroup.svg", "nodes/testGroup.svg", -1600035187, 0);
    /** 16x16 */ public static final @NotNull Icon TestIgnored = load("expui/nodes/testIgnored.svg", "nodes/testIgnored.svg", 723241848, 0);
    /** 16x16 */ public static final @NotNull Icon TestSourceFolder = load("expui/nodes/testSourceFolder.svg", "nodes/testSourceFolder.svg", -12513982, 0);
    /** 16x16 */ public static final @NotNull Icon TextArea = load("expui/nodes/textArea.svg", "nodes/textArea.svg", -342431394, 0);
    /** 16x16 */ public static final @NotNull Icon Toolbox = load("nodes/toolbox.svg", -388073839, 0);
    /** 16x16 */ public static final @NotNull Icon Type = load("expui/nodes/type.svg", "nodes/type.svg", 1771437316, 0);
    /** 16x16 */ public static final @NotNull Icon Undeploy = load("expui/actions/undeploy.svg", "nodes/undeploy.svg", -1692132469, 0);
    /** 16x16 */ public static final @NotNull Icon Unknown = load("expui/nodes/unknown.svg", "nodes/unknown.svg", 1061055855, 0);
    /** 16x16 */ public static final @NotNull Icon UnknownJdk = load("expui/nodes/ppInvalid.svg", "nodes/unknownJdk.svg", 1986945606, 0);
    /** 16x16 */ public static final @NotNull Icon UnloadedProject = load("expui/nodes/unloadedProject.svg", 793315583, 2);
    /** 16x16 */ public static final @NotNull Icon UpFolder = load("expui/nodes/upFolder.svg", "nodes/upFolder.svg", -98764899, 0);
    /** 16x16 */ public static final @NotNull Icon UpLevel = load("expui/nodes/upLevel.svg", "nodes/upLevel.svg", -1993017141, 0);
    /** 16x16 */ public static final @NotNull Icon Variable = load("expui/nodes/variable.svg", "nodes/variable.svg", 1782176763, 0);
    /** 16x16 */ public static final @NotNull Icon WarningIntroduction = load("expui/nodes/warningIntroduction.svg", "nodes/warningIntroduction.svg", 1012205954, 1);
    /** 16x16 */ public static final @NotNull Icon WarningMark = load("nodes/warningMark.svg", 1474957887, 2);
    /** 16x16 */ public static final @NotNull Icon WebFolder = load("expui/nodes/webFolder.svg", "nodes/webFolder.svg", 701791527, 0);
    /** 16x16 */ public static final @NotNull Icon Word = load("nodes/word.svg", -820267638, 0);
    /** 16x16 */ public static final @NotNull Icon Workspace = load("expui/nodes/workspace.svg", -251479768, 2);
    /** 16x16 */ public static final @NotNull Icon WriteAccess = load("expui/actions/showWriteAccess.svg", "nodes/write-access.svg", 735088822, 0);

    /** @deprecated to be removed without replacement */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval
    public static final @NotNull Icon InspectionResults = load("nodes/inspectionResults.svg", 0, 0);

    /** @deprecated to be removed without replacement */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval
    public static final @NotNull Icon Weblistener = load("nodes/weblistener.svg", 0, 0);
  }

  public static final class ObjectBrowser {
    /** 16x16 */ public static final @NotNull Icon AbbreviatePackageNames = load("expui/objectBrowser/abbreviatePackageNames.svg", "objectBrowser/abbreviatePackageNames.svg", -2101913433, 2);
    /** 16x16 */ public static final @NotNull Icon CompactEmptyPackages = load("expui/objectBrowser/compactEmptyPackages.svg", "objectBrowser/compactEmptyPackages.svg", 1381890836, 2);
    /** 16x16 */ public static final @NotNull Icon FlattenModules = load("expui/objectBrowser/flattenModules.svg", "objectBrowser/flattenModules.svg", 995079473, 2);
    /** 16x16 */ public static final @NotNull Icon FlattenPackages = load("expui/objectBrowser/flattenPackages.svg", "objectBrowser/flattenPackages.svg", 1534482841, 2);
    /** 16x16 */ public static final @NotNull Icon ShowLibraryContents = load("expui/objectBrowser/showLibraryContents.svg", "objectBrowser/showLibraryContents.svg", -194817890, 2);
    /** 16x16 */ public static final @NotNull Icon ShowMembers = load("expui/objectBrowser/showMembers.svg", "objectBrowser/showMembers.svg", 1639707486, 0);
    /** 16x16 */ public static final @NotNull Icon SortByType = load("expui/objectBrowser/sortByType.svg", "objectBrowser/sortByType.svg", 46592963, 2);
    /** 16x16 */ public static final @NotNull Icon Sorted = load("expui/objectBrowser/sortAlphabetically.svg", "objectBrowser/sorted.svg", -103346577, 2);
    /** 16x16 */ public static final @NotNull Icon SortedByUsage = load("expui/objectBrowser/sortByUsage.svg", "objectBrowser/sortedByUsage.svg", 918667062, 2);
    /** 16x16 */ public static final @NotNull Icon VisibilitySort = load("expui/objectBrowser/sortByVisibility.svg", "objectBrowser/visibilitySort.svg", -240414377, 2);
  }

  public static final class Plugins {
    /** 16x16 */ public static final @NotNull Icon Disabled = load("plugins/disabled.svg", 819830524, 0);
    /** 12x12 */ public static final @NotNull Icon Downloads = load("plugins/downloads.svg", -1752016306, 2);
    /** 15x15 */ public static final @NotNull Icon ModifierInvalid = load("plugins/modifierInvalid.svg", 2038910854, 2);
    /** 40x40 */ public static final @NotNull Icon PluginLogo = load("expui/nodes/pluginLogo.svg", "plugins/pluginLogo.svg", 899855946, 0);
    /** 40x40 */ public static final @NotNull Icon PluginLogoDisabled = load("expui/nodes/pluginLogoDisabled.svg", "plugins/pluginLogoDisabled.svg", 1569910218, 0);
    /** 12x12 */ public static final @NotNull Icon Rating = load("plugins/rating.svg", 1714785539, 2);
    /** 12x12 */ public static final @NotNull Icon Updated = load("plugins/updated.svg", 1725310914, 2);
  }

  public static final class Process {
    public static final class Big {
      /** 32x32 */ public static final @NotNull Icon Step_1 = load("process/big/step_1.svg", 1950965259, 0);
      /** 32x32 */ public static final @NotNull Icon Step_2 = load("process/big/step_2.svg", 686467090, 0);
      /** 32x32 */ public static final @NotNull Icon Step_3 = load("process/big/step_3.svg", -59514177, 0);
      /** 32x32 */ public static final @NotNull Icon Step_4 = load("process/big/step_4.svg", 2074387692, 0);
      /** 32x32 */ public static final @NotNull Icon Step_5 = load("process/big/step_5.svg", -1914367921, 0);
      /** 32x32 */ public static final @NotNull Icon Step_6 = load("process/big/step_6.svg", 1195148056, 0);
      /** 32x32 */ public static final @NotNull Icon Step_7 = load("process/big/step_7.svg", -1874870684, 0);
      /** 32x32 */ public static final @NotNull Icon Step_8 = load("process/big/step_8.svg", 1634972671, 0);
      /** 32x32 */ public static final @NotNull Icon Step_passive = load("process/big/step_passive.svg", 1533666781, 0);
    }

    public static final class FS {
      /** 16x16 */ public static final @NotNull Icon Step_1 = load("process/fs/step_1.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_10 = load("process/fs/step_10.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_11 = load("process/fs/step_11.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_12 = load("process/fs/step_12.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_13 = load("process/fs/step_13.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_14 = load("process/fs/step_14.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_15 = load("process/fs/step_15.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_16 = load("process/fs/step_16.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_17 = load("process/fs/step_17.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_18 = load("process/fs/step_18.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_2 = load("process/fs/step_2.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_3 = load("process/fs/step_3.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_4 = load("process/fs/step_4.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_5 = load("process/fs/step_5.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_6 = load("process/fs/step_6.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_7 = load("process/fs/step_7.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_8 = load("process/fs/step_8.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_9 = load("process/fs/step_9.png", 0, 7);
      /** 16x16 */ public static final @NotNull Icon Step_mask = load("process/fs/step_mask.png", 0, 1);
      /** 16x16 */ public static final @NotNull Icon Step_passive = load("process/fs/step_passive.png", 0, 7);
    }

    /** 14x14 */ public static final @NotNull Icon ProgressPause = load("expui/progress/pause.svg", "process/progressPause.svg", 393051057, 0);
    /** 14x14 */ public static final @NotNull Icon ProgressPauseHover = load("expui/progress/pauseHovered.svg", "process/progressPauseHover.svg", 1673158723, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressPauseSmall = load("expui/progress/pause.svg", "process/progressPauseSmall.svg", -25151793, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressPauseSmallHover = load("expui/progress/pauseHovered.svg", "process/progressPauseSmallHover.svg", -572608376, 0);
    /** 14x14 */ public static final @NotNull Icon ProgressResume = load("expui/progress/resume.svg", "process/progressResume.svg", -1530155965, 0);
    /** 14x14 */ public static final @NotNull Icon ProgressResumeHover = load("expui/progress/resumeHovered.svg", "process/progressResumeHover.svg", -494663563, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressResumeSmall = load("expui/progress/resume.svg", "process/progressResumeSmall.svg", 2056201369, 0);
    /** 12x12 */ public static final @NotNull Icon ProgressResumeSmallHover = load("expui/progress/resumeHovered.svg", "process/progressResumeSmallHover.svg", 2010567265, 0);
    /** 16x16 */ public static final @NotNull Icon Step_1 = load("process/step_1.svg", 801053044, 0);
    /** 16x16 */ public static final @NotNull Icon Step_2 = load("process/step_2.svg", 1356365142, 0);
    /** 16x16 */ public static final @NotNull Icon Step_3 = load("process/step_3.svg", -86893478, 0);
    /** 16x16 */ public static final @NotNull Icon Step_4 = load("process/step_4.svg", -715393837, 0);
    /** 16x16 */ public static final @NotNull Icon Step_5 = load("process/step_5.svg", 1297771707, 0);
    /** 16x16 */ public static final @NotNull Icon Step_6 = load("process/step_6.svg", -371106068, 0);
    /** 16x16 */ public static final @NotNull Icon Step_7 = load("process/step_7.svg", -887860406, 0);
    /** 16x16 */ public static final @NotNull Icon Step_8 = load("process/step_8.svg", -1324285093, 0);
    /** 16x16 */ public static final @NotNull Icon Step_mask = load("process/step_mask.svg", 541198891, 0);
    /** 16x16 */ public static final @NotNull Icon Step_passive = load("process/step_passive.svg", 850739805, 0);
    /** 14x14 */ public static final @NotNull Icon Stop = load("expui/progress/stop.svg", "process/stop.svg", 252291276, 0);
    /** 14x14 */ public static final @NotNull Icon StopHovered = load("expui/progress/stopHovered.svg", "process/stopHovered.svg", 1512682765, 0);
    /** 12x12 */ public static final @NotNull Icon StopSmall = load("expui/progress/stop.svg", "process/stopSmall.svg", -917305084, 0);
    /** 12x12 */ public static final @NotNull Icon StopSmallHovered = load("expui/progress/stopHovered.svg", "process/stopSmallHovered.svg", 1491267815, 0);
  }

  public static final class Profiler {
    /** 9x9 */ public static final @NotNull Icon CollapseNode = load("expui/profiler/collapseNode.svg", "profiler/collapseNode.svg", -1951001089, 2);
    /** 9x9 */ public static final @NotNull Icon ExpandNode = load("expui/profiler/expandNode.svg", "profiler/expandNode.svg", -934605771, 2);
    /** 12x12 */ public static final @NotNull Icon Rec = load("expui/profiler/rec.svg", "profiler/rec.svg", 204716318, 2);
  }

  public static final class Providers {
    /** 16x16 */ public static final @NotNull Icon ActiveMQ = load("providers/activeMQ.svg", -1202590345, 0);
    /** 16x16 */ public static final @NotNull Icon AmazonWebServices = load("providers/amazonWebServices.svg", -1722782738, 2);
    /** 16x16 */ public static final @NotNull Icon Apache = load("providers/apache.svg", 1920166272, 2);
    /** 16x16 */ public static final @NotNull Icon ApacheDerby = load("providers/apacheDerby.svg", -1039281205, 2);
    /** 16x16 */ public static final @NotNull Icon ApacheIgnite = load("providers/apacheIgnite.svg", 550257054, 2);
    /** 16x16 */ public static final @NotNull Icon ApachePhoenix = load("providers/apachePhoenix.svg", 426659470, 0);
    /** 16x16 */ public static final @NotNull Icon Athena = load("providers/athena.svg", 1959048894, 0);
    /** 16x16 */ public static final @NotNull Icon Azure = load("providers/azure.svg", 2141980648, 0);
    /** 16x16 */ public static final @NotNull Icon BigQuery = load("providers/bigQuery.svg", 1138709532, 0);
    /** 16x16 */ public static final @NotNull Icon Cassandra = load("providers/cassandra.svg", -819208447, 2);
    /** 16x16 */ public static final @NotNull Icon ClickHouse = load("providers/clickHouse.svg", -519696265, 0);
    /** 16x16 */ public static final @NotNull Icon CockroachDB = load("providers/cockroachDB.svg", -430761369, 0);
    /** 16x16 */ public static final @NotNull Icon Couchbase = load("providers/couchbase.svg", 125110449, 0);
    /** 16x16 */ public static final @NotNull Icon Databricks = load("providers/databricks.svg", 1206450250, 2);
    /** 16x16 */ public static final @NotNull Icon DB2 = load("providers/DB2.svg", -700958296, 2);
    /** 16x16 */ public static final @NotNull Icon Denodo = load("providers/denodo.svg", -1481188209, 2);
    /** 16x16 */ public static final @NotNull Icon DocumentDB = load("providers/documentDB.svg", -1286984491, 2);
    /** 16x16 */ public static final @NotNull Icon DuckDB = load("providers/duckDB.svg", -590062592, 2);
    /** 16x16 */ public static final @NotNull Icon DynamoDB = load("providers/dynamoDB.svg", 820880886, 0);
    /** 16x16 */ public static final @NotNull Icon Eclipse = load("expui/fileTypes/eclipse.svg", "providers/eclipse.svg", -614086709, 2);
    /** 16x16 */ public static final @NotNull Icon Elasticsearch = load("providers/elasticsearch.svg", -407419806, 0);
    /** 16x16 */ public static final @NotNull Icon Exasol = load("providers/exasol.svg", 1285797270, 2);
    /** 16x16 */ public static final @NotNull Icon Firebird = load("providers/firebird.svg", 1881709539, 0);
    /** 16x16 */ public static final @NotNull Icon GaussDB = load("providers/gaussDB.svg", -650009525, 2);
    /** 16x16 */ public static final @NotNull Icon GeminiDb = load("providers/geminiDb.svg", 1146970231, 2);
    /** 16x16 */ public static final @NotNull Icon GoogleCloud = load("providers/googleCloud.svg", -1785343781, 0);
    /** 16x16 */ public static final @NotNull Icon GoogleCloudSpanner = load("providers/googleCloudSpanner.svg", 2080603813, 0);
    /** 16x16 */ public static final @NotNull Icon Greenplum = load("providers/greenplum.svg", -2098154949, 0);
    /** 16x16 */ public static final @NotNull Icon H2 = load("providers/h2.svg", 1284289147, 2);
    /** 16x16 */ public static final @NotNull Icon HANA = load("providers/HANA.svg", 132046000, 0);
    /** 16x16 */ public static final @NotNull Icon Hive = load("providers/hive.svg", 24592390, 2);
    /** 16x16 */ public static final @NotNull Icon Hsqldb = load("providers/hsqldb.svg", -1331653091, 0);
    /** 16x16 */ public static final @NotNull Icon Ibm = load("providers/ibm.svg", 84455348, 2);
    /** 16x16 */ public static final @NotNull Icon Impala = load("providers/impala.svg", -1453615062, 2);
    /** 16x16 */ public static final @NotNull Icon InfluxDB = load("providers/influxDB.svg", -51988850, 2);
    /** 16x16 */ public static final @NotNull Icon Informix = load("providers/informix.svg", -751153930, 0);
    /** 16x16 */ public static final @NotNull Icon IntersystemCache = load("providers/intersystemCache.svg", 836219844, 2);
    /** 16x16 */ public static final @NotNull Icon Kafka = load("providers/kafka.svg", 185527233, 2);
    /** 16x16 */ public static final @NotNull Icon Liquibase = load("providers/liquibase.svg", -1061466874, 0);
    /** 16x16 */ public static final @NotNull Icon Mariadb = load("providers/mariadb.svg", -66597132, 2);
    /** 16x16 */ public static final @NotNull Icon Microsoft = load("providers/microsoft.svg", 1693855115, 0);
    /** 16x16 */ public static final @NotNull Icon MimerSQL = load("providers/mimerSQL.svg", -1251881855, 0);
    /** 16x16 */ public static final @NotNull Icon MongoDB = load("providers/mongoDB.svg", -1469680525, 0);
    /** 16x16 */ public static final @NotNull Icon Mysql = load("providers/mysql.svg", -717100114, 2);
    /** 16x16 */ public static final @NotNull Icon Netezza = load("providers/netezza.svg", 1267154425, 2);
    /** 16x16 */ public static final @NotNull Icon Openedge = load("providers/openedge.svg", 101561569, 0);
    /** 16x16 */ public static final @NotNull Icon Oracle = load("providers/oracle.svg", -2123432217, 0);
    /** 16x16 */ public static final @NotNull Icon Postgresql = load("providers/postgresql.svg", 2080604372, 2);
    /** 16x16 */ public static final @NotNull Icon Presto = load("providers/presto.svg", -452330035, 2);
    /** 16x16 */ public static final @NotNull Icon RabbitMQ = load("providers/rabbitMQ.svg", -1667525054, 0);
    /** 16x16 */ public static final @NotNull Icon Redis = load("providers/redis.svg", 1275648116, 2);
    /** 16x16 */ public static final @NotNull Icon Redshift = load("providers/redshift.svg", -1692420973, 0);
    /** 16x16 */ public static final @NotNull Icon Singlestore = load("providers/singlestore.svg", -981783807, 0);
    /** 16x16 */ public static final @NotNull Icon Snowflake = load("providers/snowflake.svg", -900289909, 0);
    /** 16x16 */ public static final @NotNull Icon Spark = load("providers/spark.svg", 505740135, 0);
    /** 16x16 */ public static final @NotNull Icon Sqlite = load("providers/sqlite.svg", -469619323, 2);
    /** 16x16 */ public static final @NotNull Icon SqlServer = load("providers/sqlServer.svg", 33975713, 2);
    /** 16x16 */ public static final @NotNull Icon Sun = load("providers/sun.svg", -210021560, 2);
    /** 16x16 */ public static final @NotNull Icon Sybase = load("providers/sybase.svg", 174932757, 0);
    /** 16x16 */ public static final @NotNull Icon Tair = load("providers/tair.svg", 1322700262, 2);
    /** 16x16 */ public static final @NotNull Icon Tarantool = load("providers/tarantool.svg", 1122877793, 0);
    /** 16x16 */ public static final @NotNull Icon TaurusDB = load("providers/taurusDB.svg", -445140387, 2);
    /** 16x16 */ public static final @NotNull Icon TensorFlow = load("providers/tensorFlow.svg", 1673568687, 2);
    /** 16x16 */ public static final @NotNull Icon Teradata = load("providers/teradata.svg", 2088926461, 0);
    /** 16x16 */ public static final @NotNull Icon Tibero = load("providers/tibero.svg", 1044999302, 2);
    /** 16x16 */ public static final @NotNull Icon Tidb = load("providers/tidb.svg", 32027773, 0);
    /** 16x16 */ public static final @NotNull Icon Trino = load("providers/trino.svg", 1032883598, 2);
    /** 16x16 */ public static final @NotNull Icon Turso = load("providers/turso.svg", -988781978, 2);
    /** 16x16 */ public static final @NotNull Icon Vertica = load("providers/vertica.svg", 237190308, 2);
    /** 16x16 */ public static final @NotNull Icon Yugabyte = load("providers/yugabyte.svg", -644567085, 2);

    /** @deprecated to be removed (Use AllIcons.Providers.AmazonWebServices instead) */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval
    public static final @NotNull Icon Aws = load("providers/aws.svg", 0, 0);
  }

  public static final class RemoteServers {
    /** 16x16 */ public static final @NotNull Icon ResumeScaled = load("expui/remoteServers/resumeScaled.svg", -397781337, 0);
    /** 16x16 */ public static final @NotNull Icon SuspendScaled = load("expui/remoteServers/suspendScaled.svg", 1727665128, 0);
  }

  public static final class Run {
    /** 16x16 */ public static final @NotNull Icon Restart = load("expui/run/restart.svg", -275136128, 2);
    /** 16x16 */ public static final @NotNull Icon ShowIgnored = load("expui/run/showIgnored.svg", 766664095, 2);
    /** 16x16 */ public static final @NotNull Icon Stop = load("expui/run/stop.svg", 1749021823, 10);

    public static final class Widget {
      /** 16x16 */ public static final @NotNull Icon Build = load("expui/run/widget/build.svg", 744666306, 2);
      /** 16x16 */ public static final @NotNull Icon Restart = load("expui/run/widget/restart.svg", -509572269, 2);
    }
  }

  public static final class RunConfigurations {
    /** 16x16 */ public static final @NotNull Icon Applet = load("expui/runConfigurations/application.svg", "runConfigurations/applet.svg", 874112802, 0);
    /** 16x16 */ public static final @NotNull Icon Application = load("expui/runConfigurations/application.svg", "runConfigurations/application.svg", -259432056, 0);
    /** 16x16 */ public static final @NotNull Icon Compound = load("expui/runConfigurations/compound.svg", "runConfigurations/compound.svg", 1897924291, 0);
    /** 16x16 */ public static final @NotNull Icon HidePassed = load("runConfigurations/hidePassed.svg", -705568960, 2);
    /** 16x16 */ public static final @NotNull Icon IgnoredTest = load("expui/runConfigurations/ignoredTest.svg", "runConfigurations/ignoredTest.svg", -668295495, 2);
    /** 16x16 */ public static final @NotNull Icon InvalidConfigurationLayer = load("expui/runConfigurations/invalidConfigurationLayer.svg", "runConfigurations/invalidConfigurationLayer.svg", -1278168787, 0);
    /** 16x16 */ public static final @NotNull Icon Junit = load("expui/runConfigurations/junit.svg", "runConfigurations/junit.svg", 1196565689, 0);
    /** 16x16 */ public static final @NotNull Icon MultiLaunch = load("expui/runConfigurations/multiLaunch.svg", "runConfigurations/multiLaunch.svg", 295730941, 0);
    /** 16x16 */ public static final @NotNull Icon Remote = load("expui/runConfigurations/applicationRemote.svg", "runConfigurations/remote.svg", -1946031837, 2);
    /** 16x16 */ public static final @NotNull Icon RemoteDebug = load("runConfigurations/remoteDebug.svg", 1740316749, 2);
    /** 16x16 */ public static final @NotNull Icon RerunFailedTests = load("expui/run/restartFailedTests.svg", "runConfigurations/rerunFailedTests.svg", 1872352548, 2);
    /** 16x16 */ public static final @NotNull Icon Scroll_down = load("expui/general/scrollDown.svg", "runConfigurations/scroll_down.svg", 213387752, 2);
    /** 16x16 */ public static final @NotNull Icon Scroll_up = load("expui/general/scrollUp.svg", "runConfigurations/scroll_up.svg", 111249550, 2);
    /** 16x16 */ public static final @NotNull Icon ShowIgnored = load("expui/run/showIgnored.svg", "runConfigurations/showIgnored.svg", 1286017757, 2);
    /** 16x16 */ public static final @NotNull Icon ShowPassed = load("expui/run/showPassed.svg", "runConfigurations/showPassed.svg", 1372966511, 2);
    /** 16x16 */ public static final @NotNull Icon SortbyDuration = load("expui/runConfigurations/sortByDuration.svg", "runConfigurations/sortbyDuration.svg", 531119958, 2);
    /** 16x16 */ public static final @NotNull Icon TestCustom = load("expui/run/testCustom.svg", "runConfigurations/testCustom.svg", 347487674, 0);
    /** 16x16 */ public static final @NotNull Icon TestError = load("expui/run/testError.svg", "runConfigurations/testError.svg", -562983033, 0);
    /** 16x16 */ public static final @NotNull Icon TestFailed = load("expui/run/testFailed.svg", "runConfigurations/testFailed.svg", -1391614819, 0);
    /** 16x16 */ public static final @NotNull Icon TestIgnored = load("expui/run/testIgnored.svg", "runConfigurations/testIgnored.svg", -1607647077, 0);
    /** 16x16 */ public static final @NotNull Icon TestMark = load("expui/runConfigurations/junitTestMark.svg", "runConfigurations/testMark.svg", 434758191, 0);
    /** 16x16 */ public static final @NotNull Icon TestNotRan = load("expui/run/testNotRunYet.svg", "runConfigurations/testNotRan.svg", 964136050, 0);
    /** 16x16 */ public static final @NotNull Icon TestPassed = load("expui/run/testPassed.svg", "runConfigurations/testPassed.svg", -2108716583, 0);
    /** 16x16 */ public static final @NotNull Icon TestPassedIgnored = load("expui/run/testPassedIgnored.svg", "runConfigurations/testPassedIgnored.svg", -1755561418, 0);
    /** 16x16 */ public static final @NotNull Icon TestPaused = load("expui/run/testPaused.svg", "runConfigurations/testPaused.svg", -961367707, 0);
    /** 16x16 */ public static final @NotNull Icon TestSkipped = load("expui/run/testSkipped.svg", "runConfigurations/testSkipped.svg", -2138701849, 0);

    public static final class TestState {
      /** 12x12 */ public static final @NotNull Icon Green2 = load("expui/gutter/runSuccess.svg", "runConfigurations/testState/green2.svg", 109781931, 2);
      /** 12x12 */ public static final @NotNull Icon Red2 = load("expui/gutter/runError.svg", "runConfigurations/testState/red2.svg", 1932966851, 2);
      /** 12x12 */ public static final @NotNull Icon Run = load("expui/gutter/run.svg", "runConfigurations/testState/run.svg", 748579226, 2);
      /** 12x12 */ public static final @NotNull Icon Run_run = load("expui/gutter/rerun.svg", "runConfigurations/testState/run_run.svg", -57574424, 2);
      /** 12x12 */ public static final @NotNull Icon Yellow2 = load("expui/gutter/runFailed.svg", "runConfigurations/testState/yellow2.svg", -1665495764, 2);
    }

    /** 16x16 */ public static final @NotNull Icon TestTerminated = load("expui/run/testTerminated.svg", "runConfigurations/testTerminated.svg", -1944001504, 0);
    /** 16x16 */ public static final @NotNull Icon TestUnknown = load("expui/run/testUnknown.svg", "runConfigurations/testUnknown.svg", 1336916766, 0);
    /** 16x16 */ public static final @NotNull Icon Tomcat = load("runConfigurations/tomcat.svg", -114924250, 0);
    /** 16x16 */ public static final @NotNull Icon ToolbarError = load("expui/run/testError.svg", "runConfigurations/toolbarError.svg", 1417200473, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarFailed = load("expui/run/testFailed.svg", "runConfigurations/toolbarFailed.svg", -888465246, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarPassed = load("expui/run/testPassed.svg", "runConfigurations/toolbarPassed.svg", 580563909, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarPassedIgnored = load("expui/run/testPassedIgnored.svg", "runConfigurations/toolbarPassedIgnored.svg", 1250729951, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarSkipped = load("expui/run/testSkipped.svg", "runConfigurations/toolbarSkipped.svg", 1127324350, 2);
    /** 16x16 */ public static final @NotNull Icon ToolbarTerminated = load("expui/run/testTerminated.svg", "runConfigurations/toolbarTerminated.svg", -765547949, 2);
    /** 16x16 */ public static final @NotNull Icon TrackCoverage = load("expui/runConfigurations/coverage.svg", "runConfigurations/trackCoverage.svg", -1007935976, 2);
    /** 16x16 */ public static final @NotNull Icon Web_app = load("expui/runConfigurations/webApp.svg", "runConfigurations/web_app.svg", 1992356407, 0);
    /** 16x16 */ public static final @NotNull Icon Wsl = load("runConfigurations/wsl.svg", 1026762617, 2);
  }

  public static final class Scope {
    /** 16x16 */ public static final @NotNull Icon ChangedFiles = load("expui/fileTypes/changedFile.svg", "scope/changedFiles.svg", -306418948, 0);
    /** 16x16 */ public static final @NotNull Icon ChangedFilesAll = load("expui/fileTypes/changedFiles.svg", "scope/changedFilesAll.svg", 1640590064, 0);
    /** 16x16 */ public static final @NotNull Icon Problems = load("expui/status/warning.svg", "scope/problems.svg", -750835831, 0);
    /** 16x16 */ public static final @NotNull Icon Production = load("expui/build/taskGroup.svg", "scope/production.svg", 199506138, 0);
    /** 16x16 */ public static final @NotNull Icon Scratches = load("expui/fileTypes/scratches.svg", "scope/scratches.svg", 1463983811, 0);
    /** 16x16 */ public static final @NotNull Icon Tests = load("expui/runConfigurations/junit.svg", "scope/tests.svg", 1447982844, 0);
  }

  public static final class Status {
    /** 16x16 */ public static final @NotNull Icon FailedInProgress = load("expui/status/failedInProgress.svg", "status/failedInProgress.svg", -1537622035, 0);
    /** 16x16 */ public static final @NotNull Icon Success = load("expui/status/success.svg", "status/success.svg", 654373984, 0);
  }

  /** 16x16 */ public static final @NotNull Icon Stub = load("expui/stub.svg", -784127213, 2);

  public static final class Survey {
    /** 20x20 */ public static final @NotNull Icon Dissatisfied = load("expui/survey/dissatisfied.svg", 814615320, 2);
    /** 20x20 */ public static final @NotNull Icon Neutral = load("expui/survey/neutral.svg", -768478795, 2);
    /** 20x20 */ public static final @NotNull Icon Satisfied = load("expui/survey/satisfied.svg", -1133994044, 2);
    /** 20x20 */ public static final @NotNull Icon VeryDissatisfied = load("expui/survey/veryDissatisfied.svg", -614260991, 2);
    /** 20x20 */ public static final @NotNull Icon VerySatisfied = load("expui/survey/verySatisfied.svg", 641677345, 2);
  }

  public static final class Table {
    /** 16x16 */ public static final @NotNull Icon Pagination = load("expui/table/pagination.svg", "table/pagination.svg", -773531095, 2);
  }

  public static final class Toolbar {
    /** 16x16 */ public static final @NotNull Icon AddSlot = load("toolbar/addSlot.svg", -1835020141, 2);
    /** 16x16 */ public static final @NotNull Icon Collapse = load("expui/general/chevronUpLarge.svg", "toolbar/collapse.svg", -855515710, 2);
    /** 16x16 */ public static final @NotNull Icon Expand = load("expui/general/chevronDownLarge.svg", "toolbar/expand.svg", -807850555, 2);
    /** 16x16 */ public static final @NotNull Icon Filterdups = load("expui/actions/filterdups.svg", "toolbar/filterdups.svg", -659728011, 2);
    /** 16x16 */ public static final @NotNull Icon Locale = load("expui/general/language.svg", "toolbar/locale.svg", 908326804, 2);
    /** 16x16 */ public static final @NotNull Icon Pin = load("expui/general/pin.svg", "toolbar/pin.svg", 1681368704, 2);
    /** 16x16 */ public static final @NotNull Icon RemoveSlot = load("expui/general/remove.svg", "toolbar/removeSlot.svg", -315928612, 2);
    /** 16x16 */ public static final @NotNull Icon Unknown = load("expui/toolbar/unknown.svg", "toolbar/unknown.svg", 1954017666, 2);
    /** 16x16 */ public static final @NotNull Icon Xcode = load("toolbar/Xcode.svg", -1022017223, 2);
  }

  public static final class ToolbarDecorator {
    /** 16x16 */ public static final @NotNull Icon AddBlankLine = load("toolbarDecorator/addBlankLine.svg", 1622563551, 2);
    /** 16x16 */ public static final @NotNull Icon AddClass = load("toolbarDecorator/addClass.svg", 955762711, 2);
    /** 16x16 */ public static final @NotNull Icon AddFolder = load("toolbarDecorator/addFolder.svg", 395130952, 2);
    /** 16x16 */ public static final @NotNull Icon AddIcon = load("toolbarDecorator/addIcon.svg", 928060610, 2);
    /** 16x16 */ public static final @NotNull Icon AddJira = load("toolbarDecorator/addJira.svg", -1559078405, 2);
    /** 16x16 */ public static final @NotNull Icon AddLink = load("toolbarDecorator/addLink.svg", 740343788, 2);
    /** 16x16 */ public static final @NotNull Icon AddPattern = load("toolbarDecorator/addPattern.svg", 1133058713, 2);
    /** 16x16 */ public static final @NotNull Icon AddRemoteDatasource = load("toolbarDecorator/addRemoteDatasource.svg", -1532941571, 2);
    /** 16x16 */ public static final @NotNull Icon AddYouTrack = load("toolbarDecorator/addYouTrack.svg", -1383628266, 2);
    /** 16x16 */ public static final @NotNull Icon Export = load("expui/general/export.svg", "toolbarDecorator/export.svg", -983607867, 2);
    /** 16x16 */ public static final @NotNull Icon ExportSmall = load("toolbarDecorator/exportSmall.svg", -953801334, 2);
    /** 16x16 */ public static final @NotNull Icon Import = load("expui/general/import.svg", "toolbarDecorator/import.svg", 1355728855, 2);
  }

  public static final class Toolwindows {
    /** 16x16 */ public static final @NotNull Icon Changes = load("expui/toolwindows/changes.svg", -848826910, 2);
    /** 16x16 */ public static final @NotNull Icon Dependencies = load("expui/toolwindows/dependencies.svg", -2145342262, 2);
    /** 13x13 */ public static final @NotNull Icon Documentation = load("expui/toolwindows/documentation.svg", "toolwindows/documentation.svg", -994176348, 2);
    /** 13x13 */ public static final @NotNull Icon ErrorEvents = load("toolwindows/errorEvents.svg", 544961938, 2);
    /** 13x13 */ public static final @NotNull Icon InfoEvents = load("toolwindows/infoEvents.svg", 2005038383, 2);
    /** 13x13 */ public static final @NotNull Icon Learn = load("expui/toolwindows/learn.svg", "toolwindows/learn.svg", 1964715395, 2);
    /** 16x16 */ public static final @NotNull Icon MeetNewUi = load("expui/toolwindows/meetNewUi.svg", -215928280, 2);
    /** 13x13 */ public static final @NotNull Icon NoEvents = load("toolwindows/noEvents.svg", 1510437398, 2);
    /** 13x13 */ public static final @NotNull Icon Notifications = load("expui/toolwindows/notifications.svg", "toolwindows/notifications.svg", 158984276, 2);
    /** 13x13 */ public static final @NotNull Icon NotificationsNew = load("toolwindows/notificationsNew.svg", -1220587603, 2);
    /** 13x13 */ public static final @NotNull Icon NotificationsNewImportant = load("toolwindows/notificationsNewImportant.svg", 1735290634, 2);
    /** 13x13 */ public static final @NotNull Icon Problems = load("toolwindows/problems.svg", -1934296403, 2);
    /** 13x13 */ public static final @NotNull Icon ProblemsEmpty = load("toolwindows/problemsEmpty.svg", -1481960925, 2);
    /** 16x16 */ public static final @NotNull Icon Repositories = load("expui/toolwindows/repositories.svg", 974555029, 2);
    /** 13x13 */ public static final @NotNull Icon SettingSync = load("expui/toolwindows/settingSync.svg", "toolwindows/settingSync.svg", -1037362170, 2);
    /** 16x16 */ public static final @NotNull Icon Task = load("expui/toolwindows/task.svg", -1024942290, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowAnalyzeDataflow = load("expui/toolwindows/dataflow.svg", "toolwindows/toolWindowAnalyzeDataflow.svg", -1971803045, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowAnt = load("expui/toolwindows/ant.svg", "toolwindows/toolWindowAnt.svg", -835486132, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowAskAI = load("expui/toolwindows/toolWindowAskAI.svg", "toolwindows/toolWindowAskAI.svg", -1185265807, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowBookmarks = load("expui/toolwindows/bookmarks.svg", "toolwindows/toolWindowBookmarks.svg", 1090576904, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowBuild = load("expui/toolwindows/build.svg", "toolwindows/toolWindowBuild.svg", -477872521, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowChanges = load("expui/toolwindows/vcs.svg", "toolwindows/toolWindowChanges.svg", 644395758, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowCommander = load("toolwindows/toolWindowCommander.svg", -572791393, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowCommit = load("expui/toolwindows/commit.svg", "toolwindows/toolWindowCommit.svg", -1809755118, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowComponents = load("expui/toolwindows/toolWindowComponents.svg", "toolwindows/toolWindowComponents.svg", -886250892, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowCoverage = load("expui/toolwindows/coverage.svg", "toolwindows/toolWindowCoverage.svg", -43772594, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowDataView = load("expui/toolwindows/toolWindowDataView.svg", "toolwindows/toolWindowDataView.svg", 929762492, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowDebugger = load("expui/toolwindows/debug.svg", "toolwindows/toolWindowDebugger.svg", 332521029, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowDevMode = load("expui/toolwindows/toolWindowDevMode.svg", "toolwindows/toolWindowDevMode.svg", 1168318923, 2);
    /** 16x16 */ public static final @NotNull Icon ToolWindowDuplicates = load("expui/toolwindows/toolWindowDuplicates.svg", 282855334, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowFind = load("expui/toolwindows/find.svg", "toolwindows/toolWindowFind.svg", -2111567640, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowHierarchy = load("expui/toolwindows/hierarchy.svg", "toolwindows/toolWindowHierarchy.svg", -2047586995, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowInspection = load("expui/toolwindows/toolWindowInspection.svg", "toolwindows/toolWindowInspection.svg", 298386539, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowInternal = load("expui/toolwindows/toolWindowInternal.svg", "toolwindows/toolWindowInternal.svg", -985241158, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowJsonPath = load("expui/toolwindows/toolWindowJsonPath.svg", "toolwindows/toolWindowJsonPath.svg", -156327706, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowMessages = load("expui/toolwindows/messages.svg", "toolwindows/toolWindowMessages.svg", -1474002272, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowModuleDependencies = load("toolwindows/toolWindowModuleDependencies.svg", -1086444002, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowOverflow = load("expui/toolwindows/toolWindowOverflow.svg", "toolwindows/toolWindowOverflow.svg", 2128111837, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowPalette = load("expui/toolwindows/palette.svg", "toolwindows/toolWindowPalette.svg", -1095449744, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProblems = load("expui/toolwindows/problems.svg", "toolwindows/toolWindowProblems.svg", 1795380210, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProblemsEmpty = load("expui/toolwindows/problems.svg", "toolwindows/toolWindowProblemsEmpty.svg", -1113987786, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProfiler = load("expui/toolwindows/profiler.svg", "toolwindows/toolWindowProfiler.svg", 840495627, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProfilerAndroid = load("expui/toolwindows/profilerAndroid.svg", "toolwindows/toolWindowProfilerAndroid.svg", 252204624, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowProject = load("expui/toolwindows/project.svg", "toolwindows/toolWindowProject.svg", 373456992, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowRun = load("expui/toolwindows/run.svg", "toolwindows/toolWindowRun.svg", 562367487, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowRunWithCoverage = load("expui/toolwindows/toolWindowRunWithCoverage.svg", "toolwindows/toolWindowRunWithCoverage.svg", -2005199929, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowServer = load("expui/toolwindows/webServer.svg", "toolwindows/toolWindowServer.svg", 79377911, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowServices = load("expui/toolwindows/services.svg", "toolwindows/toolWindowServices.svg", 116892796, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowStructure = load("expui/toolwindows/structure.svg", "toolwindows/toolWindowStructure.svg", -1465620418, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowTodo = load("expui/toolwindows/todo.svg", "toolwindows/toolWindowTodo.svg", -2027082181, 2);
    /** 13x13 */ public static final @NotNull Icon ToolWindowVariableView = load("expui/toolwindows/toolWindowVariableView.svg", "toolwindows/toolWindowVariableView.svg", 684149723, 2);
    /** 13x13 */ public static final @NotNull Icon WarningEvents = load("toolwindows/warningEvents.svg", 249706562, 2);
    /** 13x13 */ public static final @NotNull Icon WebToolWindow = load("expui/toolwindows/web.svg", "toolwindows/webToolWindow.svg", -1935851554, 2);

    /** @deprecated to be removed without replacement */
    @SuppressWarnings("unused")
    @Deprecated
    @ScheduledForRemoval
    public static final @NotNull Icon ToolWindowFavorites = load("toolwindows/toolWindowFavorites.svg", 0, 0);
  }

  public static final class TransferSettings {
    /** 40x40 */ public static final @NotNull Icon Keymap = load("transferSettings/keymap.svg", 863112917, 0);
    /** 40x40 */ public static final @NotNull Icon PluginsAndFeatures = load("transferSettings/pluginsAndFeatures.svg", 1153695742, 0);
    /** 40x40 */ public static final @NotNull Icon RecentProjects = load("transferSettings/recentProjects.svg", 1477886211, 0);
    /** 20x20 */ public static final @NotNull Icon Resharper = load("transferSettings/resharper.svg", -784648925, 0);
    /** 40x40 */ public static final @NotNull Icon Settings = load("transferSettings/settings.svg", 1520723510, 0);
    /** 40x40 */ public static final @NotNull Icon VS = load("transferSettings/vs.svg", -1461702622, 0);
    /** 40x40 */ public static final @NotNull Icon Vscode = load("transferSettings/vscode.svg", 908743772, 0);
    /** 40x40 */ public static final @NotNull Icon Vsmac = load("transferSettings/vsmac.svg", -492319955, 0);
    /** 40x40 */ public static final @NotNull Icon Xcode = load("transferSettings/xcode.svg", -748587332, 0);
  }

  public static final class Ultimate {
    /** 16x16 */ public static final @NotNull Icon IdeaUltimatePromo = load("ultimate/ideaUltimatePromo.svg", -1332958664, 0);
    /** 16x16 */ public static final @NotNull Icon Lock = load("expui/ultimate/lock.svg", "ultimate/lock.svg", 2079176291, 2);
    /** 16x16 */ public static final @NotNull Icon LockWhite = load("ultimate/lockWhite.svg", -1891265957, 0);
    /** 16x16 */ public static final @NotNull Icon PycharmLock = load("ultimate/pycharmLock.svg", 1729774235, 2);
    /** 16x16 */ public static final @NotNull Icon PycharmPromo = load("ultimate/pycharmPromo.svg", 663371893, 0);
  }

  public static final class Vcs {
    /** 16x16 */ public static final @NotNull Icon Abort = load("expui/vcs/abort.svg", 655634747, 10);
    /** 16x16 */ public static final @NotNull Icon Arrow_left = load("expui/vcs/arrowLeft.svg", "vcs/arrow_left.svg", 305884335, 2);
    /** 16x16 */ public static final @NotNull Icon Arrow_right = load("expui/vcs/arrowRight.svg", "vcs/arrow_right.svg", 1390379041, 2);
    /** 16x16 */ public static final @NotNull Icon Author = load("expui/general/user.svg", "vcs/author.svg", 313414126, 0);
    /** 16x16 */ public static final @NotNull Icon Branch = load("expui/general/vcs.svg", "vcs/branch.svg", -1419137718, 2);
    /** 16x16 */ public static final @NotNull Icon BranchNode = load("expui/general/vcs.svg", "vcs/branchNode.svg", -1691291258, 0);
    /** 16x16 */ public static final @NotNull Icon Changelist = load("expui/vcs/changelist.svg", "vcs/changelist.svg", -676612903, 2);
    /** 16x16 */ public static final @NotNull Icon Clone = load("expui/vcs/update.svg", "vcs/clone.svg", 1374345994, 2);
    /** 16x16 */ public static final @NotNull Icon CommitNode = load("expui/vcs/commit.svg", "vcs/commitNode.svg", 334394479, 0);
    /** 16x16 */ public static final @NotNull Icon Equal = load("vcs/equal.svg", -1196383288, 2);
    /** 16x16 */ public static final @NotNull Icon Fetch = load("expui/vcs/fetch.svg", "vcs/fetch.svg", -1252692037, 2);
    /** 20x20 */ public static final @NotNull Icon Fetch_20x20 = load("expui/vcs/fetch@20x20.svg", -1632890854, 2);
    /** 16x16 */ public static final @NotNull Icon Folders = load("expui/nodes/copyOfFolder.svg", "vcs/folders.svg", 1810604817, 2);
    /** 24x24 */ public static final @NotNull Icon FromVCSDialog = load("vcs/fromVCSDialog.svg", -500633666, 2);
    /** 16x16 */ public static final @NotNull Icon History = load("expui/general/history.svg", "vcs/history.svg", 995622878, 2);
    /** 16x16 */ public static final @NotNull Icon HistoryInline = load("expui/general/history.svg", "vcs/historyInline.svg", 317383723, 0);
    /** 16x16 */ public static final @NotNull Icon HistoryInlineHovered = load("expui/general/history.svg", "vcs/historyInlineHovered.svg", -1552579046, 0);
    /** 16x16 */ public static final @NotNull Icon Ignore_file = load("expui/fileTypes/ignored.svg", "vcs/ignore_file.svg", -1839679605, 2);
    /** 16x16 */ public static final @NotNull Icon Merge = load("expui/vcs/merge.svg", "vcs/merge.svg", -1946954229, 2);
    /** 16x16 */ public static final @NotNull Icon Not_equal = load("vcs/not_equal.svg", -1511694081, 2);
    /** 16x16 */ public static final @NotNull Icon Patch = load("expui/vcs/patch.svg", "vcs/patch.svg", 829304727, 2);
    /** 16x16 */ public static final @NotNull Icon Patch_applied = load("vcs/patch_applied.svg", -2166485, 2);
    /** 16x16 */ public static final @NotNull Icon Patch_file = load("expui/fileTypes/patch.svg", "vcs/patch_file.svg", -1991117101, 0);
    /** 16x16 */ public static final @NotNull Icon Push = load("expui/vcs/push.svg", "vcs/push.svg", 1768616645, 2);
    /** 20x20 */ public static final @NotNull Icon Push_20x20 = load("expui/vcs/push@20x20.svg", 1083651890, 2);
    /** 16x16 */ public static final @NotNull Icon Remove = load("expui/vcs/remove.svg", "vcs/remove.svg", -930385649, 2);
    /** 16x16 */ public static final @NotNull Icon ShelveSilent = load("expui/vcs/shelve.svg", "vcs/shelveSilent.svg", -370626475, 2);
    /** 16x16 */ public static final @NotNull Icon ShowUnversionedFiles = load("vcs/ShowUnversionedFiles.svg", -1565476650, 2);
    /** 16x16 */ public static final @NotNull Icon Unshelve = load("expui/vcs/unshelve.svg", "vcs/Unshelve.svg", -81545320, 2);
    /** 16x16 */ public static final @NotNull Icon UnshelveSilent = load("expui/vcs/unshelve.svg", "vcs/unshelveSilent.svg", -20176584, 2);
    /** 20x20 */ public static final @NotNull Icon Update_20x20 = load("expui/vcs/update@20x20.svg", 518676462, 2);

    public static final class Vendors {
      /** 16x16 */ public static final @NotNull Icon Github = load("vcs/vendors/github.svg", 588882631, 2);
    }
  }

  public static final class Webreferences {
    /** 16x16 */ public static final @NotNull Icon MessageQueue = load("expui/webReferences/messageQueue.svg", "webreferences/messageQueue.svg", 697724752, 0);
    /** 16x16 */ public static final @NotNull Icon Openapi = load("expui/webReferences/openApi.svg", "webreferences/openapi.svg", -1218656258, 2);
    /** 16x16 */ public static final @NotNull Icon Server = load("expui/webReferences/server.svg", "webreferences/server.svg", -1538667407, 2);
    /** 16x16 */ public static final @NotNull Icon WebSocket = load("webreferences/webSocket.svg", -144898297, 0);
  }

  public static final class Welcome {
    /** 24x24 */ public static final @NotNull Icon CreateNewProjectTab = load("expui/welcome/createNewProjectTab.svg", "welcome/createNewProjectTab.svg", 518832698, 2);
    /** 24x24 */ public static final @NotNull Icon CreateNewProjectTabSelected = load("welcome/createNewProjectTabSelected.svg", 2094921405, 0);
    /** 24x24 */ public static final @NotNull Icon FromVCSTab = load("expui/welcome/fromVCSTab.svg", "welcome/fromVCSTab.svg", -2033924706, 2);
    /** 24x24 */ public static final @NotNull Icon FromVCSTabSelected = load("welcome/fromVCSTabSelected.svg", 821127730, 0);

    public static final class LearnTab {
      /** 16x16 */ public static final @NotNull Icon JetBrainsAcademy = load("welcome/learnTab/jetBrainsAcademy.svg", 1579449473, 0);
    }

    /** 24x24 */ public static final @NotNull Icon Open = load("expui/welcome/open.svg", "welcome/open.svg", -1032470701, 2);
    /** 24x24 */ public static final @NotNull Icon OpenSelected = load("welcome/openSelected.svg", -720655450, 0);

    public static final class RecentProjects {
      /** 16x16 */ public static final @NotNull Icon RemoteProject = load("welcome/recentProjects/remoteProject.svg", 1948055625, 2);
      /** 10x10 */ public static final @NotNull Icon RemoveHover = load("welcome/recentProjects/remove-hover.svg", -1249716707, 2);
      /** 10x10 */ public static final @NotNull Icon Remove = load("welcome/recentProjects/remove.svg", -1427151265, 2);
      /** 10x10 */ public static final @NotNull Icon RemoveDisabledHover = load("welcome/recentProjects/removeDisabled-hover.svg", -1439591680, 2);
      /** 10x10 */ public static final @NotNull Icon RemoveDisabled = load("welcome/recentProjects/removeDisabled.svg", -760582353, 2);
    }
  }

  public static final class Windows {
    /** 16x16 */ public static final @NotNull Icon Close = load("expui/windows/close.svg", 167822176, 2);
    /** 16x16 */ public static final @NotNull Icon CloseActive = load("expui/windows/closeActive.svg", "windows/closeActive.svg", -932066645, 2);
    /** 16x16 */ public static final @NotNull Icon CloseHover = load("windows/closeHover.svg", 137236279, 0);
    /** 16x16 */ public static final @NotNull Icon CloseInactive = load("expui/windows/closeInactive.svg", "windows/closeInactive.svg", -10007288, 2);
    /** 16x16 */ public static final @NotNull Icon CloseSmall = load("expui/windows/closeSmall.svg", "windows/closeSmall.svg", 2039555918, 2);
    /** 16x16 */ public static final @NotNull Icon Collapse = load("expui/windows/collapse.svg", -1002636336, 2);
    /** 16x16 */ public static final @NotNull Icon Help = load("expui/windows/help.svg", "windows/help.svg", -339937393, 2);
    /** 16x16 */ public static final @NotNull Icon HelpButton = load("windows/helpButton.svg", 1283295210, 2);
    /** 16x16 */ public static final @NotNull Icon HelpButtonInactive = load("windows/helpButtonInactive.svg", -631513058, 2);
    /** 16x16 */ public static final @NotNull Icon HelpInactive = load("expui/windows/helpInactive.svg", "windows/helpInactive.svg", -1162931473, 2);
    /** 16x16 */ public static final @NotNull Icon Maximize = load("expui/windows/maximize.svg", "windows/maximize.svg", 794554909, 2);
    /** 16x16 */ public static final @NotNull Icon MaximizeInactive = load("expui/windows/maximizeInactive.svg", "windows/maximizeInactive.svg", 520981781, 2);
    /** 16x16 */ public static final @NotNull Icon MaximizeSmall = load("expui/windows/maximizeSmall.svg", "windows/maximizeSmall.svg", -233791604, 2);
    /** 16x16 */ public static final @NotNull Icon Minimize = load("expui/windows/minimize.svg", "windows/minimize.svg", -1640245376, 2);
    /** 16x16 */ public static final @NotNull Icon MinimizeInactive = load("expui/windows/minimizeInactive.svg", "windows/minimizeInactive.svg", -319650745, 2);
    /** 16x16 */ public static final @NotNull Icon MinimizeSmall = load("expui/windows/minimizeSmall.svg", "windows/minimizeSmall.svg", -168323289, 2);

    public static final class Mouse {
      /** 16x16 */ public static final @NotNull Icon CursorPointingHand = load("expui/windows/mouse/cursorPointingHand.svg", 1179133742, 0);
      /** 16x16 */ public static final @NotNull Icon CursorText = load("expui/windows/mouse/cursorText.svg", 679255143, 0);
    }

    /** 16x16 */ public static final @NotNull Icon Restore = load("expui/windows/restore.svg", "windows/restore.svg", 11845937, 2);
    /** 16x16 */ public static final @NotNull Icon RestoreInactive = load("expui/windows/restoreInactive.svg", "windows/restoreInactive.svg", 191870325, 2);
    /** 16x16 */ public static final @NotNull Icon RestoreSmall = load("expui/windows/restoreSmall.svg", "windows/restoreSmall.svg", 1984923907, 2);
  }

  public static final class Xml {
    public static final class Browsers {
      /** 16x16 */ public static final @NotNull Icon Canary = load("xml/browsers/canary.svg", 1155643146, 0);
      /** 16x16 */ public static final @NotNull Icon Chrome = load("xml/browsers/chrome.svg", -1254806517, 0);
      /** 16x16 */ public static final @NotNull Icon Chromium = load("xml/browsers/chromium.svg", -1696650918, 0);
      /** 16x16 */ public static final @NotNull Icon Edge = load("xml/browsers/edge.svg", 1590404949, 0);
      /** 16x16 */ public static final @NotNull Icon Explorer = load("xml/browsers/explorer.svg", -737513654, 0);
      /** 16x16 */ public static final @NotNull Icon Firefox = load("xml/browsers/firefox.svg", -1170112055, 0);
      /** 16x16 */ public static final @NotNull Icon FirefoxDeveloper = load("xml/browsers/firefoxDeveloper.svg", 11858477, 0);
      /** 16x16 */ public static final @NotNull Icon Nwjs = load("xml/browsers/nwjs.svg", -953920925, 0);
      /** 16x16 */ public static final @NotNull Icon Opera = load("xml/browsers/opera.svg", -120244371, 0);
      /** 16x16 */ public static final @NotNull Icon Safari = load("xml/browsers/safari.svg", -1238351338, 0);
      /** 16x16 */ public static final @NotNull Icon Yandex = load("xml/browsers/yandex.svg", 1087269231, 0);
    }

    /** 16x16 */ public static final @NotNull Icon Css_class = load("expui/xml/cssClass.svg", "xml/css_class.svg", -1719682561, 0);
    /** 16x16 */ public static final @NotNull Icon Html5 = load("xml/html5.svg", -770233754, 0);
    /** 16x16 */ public static final @NotNull Icon Html_id = load("expui/xml/id.svg", "xml/html_id.svg", 86602159, 0);
  }

  /** @deprecated use ProductIcons.getInstance().getProductIcon() instead */
  @SuppressWarnings("unused")
  @Deprecated
  public static final @NotNull Icon Icon = load("icon.png", 0, 0);
}
