/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import org.jetbrains.annotations.NotNull;

public abstract class PositionTracker<T>
implements Disposable,
HierarchyBoundsListener,
HierarchyListener,
ComponentListener {
    private final Component myComponent;
    private Client<T> myClient;

    public PositionTracker(Component component) {
        this.myComponent = component;
    }

    public final void init(Client<T> client) {
        this.myClient = client;
        Disposer.register(client, (Disposable)this);
        this.myComponent.addHierarchyBoundsListener(this);
        this.myComponent.addHierarchyListener(this);
        this.myComponent.addComponentListener(this);
    }

    public final Component getComponent() {
        return this.myComponent;
    }

    @Override
    public final void ancestorMoved(HierarchyEvent e) {
        this.revalidate();
    }

    @Override
    public final void ancestorResized(HierarchyEvent e) {
        this.revalidate();
    }

    @Override
    public final void hierarchyChanged(HierarchyEvent e) {
        this.revalidate();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.revalidate();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.revalidate();
    }

    protected final void revalidate() {
        this.myClient.revalidate(this);
    }

    public abstract RelativePoint recalculateLocation(@NotNull T var1);

    public final void dispose() {
        this.myComponent.removeHierarchyBoundsListener(this);
        this.myComponent.removeHierarchyListener(this);
        this.myComponent.removeComponentListener(this);
    }

    public static interface Client<T>
    extends Disposable {
        public void revalidate();

        public void revalidate(@NotNull PositionTracker<T> var1);
    }

    public static final class Static<T>
    extends PositionTracker<T> {
        private final RelativePoint myPoint;

        public Static(RelativePoint point) {
            super(point.getComponent());
            this.myPoint = point;
        }

        @Override
        public RelativePoint recalculateLocation(@NotNull Object object) {
            if (object == null) {
                Static.$$$reportNull$$$0(0);
            }
            return this.myPoint;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/util/ui/PositionTracker$Static", "recalculateLocation"));
        }
    }
}

