/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class WideSelectionTreeUI
extends BasicTreeUI {
    @NonNls
    public static final String SOURCE_LIST_CLIENT_PROPERTY = "mac.ui.source.list";
    @NonNls
    public static final String STRIPED_CLIENT_PROPERTY = "mac.ui.striped";
    private static final Border LIST_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListBackgroundPainter");
    private static final Border LIST_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListSelectionBackgroundPainter");
    private static final Border LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER = UIManager.getBorder("List.sourceListFocusedSelectionBackgroundPainter");
    private static final Logger LOG = Logger.getInstance(WideSelectionTreeUI.class);
    private static final Set<String> LOGGED_RENDERERS = ConcurrentHashMap.newKeySet();
    @NotNull
    private final Condition<? super Integer> myWideSelectionCondition;
    private final boolean myWideSelection;
    private boolean myOldRepaintAllRowValue;
    private static final boolean mySkinny = false;
    private static final TreeUIAction EXPAND_OR_SELECT_NEXT = new TreeUIAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JTree tree;
            TreePath path;
            Object source = event.getSource();
            if (source instanceof JTree && (path = (tree = (JTree)source).getLeadSelectionPath()) != null) {
                if (tree.isExpanded(path) || tree.getModel().isLeaf(path.getLastPathComponent())) {
                    int row = tree.getRowForPath(path);
                    TreePath treePath = path = row < 0 ? null : tree.getPathForRow(row + 1);
                    if (path != null) {
                        tree.setSelectionPath(path);
                        tree.scrollPathToVisible(path);
                    }
                } else {
                    tree.expandPath(path);
                }
            }
        }
    };
    private static final TreeUIAction COLLAPSE_OR_SELECT_PREVIOUS = new TreeUIAction(){

        @Override
        public void actionPerformed(ActionEvent event) {
            JTree tree;
            TreePath path;
            Object source = event.getSource();
            if (source instanceof JTree && (path = (tree = (JTree)source).getLeadSelectionPath()) != null) {
                if (tree.isExpanded(path)) {
                    tree.collapsePath(path);
                } else {
                    TreePath parent = path.getParentPath();
                    if (parent != null) {
                        if (!tree.isRootVisible() && null == parent.getParentPath()) {
                            int row = tree.getRowForPath(path);
                            TreePath treePath = parent = row < 1 ? null : tree.getPathForRow(row - 1);
                        }
                        if (parent != null) {
                            tree.setSelectionPath(parent);
                            tree.scrollPathToVisible(parent);
                        }
                    }
                }
            }
        }
    };

    public WideSelectionTreeUI() {
        this(true, (Condition<? super Integer>)Conditions.alwaysTrue());
    }

    public WideSelectionTreeUI(boolean wideSelection, @NotNull Condition<? super Integer> wideSelectionCondition) {
        if (wideSelectionCondition == null) {
            WideSelectionTreeUI.$$$reportNull$$$0(0);
        }
        this.myWideSelection = wideSelection;
        this.myWideSelectionCondition = wideSelectionCondition;
    }

    @Override
    public int getRightChildIndent() {
        return this.isCustomIndent() ? this.getCustomIndent() : super.getRightChildIndent();
    }

    public boolean isCustomIndent() {
        return this.getCustomIndent() > 0;
    }

    protected int getCustomIndent() {
        return JBUIScale.scale(Registry.intValue((String)"ide.ui.tree.indent"));
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            @Override
            public void mouseDragged(MouseEvent event) {
                JTree tree = (JTree)event.getSource();
                Object property = tree.getClientProperty("DnD Source");
                if (property == null) {
                    super.mouseDragged(event);
                }
            }

            @Override
            @NotNull
            protected MouseEvent convert(@NotNull MouseEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!event.isConsumed() && SwingUtilities.isLeftMouseButton(event)) {
                    Rectangle bounds;
                    TreePath path;
                    int x = event.getX();
                    int y = event.getY();
                    JTree tree = (JTree)event.getSource();
                    if (tree.isEnabled() && (path = WideSelectionTreeUI.this.getClosestPathForLocation(tree, x, y)) != null && !WideSelectionTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds = WideSelectionTreeUI.this.getPathBounds(tree, path)) != null && bounds.y <= y && y <= bounds.y + bounds.height && (x = Math.max(bounds.x, Math.min(x, bounds.x + bounds.width - 1))) != event.getX()) {
                        event = 3.convert(event, tree, x, y);
                    }
                }
                MouseEvent mouseEvent = event;
                if (mouseEvent == null) {
                    3.$$$reportNull$$$0(1);
                }
                return mouseEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ui/tree/WideSelectionTreeUI$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ui/tree/WideSelectionTreeUI$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convert";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convert";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Override
    protected void completeUIInstall() {
        super.completeUIInstall();
        this.myOldRepaintAllRowValue = UIManager.getBoolean("Tree.repaintWholeRow");
        UIManager.put("Tree.repaintWholeRow", true);
        this.tree.setShowsRootHandles(true);
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        UIManager.put("Tree.repaintWholeRow", this.myOldRepaintAllRowValue);
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap map = this.tree.getActionMap();
        map.put("selectChild", EXPAND_OR_SELECT_NEXT);
        map.put("selectParent", COLLAPSE_OR_SELECT_PREVIOUS);
    }

    @Override
    protected int getRowX(int row, int depth) {
        if (this.isCustomIndent()) {
            int off = this.tree.isRootVisible() ? 8 : 0;
            return 8 * depth + 8 + off;
        }
        return super.getRowX(row, depth);
    }

    @Override
    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.shouldPaintLines()) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private boolean shouldPaintLines() {
        if (UIUtil.isUnderAquaBasedLookAndFeel() || StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF()) {
            return false;
        }
        return !"None".equals(this.tree.getClientProperty("JTree.lineStyle"));
    }

    @Override
    protected boolean isToggleSelectionEvent(MouseEvent e) {
        return UIUtil.isToggleListSelectionEvent(e);
    }

    @Override
    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.shouldPaintLines()) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    @Override
    protected void paintVerticalLine(Graphics g, JComponent c, int x, int top, int bottom) {
        if (this.shouldPaintLines()) {
            super.paintVerticalLine(g, c, x, top, bottom);
        }
    }

    public boolean isWideSelection() {
        return this.myWideSelection;
    }

    public static boolean isWideSelection(@NotNull JTree tree) {
        TreeUI ui;
        if (tree == null) {
            WideSelectionTreeUI.$$$reportNull$$$0(1);
        }
        return (ui = tree.getUI()) instanceof WideSelectionTreeUI && ((WideSelectionTreeUI)ui).isWideSelection() || ui != null && ui.getClass().getName().equals("com.intellij.ui.tree.ui.DefaultTreeUI");
    }

    @Override
    protected void paintRow(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        int xOffset;
        int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
        int n = xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
        if (path != null && this.myWideSelection) {
            boolean selected = this.tree.isPathSelected(path);
            Graphics2D rowGraphics = (Graphics2D)g.create();
            rowGraphics.setClip(clipBounds);
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            Color background = RenderingUtil.getBackground(this.tree);
            if (row % 2 == 0 && Boolean.TRUE.equals(this.tree.getClientProperty(STRIPED_CLIENT_PROPERTY))) {
                background = UIUtil.getDecoratedRowColor();
            }
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                if (selected) {
                    if (this.tree.hasFocus()) {
                        LIST_FOCUSED_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    } else {
                        LIST_SELECTION_BACKGROUND_PAINTER.paintBorder(this.tree, rowGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                    }
                } else if (this.myWideSelectionCondition.value((Object)row)) {
                    rowGraphics.setColor(background);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            } else if (selected && (UIUtil.isUnderAquaBasedLookAndFeel() || StartupUiUtil.isUnderDarcula() || UIUtil.isUnderIntelliJLaF())) {
                Color bg = RenderingUtil.getSelectionBackground(this.tree);
                if (this.myWideSelectionCondition.value((Object)row)) {
                    rowGraphics.setColor(bg);
                    rowGraphics.fillRect(xOffset, bounds.y, containerWidth, bounds.height);
                }
            }
            if (this.shouldPaintExpandControl(path, row, isExpanded, hasBeenExpanded, isLeaf)) {
                this.paintExpandControl(rowGraphics, bounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            }
            super.paintRow(rowGraphics, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
            rowGraphics.dispose();
        } else {
            super.paintRow(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (this.myWideSelection && !UIUtil.isUnderAquaBasedLookAndFeel() && !StartupUiUtil.isUnderDarcula() && !UIUtil.isUnderIntelliJLaF()) {
            this.paintSelectedRows(g, (JTree)c);
        }
        if (this.myWideSelection) {
            int containerWidth = this.tree.getParent() instanceof JViewport ? this.tree.getParent().getWidth() : this.tree.getWidth();
            int xOffset = this.tree.getParent() instanceof JViewport ? ((JViewport)this.tree.getParent()).getViewPosition().x : 0;
            Rectangle bounds = g.getClipBounds();
            Object sourceList = this.tree.getClientProperty(SOURCE_LIST_CLIENT_PROPERTY);
            if (sourceList != null && ((Boolean)sourceList).booleanValue()) {
                Graphics2D backgroundGraphics = (Graphics2D)g.create();
                backgroundGraphics.setClip(xOffset, bounds.y, containerWidth, bounds.height);
                LIST_BACKGROUND_PAINTER.paintBorder(this.tree, backgroundGraphics, xOffset, bounds.y, containerWidth, bounds.height);
                backgroundGraphics.dispose();
            }
        }
        super.paint(g, c);
    }

    protected void paintSelectedRows(Graphics g, JTree tr) {
        Rectangle rect = tr.getVisibleRect();
        int firstVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y);
        int lastVisibleRow = tr.getClosestRowForLocation(rect.x, rect.y + rect.height);
        for (int row = firstVisibleRow; row <= lastVisibleRow; ++row) {
            if (!tr.getSelectionModel().isRowSelected(row) || !this.myWideSelectionCondition.value((Object)row)) continue;
            Rectangle bounds = tr.getRowBounds(row);
            g.setColor(RenderingUtil.getSelectionBackground(this.tree));
            g.fillRect(0, bounds.y, tr.getWidth(), bounds.height);
        }
    }

    @Override
    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane(){

            @Override
            public void paintComponent(Graphics g, Component c, Container p, int x, int y, int w, int h, boolean shouldValidate) {
                TreeCellRenderer renderer = WideSelectionTreeUI.this.currentCellRenderer;
                if (c != null && renderer != null && LOG.isDebugEnabled()) {
                    String name;
                    Class<?> type;
                    Method method = ReflectionUtil.getMethod(c.getClass(), (String)"validate", (Class[])new Class[0]);
                    Class<?> clazz = type = method == null ? null : method.getDeclaringClass();
                    if ((Component.class.equals(type) || Container.class.equals(type)) && LOGGED_RENDERERS.add(name = renderer.getClass().getName())) {
                        LOG.debug("suspicious renderer: " + name);
                    }
                }
                if (c instanceof JComponent && WideSelectionTreeUI.this.myWideSelection && c.isOpaque()) {
                    ((JComponent)c).setOpaque(false);
                }
                super.paintComponent(g, c, p, x, y, w, h, shouldValidate);
            }
        };
    }

    @Override
    protected void paintExpandControl(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        boolean isPathSelected = this.tree.getSelectionModel().isPathSelected(path);
        if (!this.isLeaf(row)) {
            this.setExpandedIcon(UIUtil.getTreeNodeIcon(true, isPathSelected, this.tree.hasFocus()));
            this.setCollapsedIcon(UIUtil.getTreeNodeIcon(false, isPathSelected, this.tree.hasFocus()));
        }
        super.paintExpandControl(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
    }

    public void invalidateNodeSizes() {
        this.treeState.invalidateSizes();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wideSelectionCondition";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/ui/tree/WideSelectionTreeUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isWideSelection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class TreeUIAction
    extends AbstractAction
    implements UIResource {
        private TreeUIAction() {
        }
    }
}

