/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.svg;

import com.github.weisj.jsvg.attributes.AttributeParser;
import com.github.weisj.jsvg.attributes.paint.DefaultPaintParser;
import com.github.weisj.jsvg.attributes.paint.PaintParser;
import com.github.weisj.jsvg.nodes.SVG;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.Style;
import com.github.weisj.jsvg.parser.AttributeNode;
import com.github.weisj.jsvg.parser.LoadHelper;
import com.github.weisj.jsvg.parser.NodeMap;
import com.github.weisj.jsvg.parser.ParsedElement;
import com.github.weisj.jsvg.parser.UIFuture;
import com.github.weisj.jsvg.parser.ValueUIFuture;
import com.github.weisj.jsvg.parser.css.CssParser;
import com.github.weisj.jsvg.parser.css.StyleSheet;
import com.github.weisj.jsvg.parser.css.impl.SimpleCssParser;
import com.github.weisj.jsvg.util.ResourceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0007\u001a:\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2(\b\u0002\u0010\r\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u000eH\u0007\u001a8\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\f2&\u0010\r\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u000eH\u0002\u001ap\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001f0\b2&\u0010\r\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u000e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002\u001a\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0010\u001a\u00020\fH\u0002\u001aD\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010\u0010\u001a\u00020*2&\u0010\r\u001a\"\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007j\u0004\u0018\u0001`\u000eH\u0002\u001a\u001a\u0010+\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\t2\u0006\u0010-\u001a\u00020\tH\u0002\"\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u008f\u0001\u0010\u0017\u001a\u0082\u0001\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\t0\t\u0012(\u0012&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u001a0\u001a \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u00190\u0019 \u0018*?\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\t0\t\u0012(\u0012&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u001a0\u001a \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u00190\u00190\u001c\u00a2\u0006\u0002\b\u001b0\b\u00a2\u0006\u0002\b\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000*:\u0010\u0006\"\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u00072\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\n0\u0007\u00a8\u0006."}, d2={"createJSvgDocument", "Lcom/github/weisj/jsvg/nodes/SVG;", "inputStream", "Ljava/io/InputStream;", "data", "", "AttributeMutator", "Lkotlin/Function1;", "", "", "", "xmlStreamReader", "Lorg/codehaus/stax2/XMLStreamReader2;", "attributeMutator", "Lcom/intellij/ui/svg/AttributeMutator;", "buildDocument", "reader", "jsvgLoadHelper", "Lcom/github/weisj/jsvg/parser/LoadHelper;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "NODE_CONSTRUCTOR_MAP", "kotlin.jvm.PlatformType", "Ljava/util/function/Supplier;", "Lcom/github/weisj/jsvg/nodes/SVGNode;", "Lorg/jetbrains/annotations/NotNull;", "", "processElementFragment", "root", "Lcom/github/weisj/jsvg/parser/ParsedElement;", "namedElements", "styleSheets", "", "Lcom/github/weisj/jsvg/parser/css/StyleSheet;", "styleElements", "", "Lcom/github/weisj/jsvg/nodes/Style;", "getChars", "", "readAttributes", "Ljavax/xml/stream/XMLStreamReader;", "getQualifiedName", "prefix", "localName", "intellij.platform.util.ui"})
public final class JSvgDocumentFactoryKt {
    @NotNull
    private static final LoadHelper jsvgLoadHelper = new LoadHelper(new AttributeParser((PaintParser)new DefaultPaintParser()), JSvgDocumentFactoryKt::jsvgLoadHelper$lambda$0);
    @NotNull
    private static final Map<String, Supplier<SVGNode>> NODE_CONSTRUCTOR_MAP;

    @ApiStatus.Internal
    @NotNull
    public static final SVG createJSvgDocument(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return JSvgDocumentFactoryKt.createJSvgDocument$default(StaxFactory.createXmlStreamReader$default((InputStream)inputStream, null, (int)2, null), null, 2, null);
    }

    @ApiStatus.Internal
    @NotNull
    public static final SVG createJSvgDocument(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return JSvgDocumentFactoryKt.createJSvgDocument$default(StaxFactory.createXmlStreamReader((byte[])data), null, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    @NotNull
    public static final SVG createJSvgDocument(@NotNull XMLStreamReader2 xmlStreamReader, @Nullable Function1<? super Map<String, String>, Unit> attributeMutator) {
        Intrinsics.checkNotNullParameter((Object)xmlStreamReader, (String)"xmlStreamReader");
        try {
            SVG sVG = JSvgDocumentFactoryKt.buildDocument(xmlStreamReader, attributeMutator);
            return sVG;
        }
        finally {
            xmlStreamReader.closeCompletely();
        }
    }

    public static /* synthetic */ SVG createJSvgDocument$default(XMLStreamReader2 xMLStreamReader2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return JSvgDocumentFactoryKt.createJSvgDocument(xMLStreamReader2, (Function1<? super Map<String, String>, Unit>)function1);
    }

    private static final SVG buildDocument(XMLStreamReader2 reader, Function1<? super Map<String, String>, Unit> attributeMutator) {
        int state = reader.getEventType();
        if (7 != state) {
            throw new IOException("Incorrect state: " + state);
        }
        ParsedElement root = null;
        List styleElements = new ArrayList();
        List styleSheets = new ArrayList();
        while (state != 8) {
            switch (state) {
                case 7: {
                    boolean bl;
                    boolean bl2 = bl = root == null;
                    if (!_Assertions.ENABLED || bl) break;
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    String localName = reader.getLocalName();
                    if (!Intrinsics.areEqual((Object)localName, (Object)"svg")) {
                        throw new IOException("Root element does not match that requested:\nRequested: svg\nFound: " + localName);
                    }
                    HashMap namedElements = new HashMap();
                    Map<String, String> attributes = JSvgDocumentFactoryKt.readAttributes((XMLStreamReader)reader, null);
                    root = new ParsedElement(attributes.get("id"), new AttributeNode(JSvgDocumentFactoryKt.getQualifiedName(reader.getPrefix(), localName), attributes, null, (Map)namedElements, styleSheets, jsvgLoadHelper), (SVGNode)new SVG());
                    JSvgDocumentFactoryKt.processElementFragment(reader, root, namedElements, attributeMutator, styleSheets, styleElements);
                    break;
                }
                case 4: {
                    String badContent = reader.getText();
                    if (reader.isWhiteSpace()) break;
                    throw new IOException("Unexpected XMLStream event at Document level: CHARACTERS (" + badContent + ")");
                }
                default: {
                    throw new IOException("Unexpected XMLStream event at Document level:" + state);
                }
            }
            if (!reader.hasNext()) {
                throw new IOException("Unexpected end-of-XMLStreamReader");
            }
            state = reader.next();
        }
        if (!styleElements.isEmpty()) {
            SimpleCssParser cssParser = new SimpleCssParser();
            for (Style styleElement : styleElements) {
                styleElement.parseStyleSheet((CssParser)cssParser);
                StyleSheet styleSheet = styleElement.styleSheet();
                Intrinsics.checkNotNullExpressionValue((Object)styleSheet, (String)"styleSheet(...)");
                styleSheets.add(styleSheet);
            }
        }
        ParsedElement parsedElement = root;
        Intrinsics.checkNotNull(parsedElement);
        parsedElement.build();
        SVGNode sVGNode = root.node();
        Intrinsics.checkNotNull((Object)sVGNode, (String)"null cannot be cast to non-null type com.github.weisj.jsvg.nodes.SVG");
        return (SVG)sVGNode;
    }

    private static final Logger getLOG() {
        Logger logger = Logger.getInstance(NodeMap.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final void processElementFragment(XMLStreamReader2 reader, ParsedElement root, Map<String, ParsedElement> namedElements, Function1<? super Map<String, String>, Unit> attributeMutator, List<? extends StyleSheet> styleSheets, List<Style> styleElements) {
        ArrayList<ParsedElement> queue = new ArrayList<ParsedElement>();
        queue.add(root);
        block7: while (!((Collection)queue).isEmpty() && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    String localName = reader.getLocalName();
                    Supplier<SVGNode> nodeSupplier = NODE_CONSTRUCTOR_MAP.get(localName);
                    if (nodeSupplier == null) {
                        reader.skipElement();
                        JSvgDocumentFactoryKt.getLOG().warn("unsupported " + localName);
                        continue block7;
                    }
                    SVGNode svgNode = nodeSupplier.get();
                    if (svgNode instanceof Style) {
                        styleElements.add((Style)svgNode);
                    }
                    ParsedElement parent = (ParsedElement)CollectionsKt.last((List)queue);
                    Map<String, String> attributes = JSvgDocumentFactoryKt.readAttributes((XMLStreamReader)reader, attributeMutator);
                    String string = reader.getPrefix();
                    Intrinsics.checkNotNull((Object)localName);
                    ParsedElement parsedElement = new ParsedElement(attributes.get("id"), new AttributeNode(JSvgDocumentFactoryKt.getQualifiedName(string, localName), attributes, parent.attributeNode(), namedElements, styleSheets, jsvgLoadHelper), svgNode);
                    parent.addChild(parsedElement);
                    String id = parsedElement.id();
                    if (id != null) {
                        namedElements.putIfAbsent(id, parsedElement);
                    }
                    queue.add(parsedElement);
                    continue block7;
                }
                case 2: {
                    Object e = queue.removeLast();
                    Intrinsics.checkNotNull(e);
                    continue block7;
                }
                case 12: {
                    ((ParsedElement)CollectionsKt.last((List)queue)).node().addContent(JSvgDocumentFactoryKt.getChars(reader));
                    continue block7;
                }
                case 4: 
                case 6: {
                    if (reader.isWhiteSpace()) continue block7;
                    ((ParsedElement)CollectionsKt.last((List)queue)).node().addContent(JSvgDocumentFactoryKt.getChars(reader));
                    continue block7;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block7;
                }
            }
            throw new IOException("Unexpected XMLStream event: " + reader.getEventType());
        }
    }

    private static final char[] getChars(XMLStreamReader2 reader) {
        int fromIndex = reader.getTextStart();
        char[] cArray = reader.getTextCharacters();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getTextCharacters(...)");
        char[] cArray2 = cArray;
        int n = fromIndex + reader.getTextLength();
        return ArraysKt.copyOfRange((char[])cArray2, (int)fromIndex, (int)n);
    }

    private static final Map<String, String> readAttributes(XMLStreamReader reader, Function1<? super Map<String, String>, Unit> attributeMutator) {
        HashMap<String, String> attributes;
        block2: {
            int attributeCount = reader.getAttributeCount();
            if (attributeCount == 0) {
                return MapsKt.emptyMap();
            }
            attributes = new HashMap<String, String>(attributeCount);
            for (int i = 0; i < attributeCount; ++i) {
                String localName = reader.getAttributeLocalName(i);
                String prefix = reader.getAttributePrefix(i);
                Intrinsics.checkNotNull((Object)localName);
                String qualifiedName = JSvgDocumentFactoryKt.getQualifiedName(prefix, localName);
                String string = reader.getAttributeValue(i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                attributes.put(qualifiedName, ((Object)StringsKt.trim((CharSequence)string)).toString());
            }
            Function1<? super Map<String, String>, Unit> function1 = attributeMutator;
            if (function1 == null) break block2;
            function1.invoke(attributes);
        }
        return attributes;
    }

    private static final String getQualifiedName(String prefix, String localName) {
        CharSequence charSequence = prefix;
        return charSequence == null || charSequence.length() == 0 ? localName : prefix + ":" + localName;
    }

    private static final UIFuture jsvgLoadHelper$lambda$0(URI uri) {
        UIFuture uIFuture;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (Intrinsics.areEqual((Object)uri.getScheme(), (Object)"data")) {
            uIFuture = (UIFuture)new ValueUIFuture((Object)ResourceUtil.loadImage((URI)uri));
        } else {
            JSvgDocumentFactoryKt.getLOG().warn("Only data URI is allowed (uri=" + uri + ")");
            uIFuture = null;
        }
        return uIFuture;
    }

    static {
        Map map = NodeMap.createNodeConstructorMap((Map)CollectionFactory.createCaseInsensitiveStringMap());
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"createNodeConstructorMap(...)");
        NODE_CONSTRUCTOR_MAP = map;
    }
}

