/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.accessibility;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J.\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0007JB\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J(\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0007J<\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J1\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u000f\u001a\u00020\u00052\u0016\u0010\u0015\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\u0016\"\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0007J\u001c\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J.\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0007JB\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J(\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0007J<\u0010\u001b\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0011\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\b\b\u0001\u0010\u0012\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\nH\u0007J\u001e\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001d\u001a\u00020\u001e2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010 \u001a\u0004\u0018\u00010\nH\u0007J\"\u0010!\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007J,\u0010!\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u000f\u001a\u00020\u00052\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u0005H\u0007JB\u0010!\u001a\u0004\u0018\u00010\u00052\n\b\u0001\u0010\"\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0011\u001a\u00020\u00052\n\b\u0001\u0010#\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u0012\u001a\u00020\u00052\n\b\u0001\u0010$\u001a\u0004\u0018\u00010\u0005H\u0007J3\u0010%\u001a\u0004\u0018\u00010\u00052\b\b\u0001\u0010\u000f\u001a\u00020\u00052\u0018\b\u0001\u0010&\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00050\u0016\"\u0004\u0018\u00010\u0005H\u0007\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u00020\u00052\b\u0010)\u001a\u0004\u0018\u00010\u0005H\u0007J\u0014\u0010*\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0003J\u001c\u0010+\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\u0005H\u0002J\u0014\u0010,\u001a\u0004\u0018\u00010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0003J\u001c\u0010-\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/util/ui/accessibility/AccessibleContextUtil;", "", "<init>", "()V", "PUNCTUATION_CHARACTER", "", "PUNCTUATION_SEPARATOR", "setName", "", "component", "Ljava/awt/Component;", "name", "source", "setCombinedName", "j1", "separator", "j2", "separator1", "separator2", "j3", "getCombinedName", "components", "", "(Ljava/lang/String;[Ljava/awt/Component;)Ljava/lang/String;", "setDescription", "description", "setCombinedDescription", "getCombinedDescription", "getUniqueDescription", "context", "Ljavax/accessibility/AccessibleContext;", "setParent", "newParent", "combineAccessibleStrings", "s1", "s2", "s3", "joinAccessibleStrings", "strings", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "replaceLineSeparatorsWithPunctuation", "text", "getAccessibleName", "setAccessibleName", "getAccessibleDescription", "setAccessibleDescription", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nAccessibleContextUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccessibleContextUtil.kt\ncom/intellij/util/ui/accessibility/AccessibleContextUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,231:1\n11705#2:232\n12052#2,3:233\n777#3:236\n873#3,2:237\n*S KotlinDebug\n*F\n+ 1 AccessibleContextUtil.kt\ncom/intellij/util/ui/accessibility/AccessibleContextUtil\n*L\n206#1:232\n206#1:233,3\n207#1:236\n207#1:237,2\n*E\n"})
public final class AccessibleContextUtil {
    @NotNull
    public static final AccessibleContextUtil INSTANCE = new AccessibleContextUtil();
    @ApiStatus.Internal
    @NotNull
    public static final String PUNCTUATION_CHARACTER = ".";
    @ApiStatus.Internal
    @NotNull
    public static final String PUNCTUATION_SEPARATOR = "  ";

    private AccessibleContextUtil() {
    }

    @JvmStatic
    public static final void setName(@NotNull Component component, @Nls @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        INSTANCE.setAccessibleName(component, name);
    }

    @JvmStatic
    public static final void setName(@NotNull Component component, @NotNull Component source) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        AccessibleContextUtil.setName(component, INSTANCE.getAccessibleName(source));
    }

    @JvmStatic
    public static final void setCombinedName(@NotNull Component component, @Nullable Component j1, @NlsSafe @NotNull String separator, @Nullable Component j2) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        INSTANCE.setAccessibleName(component, AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleName(j1), separator, INSTANCE.getAccessibleName(j2)));
    }

    @JvmStatic
    public static final void setCombinedName(@NotNull Component component, @Nullable Component j1, @NlsSafe @NotNull String separator1, @Nullable Component j2, @NlsSafe @NotNull String separator2, @Nullable Component j3) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)separator1, (String)"separator1");
        Intrinsics.checkNotNullParameter((Object)separator2, (String)"separator2");
        INSTANCE.setAccessibleName(component, AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleName(j1), separator1, INSTANCE.getAccessibleName(j2), separator2, INSTANCE.getAccessibleName(j3)));
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String getCombinedName(@Nullable Component j1, @NlsSafe @NotNull String separator, @Nullable Component j2) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleName(j1), separator, INSTANCE.getAccessibleName(j2));
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String getCombinedName(@Nullable Component j1, @NlsSafe @NotNull String separator1, @Nullable Component j2, @NlsSafe @NotNull String separator2, @Nullable Component j3) {
        Intrinsics.checkNotNullParameter((Object)separator1, (String)"separator1");
        Intrinsics.checkNotNullParameter((Object)separator2, (String)"separator2");
        return AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleName(j1), separator1, INSTANCE.getAccessibleName(j2), separator2, INSTANCE.getAccessibleName(j3));
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String getCombinedName(@NlsSafe @NotNull String separator, Component ... components) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        String result = "";
        for (Component c : components) {
            result = AccessibleContextUtil.combineAccessibleStrings(result, separator, INSTANCE.getAccessibleName(c));
        }
        return result;
    }

    @JvmStatic
    public static final void setDescription(@NotNull Component component, @NotNull Component source) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        INSTANCE.setAccessibleDescription(component, INSTANCE.getAccessibleDescription(source));
    }

    @JvmStatic
    public static final void setDescription(@NotNull Component component, @Nls @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        INSTANCE.setAccessibleDescription(component, description);
    }

    @JvmStatic
    public static final void setCombinedDescription(@NotNull Component component, @Nullable Component j1, @NlsSafe @NotNull String separator, @Nullable Component j2) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        INSTANCE.setAccessibleDescription(component, AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleDescription(j1), separator, INSTANCE.getAccessibleDescription(j2)));
    }

    @JvmStatic
    public static final void setCombinedDescription(@NotNull Component component, @Nullable Component j1, @NlsSafe @NotNull String separator1, @Nullable Component j2, @NlsSafe @NotNull String separator2, @Nullable Component j3) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)separator1, (String)"separator1");
        Intrinsics.checkNotNullParameter((Object)separator2, (String)"separator2");
        INSTANCE.setAccessibleDescription(component, AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleDescription(j1), separator1, INSTANCE.getAccessibleDescription(j2), separator2, INSTANCE.getAccessibleDescription(j3)));
    }

    @JvmStatic
    @Nullable
    public static final String getCombinedDescription(@Nullable Component j1, @NlsSafe @NotNull String separator, @Nullable Component j2) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleDescription(j1), separator, INSTANCE.getAccessibleDescription(j2));
    }

    @JvmStatic
    @Nullable
    public static final String getCombinedDescription(@Nullable Component j1, @NlsSafe @NotNull String separator1, @Nullable Component j2, @NlsSafe @NotNull String separator2, @Nullable Component j3) {
        Intrinsics.checkNotNullParameter((Object)separator1, (String)"separator1");
        Intrinsics.checkNotNullParameter((Object)separator2, (String)"separator2");
        return AccessibleContextUtil.combineAccessibleStrings(INSTANCE.getAccessibleDescription(j1), separator1, INSTANCE.getAccessibleDescription(j2), separator2, INSTANCE.getAccessibleDescription(j3));
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String getUniqueDescription(@NotNull AccessibleContext context, @Nls @Nullable String description) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return Intrinsics.areEqual((Object)description, (Object)context.getAccessibleName()) ? null : description;
    }

    @JvmStatic
    public static final void setParent(@NotNull Component component, @Nullable Component newParent) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        component.getAccessibleContext().setAccessibleParent(newParent instanceof Accessible ? (Accessible)((Object)newParent) : null);
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String combineAccessibleStrings(@Nls @Nullable String s1, @Nls @Nullable String s2) {
        return AccessibleContextUtil.combineAccessibleStrings(s1, " ", s2);
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String combineAccessibleStrings(@Nls @Nullable String s1, @NlsSafe @NotNull String separator, @Nls @Nullable String s2) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        CharSequence charSequence = s1;
        return (charSequence == null || charSequence.length() == 0) && ((charSequence = (CharSequence)s2) == null || charSequence.length() == 0) ? null : ((charSequence = (CharSequence)s1) == null || charSequence.length() == 0 ? s2 : ((charSequence = (CharSequence)s2) == null || charSequence.length() == 0 ? s1 : s1 + separator + s2));
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String combineAccessibleStrings(@Nls @Nullable String s1, @Nls @NotNull String separator1, @Nls @Nullable String s2, @Nls @NotNull String separator2, @Nls @Nullable String s3) {
        Intrinsics.checkNotNullParameter((Object)separator1, (String)"separator1");
        Intrinsics.checkNotNullParameter((Object)separator2, (String)"separator2");
        return AccessibleContextUtil.combineAccessibleStrings(AccessibleContextUtil.combineAccessibleStrings(s1, separator1, s2), separator2, s3);
    }

    @JvmStatic
    @Nls
    @Nullable
    public static final String joinAccessibleStrings(@NlsSafe @NotNull String separator, String ... strings) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        String result = null;
        for (String s : strings) {
            result = AccessibleContextUtil.combineAccessibleStrings(result, separator, s);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String replaceLineSeparatorsWithPunctuation(@Nullable String text) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        CharSequence charSequence = text;
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        String[] stringArray = StringUtil.splitByLines((String)text);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLines(...)");
        Object[] $this$map$iv = stringArray;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)PUNCTUATION_SEPARATOR, null, null, (int)0, null, AccessibleContextUtil::replaceLineSeparatorsWithPunctuation$lambda$2, (int)30, null);
    }

    @Nls
    private final String getAccessibleName(Component component) {
        Object object = component instanceof Accessible ? (Accessible)((Object)component) : null;
        return object != null && (object = object.getAccessibleContext()) != null ? ((AccessibleContext)object).getAccessibleName() : null;
    }

    private final void setAccessibleName(Component component, @Nls String name) {
        block0: {
            Object object = component instanceof Accessible ? (Accessible)((Object)component) : null;
            if (object == null || (object = object.getAccessibleContext()) == null) break block0;
            ((AccessibleContext)object).setAccessibleName(name);
        }
    }

    @Nls
    private final String getAccessibleDescription(Component component) {
        Object object = component instanceof Accessible ? (Accessible)((Object)component) : null;
        return object != null && (object = object.getAccessibleContext()) != null ? ((AccessibleContext)object).getAccessibleDescription() : null;
    }

    private final void setAccessibleDescription(Component component, @Nls String description) {
        block0: {
            Object object = component instanceof Accessible ? (Accessible)((Object)component) : null;
            if (object == null || (object = object.getAccessibleContext()) == null) break block0;
            ((AccessibleContext)object).setAccessibleDescription(description);
        }
    }

    private static final CharSequence replaceLineSeparatorsWithPunctuation$lambda$2(String line) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return StringsKt.endsWith$default((String)line, (String)PUNCTUATION_CHARACTER, (boolean)false, (int)2, null) ? (CharSequence)line : (CharSequence)(line + PUNCTUATION_CHARACTER);
    }
}

