/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.ui.icons.CachedImageIcon;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ*\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0014\u001a\u00020\u0012H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\n\u0010\u0019\u001a\u00020\u001aH\u0096\u0080\u0004R\u0010\u0010\u0003\u001a\u00020\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ui/icons/ScaledResultIcon;", "Ljavax/swing/Icon;", "Lcom/intellij/ui/icons/ReplaceableIcon;", "image", "Ljava/awt/Image;", "original", "Lcom/intellij/ui/icons/CachedImageIcon;", "objectScale", "", "<init>", "(Ljava/awt/Image;Lcom/intellij/ui/icons/CachedImageIcon;F)V", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "", "y", "getIconWidth", "getIconHeight", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "toString", "", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nScaledIconCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaledIconCache.kt\ncom/intellij/ui/icons/ScaledResultIcon\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,156:1\n13#2:157\n*S KotlinDebug\n*F\n+ 1 ScaledIconCache.kt\ncom/intellij/ui/icons/ScaledResultIcon\n*L\n122#1:157\n*E\n"})
public final class ScaledResultIcon
implements Icon,
ReplaceableIcon {
    @JvmField
    @NotNull
    public final Image image;
    @NotNull
    private final CachedImageIcon original;
    private final float objectScale;

    public ScaledResultIcon(@NotNull Image image, @NotNull CachedImageIcon original, float objectScale) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        this.image = image;
        this.original = original;
        this.objectScale = objectScale;
    }

    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        StartupUiUtil.drawImage$default(g, this.image, x, y, 0, 0, null, null, c, 48, null);
    }

    @Override
    public int getIconWidth() {
        return this.image.getWidth(null);
    }

    @Override
    public int getIconHeight() {
        return this.image.getHeight(null);
    }

    @NotNull
    public Icon replaceBy(@NotNull IconReplacer replacer) {
        Intrinsics.checkNotNullParameter((Object)replacer, (String)"replacer");
        Icon originalReplaced = replacer.replaceIcon((Icon)this.original);
        if (originalReplaced instanceof ScalableIcon) {
            Icon icon = ((ScalableIcon)originalReplaced).scale(this.objectScale);
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"scale(...)");
            return icon;
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ScaledResultIcon.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.error("The result after replacing cannot be scaled: " + originalReplaced);
        return this;
    }

    @NotNull
    public String toString() {
        return "ScaledResultIcon for " + this.original;
    }
}

