/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JreHiDpiUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.ui.scale.ScaleKt;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.JBHiDPIScaledImage;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.system.OS;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.util.Locale;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.StyleContext;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0002J\u0012\u0010\u0011\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0007J\u0010\u0010\u0011\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001aH\u0007J2\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J,\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010\u001c2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J6\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010'\u001a\u0004\u0018\u00010\u001c2\b\u0010(\u001a\u0004\u0018\u00010\u001c2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007J2\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0007J\u0010\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020-H\u0007J \u00103\u001a\u00020\u001e2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0007J \u00103\u001a\u00020\u001e2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u00104\u001a\u000205H\u0007J\b\u0010:\u001a\u00020\u0005H\u0007J\b\u0010;\u001a\u00020\u0005H\u0007J\b\u0010<\u001a\u00020\u0005H\u0007J\b\u0010=\u001a\u00020\u001eH\u0007J$\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u00010A2\b\b\u0001\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020DH\u0007J@\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010E\u001a\u0004\u0018\u00010\u001c2\b\u0010F\u001a\u0004\u0018\u00010\u001c2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007Jd\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\r2\b\b\u0002\u0010$\u001a\u00020\r2\b\b\u0002\u0010H\u001a\u00020\r2\b\b\u0002\u0010I\u001a\u00020\r2\n\b\u0002\u0010F\u001a\u0004\u0018\u00010\u001c2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010+2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&H\u0007Jv\u0010J\u001a\u00020\u001e2\u0006\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020\r2\u0006\u0010P\u001a\u00020\r2\u0006\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020\r2\u0006\u0010Q\u001a\u00020\u00052\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\"2\b\u0010(\u001a\u0004\u0018\u00010\u001c2\b\u0010%\u001a\u0004\u0018\u00010&H\u0002J\u0018\u0010R\u001a\u00020\r2\u0006\u0010C\u001a\u00020\r2\u0006\u0010M\u001a\u00020NH\u0002J\u0080\u0001\u0010S\u001a\u00020\u001e2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010!\u001a\u00020\"2\b\u0010T\u001a\u0004\u0018\u00010U2\u0006\u0010Q\u001a\u00020\u00052\u0006\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020\r2\b\u0010F\u001a\u0004\u0018\u00010\u001c2\u0006\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010O\u001a\u00020\r2\u0006\u0010P\u001a\u00020\r2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010M\u001a\u00020NH\u0002R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0004\u0010\u0007R\u001a\u0010\b\u001a\u00020\u00058GX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\t\u0010\u0003\u001a\u0004\b\b\u0010\u0007R\u0011\u0010\n\u001a\u00020\u00058G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u001a\u0010\u0011\u001a\u00020\u00058FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0012\u0010\u0003\u001a\u0004\b\u0011\u0010\u0007R\u001a\u0010,\u001a\u00020-8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b.\u0010\u0003\u001a\u0004\b/\u00100R\u000e\u0010G\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006V"}, d2={"Lcom/intellij/util/ui/StartupUiUtil;", "", "<init>", "()V", "isWayland", "", "isWayland$annotations", "()Z", "isUnderDarcula", "isUnderDarcula$annotations", "isDarkTheme", "isUnderIntelliJLaF", "getLcdContrastValue", "", "doGetLcdContrastValueForSplash", "normalizeLcdContrastValue", "lcdContrastValue", "isJreHiDPI", "isJreHiDPI$annotations", "component", "Ljava/awt/Component;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "getCenterPoint", "Ljava/awt/Point;", "container", "Ljava/awt/Dimension;", "child", "Ljava/awt/Rectangle;", "drawImage", "", "g", "Ljava/awt/Graphics;", "image", "Ljava/awt/Image;", "x", "y", "observer", "Ljava/awt/image/ImageObserver;", "dstBounds", "srcBounds", "Ljava/awt/image/BufferedImage;", "op", "Ljava/awt/image/BufferedImageOp;", "labelFont", "Ljava/awt/Font;", "getLabelFont$annotations", "getLabelFont", "()Ljava/awt/Font;", "isDialogFont", "font", "addAwtListener", "listener", "Ljava/awt/event/AWTEventListener;", "mask", "", "parent", "Lcom/intellij/openapi/Disposable;", "isWaylandToolkit", "isXToolkit", "isLWCToolkit", "pump", "getFontWithFallback", "Ljavax/swing/plaf/FontUIResource;", "familyName", "", "style", "size", "", "destinationBounds", "sourceBounds", "useAccuracyDelta", "dw", "dh", "doDrawHiDpi", "userWidth", "userHeight", "scale", "", "dx", "dy", "hasDestinationSize", "scaleSize", "doDraw", "invG", "Ljava/awt/Graphics2D;", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nStartupUiUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StartupUiUtil.kt\ncom/intellij/util/ui/StartupUiUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,410:1\n1#2:411\n*E\n"})
public final class StartupUiUtil {
    @NotNull
    public static final StartupUiUtil INSTANCE = new StartupUiUtil();
    private static final boolean isWayland = OS.isGenericUnix() && System.getenv("WAYLAND_DISPLAY") != null;
    private static final boolean useAccuracyDelta = Boolean.parseBoolean(System.getProperty("ide.icon.scale.useAccuracyDelta", "true"));

    private StartupUiUtil() {
    }

    public static final boolean isWayland() {
        return isWayland;
    }

    @JvmStatic
    public static /* synthetic */ void isWayland$annotations() {
    }

    @Deprecated(message="Do not use it. Use UI theme properties.", replaceWith=@ReplaceWith(expression="StartupUiUtil[isDarkTheme]", imports={}))
    @ApiStatus.ScheduledForRemoval
    public static final boolean isUnderDarcula() {
        return INSTANCE.isDarkTheme();
    }

    @JvmStatic
    public static /* synthetic */ void isUnderDarcula$annotations() {
    }

    @ApiStatus.Internal
    public final boolean isDarkTheme() {
        UIDefaults lookAndFeelDefaults = UIManager.getLookAndFeelDefaults();
        return lookAndFeelDefaults == null || lookAndFeelDefaults.getBoolean("ui.theme.is.dark");
    }

    @JvmStatic
    @Deprecated(message="Starts from 2023.3 all themes use DarculaLaf", replaceWith=@ReplaceWith(expression="false", imports={}))
    @ApiStatus.ScheduledForRemoval
    public static final boolean isUnderIntelliJLaF() {
        return !INSTANCE.isDarkTheme();
    }

    @JvmStatic
    public static final int getLcdContrastValue() {
        int lcdContrastValue = LoadingState.APP_STARTED.isOccurred() ? Registry.Companion.intValue("lcd.contrast.value", 0) : 0;
        return lcdContrastValue == 0 ? INSTANCE.doGetLcdContrastValueForSplash(INSTANCE.isDarkTheme()) : INSTANCE.normalizeLcdContrastValue(lcdContrastValue);
    }

    private final int doGetLcdContrastValueForSplash(boolean isUnderDarcula) {
        Map hints;
        if (OS.CURRENT == OS.macOS) {
            return isUnderDarcula ? 140 : 230;
        }
        Object object = Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Map map = hints = object instanceof Map ? (Map)object : null;
        Integer n = (Integer)(map != null ? map.get(RenderingHints.KEY_TEXT_LCD_CONTRAST) : null);
        if (n == null) {
            return 140;
        }
        int lcdContrastValue = n;
        return this.normalizeLcdContrastValue(lcdContrastValue);
    }

    private final int normalizeLcdContrastValue(int lcdContrastValue) {
        return !(100 <= lcdContrastValue ? lcdContrastValue < 251 : false) ? 140 : lcdContrastValue;
    }

    public static final boolean isJreHiDPI() {
        return ScaleKt.isHiDPIEnabledAndApplicable(JBUIScale.sysScale());
    }

    @JvmStatic
    public static /* synthetic */ void isJreHiDPI$annotations() {
    }

    @JvmStatic
    public static final boolean isJreHiDPI(@Nullable Component component) {
        Component component2 = component;
        return JreHiDpiUtil.isJreHiDPI(component2 != null ? component2.getGraphicsConfiguration() : null);
    }

    public final boolean isJreHiDPI(@Nullable ScaleContext scaleContext) {
        ScaleContext scaleContext2 = scaleContext;
        return ScaleKt.isHiDPIEnabledAndApplicable(scaleContext2 != null ? (float)scaleContext2.getScale(ScaleType.SYS_SCALE) : JBUIScale.sysScale());
    }

    @JvmStatic
    @NotNull
    public static final Point getCenterPoint(@NotNull Dimension container, @NotNull Dimension child) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return StartupUiUtil.getCenterPoint(new Rectangle(container), child);
    }

    @JvmStatic
    @NotNull
    public static final Point getCenterPoint(@NotNull Rectangle container, @NotNull Dimension child) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        return new Point(container.x + (container.width - child.width) / 2, container.y + (container.height - child.height) / 2);
    }

    @JvmStatic
    public static final void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        StartupUiUtil.drawImage$default(g, image, x, y, 0, 0, null, null, observer, 48, null);
    }

    @JvmStatic
    public static final void drawImage(@NotNull Graphics g, @NotNull Image image) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        StartupUiUtil.drawImage(g, image, 0, 0, -1, -1, null, null, null);
    }

    @JvmStatic
    public static final void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        StartupUiUtil.drawImage(g, image, dstBounds, null, null, observer);
    }

    @JvmStatic
    public static final void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle dstBounds, @Nullable Rectangle srcBounds, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        StartupUiUtil.drawImage(g, image, dstBounds, srcBounds, null, observer);
    }

    @JvmStatic
    public static final void drawImage(@NotNull Graphics g, @NotNull BufferedImage image, @Nullable BufferedImageOp op, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        StartupUiUtil.drawImage(g, image, x, y, -1, -1, null, op, null);
    }

    @NotNull
    public static final Font getLabelFont() {
        Font font = UIManager.getFont("Label.font");
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        return font;
    }

    @JvmStatic
    public static /* synthetic */ void getLabelFont$annotations() {
    }

    @JvmStatic
    public static final boolean isDialogFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return Intrinsics.areEqual((Object)"Dialog", (Object)font.getFamily(Locale.US));
    }

    @Deprecated(message="Use lambda-friendly overload instead", replaceWith=@ReplaceWith(expression="addAwtListener(mask, parent, listener)", imports={}))
    @JvmStatic
    public static final void addAwtListener(@NotNull AWTEventListener listener2, long mask, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, mask);
        Disposer.register((Disposable)parent, () -> StartupUiUtil.addAwtListener$lambda$0(listener2));
    }

    @JvmStatic
    public static final void addAwtListener(long mask, @NotNull Disposable parent, @NotNull AWTEventListener listener2) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, mask);
        Disposer.register((Disposable)parent, () -> StartupUiUtil.addAwtListener$lambda$1(listener2));
    }

    @JvmStatic
    public static final boolean isWaylandToolkit() {
        return OS.isGenericUnix() && Intrinsics.areEqual((Object)"sun.awt.wl.WLToolkit", (Object)Toolkit.getDefaultToolkit().getClass().getName());
    }

    @JvmStatic
    public static final boolean isXToolkit() {
        return OS.isGenericUnix() && Intrinsics.areEqual((Object)"sun.awt.X11.XToolkit", (Object)Toolkit.getDefaultToolkit().getClass().getName());
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean isLWCToolkit() {
        return OS.CURRENT == OS.macOS && Intrinsics.areEqual((Object)"sun.lwawt.macosx.LWCToolkit", (Object)Toolkit.getDefaultToolkit().getClass().getName());
    }

    @TestOnly
    public final void pump() {
        boolean bl;
        boolean bl2 = bl = !SwingUtilities.isEventDispatchThread();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Semaphore lock = new Semaphore(1);
        SwingUtilities.invokeLater(() -> StartupUiUtil.pump$lambda$0(lock));
        lock.waitFor();
    }

    @JvmStatic
    @NotNull
    public static final FontUIResource getFontWithFallback(@Nullable String familyName, @JdkConstants.FontStyle int style, float size) {
        Font fontWithFallback = OS.CURRENT == OS.macOS || GraphicsEnvironment.isHeadless() ? new Font(familyName, style, (int)size).deriveFont(size) : new StyleContext().getFont(familyName, style, (int)size).deriveFont(size);
        FontUIResource fontUIResource = fontWithFallback instanceof FontUIResource ? (FontUIResource)fontWithFallback : null;
        if (fontUIResource == null) {
            fontUIResource = new FontUIResource(fontWithFallback);
        }
        return fontUIResource;
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void drawImage(@NotNull Graphics g, @NotNull Image image, @Nullable Rectangle destinationBounds, @Nullable Rectangle sourceBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        if (destinationBounds == null) {
            StartupUiUtil.drawImage$default(g, image, 0, 0, 0, 0, sourceBounds, op, observer, 60, null);
        } else {
            StartupUiUtil.drawImage(g, image, destinationBounds.x, destinationBounds.y, destinationBounds.width, destinationBounds.height, sourceBounds, op, observer);
        }
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final void drawImage(@NotNull Graphics g, @NotNull Image image, int x, int y, int dw, int dh, @Nullable Rectangle sourceBounds, @Nullable BufferedImageOp op, @Nullable ImageObserver observer) {
        boolean hasDestinationSize;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        boolean bl = hasDestinationSize = dw >= 0 && dh >= 0;
        if (image instanceof JBHiDPIScaledImage) {
            int n = ((JBHiDPIScaledImage)image).getUserWidth();
            int n2 = ((JBHiDPIScaledImage)image).getUserHeight();
            double d = ((JBHiDPIScaledImage)image).getScale();
            Image image2 = ((JBHiDPIScaledImage)image).getDelegate();
            if (image2 == null) {
                image2 = image;
            }
            INSTANCE.doDrawHiDpi(n, n2, g, d, x, y, dw, dh, hasDestinationSize, op, image2, sourceBounds, observer);
        } else {
            INSTANCE.doDraw(op, image, null, hasDestinationSize, dw, dh, sourceBounds, image.getWidth(null), image.getHeight(null), g, x, y, observer, 1.0);
        }
    }

    public static /* synthetic */ void drawImage$default(Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x20) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n5 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n5 & 0x100) != 0) {
            imageObserver = null;
        }
        StartupUiUtil.drawImage(graphics, image, n, n2, n3, n4, rectangle, bufferedImageOp, imageObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void doDrawHiDpi(int userWidth, int userHeight, Graphics g, double scale, int dx, int dy, int dw, int dh, boolean hasDestinationSize, BufferedImageOp op, Image image, Rectangle srcBounds, ImageObserver observer) {
        int maxSize;
        double scale1 = scale;
        int dx1 = dx;
        int dy1 = dy;
        double delta = 0.0;
        if (useAccuracyDelta && (maxSize = Math.max(userWidth, userHeight)) < 0x3FFFFFFF) {
            int dotAccuracy = 1;
            double pow = 0.0;
            while (true) {
                void it;
                double d;
                double d2 = d = Math.pow(10.0, dotAccuracy);
                double d3 = maxSize;
                boolean bl = false;
                pow = it;
                Unit unit = Unit.INSTANCE;
                if (!(d3 > d)) break;
                ++dotAccuracy;
            }
            delta = 1.0 / pow;
        }
        if (!(g instanceof Graphics2D)) {
            return;
        }
        AffineTransform tx = ((Graphics2D)g).getTransform();
        Graphics invG = null;
        Graphics g1 = g;
        if ((tx.getType() & 0x18) == 0 && Math.abs(scale1 - tx.getScaleX()) <= delta) {
            scale1 = tx.getScaleX();
            double gScaleX = tx.getScaleX();
            double gScaleY = tx.getScaleY();
            tx.scale(1.0 / gScaleX, 1.0 / gScaleY);
            tx.translate((double)dx1 * gScaleX, (double)dy1 * gScaleY);
            dy1 = 0;
            dx1 = 0;
            Graphics graphics = g1.create();
            Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            g1 = invG = (Graphics2D)graphics;
            ((Graphics2D)invG).setTransform(tx);
        }
        try {
            int dw2 = dw;
            int dh2 = dh;
            if (invG != null && hasDestinationSize) {
                dw2 = this.scaleSize(dw2, scale1);
                dh2 = this.scaleSize(dh2, scale1);
            }
            this.doDraw(op, image, (Graphics2D)invG, hasDestinationSize, dw2, dh2, srcBounds, userWidth, userHeight, g1, dx1, dy1, observer, scale1);
        }
        finally {
            Graphics graphics = invG;
            if (graphics != null) {
                graphics.dispose();
            }
        }
    }

    private final int scaleSize(int size, double scale) {
        return MathKt.roundToInt((double)((double)size * scale));
    }

    private final void doDraw(BufferedImageOp op, Image image, Graphics2D invG, boolean hasDestinationSize, int dw, int dh, Rectangle sourceBounds, int userWidth, int userHeight, Graphics g, int dx, int dy, ImageObserver observer, double scale) {
        Image image2 = image;
        if (op != null && image2 instanceof BufferedImage) {
            BufferedImage bufferedImage = op.filter((BufferedImage)image2, null);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"filter(...)");
            image2 = bufferedImage;
        }
        if (sourceBounds != null) {
            int sx = StartupUiUtil.doDraw$size(scale, sourceBounds.x);
            int sy = StartupUiUtil.doDraw$size(scale, sourceBounds.y);
            int sw = sourceBounds.width >= 0 ? StartupUiUtil.doDraw$size(scale, sourceBounds.width) : StartupUiUtil.doDraw$size(scale, userWidth) - sx;
            int sh = sourceBounds.height >= 0 ? StartupUiUtil.doDraw$size(scale, sourceBounds.height) : StartupUiUtil.doDraw$size(scale, userHeight) - sy;
            int dw2 = dw;
            int dh2 = dh;
            if (!hasDestinationSize) {
                dw2 = StartupUiUtil.doDraw$size(scale, userWidth);
                dh2 = StartupUiUtil.doDraw$size(scale, userHeight);
            }
            v1 = g.drawImage(image2, dx, dy, dx + dw2, dy + dh2, sx, sy, sx + sw, sy + sh, observer);
        } else {
            v1 = hasDestinationSize ? g.drawImage(image2, dx, dy, dw, dh, observer) : (invG == null ? g.drawImage(image2, dx, dy, userWidth, userHeight, observer) : g.drawImage(image2, dx, dy, observer));
        }
    }

    private static final void addAwtListener$lambda$0(AWTEventListener $listener) {
        Toolkit.getDefaultToolkit().removeAWTEventListener($listener);
    }

    private static final void addAwtListener$lambda$1(AWTEventListener $listener) {
        Toolkit.getDefaultToolkit().removeAWTEventListener($listener);
    }

    private static final void pump$lambda$0(Semaphore $lock) {
        $lock.up();
    }

    private static final int doDraw$size(double $scale, int size) {
        return INSTANCE.scaleSize(size, $scale);
    }
}

