/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.DarculaColors;
import com.intellij.ui.Gray;
import com.intellij.ui.SwingTuneBrighter;
import com.intellij.ui.SwingTuneDarker;
import com.intellij.util.NotNullProducer;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.ui.ComparableColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PresentableColor;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.UIManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBColor
extends Color
implements PresentableColor,
ComparableColor {
    public static final Color PanelBackground = new JBColor("Panel.background", new Color(0xFFFFFF));
    private static final SynchronizedClearableLazy<Boolean> DARK = new SynchronizedClearableLazy(() -> StartupUiUtil.INSTANCE.isDarkTheme());
    private static final Color NAMED_COLOR_FALLBACK_MARKER = JBColor.marker("NAMED_COLOR_FALLBACK_MARKER");
    private final String name;
    private final Color darkColor;
    private final Color defaultColor;
    private final Supplier<? extends Color> func;
    private static final Color CACHED_NULL = JBColor.marker("CACHED_NULL");
    public static final JBColor red;
    public static final JBColor RED;
    public static final JBColor blue;
    public static final JBColor BLUE;
    public static final JBColor white;
    public static final JBColor WHITE;
    public static final JBColor black;
    public static final JBColor BLACK;
    public static final JBColor gray;
    public static final JBColor GRAY;
    public static final JBColor lightGray;
    public static final JBColor LIGHT_GRAY;
    public static final JBColor darkGray;
    public static final JBColor DARK_GRAY;
    public static final JBColor pink;
    public static final JBColor PINK;
    public static final JBColor orange;
    public static final JBColor ORANGE;
    public static final JBColor yellow;
    public static final JBColor YELLOW;
    public static final JBColor green;
    public static final JBColor GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    private static final Map<String, Color> defaultThemeColors;

    public JBColor(int rgb, int darkRGB) {
        this(new Color(rgb, (rgb & 0xFF000000) != 0), new Color(darkRGB, (rgb & 0xFF000000) != 0));
    }

    public JBColor(@NotNull Color regular, @NotNull Color dark) {
        if (regular == null) {
            JBColor.$$$reportNull$$$0(0);
        }
        if (dark == null) {
            JBColor.$$$reportNull$$$0(1);
        }
        super(regular.getRGB(), regular.getAlpha() != 255);
        this.name = null;
        this.defaultColor = null;
        this.darkColor = dark;
        this.func = null;
    }

    protected JBColor(@NotNull @NotNull Supplier<? extends @NotNull Color> function) {
        if (function == null) {
            JBColor.$$$reportNull$$$0(2);
        }
        super(0);
        this.name = null;
        this.defaultColor = null;
        this.darkColor = null;
        this.func = function;
    }

    @Deprecated
    public JBColor(@NotNull NotNullProducer<? extends Color> function) {
        if (function == null) {
            JBColor.$$$reportNull$$$0(3);
        }
        super(0);
        this.name = null;
        this.defaultColor = null;
        this.darkColor = null;
        this.func = () -> function.produce();
    }

    public JBColor(@NotNull String name, @Nullable Color defaultColor) {
        if (name == null) {
            JBColor.$$$reportNull$$$0(4);
        }
        super(0);
        this.name = name;
        this.defaultColor = defaultColor;
        this.darkColor = null;
        this.func = null;
    }

    @NotNull
    public static JBColor lazy(@NotNull @NotNull Supplier<? extends @NotNull Color> supplier) {
        if (supplier == null) {
            JBColor.$$$reportNull$$$0(5);
        }
        return new JBColor(supplier);
    }

    @NotNull
    public static Color marker(final @NotNull String name) {
        if (name == null) {
            JBColor.$$$reportNull$$$0(6);
        }
        return new JBColor(() -> {
            throw new AssertionError((Object)name);
        }){

            @Override
            public boolean equals(Object obj) {
                return this == obj;
            }

            @Override
            public int hashCode() {
                return System.identityHashCode(this);
            }

            @Override
            public String getPresentableName() {
                return "Marker: " + name;
            }

            @Override
            public String toString() {
                return name;
            }
        };
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, int defaultValueRGB) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(7);
        }
        return JBColor.namedColor(propertyName, new Color(defaultValueRGB));
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, int defaultValueRGB, int darkValueRGB) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(8);
        }
        return JBColor.namedColor(propertyName, new JBColor(defaultValueRGB, darkValueRGB));
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(9);
        }
        return JBColor.namedColor(propertyName, NAMED_COLOR_FALLBACK_MARKER);
    }

    public static JBColor namedColorOrNull(@NonNls @NotNull String propertyName) {
        JBColor color;
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(10);
        }
        if ((color = new JBColor(propertyName, NAMED_COLOR_FALLBACK_MARKER)).getColorOrNull() == null) {
            return null;
        }
        return color;
    }

    @NotNull
    public static JBColor namedColor(@NonNls @NotNull String propertyName, @NotNull Color defaultColor) {
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(11);
        }
        if (defaultColor == null) {
            JBColor.$$$reportNull$$$0(12);
        }
        return new JBColor(propertyName, defaultColor);
    }

    @NotNull
    private static Color calculateColor(@NonNls @NotNull String name, @Nullable Color defaultColor) {
        Color color;
        if (name == null) {
            JBColor.$$$reportNull$$$0(13);
        }
        if ((color = JBColor.calculateColorOrNull(name)) == null) {
            Color color2 = defaultColor == NAMED_COLOR_FALLBACK_MARKER || defaultColor == null ? Gray.TRANSPARENT : defaultColor;
            if (color2 == null) {
                JBColor.$$$reportNull$$$0(14);
            }
            return color2;
        }
        Color color3 = color;
        if (color3 == null) {
            JBColor.$$$reportNull$$$0(15);
        }
        return color3;
    }

    private static Color calculateColorOrNull(@NonNls @NotNull String propertyName) {
        Color color;
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(16);
        }
        if ((color = UIManager.getColor(propertyName)) == null) {
            color = JBColor.findPatternMatch(propertyName);
        }
        if (UIManager.get(propertyName) == null && Registry.is((String)"ide.save.missing.jb.colors", (boolean)false)) {
            return JBColor._saveAndReturnColor(propertyName, color == null ? Gray.TRANSPARENT : color);
        }
        return color;
    }

    private static Color findPatternMatch(@NotNull String name) {
        Object value;
        if (name == null) {
            JBColor.$$$reportNull$$$0(17);
        }
        if ((value = UIManager.get("*")) instanceof Map) {
            Map map = (Map)value;
            Map cache = (Map)UIManager.get("*cache");
            if (cache != null && cache.containsKey(name)) {
                Color cached = (Color)cache.get(name);
                return cached == CACHED_NULL ? null : cached;
            }
            Color color = null;
            for (Map.Entry entry : map.entrySet()) {
                Object result;
                if (!(entry.getKey() instanceof String) || !name.endsWith((String)entry.getKey()) || !((result = map.get(entry.getKey())) instanceof Color)) continue;
                color = (Color)result;
                break;
            }
            if (cache != null) {
                cache.put(name, color == null ? CACHED_NULL : color);
            }
            return color;
        }
        return null;
    }

    public static void setDark(boolean dark) {
        DARK.setValue((Object)dark);
    }

    public static boolean isBright() {
        return (Boolean)DARK.getValue() == false;
    }

    @ApiStatus.Internal
    public Color getDarkVariant() {
        return this.darkColor;
    }

    @NotNull
    Color getColor() {
        if (this.func != null) {
            Color color = this.func.get();
            if (color == null) {
                JBColor.$$$reportNull$$$0(18);
            }
            return color;
        }
        if (this.name != null) {
            return JBColor.calculateColor(this.name, this.defaultColor);
        }
        Color color = (Boolean)DARK.getValue() != false ? this.getDarkVariant() : this;
        if (color == null) {
            JBColor.$$$reportNull$$$0(19);
        }
        return color;
    }

    Color getColorOrNull() {
        if (this.func != null) {
            return this.func.get();
        }
        if (this.name != null) {
            return JBColor.calculateColorOrNull(this.name);
        }
        return (Boolean)DARK.getValue() != false ? this.getDarkVariant() : this;
    }

    @ApiStatus.Internal
    @Nullable
    public String getName() {
        return this.name;
    }

    @ApiStatus.Internal
    @NlsSafe
    @Nullable
    public String getPresentableName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.func != null) {
            Supplier<? extends Color> supplier = this.func;
            if (supplier instanceof PresentableColor) {
                PresentableColor presentableFun = (PresentableColor)supplier;
                return "Lazy: " + presentableFun.getPresentableName();
            }
            Color color = this.func.get();
            return "Lazy: " + PresentableColor.toPresentableString((Color)color) + " (" + String.valueOf(this.func) + ")";
        }
        if (this.defaultColor != null && this.darkColor != null) {
            return "Color pair: (" + PresentableColor.toPresentableString((Color)this.defaultColor) + ", " + PresentableColor.toPresentableString((Color)this.darkColor) + ")";
        }
        return null;
    }

    @ApiStatus.Internal
    @Nullable
    public Color getDefaultColor() {
        return this.defaultColor == NAMED_COLOR_FALLBACK_MARKER ? null : this.defaultColor;
    }

    @Override
    public int getRed() {
        Color c = this.getColor();
        return c == this ? super.getRed() : c.getRed();
    }

    @Override
    public int getGreen() {
        Color c = this.getColor();
        return c == this ? super.getGreen() : c.getGreen();
    }

    @Override
    public int getBlue() {
        Color c = this.getColor();
        return c == this ? super.getBlue() : c.getBlue();
    }

    @Override
    public int getAlpha() {
        Color c = this.getColor();
        return c == this ? super.getAlpha() : c.getAlpha();
    }

    @Override
    public int getRGB() {
        Color c = this.getColor();
        return c == this ? super.getRGB() : c.getRGB();
    }

    @Override
    @NotNull
    public Color brighter() {
        if (SystemProperties.getBooleanProperty((String)"ide.color.mixture.mark.colors", (boolean)false)) {
            Color color = new SwingTuneBrighter(this).createColor(true);
            if (color == null) {
                JBColor.$$$reportNull$$$0(20);
            }
            return color;
        }
        if (this.func != null) {
            return JBColor.lazy(() -> this.func.get().brighter());
        }
        if (this.name != null) {
            Color color = JBColor.calculateColor(this.name, this.defaultColor).brighter();
            if (color == null) {
                JBColor.$$$reportNull$$$0(21);
            }
            return color;
        }
        return new JBColor(super.brighter(), this.getDarkVariant().brighter());
    }

    @Override
    @NotNull
    public Color darker() {
        if (SystemProperties.getBooleanProperty((String)"ide.color.mixture.mark.colors", (boolean)false)) {
            Color color = new SwingTuneDarker(this).createColor(true);
            if (color == null) {
                JBColor.$$$reportNull$$$0(22);
            }
            return color;
        }
        if (this.func != null) {
            return JBColor.lazy(() -> this.func.get().darker());
        }
        if (this.name != null) {
            Color color = JBColor.calculateColor(this.name, this.defaultColor).darker();
            if (color == null) {
                JBColor.$$$reportNull$$$0(23);
            }
            return color;
        }
        return new JBColor(super.darker(), this.getDarkVariant().darker());
    }

    @Override
    public int hashCode() {
        Color c = this.getColor();
        return c == this ? super.hashCode() : c.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        Color c = this.getColor();
        return c == this ? super.equals(obj) : c.equals(obj);
    }

    @ApiStatus.Internal
    public boolean colorEquals(@NotNull ComparableColor otherColor) {
        if (otherColor == null) {
            JBColor.$$$reportNull$$$0(24);
        }
        if (otherColor.getClass() == this.getClass()) {
            JBColor other = (JBColor)otherColor;
            if (this.func != null) {
                return ComparableColor.equalComparable(this.func, other.func);
            }
            if (this.name != null) {
                return this.name.equals(other.name);
            }
            return UIUtil.equalColors(this.defaultColor, other.defaultColor) && UIUtil.equalColors(this.darkColor, other.darkColor);
        }
        return false;
    }

    @ApiStatus.Internal
    public int colorHashCode() {
        if (this.func != null) {
            return ComparableColor.comparableHashCode(this.func);
        }
        if (this.name != null) {
            return this.name.hashCode();
        }
        return UIUtil.colorHashCode(this.defaultColor) + 31 * UIUtil.colorHashCode(this.darkColor);
    }

    @Override
    public String toString() {
        Color c = this.getColor();
        return c == this ? super.toString() : c.toString();
    }

    @Override
    public float @NotNull [] getRGBComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getRGBComponents(compArray) : c.getRGBComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(25);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getRGBColorComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getRGBComponents(compArray) : c.getRGBColorComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(26);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getComponents(compArray) : c.getComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(27);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getColorComponents(float[] compArray) {
        Color c = this.getColor();
        float[] fArray = c == this ? super.getColorComponents(compArray) : c.getColorComponents(compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(28);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getComponents(@NotNull ColorSpace colorSpace, float[] compArray) {
        Color c;
        if (colorSpace == null) {
            JBColor.$$$reportNull$$$0(29);
        }
        float[] fArray = (c = this.getColor()) == this ? super.getComponents(colorSpace, compArray) : c.getComponents(colorSpace, compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(30);
        }
        return fArray;
    }

    @Override
    public float @NotNull [] getColorComponents(@NotNull ColorSpace colorSpace, float[] compArray) {
        Color c;
        if (colorSpace == null) {
            JBColor.$$$reportNull$$$0(31);
        }
        float[] fArray = (c = this.getColor()) == this ? super.getColorComponents(colorSpace, compArray) : c.getColorComponents(colorSpace, compArray);
        if (fArray == null) {
            JBColor.$$$reportNull$$$0(32);
        }
        return fArray;
    }

    @Override
    @NotNull
    public ColorSpace getColorSpace() {
        Color c = this.getColor();
        ColorSpace colorSpace = c == this ? super.getColorSpace() : c.getColorSpace();
        if (colorSpace == null) {
            JBColor.$$$reportNull$$$0(33);
        }
        return colorSpace;
    }

    @Override
    @NotNull
    public synchronized PaintContext createContext(ColorModel cm, Rectangle r, Rectangle2D r2d, AffineTransform affineTransform, RenderingHints hints) {
        Color c = this.getColor();
        PaintContext paintContext = c == this ? super.createContext(cm, r, r2d, affineTransform, hints) : c.createContext(cm, r, r2d, affineTransform, hints);
        if (paintContext == null) {
            JBColor.$$$reportNull$$$0(34);
        }
        return paintContext;
    }

    @Override
    public int getTransparency() {
        Color c = this.getColor();
        return c == this ? super.getTransparency() : c.getTransparency();
    }

    @NotNull
    public static Color foreground() {
        return JBColor.namedColor("Label.foreground", new JBColor(Gray._0, (Color)Gray.xBB));
    }

    @NotNull
    public static Color background() {
        return JBColor.lazy(() -> JBUI.CurrentTheme.List.BACKGROUND);
    }

    @NotNull
    public static Color border() {
        return JBColor.namedColor("Borders.color", new JBColor(Gray._192, (Color)Gray._50));
    }

    @NotNull
    public static Color get(@NotNull String colorId, @NotNull Color defaultColor) {
        if (colorId == null) {
            JBColor.$$$reportNull$$$0(35);
        }
        if (defaultColor == null) {
            JBColor.$$$reportNull$$$0(36);
        }
        return JBColor.lazy(() -> {
            Color color = defaultThemeColors.get(colorId);
            if (color != null) {
                return color;
            }
            defaultThemeColors.put(colorId, defaultColor);
            return defaultColor;
        });
    }

    private static void saveMissingColorInUIDefaults(String propertyName, Color color) {
        String key;
        if (Registry.is((String)"ide.save.missing.jb.colors", (boolean)false) && UIManager.get(key = propertyName + "!!!") == null) {
            UIManager.put(key, color);
        }
    }

    @ApiStatus.Internal
    private static Color _saveAndReturnColor(@NonNls @NotNull String propertyName, Color color) {
        String key;
        Object saved;
        if (propertyName == null) {
            JBColor.$$$reportNull$$$0(37);
        }
        if ((saved = UIManager.get(key = propertyName + "!!!")) instanceof Color) {
            return (Color)saved;
        }
        UIManager.put(key, color);
        return color;
    }

    static {
        RED = red = new JBColor(Color.red, DarculaColors.RED);
        BLUE = blue = new JBColor(Color.blue, DarculaColors.BLUE);
        WHITE = white = new JBColor(Color.white, JBColor.background());
        BLACK = black = new JBColor(Color.black, JBColor.foreground());
        GRAY = gray = new JBColor(Gray._128, (Color)Gray._128);
        LIGHT_GRAY = lightGray = new JBColor(Gray._192, (Color)Gray._64);
        DARK_GRAY = darkGray = new JBColor(Gray._64, (Color)Gray._192);
        PINK = pink = new JBColor(Color.pink, Color.pink);
        ORANGE = orange = new JBColor(Color.orange, new Color(159, 107, 0));
        YELLOW = yellow = new JBColor(Color.yellow, new Color(138, 138, 0));
        GREEN = green = new JBColor(Color.green, new Color(98, 150, 85));
        MAGENTA = magenta = new JBColor(Color.magenta, new Color(151, 118, 169));
        CYAN = cyan = new JBColor(Color.cyan, new Color(0, 137, 137));
        defaultThemeColors = new HashMap<String, Color>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 30, 32, 33, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regular";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dark";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 12: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultColor";
                break;
            }
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/JBColor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherColor";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorSpace";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/JBColor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateColor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getColor";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "brighter";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "darker";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getRGBComponents";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRGBColorComponents";
                break;
            }
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
            case 28: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorComponents";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorSpace";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lazy";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "marker";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "namedColor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "namedColorOrNull";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calculateColor";
                break;
            }
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateColorOrNull";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findPatternMatch";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "colorEquals";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getComponents";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getColorComponents";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "_saveAndReturnColor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 18, 19, 20, 21, 22, 23, 25, 26, 27, 28, 30, 32, 33, 34 -> new IllegalStateException(string);
        };
    }
}

