/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.icons;

import com.intellij.ui.icons.IconTransform;
import com.intellij.ui.icons.ImageCacheKt;
import com.intellij.ui.icons.ImageDataByUrlLoaderKt;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.LoadIconParameters;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.SVGLoader;
import java.awt.Image;
import java.awt.image.ImageFilter;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0016\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020\tH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/ui/icons/ImageDataByPathResourceLoader;", "Lcom/intellij/ui/icons/ImageDataLoader;", "ownerClass", "Ljava/lang/Class;", "classLoader", "Ljava/lang/ClassLoader;", "strict", "", "path", "", "<init>", "(Ljava/lang/Class;Ljava/lang/ClassLoader;ZLjava/lang/String;)V", "getPath", "()Ljava/lang/String;", "url", "Ljava/net/URL;", "getUrl", "()Ljava/net/URL;", "setUrl", "(Ljava/net/URL;)V", "loadImage", "Ljava/awt/Image;", "parameters", "Lcom/intellij/ui/icons/LoadIconParameters;", "scaleContext", "Lcom/intellij/ui/scale/ScaleContext;", "patch", "transform", "Lcom/intellij/ui/icons/IconTransform;", "isMyClassLoader", "getCoords", "Lkotlin/Pair;", "toString", "intellij.platform.util.ui"})
@SourceDebugExtension(value={"SMAP\nImageDataByUrlLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageDataByUrlLoader.kt\ncom/intellij/ui/icons/ImageDataByPathResourceLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class ImageDataByPathResourceLoader
implements ImageDataLoader {
    @Nullable
    private final Class<?> ownerClass;
    @Nullable
    private final ClassLoader classLoader;
    private final boolean strict;
    @NotNull
    private final String path;
    @Nullable
    private volatile URL url;

    public ImageDataByPathResourceLoader(@Nullable Class<?> ownerClass, @Nullable ClassLoader classLoader, boolean strict, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.ownerClass = ownerClass;
        this.classLoader = classLoader;
        this.strict = strict;
        this.path = path;
        this.url = ImageDataByUrlLoaderKt.access$getUNRESOLVED_URL$p();
    }

    public /* synthetic */ ImageDataByPathResourceLoader(Class clazz, ClassLoader classLoader, boolean bl, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            clazz = null;
        }
        if ((n & 2) != 0) {
            classLoader = null;
        }
        this(clazz, classLoader, bl, string);
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public URL getUrl() {
        URL result = this.url;
        if (result == ImageDataByUrlLoaderKt.access$getUNRESOLVED_URL$p()) {
            URL uRL;
            try {
                uRL = ImageDataByUrlLoaderKt.access$resolveUrl(this.getPath(), this.classLoader, this.ownerClass, this.strict);
            }
            finally {
                this.url = result;
            }
            result = uRL;
        }
        return result;
    }

    public void setUrl(@Nullable URL uRL) {
        this.url = uRL;
    }

    @Override
    @Nullable
    public Image loadImage(@NotNull LoadIconParameters parameters, @NotNull ScaleContext scaleContext) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        String string = this.getPath();
        List<ImageFilter> list = parameters.filters;
        SVGLoader.SvgElementColorPatcherProvider svgElementColorPatcherProvider = parameters.colorPatcher;
        Class<?> clazz = this.ownerClass;
        ClassLoader classLoader = this.classLoader;
        boolean bl = parameters.isDark;
        return ImageCacheKt.loadImage$default(string, clazz, classLoader, scaleContext, bl, svgElementColorPatcherProvider, list, false, false, 128, null);
    }

    @Override
    @Nullable
    public ImageDataLoader patch(@NotNull IconTransform transform) {
        Intrinsics.checkNotNullParameter((Object)transform, (String)"transform");
        return ImageDataByUrlLoaderKt.access$createNewResolverIfNeeded(this.classLoader, this.getPath(), transform);
    }

    @Override
    public boolean isMyClassLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        return this.classLoader == classLoader;
    }

    @Override
    @Nullable
    public Pair<String, ClassLoader> getCoords() {
        Pair pair;
        ClassLoader classLoader = this.classLoader;
        if (classLoader != null) {
            ClassLoader it = classLoader;
            boolean bl = false;
            pair = TuplesKt.to((Object)this.getPath(), (Object)this.classLoader);
        } else {
            pair = null;
        }
        return pair;
    }

    @NotNull
    public String toString() {
        Class<?> clazz = this.ownerClass;
        return "ImageDataByPathResourceLoader(ownerClass=" + (clazz != null ? clazz.getName() : null) + ", classLoader=" + this.classLoader + ", path=" + this.getPath() + ")";
    }
}

